/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenMetadataEventProtocolVersion;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenMetadataExchangeRule;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;

public class OMRSConfigurationFactory {
    private static final String defaultEnterpriseMetadataCollectionName = " Enterprise Metadata Collection";
    private static final String defaultCohortName = "defaultCohort";
    private ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();

    private OpenMetadataEventProtocolVersion getDefaultEnterpriseOMRSTopicProtocolVersion() {
        return OpenMetadataEventProtocolVersion.V1;
    }

    private OpenMetadataEventProtocolVersion getDefaultCohortOMRSTopicProtocolVersion() {
        return OpenMetadataEventProtocolVersion.V1;
    }

    private OpenMetadataExchangeRule getDefaultEventsToSendRule() {
        return OpenMetadataExchangeRule.ALL;
    }

    private List<TypeDefSummary> getDefaultSelectedTypesToSend() {
        return null;
    }

    private OpenMetadataExchangeRule getDefaultEventsToSaveRule() {
        return OpenMetadataExchangeRule.ALL;
    }

    private List<TypeDefSummary> getDefaultSelectedTypesToSave() {
        return null;
    }

    private OpenMetadataExchangeRule getDefaultEventsToProcessRule() {
        return OpenMetadataExchangeRule.ALL;
    }

    private List<TypeDefSummary> getDefaultSelectedTypesToProcess() {
        return null;
    }

    private LocalRepositoryConfig getDefaultLocalRepositoryConfig(String repositoryName, String localServerName, String localServerURL) {
        LocalRepositoryConfig localRepositoryConfig = new LocalRepositoryConfig();
        localRepositoryConfig.setMetadataCollectionId(UUID.randomUUID().toString());
        localRepositoryConfig.setLocalRepositoryLocalConnection(this.connectorConfigurationFactory.getDefaultLocalRepositoryLocalConnection());
        localRepositoryConfig.setLocalRepositoryRemoteConnection(this.connectorConfigurationFactory.getDefaultLocalRepositoryRemoteConnection(repositoryName, localServerName, localServerURL));
        localRepositoryConfig.setEventsToSaveRule(this.getDefaultEventsToSaveRule());
        localRepositoryConfig.setSelectedTypesToSave(this.getDefaultSelectedTypesToSave());
        localRepositoryConfig.setEventsToSendRule(this.getDefaultEventsToSendRule());
        localRepositoryConfig.setSelectedTypesToSend(this.getDefaultSelectedTypesToSend());
        localRepositoryConfig.setEventMapperConnection(this.connectorConfigurationFactory.getDefaultEventMapperConnection());
        return localRepositoryConfig;
    }

    public LocalRepositoryConfig getInMemoryLocalRepositoryConfig(String localServerName, String localServerURL) {
        String repositoryName = "In-memory repository";
        LocalRepositoryConfig localRepositoryConfig = this.getDefaultLocalRepositoryConfig("In-memory repository", localServerName, localServerURL);
        localRepositoryConfig.setLocalRepositoryLocalConnection(this.connectorConfigurationFactory.getInMemoryLocalRepositoryLocalConnection("In-memory repository", localServerName));
        return localRepositoryConfig;
    }

    public LocalRepositoryConfig getLocalGraphLocalRepositoryConfig(String localServerName, String localServerURL) {
        String repositoryName = "Graph Open Metadata Repository";
        LocalRepositoryConfig localRepositoryConfig = this.getDefaultLocalRepositoryConfig("Graph Open Metadata Repository", localServerName, localServerURL);
        localRepositoryConfig.setLocalRepositoryLocalConnection(this.connectorConfigurationFactory.getLocalGraphRepositoryLocalConnection("Graph Open Metadata Repository", localServerName));
        return localRepositoryConfig;
    }

    public LocalRepositoryConfig getRepositoryProxyLocalRepositoryConfig(String localServerName, String localServerURL) {
        String repositoryName = "Repository Proxy";
        LocalRepositoryConfig localRepositoryConfig = this.getDefaultLocalRepositoryConfig("Repository Proxy", localServerName, localServerURL);
        localRepositoryConfig.setLocalRepositoryLocalConnection(null);
        return localRepositoryConfig;
    }

    public EnterpriseAccessConfig getDefaultEnterpriseAccessConfig(String localServerName, String localServerId) {
        EnterpriseAccessConfig enterpriseAccessConfig = new EnterpriseAccessConfig();
        enterpriseAccessConfig.setEnterpriseMetadataCollectionId(UUID.randomUUID().toString());
        enterpriseAccessConfig.setEnterpriseMetadataCollectionName(localServerName + defaultEnterpriseMetadataCollectionName);
        enterpriseAccessConfig.setEnterpriseOMRSTopicConnection(this.connectorConfigurationFactory.getDefaultEnterpriseOMRSTopicConnection(localServerName, localServerId));
        enterpriseAccessConfig.setEnterpriseOMRSTopicProtocolVersion(this.getDefaultEnterpriseOMRSTopicProtocolVersion());
        return enterpriseAccessConfig;
    }

    public CohortConfig getDefaultCohortConfig(String localServerName, String cohortName, Map<String, Object> configurationProperties, String eventBusConnectorProvider, String topicURLRoot, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        CohortConfig cohortConfig = new CohortConfig();
        String newCohortName = defaultCohortName;
        if (cohortName != null) {
            newCohortName = cohortName;
        }
        cohortConfig.setCohortName(newCohortName);
        cohortConfig.setCohortRegistryConnection(this.connectorConfigurationFactory.getDefaultCohortRegistryConnection(localServerName, newCohortName));
        cohortConfig.setCohortOMRSTopicConnection(this.connectorConfigurationFactory.getDefaultCohortOMRSTopicConnection(newCohortName, configurationProperties, eventBusConnectorProvider, topicURLRoot, serverId, eventBusConfigurationProperties));
        cohortConfig.setCohortOMRSTopicProtocolVersion(this.getDefaultCohortOMRSTopicProtocolVersion());
        cohortConfig.setEventsToProcessRule(this.getDefaultEventsToProcessRule());
        cohortConfig.setSelectedTypesToProcess(this.getDefaultSelectedTypesToProcess());
        return cohortConfig;
    }

    public RepositoryServicesConfig getDefaultRepositoryServicesConfig(String localServerName) {
        RepositoryServicesConfig repositoryServicesConfig = new RepositoryServicesConfig();
        ArrayList<Connection> auditLogStoreConnections = new ArrayList<Connection>();
        auditLogStoreConnections.add(this.connectorConfigurationFactory.getDefaultAuditLogConnection(localServerName));
        repositoryServicesConfig.setAuditLogConnections(auditLogStoreConnections);
        return repositoryServicesConfig;
    }
}

