/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.EntityAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.CloneableRepositoryExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.PageableRepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class FindEntitiesByPropertyValueExecutor
extends PageableRepositoryExecutorBase {
    private String searchCriteria;
    private List<String> limitResultsByClassification;
    private EntityAccumulator accumulator;

    public FindEntitiesByPropertyValueExecutor(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String localMetadataCollectionId, OMRSAuditLog auditLog, OMRSRepositoryValidator repositoryValidator, String methodName) {
        this(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize, new EntityAccumulator(localMetadataCollectionId, auditLog, repositoryValidator), methodName);
    }

    private FindEntitiesByPropertyValueExecutor(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, EntityAccumulator accumulator, String methodName) {
        super(userId, entityTypeGUID, fromEntityElement, limitResultsByStatus, sequencingProperty, sequencingOrder, pageSize, asOfTime, accumulator, methodName);
        this.searchCriteria = searchCriteria;
        this.limitResultsByClassification = limitResultsByClassification;
        this.accumulator = accumulator;
    }

    @Override
    public CloneableRepositoryExecutor getClone() {
        return new FindEntitiesByPropertyValueExecutor(this.userId, this.instanceTypeGUID, this.searchCriteria, this.startingElement, this.limitResultsByStatus, this.limitResultsByClassification, this.asOfTime, this.sequencingProperty, this.sequencingOrder, this.pageSize, this.accumulator, this.methodName);
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            List results = metadataCollection.findEntitiesByPropertyValue(this.userId, this.instanceTypeGUID, this.searchCriteria, this.startingElement, this.limitResultsByStatus, this.limitResultsByClassification, this.asOfTime, this.sequencingProperty, this.sequencingOrder, this.pageSize);
            this.accumulator.addEntities(results, metadataCollectionId);
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (FunctionNotSupportedException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (TypeErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (PagingErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (PropertyErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (Throwable error) {
            this.accumulator.captureGenericException(metadataCollectionId, error);
        }
        return true;
    }

    public List<EntityDetail> getResults(EnterpriseOMRSRepositoryConnector repositoryConnector) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (this.accumulator.resultsReturned()) {
            return this.accumulator.getResults(repositoryConnector);
        }
        this.handleCommonPagingRequestExceptions();
        return null;
    }
}

