/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.QueryInstanceAccumulatorBase;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.CloneableRepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

abstract class PageableRepositoryExecutorBase
extends CloneableRepositoryExecutorBase {
    int startingElement;
    int pageSize;
    String instanceTypeGUID;
    List<InstanceStatus> limitResultsByStatus;
    String sequencingProperty;
    SequencingOrder sequencingOrder;
    Date asOfTime;
    private QueryInstanceAccumulatorBase queryInstanceAccumulator;

    PageableRepositoryExecutorBase(String userId, String instanceTypeGUID, int startingElement, List<InstanceStatus> limitResultsByStatus, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, Date asOfTime, QueryInstanceAccumulatorBase accumulator, String methodName) {
        super(userId, methodName, accumulator);
        this.instanceTypeGUID = instanceTypeGUID;
        this.startingElement = startingElement;
        this.limitResultsByStatus = limitResultsByStatus;
        this.sequencingProperty = sequencingProperty;
        this.sequencingOrder = sequencingOrder;
        this.pageSize = pageSize;
        this.asOfTime = asOfTime;
        this.queryInstanceAccumulator = accumulator;
    }

    void handleCommonPagingRequestExceptions() throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        this.queryInstanceAccumulator.throwCapturedUserNotAuthorizedException();
        this.queryInstanceAccumulator.throwCapturedRepositoryErrorException();
        this.queryInstanceAccumulator.throwCapturedThrowableException(this.methodName);
        this.queryInstanceAccumulator.throwCapturedPropertyErrorException();
        this.queryInstanceAccumulator.throwCapturedInvalidParameterException();
        this.queryInstanceAccumulator.throwCapturedFunctionNotSupportedException();
        this.queryInstanceAccumulator.throwCapturedTypeErrorException();
        this.queryInstanceAccumulator.throwCapturedPagingErrorException();
    }
}

