/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.connectormanager;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectionConsumer;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectorConsumer;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectorManager;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentHelper;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSEnterpriseConnectorManager
implements OMRSConnectionConsumer,
OMRSConnectorManager {
    private static final Logger log = LoggerFactory.getLogger(OMRSEnterpriseConnectorManager.class);
    private boolean enterpriseAccessEnabled;
    private int maxPageSize;
    private String localMetadataCollectionId = null;
    private LocalOMRSRepositoryConnector localRepositoryConnector = null;
    private OMRSRepositoryContentManager repositoryContentManager;
    private List<RegisteredConnector> registeredRemoteConnectors = new ArrayList<RegisteredConnector>();
    private List<RegisteredConnectorConsumer> registeredConnectorConsumers = new ArrayList<RegisteredConnectorConsumer>();
    private OMRSAuditLog auditLog;
    private String localServerUserId;
    private String localServerPassword;

    public OMRSEnterpriseConnectorManager(boolean enterpriseAccessEnabled, int maxPageSize, OMRSRepositoryContentManager repositoryContentManager, OMRSAuditLog auditLog, String localServerUserId, String localServerPassword) {
        this.enterpriseAccessEnabled = enterpriseAccessEnabled;
        this.maxPageSize = maxPageSize;
        this.repositoryContentManager = repositoryContentManager;
        this.auditLog = auditLog;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
    }

    public boolean isEnterpriseAccessEnabled() {
        return this.enterpriseAccessEnabled;
    }

    public void disconnect() throws ConnectorCheckedException {
        if (this.localRepositoryConnector != null) {
            try {
                this.localRepositoryConnector.disconnect();
            }
            catch (Throwable error) {
                log.error("Exception from disconnect of connector to metadata collection:" + this.localMetadataCollectionId + "  Error message was: " + error.getMessage());
                throw error;
            }
        }
        for (RegisteredConnectorConsumer registeredConnectorConsumer : this.registeredConnectorConsumers) {
            registeredConnectorConsumer.getConnectorConsumer().disconnectAllConnectors();
        }
    }

    public void setLocalConnector(String localMetadataCollectionId, LocalOMRSRepositoryConnector localRepositoryConnector) {
        this.localRepositoryConnector = localRepositoryConnector;
        this.localMetadataCollectionId = localMetadataCollectionId;
        for (RegisteredConnectorConsumer registeredConnectorConsumer : this.registeredConnectorConsumers) {
            registeredConnectorConsumer.getConnectorConsumer().setLocalConnector(localMetadataCollectionId, localRepositoryConnector);
        }
    }

    @Override
    public synchronized void addRemoteConnection(String cohortName, String remoteServerName, String remoteServerType, String owningOrganizationName, String metadataCollectionId, String metadataCollectionName, Connection remoteConnection) throws ConnectionCheckedException, ConnectorCheckedException {
        OMRSMetadataCollection metadataCollection;
        OMRSAuditCode auditCode;
        String actionDescription = "Processing incoming registration request from remote cohort member";
        RegisteredConnector registeredConnector = this.getRegisteredConnector(metadataCollectionId);
        if (registeredConnector == null) {
            auditCode = OMRSAuditCode.NEW_REMOTE_MEMBER;
            this.auditLog.logRecord("Processing incoming registration request from remote cohort member", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{remoteServerName, cohortName, metadataCollectionId, metadataCollectionName, remoteServerType, owningOrganizationName}), remoteConnection.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        } else {
            auditCode = OMRSAuditCode.REMOTE_MEMBER_REFRESHED;
            this.auditLog.logRecord("Processing incoming registration request from remote cohort member", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{remoteServerName, cohortName, metadataCollectionId, metadataCollectionName, remoteServerType, owningOrganizationName}), remoteConnection.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
        OMRSRepositoryConnector remoteConnector = this.getOMRSRepositoryConnector(remoteConnection, remoteServerName, remoteServerType, owningOrganizationName, metadataCollectionId, metadataCollectionName);
        try {
            metadataCollection = remoteConnector.getMetadataCollection();
        }
        catch (Exception error) {
            metadataCollection = null;
            auditCode = OMRSAuditCode.NEW_REMOTE_MEMBER_FAILURE;
            this.auditLog.logException("Processing incoming registration request from remote cohort member", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{remoteServerName, cohortName, error.getClass().getName(), error.getMessage()}), remoteConnection.toString(), auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)error);
        }
        remoteConnector.disconnect();
        if (metadataCollection == null) {
            String methodName = "addRemoteConnection";
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_COHORT_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{cohortName, metadataCollectionId});
            throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addRemoteConnection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (registeredConnector == null) {
            this.registeredRemoteConnectors.add(new RegisteredConnector(cohortName, remoteServerName, remoteServerType, owningOrganizationName, metadataCollectionId, metadataCollectionName, remoteConnection));
        } else {
            registeredConnector.refresh(cohortName, remoteServerName, remoteServerType, owningOrganizationName, metadataCollectionId, metadataCollectionName, remoteConnection);
        }
        if (this.enterpriseAccessEnabled) {
            for (RegisteredConnectorConsumer registeredConnectorConsumer : this.registeredConnectorConsumers) {
                registeredConnectorConsumer.getConnectorConsumer().addRemoteConnector(metadataCollectionId, this.getOMRSRepositoryConnector(remoteConnection, remoteServerName, remoteServerType, owningOrganizationName, metadataCollectionId, metadataCollectionName));
            }
            this.printFederationList("Processing incoming registration request from remote cohort member");
        }
    }

    private RegisteredConnector getRegisteredConnector(String metadataCollectionId) {
        for (RegisteredConnector registeredConnector : this.registeredRemoteConnectors) {
            String remoteMetadataCollectionId;
            if (registeredConnector == null || (remoteMetadataCollectionId = registeredConnector.getMetadataCollectionId()) == null || !remoteMetadataCollectionId.equals(metadataCollectionId)) continue;
            return registeredConnector;
        }
        return null;
    }

    private void printFederationList(String actionDescription) {
        ArrayList<String> serverList = new ArrayList<String>();
        for (RegisteredConnector registeredConnector : this.registeredRemoteConnectors) {
            if (registeredConnector == null) continue;
            serverList.add(registeredConnector.getServerName());
        }
        OMRSAuditCode auditCode = OMRSAuditCode.FEDERATION_LIST;
        this.auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{((Object)serverList).toString()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    @Override
    public synchronized void removeRemoteConnection(String cohortName, String metadataCollectionId) {
        String actionDescription = "Processing incoming unregistration request from remote cohort member";
        OMRSAuditCode auditCode = OMRSAuditCode.REMOVE_REMOTE_MEMBER;
        this.auditLog.logRecord("Processing incoming unregistration request from remote cohort member", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{cohortName, metadataCollectionId}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        Iterator<RegisteredConnector> iterator = this.registeredRemoteConnectors.iterator();
        int repositoryRegistrationCount = 0;
        while (iterator.hasNext()) {
            RegisteredConnector registeredRemoteConnector = iterator.next();
            if (!registeredRemoteConnector.getMetadataCollectionId().equals(metadataCollectionId)) continue;
            if (registeredRemoteConnector.getSource().equals(cohortName)) {
                iterator.remove();
                continue;
            }
            ++repositoryRegistrationCount;
        }
        if (this.enterpriseAccessEnabled && repositoryRegistrationCount == 0) {
            for (RegisteredConnectorConsumer registeredConnectorConsumer : this.registeredConnectorConsumers) {
                registeredConnectorConsumer.getConnectorConsumer().removeRemoteConnector(metadataCollectionId);
            }
            this.printFederationList("Processing incoming unregistration request from remote cohort member");
        }
    }

    @Override
    public synchronized void removeCohort(String cohortName) {
        ArrayList<String> metadataCollectionIds = new ArrayList<String>();
        for (RegisteredConnector registeredRemoteConnector : this.registeredRemoteConnectors) {
            if (!registeredRemoteConnector.getSource().equals(cohortName)) continue;
            metadataCollectionIds.add(registeredRemoteConnector.getMetadataCollectionId());
        }
        for (String metadataCollectionId : metadataCollectionIds) {
            this.removeRemoteConnection(cohortName, metadataCollectionId);
        }
    }

    @Override
    public synchronized String registerConnectorConsumer(OMRSConnectorConsumer connectorConsumer) {
        RegisteredConnectorConsumer registeredConnectorConsumer = new RegisteredConnectorConsumer(connectorConsumer);
        String connectorConsumerId = registeredConnectorConsumer.getConnectorConsumerId();
        this.registeredConnectorConsumers.add(registeredConnectorConsumer);
        if (this.localRepositoryConnector != null) {
            connectorConsumer.setLocalConnector(this.localMetadataCollectionId, this.localRepositoryConnector);
        }
        if (this.enterpriseAccessEnabled) {
            for (RegisteredConnector registeredConnector : this.registeredRemoteConnectors) {
                try {
                    connectorConsumer.addRemoteConnector(registeredConnector.getMetadataCollectionId(), this.getOMRSRepositoryConnector(registeredConnector.getConnection(), registeredConnector.getServerName(), registeredConnector.getServerType(), registeredConnector.getOwningOrganizationName(), registeredConnector.getMetadataCollectionId(), registeredConnector.getMetadataCollectionName()));
                }
                catch (ConnectionCheckedException | ConnectorCheckedException error) {
                    String actionDescription = "Registering an enterprise connector with the enterprise connector manager";
                    String methodName = "registerConnectorConsumer";
                    OMRSAuditCode auditCode = OMRSAuditCode.UNEXPECTED_EXCEPTION;
                    this.auditLog.logException("Registering an enterprise connector with the enterprise connector manager", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getClass().getName(), "registerConnectorConsumer", error.getErrorMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction(), error);
                }
            }
        }
        return connectorConsumerId;
    }

    @Override
    public synchronized void unregisterConnectorConsumer(String connectorConsumerId) {
        Iterator<RegisteredConnectorConsumer> iterator = this.registeredConnectorConsumers.iterator();
        while (iterator.hasNext()) {
            RegisteredConnectorConsumer registeredConnectorConsumer = iterator.next();
            if (!registeredConnectorConsumer.getConnectorConsumerId().equals(connectorConsumerId)) continue;
            iterator.remove();
            break;
        }
    }

    private OMRSRepositoryConnector getOMRSRepositoryConnector(Connection connection, String serverName, String serverType, String owningOrganizationName, String metadataCollectionId, String metadataCollectionName) throws ConnectionCheckedException, ConnectorCheckedException {
        String methodName = "getOMRSRepositoryConnector";
        try {
            String repositoryName = null;
            if (connection != null) {
                if (connection.getUserId() == null) {
                    connection.setUserId(this.localServerUserId);
                }
                if (connection.getClearPassword() == null) {
                    connection.setClearPassword(this.localServerPassword);
                }
                repositoryName = connection.getDisplayName();
            }
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(connection);
            OMRSRepositoryConnector repositoryConnector = (OMRSRepositoryConnector)connector;
            if (repositoryName == null) {
                repositoryName = serverName;
            }
            repositoryConnector.setRepositoryName(repositoryName);
            repositoryConnector.setAuditLog(this.auditLog.createNewAuditLog(OMRSAuditingComponent.REMOTE_REPOSITORY_CONNECTOR));
            repositoryConnector.setServerName(serverName);
            repositoryConnector.setServerType(serverType);
            repositoryConnector.setServerUserId(this.localServerUserId);
            repositoryConnector.setOrganizationName(owningOrganizationName);
            repositoryConnector.setMaxPageSize(this.maxPageSize);
            repositoryConnector.setRepositoryValidator((OMRSRepositoryValidator)new OMRSRepositoryContentValidator(this.repositoryContentManager));
            repositoryConnector.setRepositoryHelper((OMRSRepositoryHelper)new OMRSRepositoryContentHelper(this.repositoryContentManager));
            repositoryConnector.setMetadataCollectionId(metadataCollectionId);
            repositoryConnector.setMetadataCollectionName(metadataCollectionName);
            repositoryConnector.start();
            return repositoryConnector;
        }
        catch (ConnectionCheckedException | ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            String connectionName = "<null>";
            if (connection != null) {
                connectionName = connection.toString();
            }
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_OMRS_CONNECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{connectionName});
            throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)error);
        }
    }

    private class RegisteredConnectorConsumer {
        private String connectorConsumerId;
        private OMRSConnectorConsumer connectorConsumer;

        public RegisteredConnectorConsumer(String connectorConsumerId, OMRSConnectorConsumer connectorConsumer) {
            this.connectorConsumerId = connectorConsumerId;
            this.connectorConsumer = connectorConsumer;
        }

        public RegisteredConnectorConsumer(OMRSConnectorConsumer connectorConsumer) {
            this.connectorConsumer = connectorConsumer;
            this.connectorConsumerId = UUID.randomUUID().toString();
        }

        public String getConnectorConsumerId() {
            return this.connectorConsumerId;
        }

        public OMRSConnectorConsumer getConnectorConsumer() {
            return this.connectorConsumer;
        }
    }

    private class RegisteredConnector {
        private String source;
        private String serverName;
        private String serverType;
        private String owningOrganizationName;
        private String metadataCollectionId;
        private String metadataCollectionName;
        private Connection connection;

        RegisteredConnector(String source, String serverName, String serverType, String owningOrganizationName, String metadataCollectionId, String metadataCollectionName, Connection connection) {
            this.source = source;
            this.serverName = serverName;
            this.serverType = serverType;
            this.owningOrganizationName = owningOrganizationName;
            this.metadataCollectionId = metadataCollectionId;
            this.metadataCollectionName = metadataCollectionName;
            this.connection = connection;
        }

        void refresh(String source, String serverName, String serverType, String owningOrganizationName, String metadataCollectionId, String metadataCollectionName, Connection connection) {
            this.source = source;
            this.serverName = serverName;
            this.serverType = serverType;
            this.owningOrganizationName = owningOrganizationName;
            this.metadataCollectionId = metadataCollectionId;
            this.metadataCollectionName = metadataCollectionName;
            this.connection = connection;
        }

        public String getSource() {
            return this.source;
        }

        public String getServerName() {
            return this.serverName;
        }

        public String getServerType() {
            return this.serverType;
        }

        public String getOwningOrganizationName() {
            return this.owningOrganizationName;
        }

        public String getMetadataCollectionId() {
            return this.metadataCollectionId;
        }

        public String getMetadataCollectionName() {
            return this.metadataCollectionName;
        }

        public Connection getConnection() {
            return this.connection;
        }
    }
}

