/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.metadatahighway;

import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.OMRSCohortRegistryStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.properties.MemberRegistration;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectionConsumer;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSEventListener;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRegistryEventPublisher;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventExchangeRule;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventManager;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventPublisher;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConnectorErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.OMRSLocalRepository;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentValidator;
import org.odpi.openmetadata.repositoryservices.metadatahighway.cohortregistry.OMRSCohortRegistry;
import org.odpi.openmetadata.repositoryservices.properties.CohortConnectionStatus;
import org.odpi.openmetadata.repositoryservices.properties.CohortDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSCohortManager {
    private String cohortName = null;
    private OMRSTopicConnector cohortTopicConnector = null;
    private Connection cohortTopicConnection = null;
    private OMRSRepositoryEventManager cohortRepositoryEventManager = null;
    private OMRSCohortRegistry cohortRegistry = null;
    private OMRSEventListener cohortEventListener = null;
    private CohortConnectionStatus cohortConnectionStatus = CohortConnectionStatus.NOT_INITIALIZED;
    private OMRSRepositoryEventManager localRepositoryEventManager = null;
    private OMRSAuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(OMRSCohortManager.class);

    public OMRSCohortManager(OMRSAuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public void initialize(String cohortName, String localMetadataCollectionId, String localMetadataCollectionName, String localServerName, String localServerType, String localOrganizationName, OMRSLocalRepository localRepository, OMRSRepositoryContentManager localRepositoryContentManager, OMRSConnectionConsumer connectionConsumer, OMRSTopicConnector enterpriseTopicConnector, OMRSCohortRegistryStore cohortRegistryStore, Connection cohortTopicConnection, OMRSTopicConnector cohortTopicConnector, OMRSRepositoryEventExchangeRule inboundEventExchangeRule) {
        String actionDescription = "Initialize Cohort Manager";
        log.debug("Initialize Cohort Manager");
        try {
            this.cohortName = cohortName;
            OMRSAuditCode auditCode = OMRSAuditCode.COHORT_INITIALIZING;
            this.auditLog.logRecord("Initialize Cohort Manager", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{cohortName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.cohortConnectionStatus = CohortConnectionStatus.INITIALIZING;
            this.cohortTopicConnection = cohortTopicConnection;
            this.cohortRepositoryEventManager = new OMRSRepositoryEventManager(cohortName + " cohort inbound", inboundEventExchangeRule, new OMRSRepositoryContentValidator(localRepositoryContentManager), this.auditLog.createNewAuditLog(OMRSAuditingComponent.REPOSITORY_EVENT_MANAGER));
            OMRSRegistryEventPublisher outboundRegistryEventProcessor = new OMRSRegistryEventPublisher(cohortName, cohortTopicConnector, this.auditLog.createNewAuditLog(OMRSAuditingComponent.EVENT_PUBLISHER));
            this.cohortRegistry = new OMRSCohortRegistry(this.auditLog.createNewAuditLog(OMRSAuditingComponent.COHORT_REGISTRY));
            if (localRepository != null) {
                this.cohortRegistry.initialize(cohortName, localMetadataCollectionId, localMetadataCollectionName, localRepository.getLocalRepositoryRemoteConnection(), localServerName, localServerType, localOrganizationName, outboundRegistryEventProcessor, cohortRegistryStore, connectionConsumer);
                this.localRepositoryEventManager = localRepository.getOutboundRepositoryEventManager();
                if (this.localRepositoryEventManager != null) {
                    OMRSRepositoryEventPublisher repositoryEventPublisher = new OMRSRepositoryEventPublisher(cohortName, cohortTopicConnector, this.auditLog.createNewAuditLog(OMRSAuditingComponent.EVENT_PUBLISHER));
                    this.localRepositoryEventManager.registerRepositoryEventProcessor(repositoryEventPublisher);
                }
                if (localRepository.getIncomingTypeDefEventProcessor() != null) {
                    this.cohortRepositoryEventManager.registerTypeDefProcessor(localRepository.getIncomingTypeDefEventProcessor());
                }
                if (localRepository.getIncomingInstanceEventProcessor() != null) {
                    this.cohortRepositoryEventManager.registerInstanceProcessor(localRepository.getIncomingInstanceEventProcessor());
                }
            } else {
                this.cohortRegistry.initialize(cohortName, null, null, null, localServerName, localServerType, localOrganizationName, outboundRegistryEventProcessor, cohortRegistryStore, connectionConsumer);
            }
            if (enterpriseTopicConnector != null) {
                OMRSRepositoryEventPublisher enterpriseEventPublisher = new OMRSRepositoryEventPublisher("Cohort to Enterprise", enterpriseTopicConnector, this.auditLog.createNewAuditLog(OMRSAuditingComponent.EVENT_PUBLISHER));
                this.cohortRepositoryEventManager.registerRepositoryEventProcessor(enterpriseEventPublisher);
            }
            this.cohortConnectionStatus = CohortConnectionStatus.NEW;
            if (this.cohortRepositoryEventManager != null) {
                this.cohortRepositoryEventManager.start();
            }
            if (cohortTopicConnector != null) {
                OMRSEventListener cohortEventListener = new OMRSEventListener(cohortName, localMetadataCollectionId, this.cohortRegistry, this.cohortRepositoryEventManager, this.auditLog.createNewAuditLog(OMRSAuditingComponent.EVENT_LISTENER));
                cohortTopicConnector.registerListener((OMRSTopicListener)cohortEventListener, cohortName);
                cohortTopicConnector.start();
                this.cohortTopicConnector = cohortTopicConnector;
                this.cohortEventListener = cohortEventListener;
                this.cohortRegistry.connectToCohort();
                this.cohortConnectionStatus = CohortConnectionStatus.CONNECTED;
            }
        }
        catch (Throwable error) {
            log.error("Unable to initialize cohort manager", error);
            this.cohortConnectionStatus = CohortConnectionStatus.CONFIGURATION_ERROR;
            OMRSAuditCode auditCode = OMRSAuditCode.COHORT_CONFIG_ERROR;
            this.auditLog.logException("Initialize Cohort Manager", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{cohortName, error.getClass().getName(), error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction(), error);
        }
        log.debug("Initialize Cohort Manager COMPLETE");
    }

    public String getCohortName() {
        return this.cohortName;
    }

    MemberRegistration getLocalRegistration() {
        if (this.cohortRegistry != null) {
            return this.cohortRegistry.getLocalRegistration();
        }
        return null;
    }

    CohortDescription getCohortDescription() {
        CohortDescription description = new CohortDescription();
        description.setCohortName(this.cohortName);
        description.setTopicConnection(this.cohortTopicConnection);
        description.setConnectionStatus(this.cohortConnectionStatus);
        return description;
    }

    List<MemberRegistration> getRemoteMembers() {
        if (this.cohortRegistry != null) {
            return this.cohortRegistry.getRemoteMembers();
        }
        return null;
    }

    public CohortConnectionStatus getCohortConnectionStatus() {
        return this.cohortConnectionStatus;
    }

    public synchronized void disconnect(boolean permanent) {
        String actionDescription = "Disconnect Cohort Manager";
        log.debug("Disconnect Cohort Manager");
        try {
            this.cohortConnectionStatus = CohortConnectionStatus.DISCONNECTING;
            if (this.cohortRegistry != null) {
                this.cohortRegistry.disconnectFromCohort(permanent);
            }
            if (this.cohortTopicConnector != null) {
                this.cohortTopicConnector.disconnect();
            }
            this.cohortConnectionStatus = CohortConnectionStatus.DISCONNECTED;
        }
        catch (ConnectorCheckedException error) {
            log.debug("Disconnect Cohort Manager FAILED with connector checked exception");
            OMRSErrorCode errorCode = OMRSErrorCode.COHORT_DISCONNECT_FAILED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.cohortName});
            throw new OMRSConnectorErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "Disconnect Cohort Manager", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)error);
        }
        catch (Throwable error) {
            log.debug("Disconnect Cohort Manager FAILED with exception");
            throw error;
        }
        log.debug("Disconnect Cohort Manager COMPLETE");
    }

    public String toString() {
        return "OMRSCohortManager{cohortName='" + this.cohortName + '\'' + ", cohortTopicConnector=" + this.cohortTopicConnector + ", cohortRepositoryEventManager=" + (Object)((Object)this.cohortRepositoryEventManager) + ", cohortRegistry=" + (Object)((Object)this.cohortRegistry) + ", cohortEventListener=" + this.cohortEventListener + ", cohortConnectionStatus=" + this.cohortConnectionStatus + ", localRepositoryEventManager=" + (Object)((Object)this.localRepositoryEventManager) + '}';
    }
}

