/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefInUseException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.metadatahighway.OMRSMetadataHighwayManager;
import org.odpi.openmetadata.repositoryservices.rest.properties.AttributeTypeDefListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.AttributeTypeDefResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.BooleanResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityCreateRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityDetailResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityNeighborhoodFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityNeighborhoodHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityPropertyFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityPropertyHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntitySummaryResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.HistoryRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceGraphRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceGraphResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstancePropertiesRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.MetadataCollectionIdResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.PropertyMatchFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.PropertyMatchHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelatedEntitiesFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelatedEntitiesHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipCreateRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefChangeRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefGalleryResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefReIdentifyRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefValidationForRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeLimitedFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeLimitedHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.VoidResponse;
import org.odpi.openmetadata.repositoryservices.rest.services.OMRSRepositoryServicesInstance;
import org.odpi.openmetadata.repositoryservices.rest.services.OMRSRepositoryServicesInstanceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryRESTServices {
    private static final String serviceName = CommonServicesDescription.REPOSITORY_SERVICES.getServiceName();
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryRESTServices.class);
    private static OMRSRepositoryServicesInstanceHandler instanceHandler = new OMRSRepositoryServicesInstanceHandler(serviceName);
    private static final String anonymousUserId = "anon";
    private boolean localRepository;

    public static void setServerRepositories(String localServerName, LocalOMRSRepositoryConnector localRepositoryConnector, OMRSRepositoryConnector enterpriseRepositoryConnector, OMRSMetadataHighwayManager metadataHighwayManager, String localServerURL, OMRSAuditLog auditLog, int maxPageSize) {
        new OMRSRepositoryServicesInstance(localServerName, localRepositoryConnector, enterpriseRepositoryConnector, metadataHighwayManager, localServerURL, serviceName, auditLog, maxPageSize);
    }

    public static void stopInboundRESTCalls(String localServerName) {
        new OMRSRepositoryServicesInstanceHandler(serviceName).removeInstance(localServerName);
    }

    public static String getEntityURL(String localServerName, String ... guid) {
        String methodName = "getEntityURL";
        if (localServerName != null) {
            try {
                String localServerURL;
                OMRSRepositoryServicesInstance localServerInstance = instanceHandler.getInstance(anonymousUserId, localServerName, "getEntityURL");
                if (localServerInstance != null && (localServerURL = localServerInstance.getLocalServerURL()) != null) {
                    String urlTemplate = "/instances/entity/{0}";
                    MessageFormat mf = new MessageFormat("/instances/entity/{0}");
                    return localServerURL + mf.format(guid);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getRelationshipURL(String localServerName, String ... guid) {
        String methodName = "getRelationshipURL";
        if (localServerName != null) {
            try {
                String localServerURL;
                OMRSRepositoryServicesInstance localServerInstance = instanceHandler.getInstance(anonymousUserId, localServerName, "getRelationshipURL");
                if (localServerInstance != null && (localServerURL = localServerInstance.getLocalServerURL()) != null) {
                    String urlTemplate = "/instances/relationship/{0}";
                    MessageFormat mf = new MessageFormat("/instances/relationship/{0}");
                    return localServerURL + mf.format(guid);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public OMRSRepositoryRESTServices(boolean localRepository) {
        this.localRepository = localRepository;
    }

    @Deprecated
    public MetadataCollectionIdResponse getMetadataCollectionId(String serverName) {
        return this.getMetadataCollectionId(serverName, anonymousUserId);
    }

    public MetadataCollectionIdResponse getMetadataCollectionId(String serverName, String userId) {
        String methodName = "getMetadataCollectionId";
        log.debug("Calling method: getMetadataCollectionId");
        MetadataCollectionIdResponse response = new MetadataCollectionIdResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getMetadataCollectionId");
            response.setMetadataCollectionId(metadataCollection.getMetadataCollectionId(userId));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getMetadataCollectionId", instanceHandler.getAuditLog(userId, serverName, "getMetadataCollectionId"));
        }
        log.debug("Returning from method: getMetadataCollectionId with response: " + response.toString());
        return response;
    }

    public TypeDefGalleryResponse getAllTypes(String serverName, String userId) {
        String methodName = "getAllTypes";
        log.debug("Calling method: getAllTypes");
        TypeDefGalleryResponse response = new TypeDefGalleryResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getAllTypes");
            TypeDefGallery typeDefGallery = metadataCollection.getAllTypes(userId);
            if (typeDefGallery != null) {
                response.setAttributeTypeDefs(typeDefGallery.getAttributeTypeDefs());
                response.setTypeDefs((List)typeDefGallery.getTypeDefs());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getAllTypes", instanceHandler.getAuditLog(userId, serverName, "getAllTypes"));
        }
        log.debug("Returning from method: getAllTypes with response: " + response.toString());
        return response;
    }

    public TypeDefGalleryResponse findTypesByName(String serverName, String userId, String name) {
        String methodName = "findTypesByName";
        log.debug("Calling method: findTypesByName");
        TypeDefGalleryResponse response = new TypeDefGalleryResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findTypesByName");
            TypeDefGallery typeDefGallery = metadataCollection.findTypesByName(userId, name);
            if (typeDefGallery != null) {
                response.setAttributeTypeDefs(typeDefGallery.getAttributeTypeDefs());
                response.setTypeDefs((List)typeDefGallery.getTypeDefs());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findTypesByName", instanceHandler.getAuditLog(userId, serverName, "findTypesByName"));
        }
        log.debug("Returning from method: findTypesByName with response: " + response.toString());
        return response;
    }

    public TypeDefListResponse findTypeDefsByCategory(String serverName, String userId, TypeDefCategory category) {
        String methodName = "findTypeDefsByCategory";
        log.debug("Calling method: findTypeDefsByCategory");
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findTypeDefsByCategory");
            response.setTypeDefs(metadataCollection.findTypeDefsByCategory(userId, category));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findTypeDefsByCategory", instanceHandler.getAuditLog(userId, serverName, "findTypeDefsByCategory"));
        }
        log.debug("Returning from method: findTypeDefsByCategory with response: " + response.toString());
        return response;
    }

    public AttributeTypeDefListResponse findAttributeTypeDefsByCategory(String serverName, String userId, AttributeTypeDefCategory category) {
        String methodName = "findAttributeTypeDefsByCategory";
        log.debug("Calling method: findAttributeTypeDefsByCategory");
        AttributeTypeDefListResponse response = new AttributeTypeDefListResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findAttributeTypeDefsByCategory");
            response.setAttributeTypeDefs(metadataCollection.findAttributeTypeDefsByCategory(userId, category));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findAttributeTypeDefsByCategory", instanceHandler.getAuditLog(userId, serverName, "findAttributeTypeDefsByCategory"));
        }
        log.debug("Returning from method: findAttributeTypeDefsByCategory with response: " + response.toString());
        return response;
    }

    public TypeDefListResponse findTypeDefsByProperty(String serverName, String userId, TypeDefProperties matchCriteria) {
        String methodName = "findTypeDefsByProperty";
        log.debug("Calling method: findTypeDefsByProperty");
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findTypeDefsByProperty");
            response.setTypeDefs(metadataCollection.findTypeDefsByProperty(userId, matchCriteria));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findTypeDefsByProperty", instanceHandler.getAuditLog(userId, serverName, "findTypeDefsByProperty"));
        }
        log.debug("Returning from method: findTypeDefsByProperty with response: " + response.toString());
        return response;
    }

    public TypeDefListResponse findTypesByExternalID(String serverName, String userId, String standard, String organization, String identifier) {
        String methodName = "findTypesByExternalID";
        log.debug("Calling method: findTypesByExternalID");
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findTypesByExternalID");
            List typeDefs = metadataCollection.findTypesByExternalID(userId, standard, organization, identifier);
            response.setTypeDefs(typeDefs);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findTypesByExternalID", instanceHandler.getAuditLog(userId, serverName, "findTypesByExternalID"));
        }
        log.debug("Returning from method: findTypesByExternalID with response: " + response.toString());
        return response;
    }

    public TypeDefListResponse searchForTypeDefs(String serverName, String userId, String searchCriteria) {
        String methodName = "searchForTypeDefs";
        log.debug("Calling method: searchForTypeDefs");
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "searchForTypeDefs");
            response.setTypeDefs(metadataCollection.searchForTypeDefs(userId, searchCriteria));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "searchForTypeDefs", instanceHandler.getAuditLog(userId, serverName, "searchForTypeDefs"));
        }
        log.debug("Returning from method: searchForTypeDefs with response: " + response.toString());
        return response;
    }

    public TypeDefResponse getTypeDefByGUID(String serverName, String userId, String guid) {
        String methodName = "getTypeDefByGUID";
        log.debug("Calling method: getTypeDefByGUID");
        TypeDefResponse response = new TypeDefResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getTypeDefByGUID");
            response.setTypeDef(metadataCollection.getTypeDefByGUID(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException(response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getTypeDefByGUID", instanceHandler.getAuditLog(userId, serverName, "getTypeDefByGUID"));
        }
        log.debug("Returning from method: getTypeDefByGUID with response: " + response.toString());
        return response;
    }

    public AttributeTypeDefResponse getAttributeTypeDefByGUID(String serverName, String userId, String guid) {
        String methodName = "getAttributeTypeDefByGUID";
        log.debug("Calling method: getAttributeTypeDefByGUID");
        AttributeTypeDefResponse response = new AttributeTypeDefResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getAttributeTypeDefByGUID");
            response.setAttributeTypeDef(metadataCollection.getAttributeTypeDefByGUID(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnown((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getAttributeTypeDefByGUID", instanceHandler.getAuditLog(userId, serverName, "getAttributeTypeDefByGUID"));
        }
        log.debug("Returning from method: getAttributeTypeDefByGUID with response: " + response.toString());
        return response;
    }

    public TypeDefResponse getTypeDefByName(String serverName, String userId, String name) {
        String methodName = "getTypeDefByName";
        log.debug("Calling method: getTypeDefByName");
        TypeDefResponse response = new TypeDefResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getTypeDefByName");
            response.setTypeDef(metadataCollection.getTypeDefByName(userId, name));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException(response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getTypeDefByName", instanceHandler.getAuditLog(userId, serverName, "getTypeDefByName"));
        }
        log.debug("Returning from method: getTypeDefByName with response: " + response.toString());
        return response;
    }

    public AttributeTypeDefResponse getAttributeTypeDefByName(String serverName, String userId, String name) {
        String methodName = "getAttributeTypeDefByName";
        log.debug("Calling method: getAttributeTypeDefByName");
        AttributeTypeDefResponse response = new AttributeTypeDefResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getAttributeTypeDefByName");
            response.setAttributeTypeDef(metadataCollection.getAttributeTypeDefByName(userId, name));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnown((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getAttributeTypeDefByName", instanceHandler.getAuditLog(userId, serverName, "getAttributeTypeDefByName"));
        }
        log.debug("Returning from method: getAttributeTypeDefByName with response: " + response.toString());
        return response;
    }

    private void logDynamicTypeManagement(String serverName, String userId, String methodName, String typeName, String typeGUID) throws InvalidParameterException, UserNotAuthorizedException, RepositoryErrorException {
        OMRSRepositoryServicesInstance instance = instanceHandler.getInstance(userId, serverName, methodName);
        if (instance != null) {
            OMRSAuditLog auditLog = instance.getAuditLog();
            OMRSAuditCode auditCode = OMRSAuditCode.AD_HOC_TYPE_DEFINITION;
            auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{typeName, typeGUID, serverName, userId, methodName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public VoidResponse addTypeDefGallery(String serverName, String userId, TypeDefGallery newTypes) {
        String methodName = "addTypeDefGallery";
        log.debug("Calling method: addTypeDefGallery");
        VoidResponse response = new VoidResponse();
        try {
            List attributeTypeDefs;
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "addTypeDefGallery");
            metadataCollection.addTypeDefGallery(userId, newTypes);
            ArrayList typeDefs = newTypes.getTypeDefs();
            if (typeDefs != null) {
                for (TypeDef typeDef : typeDefs) {
                    if (typeDef == null) continue;
                    this.logDynamicTypeManagement(serverName, userId, "addTypeDefGallery", typeDef.getName(), typeDef.getGUID());
                }
            }
            if ((attributeTypeDefs = newTypes.getAttributeTypeDefs()) != null) {
                for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
                    if (attributeTypeDef == null) continue;
                    this.logDynamicTypeManagement(serverName, userId, "addTypeDefGallery", attributeTypeDef.getName(), attributeTypeDef.getGUID());
                }
            }
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefKnownException error) {
            this.captureTypeDefKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "addTypeDefGallery", instanceHandler.getAuditLog(userId, serverName, "addTypeDefGallery"));
        }
        log.debug("Returning from method: addTypeDefGallery with response: " + response.toString());
        return response;
    }

    public VoidResponse addTypeDef(String serverName, String userId, TypeDef newTypeDef) {
        String methodName = "addTypeDef";
        log.debug("Calling method: addTypeDef");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "addTypeDef");
            metadataCollection.addTypeDef(userId, newTypeDef);
            this.logDynamicTypeManagement(serverName, userId, "addTypeDef", newTypeDef.getName(), newTypeDef.getGUID());
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefKnownException error) {
            this.captureTypeDefKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "addTypeDef", instanceHandler.getAuditLog(userId, serverName, "addTypeDef"));
        }
        log.debug("Returning from method: addTypeDef with response: " + response.toString());
        return response;
    }

    public VoidResponse addAttributeTypeDef(String serverName, String userId, AttributeTypeDef newAttributeTypeDef) {
        String methodName = "addAttributeTypeDef";
        log.debug("Calling method: addAttributeTypeDef");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "addAttributeTypeDef");
            metadataCollection.addAttributeTypeDef(userId, newAttributeTypeDef);
            this.logDynamicTypeManagement(serverName, userId, "addAttributeTypeDef", newAttributeTypeDef.getName(), newAttributeTypeDef.getGUID());
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefKnownException error) {
            this.captureTypeDefKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "addAttributeTypeDef", instanceHandler.getAuditLog(userId, serverName, "addAttributeTypeDef"));
        }
        log.debug("Returning from method: addAttributeTypeDef with response: " + response.toString());
        return response;
    }

    public BooleanResponse verifyTypeDef(String serverName, String userId, TypeDef typeDef) {
        String methodName = "verifyTypeDef";
        log.debug("Calling method: verifyTypeDef");
        BooleanResponse response = new BooleanResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "verifyTypeDef");
            response.setFlag(metadataCollection.verifyTypeDef(userId, typeDef));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "verifyTypeDef", instanceHandler.getAuditLog(userId, serverName, "verifyTypeDef"));
        }
        log.debug("Returning from method: verifyTypeDef with response: " + response.toString());
        return response;
    }

    public BooleanResponse verifyAttributeTypeDef(String serverName, String userId, AttributeTypeDef attributeTypeDef) {
        String methodName = "verifyAttributeTypeDef";
        log.debug("Calling method: verifyAttributeTypeDef");
        BooleanResponse response = new BooleanResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "verifyAttributeTypeDef");
            response.setFlag(metadataCollection.verifyAttributeTypeDef(userId, attributeTypeDef));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "verifyAttributeTypeDef", instanceHandler.getAuditLog(userId, serverName, "verifyAttributeTypeDef"));
        }
        log.debug("Returning from method: verifyAttributeTypeDef with response: " + response.toString());
        return response;
    }

    public TypeDefResponse updateTypeDef(String serverName, String userId, TypeDefPatch typeDefPatch) {
        String methodName = "updateTypeDef";
        log.debug("Calling method: updateTypeDef");
        TypeDefResponse response = new TypeDefResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "updateTypeDef");
            response.setTypeDef(metadataCollection.updateTypeDef(userId, typeDefPatch));
            this.logDynamicTypeManagement(serverName, userId, "updateTypeDef", typeDefPatch.getTypeDefName(), typeDefPatch.getTypeDefGUID());
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException(response, error);
        }
        catch (PatchErrorException error) {
            response.setRelatedHTTPCode(error.getReportedHTTPCode());
            response.setExceptionClassName(PatchErrorException.class.getName());
            response.setExceptionErrorMessage(error.getErrorMessage());
            response.setExceptionSystemAction(error.getReportedSystemAction());
            response.setExceptionUserAction(error.getReportedUserAction());
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "updateTypeDef", instanceHandler.getAuditLog(userId, serverName, "updateTypeDef"));
        }
        log.debug("Returning from method: updateTypeDef with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteTypeDef(String serverName, String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) {
        String methodName = "deleteTypeDef";
        log.debug("Calling method: deleteTypeDef");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "deleteTypeDef");
            metadataCollection.deleteTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
            this.logDynamicTypeManagement(serverName, userId, "deleteTypeDef", obsoleteTypeDefName, obsoleteTypeDefGUID);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefInUseException error) {
            this.captureTypeDefInUseException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "deleteTypeDef", instanceHandler.getAuditLog(userId, serverName, "deleteTypeDef"));
        }
        log.debug("Returning from method: deleteTypeDef with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteAttributeTypeDef(String serverName, String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) {
        String methodName = "deleteAttributeTypeDef";
        log.debug("Calling method: deleteAttributeTypeDef");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "deleteAttributeTypeDef");
            metadataCollection.deleteAttributeTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
            this.logDynamicTypeManagement(serverName, userId, "deleteAttributeTypeDef", obsoleteTypeDefName, obsoleteTypeDefGUID);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefInUseException error) {
            this.captureTypeDefInUseException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "deleteAttributeTypeDef", instanceHandler.getAuditLog(userId, serverName, "deleteAttributeTypeDef"));
        }
        log.debug("Returning from method: deleteAttributeTypeDef with response: " + response.toString());
        return response;
    }

    public TypeDefResponse reIdentifyTypeDef(String serverName, String userId, String originalTypeDefGUID, TypeDefReIdentifyRequest requestParameters) {
        String methodName = "reIdentifyTypeDef";
        log.debug("Calling method: reIdentifyTypeDef");
        String originalTypeDefName = null;
        String newTypeDefGUID = null;
        String newTypeDefName = null;
        TypeDefResponse response = new TypeDefResponse();
        if (requestParameters != null) {
            originalTypeDefName = requestParameters.getOriginalTypeDefName();
            newTypeDefGUID = requestParameters.getNewTypeDefGUID();
            newTypeDefName = requestParameters.getNewTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "reIdentifyTypeDef");
            response.setTypeDef(metadataCollection.reIdentifyTypeDef(userId, originalTypeDefGUID, originalTypeDefName, newTypeDefGUID, newTypeDefName));
            this.logDynamicTypeManagement(serverName, userId, "reIdentifyTypeDef", originalTypeDefName, originalTypeDefGUID);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException(response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "reIdentifyTypeDef", instanceHandler.getAuditLog(userId, serverName, "reIdentifyTypeDef"));
        }
        log.debug("Returning from method: reIdentifyTypeDef with response: " + response.toString());
        return response;
    }

    public AttributeTypeDefResponse reIdentifyAttributeTypeDef(String serverName, String userId, String originalAttributeTypeDefGUID, TypeDefReIdentifyRequest requestParameters) {
        String methodName = "reIdentifyAttributeTypeDef";
        log.debug("Calling method: reIdentifyAttributeTypeDef");
        String originalAttributeTypeDefName = null;
        String newAttributeTypeDefGUID = null;
        String newAttributeTypeDefName = null;
        AttributeTypeDefResponse response = new AttributeTypeDefResponse();
        if (requestParameters != null) {
            originalAttributeTypeDefName = requestParameters.getOriginalTypeDefName();
            newAttributeTypeDefGUID = requestParameters.getNewTypeDefGUID();
            newAttributeTypeDefName = requestParameters.getNewTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "reIdentifyAttributeTypeDef");
            response.setAttributeTypeDef(metadataCollection.reIdentifyAttributeTypeDef(userId, originalAttributeTypeDefGUID, originalAttributeTypeDefName, newAttributeTypeDefGUID, newAttributeTypeDefName));
            this.logDynamicTypeManagement(serverName, userId, "reIdentifyAttributeTypeDef", originalAttributeTypeDefName, originalAttributeTypeDefGUID);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnown((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "reIdentifyAttributeTypeDef", instanceHandler.getAuditLog(userId, serverName, "reIdentifyAttributeTypeDef"));
        }
        log.debug("Returning from method: reIdentifyAttributeTypeDef with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse isEntityKnown(String serverName, String userId, String guid) {
        String methodName = "isEntityKnown";
        log.debug("Calling method: isEntityKnown");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "isEntityKnown");
            response.setEntity(metadataCollection.isEntityKnown(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "isEntityKnown", instanceHandler.getAuditLog(userId, serverName, "isEntityKnown"));
        }
        log.debug("Returning from method: isEntityKnown with response: " + response.toString());
        return response;
    }

    public EntitySummaryResponse getEntitySummary(String serverName, String userId, String guid) {
        String methodName = "getEntitySummary";
        log.debug("Calling method: getEntitySummary");
        EntitySummaryResponse response = new EntitySummaryResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getEntitySummary");
            response.setEntity(metadataCollection.getEntitySummary(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getEntitySummary", instanceHandler.getAuditLog(userId, serverName, "getEntitySummary"));
        }
        log.debug("Returning from method: getEntitySummary with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse getEntityDetail(String serverName, String guid) {
        return this.getEntityDetail(serverName, null, guid);
    }

    public EntityDetailResponse getEntityDetail(String serverName, String userId, String guid) {
        String methodName = "getEntityDetail";
        log.debug("Calling method: getEntityDetail");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getEntityDetail");
            response.setEntity(metadataCollection.getEntityDetail(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (EntityProxyOnlyException error) {
            this.captureEntityProxyOnlyException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getEntityDetail", instanceHandler.getAuditLog(userId, serverName, "getEntityDetail"));
        }
        log.debug("Returning from method: getEntityDetail with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse getEntityDetail(String serverName, String userId, String guid, HistoryRequest asOfTime) {
        String methodName = "getEntityDetail";
        log.debug("Calling method: getEntityDetail");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getEntityDetail");
            if (asOfTime != null) {
                response.setEntity(metadataCollection.getEntityDetail(userId, guid, asOfTime.getAsOfTime()));
            } else {
                response.setEntity(metadataCollection.getEntityDetail(userId, guid, null));
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (EntityProxyOnlyException error) {
            this.captureEntityProxyOnlyException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getEntityDetail", instanceHandler.getAuditLog(userId, serverName, "getEntityDetail"));
        }
        log.debug("Returning from method: getEntityDetail with response: " + response.toString());
        return response;
    }

    public RelationshipListResponse getRelationshipsForEntity(String serverName, String userId, String entityGUID, TypeLimitedFindRequest findRequestParameters) {
        String methodName = "getRelationshipsForEntity";
        log.debug("Calling method: getRelationshipsForEntity");
        String relationshipTypeGUID = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getRelationshipsForEntity");
            List relationships = metadataCollection.getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/entity/{1}/relationships";
                    TypeLimitedFindRequest nextFindRequestParameters = new TypeLimitedFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("getRelationshipsForEntity", serverName, userId, "{0}/instances/entity/{1}/relationships", nextFindRequestParameters, userId, entityGUID));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getRelationshipsForEntity", instanceHandler.getAuditLog(userId, serverName, "getRelationshipsForEntity"));
        }
        log.debug("Returning from method: getRelationshipsForEntity with response: " + response.toString());
        return response;
    }

    public RelationshipListResponse getRelationshipsForEntityHistory(String serverName, String userId, String entityGUID, TypeLimitedHistoricalFindRequest findRequestParameters) {
        String methodName = "getRelationshipsForEntityHistory";
        log.debug("Calling method: getRelationshipsForEntityHistory");
        String relationshipTypeGUID = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getRelationshipsForEntityHistory");
            List relationships = metadataCollection.getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/entity/{1}/relationships/history";
                    TypeLimitedHistoricalFindRequest nextFindRequestParameters = new TypeLimitedHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("getRelationshipsForEntityHistory", serverName, userId, "{0}/instances/entity/{1}/relationships/history", nextFindRequestParameters, userId, entityGUID));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getRelationshipsForEntityHistory", instanceHandler.getAuditLog(userId, serverName, "getRelationshipsForEntityHistory"));
        }
        log.debug("Returning from method: getRelationshipsForEntityHistory with response: " + response.toString());
        return response;
    }

    public EntityListResponse findEntitiesByProperty(String serverName, String userId, EntityPropertyFindRequest findRequestParameters) {
        String methodName = "findEntitiesByProperty";
        log.debug("Calling method: findEntitiesByProperty");
        String entityTypeGUID = null;
        InstanceProperties matchProperties = null;
        MatchCriteria matchCriteria = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            matchProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findEntitiesByProperty");
            List entities = metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, null, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-property";
                    EntityPropertyFindRequest nextFindRequestParameters = new EntityPropertyFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("findEntitiesByProperty", serverName, userId, "{0}/instances/entities/by-property", nextFindRequestParameters, userId));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findEntitiesByProperty", instanceHandler.getAuditLog(userId, serverName, "findEntitiesByProperty"));
        }
        log.debug("Returning from method: findEntitiesByProperty with response: " + response.toString());
        return response;
    }

    public EntityListResponse findEntitiesByPropertyHistory(String serverName, String userId, EntityPropertyHistoricalFindRequest findRequestParameters) {
        String methodName = "findEntitiesByPropertyHistory";
        log.debug("Calling method: findEntitiesByPropertyHistory");
        String entityTypeGUID = null;
        InstanceProperties matchProperties = null;
        MatchCriteria matchCriteria = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            matchProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findEntitiesByPropertyHistory");
            List entities = metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-property/history";
                    EntityPropertyFindRequest nextFindRequestParameters = new EntityPropertyFindRequest((EntityPropertyFindRequest)findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("findEntitiesByPropertyHistory", serverName, userId, "{0}/instances/entities/by-property/history", nextFindRequestParameters, userId));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findEntitiesByPropertyHistory", instanceHandler.getAuditLog(userId, serverName, "findEntitiesByPropertyHistory"));
        }
        log.debug("Returning from method: findEntitiesByPropertyHistory with response: " + response.toString());
        return response;
    }

    public EntityListResponse findEntitiesByClassification(String serverName, String userId, String classificationName, PropertyMatchFindRequest findRequestParameters) {
        String methodName = "findEntitiesByClassification";
        log.debug("Calling method: findEntitiesByClassification");
        String entityTypeGUID = null;
        InstanceProperties matchClassificationProperties = null;
        MatchCriteria matchCriteria = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            matchClassificationProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findEntitiesByClassification");
            List entities = metadataCollection.findEntitiesByClassification(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-classification/{1}";
                    PropertyMatchFindRequest nextFindRequestParameters = new PropertyMatchFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("findEntitiesByClassification", serverName, userId, "{0}/instances/entities/by-classification/{1}", nextFindRequestParameters, userId, classificationName));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findEntitiesByClassification", instanceHandler.getAuditLog(userId, serverName, "findEntitiesByClassification"));
        }
        log.debug("Returning from method: findEntitiesByClassification with response: " + response.toString());
        return response;
    }

    public EntityListResponse findEntitiesByClassificationHistory(String serverName, String userId, String classificationName, PropertyMatchHistoricalFindRequest findRequestParameters) {
        String methodName = "findEntitiesByClassificationHistory";
        log.debug("Calling method: findEntitiesByClassificationHistory");
        String entityTypeGUID = null;
        InstanceProperties matchClassificationProperties = null;
        MatchCriteria matchCriteria = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            matchClassificationProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
            asOfTime = findRequestParameters.getAsOfTime();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findEntitiesByClassificationHistory");
            List entities = metadataCollection.findEntitiesByClassification(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-classification/{1}/history";
                    PropertyMatchHistoricalFindRequest nextFindRequestParameters = new PropertyMatchHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("findEntitiesByClassificationHistory", serverName, userId, "{0}/instances/entities/by-classification/{1}/history", nextFindRequestParameters, userId, classificationName));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findEntitiesByClassificationHistory", instanceHandler.getAuditLog(userId, serverName, "findEntitiesByClassificationHistory"));
        }
        log.debug("Returning from method: findEntitiesByClassificationHistory with response: " + response.toString());
        return response;
    }

    public EntityListResponse findEntitiesByPropertyValue(String serverName, String userId, String searchCriteria, EntityPropertyFindRequest findRequestParameters) {
        String methodName = "findEntitiesByPropertyValue";
        log.debug("Calling method: findEntitiesByPropertyValue");
        String entityTypeGUID = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findEntitiesByPropertyValue");
            List entities = metadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, null, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-property-value?searchCriteria={1}";
                    EntityPropertyFindRequest nextFindRequestParameters = new EntityPropertyFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("findEntitiesByPropertyValue", serverName, userId, "{0}/instances/entities/by-property-value?searchCriteria={1}", nextFindRequestParameters, userId, searchCriteria));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findEntitiesByPropertyValue", instanceHandler.getAuditLog(userId, serverName, "findEntitiesByPropertyValue"));
        }
        log.debug("Returning from method: findEntitiesByPropertyValue with response: " + response.toString());
        return response;
    }

    public EntityListResponse findEntitiesByPropertyValueHistory(String serverName, String userId, String searchCriteria, EntityPropertyHistoricalFindRequest findRequestParameters) {
        String methodName = "findEntitiesByPropertyValueHistory";
        log.debug("Calling method: findEntitiesByPropertyValueHistory");
        String entityTypeGUID = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findEntitiesByPropertyValueHistory");
            List entities = metadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-property-value/history?searchCriteria={1}";
                    EntityPropertyHistoricalFindRequest nextFindRequestParameters = new EntityPropertyHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("findEntitiesByPropertyValueHistory", serverName, userId, "{0}/instances/entities/by-property-value/history?searchCriteria={1}", nextFindRequestParameters, userId, searchCriteria));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findEntitiesByPropertyValueHistory", instanceHandler.getAuditLog(userId, serverName, "findEntitiesByPropertyValueHistory"));
        }
        log.debug("Returning from method: findEntitiesByPropertyValueHistory with response: " + response.toString());
        return response;
    }

    public RelationshipResponse isRelationshipKnown(String serverName, String userId, String guid) {
        String methodName = "isRelationshipKnown";
        log.debug("Calling method: isRelationshipKnown");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "isRelationshipKnown");
            response.setRelationship(metadataCollection.isRelationshipKnown(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "isRelationshipKnown", instanceHandler.getAuditLog(userId, serverName, "isRelationshipKnown"));
        }
        log.debug("Returning from method: isRelationshipKnown with response: " + response.toString());
        return response;
    }

    public RelationshipResponse getRelationship(String serverName, String guid) {
        return this.getRelationship(serverName, null, guid);
    }

    public RelationshipResponse getRelationship(String serverName, String userId, String guid) {
        String methodName = "getRelationship";
        log.debug("Calling method: getRelationship");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getRelationship");
            response.setRelationship(metadataCollection.getRelationship(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getRelationship", instanceHandler.getAuditLog(userId, serverName, "getRelationship"));
        }
        log.debug("Returning from method: getRelationship with response: " + response.toString());
        return response;
    }

    public RelationshipResponse getRelationship(String serverName, String userId, String guid, HistoryRequest asOfTime) {
        String methodName = "getRelationship";
        log.debug("Calling method: getRelationship");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getRelationship");
            if (asOfTime != null) {
                response.setRelationship(metadataCollection.getRelationship(userId, guid, asOfTime.getAsOfTime()));
            } else {
                response.setRelationship(metadataCollection.getRelationship(userId, guid, null));
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getRelationship", instanceHandler.getAuditLog(userId, serverName, "getRelationship"));
        }
        log.debug("Returning from method: getRelationship with response: " + response.toString());
        return response;
    }

    public RelationshipListResponse findRelationshipsByProperty(String serverName, String userId, PropertyMatchFindRequest findRequestParameters) {
        String methodName = "findRelationshipsByProperty";
        log.debug("Calling method: findRelationshipsByProperty");
        String relationshipTypeGUID = null;
        InstanceProperties matchProperties = null;
        MatchCriteria matchCriteria = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            matchProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findRelationshipsByProperty");
            List relationships = metadataCollection.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/relationships/by-property";
                    PropertyMatchFindRequest nextFindRequestParameters = new PropertyMatchFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("findRelationshipsByProperty", serverName, userId, "{0}/instances/relationships/by-property", nextFindRequestParameters, userId));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findRelationshipsByProperty", instanceHandler.getAuditLog(userId, serverName, "findRelationshipsByProperty"));
        }
        log.debug("Returning from method: findRelationshipsByProperty with response: " + response.toString());
        return response;
    }

    public RelationshipListResponse findRelationshipsByPropertyHistory(String serverName, String userId, PropertyMatchHistoricalFindRequest findRequestParameters) {
        String methodName = "findRelationshipsByPropertyHistory";
        log.debug("Calling method: findRelationshipsByPropertyHistory");
        String relationshipTypeGUID = null;
        InstanceProperties matchProperties = null;
        MatchCriteria matchCriteria = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            matchProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findRelationshipsByPropertyHistory");
            List relationships = metadataCollection.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/relationships/by-property/history";
                    PropertyMatchHistoricalFindRequest nextFindRequestParameters = new PropertyMatchHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("findRelationshipsByPropertyHistory", serverName, userId, "{0}/instances/relationships/by-property/history", nextFindRequestParameters, userId));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findRelationshipsByPropertyHistory", instanceHandler.getAuditLog(userId, serverName, "findRelationshipsByPropertyHistory"));
        }
        log.debug("Returning from method: findRelationshipsByPropertyHistory with response: " + response.toString());
        return response;
    }

    public RelationshipListResponse findRelationshipsByPropertyValue(String serverName, String userId, String searchCriteria, TypeLimitedFindRequest findRequestParameters) {
        String methodName = "findRelationshipsByPropertyValue";
        log.debug("Calling method: findRelationshipsByPropertyValue");
        String relationshipTypeGUID = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findRelationshipsByPropertyValue");
            List relationships = metadataCollection.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/relationships/by-property-value?searchCriteria={1}";
                    TypeLimitedFindRequest nextFindRequestParameters = new TypeLimitedFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("findRelationshipsByPropertyValue", serverName, userId, "{0}/instances/relationships/by-property-value?searchCriteria={1}", nextFindRequestParameters, userId, searchCriteria));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findRelationshipsByPropertyValue", instanceHandler.getAuditLog(userId, serverName, "findRelationshipsByPropertyValue"));
        }
        log.debug("Returning from method: findRelationshipsByPropertyValue with response: " + response.toString());
        return response;
    }

    public RelationshipListResponse findRelationshipsByPropertyValueHistory(String serverName, String userId, String searchCriteria, TypeLimitedHistoricalFindRequest findRequestParameters) {
        String methodName = "findRelationshipsByPropertyValueHistory";
        log.debug("Calling method: findRelationshipsByPropertyValueHistory");
        String relationshipTypeGUID = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "findRelationshipsByPropertyValueHistory");
            List relationships = metadataCollection.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/relationships/by-property-value/history?searchCriteria={1}";
                    TypeLimitedHistoricalFindRequest nextFindRequestParameters = new TypeLimitedHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("findRelationshipsByPropertyValueHistory", serverName, userId, "{0}/instances/relationships/by-property-value/history?searchCriteria={1}", nextFindRequestParameters, userId, searchCriteria));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "findRelationshipsByPropertyValueHistory", instanceHandler.getAuditLog(userId, serverName, "findRelationshipsByPropertyValueHistory"));
        }
        log.debug("Returning from method: findRelationshipsByPropertyValueHistory with response: " + response.toString());
        return response;
    }

    public InstanceGraphResponse getLinkingEntities(String serverName, String userId, String startEntityGUID, String endEntityGUID, OMRSAPIFindRequest findRequestParameters) {
        String methodName = "getLinkingEntities";
        log.debug("Calling method: getLinkingEntities");
        List limitResultsByStatus = null;
        InstanceGraphResponse response = new InstanceGraphResponse();
        if (findRequestParameters != null) {
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getLinkingEntities");
            InstanceGraph instanceGraph = metadataCollection.getLinkingEntities(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, null);
            if (instanceGraph != null) {
                response.setEntityElementList(instanceGraph.getEntities());
                response.setRelationshipElementList(instanceGraph.getRelationships());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getLinkingEntities", instanceHandler.getAuditLog(userId, serverName, "getLinkingEntities"));
        }
        log.debug("Returning from method: getLinkingEntities with response: " + response.toString());
        return response;
    }

    public InstanceGraphResponse getLinkingEntitiesHistory(String serverName, String userId, String startEntityGUID, String endEntityGUID, OMRSAPIHistoricalFindRequest findRequestParameters) {
        String methodName = "getLinkingEntitiesHistory";
        log.debug("Calling method: getLinkingEntitiesHistory");
        List limitResultsByStatus = null;
        Date asOfTime = null;
        InstanceGraphResponse response = new InstanceGraphResponse();
        if (findRequestParameters != null) {
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getLinkingEntitiesHistory");
            InstanceGraph instanceGraph = metadataCollection.getLinkingEntities(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
            if (instanceGraph != null) {
                response.setEntityElementList(instanceGraph.getEntities());
                response.setRelationshipElementList(instanceGraph.getRelationships());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getLinkingEntitiesHistory", instanceHandler.getAuditLog(userId, serverName, "getLinkingEntitiesHistory"));
        }
        log.debug("Returning from method: getLinkingEntitiesHistory with response: " + response.toString());
        return response;
    }

    public InstanceGraphResponse getEntityNeighborhood(String serverName, String userId, String entityGUID, int level, EntityNeighborhoodFindRequest findRequestParameters) {
        String methodName = "getEntityNeighborhood";
        log.debug("Calling method: getEntityNeighborhood");
        List entityTypeGUIDs = null;
        List relationshipTypeGUIDs = null;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        InstanceGraphResponse response = new InstanceGraphResponse();
        if (findRequestParameters != null) {
            entityTypeGUIDs = findRequestParameters.getEntityTypeGUIDs();
            relationshipTypeGUIDs = findRequestParameters.getRelationshipTypeGUIDs();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getEntityNeighborhood");
            InstanceGraph instanceGraph = metadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, null, level);
            if (instanceGraph != null) {
                response.setEntityElementList(instanceGraph.getEntities());
                response.setRelationshipElementList(instanceGraph.getRelationships());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getEntityNeighborhood", instanceHandler.getAuditLog(userId, serverName, "getEntityNeighborhood"));
        }
        log.debug("Returning from method: getEntityNeighborhood with response: " + response.toString());
        return response;
    }

    public InstanceGraphResponse getEntityNeighborhoodHistory(String serverName, String userId, String entityGUID, int level, EntityNeighborhoodHistoricalFindRequest findRequestParameters) {
        String methodName = "getEntityNeighborhoodHistory";
        log.debug("Calling method: getEntityNeighborhoodHistory");
        List entityTypeGUIDs = null;
        List relationshipTypeGUIDs = null;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        Date asOfTime = null;
        InstanceGraphResponse response = new InstanceGraphResponse();
        if (findRequestParameters != null) {
            entityTypeGUIDs = findRequestParameters.getEntityTypeGUIDs();
            relationshipTypeGUIDs = findRequestParameters.getRelationshipTypeGUIDs();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getEntityNeighborhoodHistory");
            InstanceGraph instanceGraph = metadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
            if (instanceGraph != null) {
                response.setEntityElementList(instanceGraph.getEntities());
                response.setRelationshipElementList(instanceGraph.getRelationships());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getEntityNeighborhoodHistory", instanceHandler.getAuditLog(userId, serverName, "getEntityNeighborhoodHistory"));
        }
        log.debug("Returning from method: getEntityNeighborhoodHistory with response: " + response.toString());
        return response;
    }

    public EntityListResponse getRelatedEntities(String serverName, String userId, String startEntityGUID, RelatedEntitiesFindRequest findRequestParameters) {
        String methodName = "getRelatedEntities";
        log.debug("Calling method: getRelatedEntities");
        List entityTypeGUIDs = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUIDs = findRequestParameters.getEntityTypeGUIDs();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getRelatedEntities");
            List entities = metadataCollection.getRelatedEntities(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, null, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/from-entity/{1}/by-relationship";
                    RelatedEntitiesFindRequest nextFindRequestParameters = new RelatedEntitiesFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("getRelatedEntities", serverName, userId, "{0}/instances/entities/from-entity/{1}/by-relationship", nextFindRequestParameters, userId, startEntityGUID));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getRelatedEntities", instanceHandler.getAuditLog(userId, serverName, "getRelatedEntities"));
        }
        log.debug("Returning from method: getRelatedEntities with response: " + response.toString());
        return response;
    }

    public EntityListResponse getRelatedEntitiesHistory(String serverName, String userId, String startEntityGUID, RelatedEntitiesHistoricalFindRequest findRequestParameters) {
        String methodName = "getRelatedEntitiesHistory";
        log.debug("Calling method: getRelatedEntitiesHistory");
        List entityTypeGUIDs = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUIDs = findRequestParameters.getEntityTypeGUIDs();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "getRelatedEntitiesHistory");
            List entities = metadataCollection.getRelatedEntities(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/from-entity/{1}/by-relationship/history";
                    RelatedEntitiesHistoricalFindRequest nextFindRequestParameters = new RelatedEntitiesHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL("getRelatedEntitiesHistory", serverName, userId, "{0}/instances/entities/from-entity/{1}/by-relationship/history", nextFindRequestParameters, userId, startEntityGUID));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getRelatedEntitiesHistory", instanceHandler.getAuditLog(userId, serverName, "getRelatedEntitiesHistory"));
        }
        log.debug("Returning from method: getRelatedEntitiesHistory with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse addEntity(String serverName, String userId, EntityCreateRequest requestBody) {
        String methodName = "addEntity";
        log.debug("Calling method: addEntity");
        String entityTypeGUID = null;
        InstanceProperties initialProperties = null;
        List initialClassifications = null;
        InstanceStatus initialStatus = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (requestBody != null) {
            entityTypeGUID = requestBody.getEntityTypeGUID();
            initialProperties = requestBody.getInitialProperties();
            initialClassifications = requestBody.getInitialClassifications();
            initialStatus = requestBody.getInitialStatus();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "addEntity");
            response.setEntity(metadataCollection.addEntity(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "addEntity", instanceHandler.getAuditLog(userId, serverName, "addEntity"));
        }
        log.debug("Returning from method: addEntity with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse addExternalEntity(String serverName, String userId, EntityCreateRequest requestBody) {
        String methodName = "addExternalEntity";
        log.debug("Calling method: addExternalEntity");
        String entityTypeGUID = null;
        String externalSourceGUID = null;
        String externalSourceName = null;
        InstanceProperties initialProperties = null;
        List initialClassifications = null;
        InstanceStatus initialStatus = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (requestBody != null) {
            entityTypeGUID = requestBody.getEntityTypeGUID();
            externalSourceGUID = requestBody.getMetadataCollectionId();
            externalSourceName = requestBody.getMetadataCollectionName();
            initialProperties = requestBody.getInitialProperties();
            initialClassifications = requestBody.getInitialClassifications();
            initialStatus = requestBody.getInitialStatus();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "addExternalEntity");
            response.setEntity(metadataCollection.addExternalEntity(userId, entityTypeGUID, externalSourceGUID, externalSourceName, initialProperties, initialClassifications, initialStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "addExternalEntity", instanceHandler.getAuditLog(userId, serverName, "addExternalEntity"));
        }
        log.debug("Returning from method: addExternalEntity with response: " + response.toString());
        return response;
    }

    public VoidResponse addEntityProxy(String serverName, String userId, EntityProxy entityProxy) {
        String methodName = "addEntityProxy";
        log.debug("Calling method: addEntityProxy");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "addEntityProxy");
            metadataCollection.addEntityProxy(userId, entityProxy);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "addEntityProxy", instanceHandler.getAuditLog(userId, serverName, "addEntityProxy"));
        }
        log.debug("Returning from method: addEntityProxy with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse updateEntityStatus(String serverName, String userId, String entityGUID, InstanceStatus newStatus) {
        String methodName = "updateEntityStatus";
        log.debug("Calling method: updateEntityStatus");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "updateEntityStatus");
            response.setEntity(metadataCollection.updateEntityStatus(userId, entityGUID, newStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "updateEntityStatus", instanceHandler.getAuditLog(userId, serverName, "updateEntityStatus"));
        }
        log.debug("Returning from method: updateEntityStatus with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse updateEntityProperties(String serverName, String userId, String entityGUID, InstancePropertiesRequest propertiesRequestBody) {
        String methodName = "updateEntityProperties";
        log.debug("Calling method: updateEntityProperties");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "updateEntityProperties");
            response.setEntity(metadataCollection.updateEntityProperties(userId, entityGUID, propertiesRequestBody.getInstanceProperties()));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "updateEntityProperties", instanceHandler.getAuditLog(userId, serverName, "updateEntityProperties"));
        }
        log.debug("Returning from method: updateEntityProperties with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse undoEntityUpdate(String serverName, String userId, String entityGUID) {
        String methodName = "undoEntityUpdate";
        log.debug("Calling method: undoEntityUpdate");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "undoEntityUpdate");
            response.setEntity(metadataCollection.undoEntityUpdate(userId, entityGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "undoEntityUpdate", instanceHandler.getAuditLog(userId, serverName, "undoEntityUpdate"));
        }
        log.debug("Returning from method: undoEntityUpdate with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse deleteEntity(String serverName, String userId, String obsoleteEntityGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "deleteEntity";
        log.debug("Calling method: deleteEntity");
        String typeDefGUID = null;
        String typeDefName = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "deleteEntity");
            response.setEntity(metadataCollection.deleteEntity(userId, typeDefGUID, typeDefName, obsoleteEntityGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "deleteEntity", instanceHandler.getAuditLog(userId, serverName, "deleteEntity"));
        }
        log.debug("Returning from method: deleteEntity with response: " + response.toString());
        return response;
    }

    public VoidResponse purgeEntity(String serverName, String userId, String deletedEntityGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "purgeEntity";
        log.debug("Calling method: purgeEntity");
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "purgeEntity");
            metadataCollection.purgeEntity(userId, typeDefGUID, typeDefName, deletedEntityGUID);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotDeletedException error) {
            this.captureEntityNotDeletedException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "purgeEntity", instanceHandler.getAuditLog(userId, serverName, "purgeEntity"));
        }
        log.debug("Returning from method: purgeEntity with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse restoreEntity(String serverName, String userId, String deletedEntityGUID) {
        String methodName = "restoreEntity";
        log.debug("Calling method: restoreEntity");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "restoreEntity");
            response.setEntity(metadataCollection.restoreEntity(userId, deletedEntityGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotDeletedException error) {
            this.captureEntityNotDeletedException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "restoreEntity", instanceHandler.getAuditLog(userId, serverName, "restoreEntity"));
        }
        log.debug("Returning from method: restoreEntity with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse classifyEntity(String serverName, String userId, String entityGUID, String classificationName, InstancePropertiesRequest propertiesRequestBody) {
        String methodName = "classifyEntity";
        log.debug("Calling method: classifyEntity");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "classifyEntity");
            response.setEntity(metadataCollection.classifyEntity(userId, entityGUID, classificationName, propertiesRequestBody.getInstanceProperties()));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "classifyEntity", instanceHandler.getAuditLog(userId, serverName, "classifyEntity"));
        }
        log.debug("Returning from method: classifyEntity with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse declassifyEntity(String serverName, String userId, String entityGUID, String classificationName) {
        String methodName = "declassifyEntity";
        log.debug("Calling method: declassifyEntity");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "declassifyEntity");
            response.setEntity(metadataCollection.declassifyEntity(userId, entityGUID, classificationName));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "declassifyEntity", instanceHandler.getAuditLog(userId, serverName, "declassifyEntity"));
        }
        log.debug("Returning from method: declassifyEntity with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse updateEntityClassification(String serverName, String userId, String entityGUID, String classificationName, InstancePropertiesRequest propertiesRequestBody) {
        String methodName = "updateEntityClassification";
        log.debug("Calling method: updateEntityClassification");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "updateEntityClassification");
            response.setEntity(metadataCollection.updateEntityClassification(userId, entityGUID, classificationName, propertiesRequestBody.getInstanceProperties()));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "updateEntityClassification", instanceHandler.getAuditLog(userId, serverName, "updateEntityClassification"));
        }
        log.debug("Returning from method: updateEntityClassification with response: " + response.toString());
        return response;
    }

    public RelationshipResponse addRelationship(String serverName, String userId, RelationshipCreateRequest createRequestParameters) {
        String methodName = "addRelationship";
        log.debug("Calling method: addRelationship");
        String relationshipTypeGUID = null;
        InstanceProperties initialProperties = null;
        String entityOneGUID = null;
        String entityTwoGUID = null;
        InstanceStatus initialStatus = null;
        RelationshipResponse response = new RelationshipResponse();
        if (createRequestParameters != null) {
            relationshipTypeGUID = createRequestParameters.getRelationshipTypeGUID();
            initialProperties = createRequestParameters.getInitialProperties();
            entityOneGUID = createRequestParameters.getEntityOneGUID();
            entityTwoGUID = createRequestParameters.getEntityTwoGUID();
            initialStatus = createRequestParameters.getInitialStatus();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "addRelationship");
            response.setRelationship(metadataCollection.addRelationship(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "addRelationship", instanceHandler.getAuditLog(userId, serverName, "addRelationship"));
        }
        log.debug("Returning from method: addRelationship with response: " + response.toString());
        return response;
    }

    public RelationshipResponse addExternalRelationship(String serverName, String userId, RelationshipCreateRequest createRequestParameters) {
        String methodName = "addExternalRelationship";
        log.debug("Calling method: addExternalRelationship");
        String relationshipTypeGUID = null;
        String externalSourceGUID = null;
        String externalSourceName = null;
        InstanceProperties initialProperties = null;
        String entityOneGUID = null;
        String entityTwoGUID = null;
        InstanceStatus initialStatus = null;
        RelationshipResponse response = new RelationshipResponse();
        if (createRequestParameters != null) {
            relationshipTypeGUID = createRequestParameters.getRelationshipTypeGUID();
            externalSourceGUID = createRequestParameters.getMetadataCollectionId();
            externalSourceName = createRequestParameters.getMetadataCollectionName();
            initialProperties = createRequestParameters.getInitialProperties();
            entityOneGUID = createRequestParameters.getEntityOneGUID();
            entityTwoGUID = createRequestParameters.getEntityTwoGUID();
            initialStatus = createRequestParameters.getInitialStatus();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "addExternalRelationship");
            response.setRelationship(metadataCollection.addExternalRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, initialProperties, entityOneGUID, entityTwoGUID, initialStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "addExternalRelationship", instanceHandler.getAuditLog(userId, serverName, "addExternalRelationship"));
        }
        log.debug("Returning from method: addExternalRelationship with response: " + response.toString());
        return response;
    }

    public RelationshipResponse updateRelationshipStatus(String serverName, String userId, String relationshipGUID, InstanceStatus newStatus) {
        String methodName = "updateRelationshipStatus";
        log.debug("Calling method: updateRelationshipStatus");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "updateRelationshipStatus");
            response.setRelationship(metadataCollection.updateRelationshipStatus(userId, relationshipGUID, newStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "updateRelationshipStatus", instanceHandler.getAuditLog(userId, serverName, "updateRelationshipStatus"));
        }
        log.debug("Returning from method: updateRelationshipStatus with response: " + response.toString());
        return response;
    }

    public RelationshipResponse updateRelationshipProperties(String serverName, String userId, String relationshipGUID, InstancePropertiesRequest propertiesRequestBody) {
        String methodName = "updateRelationshipProperties";
        log.debug("Calling method: updateRelationshipProperties");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "updateRelationshipProperties");
            response.setRelationship(metadataCollection.updateRelationshipProperties(userId, relationshipGUID, propertiesRequestBody.getInstanceProperties()));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "updateRelationshipProperties", instanceHandler.getAuditLog(userId, serverName, "updateRelationshipProperties"));
        }
        log.debug("Returning from method: updateRelationshipProperties with response: " + response.toString());
        return response;
    }

    public RelationshipResponse undoRelationshipUpdate(String serverName, String userId, String relationshipGUID) {
        String methodName = "undoRelationshipUpdate";
        log.debug("Calling method: undoRelationshipUpdate");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "undoRelationshipUpdate");
            response.setRelationship(metadataCollection.undoRelationshipUpdate(userId, relationshipGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "undoRelationshipUpdate", instanceHandler.getAuditLog(userId, serverName, "undoRelationshipUpdate"));
        }
        log.debug("Returning from method: undoRelationshipUpdate with response: " + response.toString());
        return response;
    }

    public RelationshipResponse deleteRelationship(String serverName, String userId, String obsoleteRelationshipGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "deleteRelationship";
        log.debug("Calling method: deleteRelationship");
        String typeDefGUID = null;
        String typeDefName = null;
        RelationshipResponse response = new RelationshipResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "deleteRelationship");
            response.setRelationship(metadataCollection.deleteRelationship(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "deleteRelationship", instanceHandler.getAuditLog(userId, serverName, "deleteRelationship"));
        }
        log.debug("Returning from method: deleteRelationship with response: " + response.toString());
        return response;
    }

    public VoidResponse purgeRelationship(String serverName, String userId, String deletedRelationshipGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "purgeRelationship";
        log.debug("Calling method: purgeRelationship");
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "purgeRelationship");
            metadataCollection.purgeRelationship(userId, typeDefGUID, typeDefName, deletedRelationshipGUID);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotDeletedException error) {
            this.captureRelationshipNotDeletedException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "purgeRelationship", instanceHandler.getAuditLog(userId, serverName, "purgeRelationship"));
        }
        log.debug("Returning from method: purgeRelationship with response: " + response.toString());
        return response;
    }

    public RelationshipResponse restoreRelationship(String serverName, String userId, String deletedRelationshipGUID) {
        String methodName = "restoreRelationship";
        log.debug("Calling method: restoreRelationship");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "restoreRelationship");
            response.setRelationship(metadataCollection.restoreRelationship(userId, deletedRelationshipGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotDeletedException error) {
            this.captureRelationshipNotDeletedException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "restoreRelationship", instanceHandler.getAuditLog(userId, serverName, "restoreRelationship"));
        }
        log.debug("Returning from method: restoreRelationship with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse reIdentifyEntity(String serverName, String userId, String entityGUID, String newEntityGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "reIdentifyEntity";
        log.debug("Calling method: reIdentifyEntity");
        String typeDefGUID = null;
        String typeDefName = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "reIdentifyEntity");
            response.setEntity(metadataCollection.reIdentifyEntity(userId, typeDefGUID, typeDefName, entityGUID, newEntityGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "reIdentifyEntity", instanceHandler.getAuditLog(userId, serverName, "reIdentifyEntity"));
        }
        log.debug("Returning from method: reIdentifyEntity with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse reTypeEntity(String serverName, String userId, String entityGUID, TypeDefChangeRequest typeDefChangeRequest) {
        String methodName = "reTypeEntity";
        log.debug("Calling method: reTypeEntity");
        TypeDefSummary currentTypeDefSummary = null;
        TypeDefSummary newTypeDefSummary = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (typeDefChangeRequest != null) {
            currentTypeDefSummary = typeDefChangeRequest.getCurrentTypeDef();
            newTypeDefSummary = typeDefChangeRequest.getNewTypeDef();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "reTypeEntity");
            response.setEntity(metadataCollection.reTypeEntity(userId, entityGUID, currentTypeDefSummary, newTypeDefSummary));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "reTypeEntity", instanceHandler.getAuditLog(userId, serverName, "reTypeEntity"));
        }
        log.debug("Returning from method: reTypeEntity with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse reHomeEntity(String serverName, String userId, String entityGUID, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "reHomeEntity";
        log.debug("Calling method: reHomeEntity");
        String typeDefGUID = null;
        String typeDefName = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "reHomeEntity");
            response.setEntity(metadataCollection.reHomeEntity(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "reHomeEntity", instanceHandler.getAuditLog(userId, serverName, "reHomeEntity"));
        }
        log.debug("Returning from method: reHomeEntity with response: " + response.toString());
        return response;
    }

    public RelationshipResponse reIdentifyRelationship(String serverName, String userId, String relationshipGUID, String newRelationshipGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "reIdentifyRelationship";
        log.debug("Calling method: reIdentifyRelationship");
        String typeDefGUID = null;
        String typeDefName = null;
        RelationshipResponse response = new RelationshipResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "reIdentifyRelationship");
            response.setRelationship(metadataCollection.reIdentifyRelationship(userId, typeDefGUID, typeDefName, relationshipGUID, newRelationshipGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "reIdentifyRelationship", instanceHandler.getAuditLog(userId, serverName, "reIdentifyRelationship"));
        }
        log.debug("Returning from method: reIdentifyRelationship with response: " + response.toString());
        return response;
    }

    public RelationshipResponse reTypeRelationship(String serverName, String userId, String relationshipGUID, TypeDefChangeRequest typeDefChangeRequest) {
        String methodName = "reTypeRelationship";
        log.debug("Calling method: reTypeRelationship");
        TypeDefSummary currentTypeDefSummary = null;
        TypeDefSummary newTypeDefSummary = null;
        RelationshipResponse response = new RelationshipResponse();
        if (typeDefChangeRequest != null) {
            currentTypeDefSummary = typeDefChangeRequest.getCurrentTypeDef();
            newTypeDefSummary = typeDefChangeRequest.getNewTypeDef();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "reTypeRelationship");
            response.setRelationship(metadataCollection.reTypeRelationship(userId, relationshipGUID, currentTypeDefSummary, newTypeDefSummary));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "reTypeRelationship", instanceHandler.getAuditLog(userId, serverName, "reTypeRelationship"));
        }
        log.debug("Returning from method: reTypeRelationship with response: " + response.toString());
        return response;
    }

    public RelationshipResponse reHomeRelationship(String serverName, String userId, String relationshipGUID, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "reHomeRelationship";
        log.debug("Calling method: reHomeRelationship");
        String typeDefGUID = null;
        String typeDefName = null;
        RelationshipResponse response = new RelationshipResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "reHomeRelationship");
            response.setRelationship(metadataCollection.reHomeRelationship(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "reHomeRelationship", instanceHandler.getAuditLog(userId, serverName, "reHomeRelationship"));
        }
        log.debug("Returning from method: reHomeRelationship with response: " + response.toString());
        return response;
    }

    public VoidResponse saveEntityReferenceCopy(String serverName, String userId, EntityDetail entity) {
        String methodName = "saveEntityReferenceCopy";
        log.debug("Calling method: saveEntityReferenceCopy");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "saveEntityReferenceCopy");
            metadataCollection.saveEntityReferenceCopy(userId, entity);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeDefErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (HomeEntityException error) {
            this.captureHomeEntityException((OMRSAPIResponse)response, error);
        }
        catch (EntityConflictException error) {
            this.captureEntityConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidEntityException error) {
            this.captureInvalidEntityException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "saveEntityReferenceCopy", instanceHandler.getAuditLog(userId, serverName, "saveEntityReferenceCopy"));
        }
        log.debug("Returning from method: saveEntityReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteEntityReferenceCopy(String serverName, String userId, EntityDetail entity) {
        String methodName = "deleteEntityReferenceCopy";
        log.debug("Calling method: deleteEntityReferenceCopy");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "deleteEntityReferenceCopy");
            metadataCollection.deleteEntityReferenceCopy(userId, entity);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeDefErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (HomeEntityException error) {
            this.captureHomeEntityException((OMRSAPIResponse)response, error);
        }
        catch (EntityConflictException error) {
            this.captureEntityConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidEntityException error) {
            this.captureInvalidEntityException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "deleteEntityReferenceCopy", instanceHandler.getAuditLog(userId, serverName, "deleteEntityReferenceCopy"));
        }
        log.debug("Returning from method: deleteEntityReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse purgeEntityReferenceCopy(String serverName, String userId, EntityDetail entity) {
        String methodName = "purgeEntityReferenceCopy";
        log.debug("Calling method: purgeEntityReferenceCopy");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "purgeEntityReferenceCopy");
            metadataCollection.purgeEntityReferenceCopy(userId, entity);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeDefErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (HomeEntityException error) {
            this.captureHomeEntityException((OMRSAPIResponse)response, error);
        }
        catch (EntityConflictException error) {
            this.captureEntityConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidEntityException error) {
            this.captureInvalidEntityException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "purgeEntityReferenceCopy", instanceHandler.getAuditLog(userId, serverName, "purgeEntityReferenceCopy"));
        }
        log.debug("Returning from method: purgeEntityReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse purgeEntityReferenceCopy(String serverName, String userId, String entityGUID, String homeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "purgeEntityReferenceCopy";
        log.debug("Calling method: purgeEntityReferenceCopy");
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "purgeEntityReferenceCopy");
            metadataCollection.purgeEntityReferenceCopy(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeEntityException error) {
            this.captureHomeEntityException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "purgeEntityReferenceCopy", instanceHandler.getAuditLog(userId, serverName, "purgeEntityReferenceCopy"));
        }
        log.debug("Returning from method: purgeEntityReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse refreshEntityReferenceCopy(String serverName, String userId, String entityGUID, String homeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "refreshEntityReferenceCopy";
        log.debug("Calling method: refreshEntityReferenceCopy");
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "refreshEntityReferenceCopy");
            metadataCollection.refreshEntityReferenceCopy(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeEntityException error) {
            this.captureHomeEntityException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "refreshEntityReferenceCopy", instanceHandler.getAuditLog(userId, serverName, "refreshEntityReferenceCopy"));
        }
        log.debug("Returning from method: refreshEntityReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse saveRelationshipReferenceCopy(String serverName, String userId, Relationship relationship) {
        String methodName = "saveRelationshipReferenceCopy";
        log.debug("Calling method: saveRelationshipReferenceCopy");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "saveRelationshipReferenceCopy");
            metadataCollection.saveRelationshipReferenceCopy(userId, relationship);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (InvalidRelationshipException error) {
            this.captureInvalidRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeRelationshipException error) {
            this.captureHomeRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeDefErrorException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipConflictException error) {
            this.captureRelationshipConflictException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "saveRelationshipReferenceCopy", instanceHandler.getAuditLog(userId, serverName, "saveRelationshipReferenceCopy"));
        }
        log.debug("Returning from method: saveRelationshipReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteRelationshipReferenceCopy(String serverName, String userId, Relationship relationship) {
        String methodName = "deleteRelationshipReferenceCopy";
        log.debug("Calling method: deleteRelationshipReferenceCopy");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "deleteRelationshipReferenceCopy");
            metadataCollection.deleteRelationshipReferenceCopy(userId, relationship);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (InvalidRelationshipException error) {
            this.captureInvalidRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeRelationshipException error) {
            this.captureHomeRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeDefErrorException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipConflictException error) {
            this.captureRelationshipConflictException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "deleteRelationshipReferenceCopy", instanceHandler.getAuditLog(userId, serverName, "deleteRelationshipReferenceCopy"));
        }
        log.debug("Returning from method: deleteRelationshipReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse purgeRelationshipReferenceCopy(String serverName, String userId, Relationship relationship) {
        String methodName = "purgeRelationshipReferenceCopy";
        log.debug("Calling method: purgeRelationshipReferenceCopy");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "purgeRelationshipReferenceCopy");
            metadataCollection.deleteRelationshipReferenceCopy(userId, relationship);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (InvalidRelationshipException error) {
            this.captureInvalidRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeRelationshipException error) {
            this.captureHomeRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeDefErrorException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipConflictException error) {
            this.captureRelationshipConflictException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "purgeRelationshipReferenceCopy", instanceHandler.getAuditLog(userId, serverName, "purgeRelationshipReferenceCopy"));
        }
        log.debug("Returning from method: purgeRelationshipReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse purgeRelationshipReferenceCopy(String serverName, String userId, String relationshipGUID, String homeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "purgeRelationshipReferenceCopy";
        log.debug("Calling method: purgeRelationshipReferenceCopy");
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "purgeRelationshipReferenceCopy");
            metadataCollection.purgeRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeRelationshipException error) {
            this.captureHomeRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "purgeRelationshipReferenceCopy", instanceHandler.getAuditLog(userId, serverName, "purgeRelationshipReferenceCopy"));
        }
        log.debug("Returning from method: purgeRelationshipReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse refreshRelationshipReferenceCopy(String serverName, String userId, String relationshipGUID, String homeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "refreshRelationshipReferenceCopy";
        log.debug("Calling method: refreshRelationshipReferenceCopy");
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "refreshRelationshipReferenceCopy");
            metadataCollection.refreshRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeRelationshipException error) {
            this.captureHomeRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "refreshRelationshipReferenceCopy", instanceHandler.getAuditLog(userId, serverName, "refreshRelationshipReferenceCopy"));
        }
        log.debug("Returning from method: refreshRelationshipReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse saveInstanceReferenceCopies(String serverName, String userId, InstanceGraphRequest instances) {
        String methodName = "saveInstanceReferenceCopies";
        log.debug("Calling method: saveInstanceReferenceCopies");
        InstanceGraph instanceGraph = new InstanceGraph();
        VoidResponse response = new VoidResponse();
        if (instances != null) {
            instanceGraph.setEntities(instances.getEntityElementList());
            instanceGraph.setRelationships(instances.getRelationshipElementList());
        }
        try {
            OMRSMetadataCollection metadataCollection = this.validateRepository(userId, serverName, "saveInstanceReferenceCopies");
            metadataCollection.saveInstanceReferenceCopies(userId, instanceGraph);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (InvalidEntityException error) {
            this.captureInvalidEntityException((OMRSAPIResponse)response, error);
        }
        catch (InvalidRelationshipException error) {
            this.captureInvalidRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeDefErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityConflictException error) {
            this.captureEntityConflictException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipConflictException error) {
            this.captureRelationshipConflictException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "saveInstanceReferenceCopies", instanceHandler.getAuditLog(userId, serverName, "saveInstanceReferenceCopies"));
        }
        log.debug("Returning from method: saveInstanceReferenceCopies with response: " + response.toString());
        return response;
    }

    private OMRSMetadataCollection validateRepository(String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, RepositoryErrorException {
        OMRSRepositoryServicesInstance instance;
        OMRSMetadataCollection metadataCollection = null;
        if (serverName != null && (instance = instanceHandler.getInstance(userId, serverName, methodName)) != null) {
            metadataCollection = this.localRepository ? instance.getLocalMetadataCollection() : instance.getEnterpriseMetadataCollection();
        }
        if (metadataCollection == null) {
            OMRSErrorCode errorCode;
            if (this.localRepository) {
                errorCode = OMRSErrorCode.NO_LOCAL_REPOSITORY;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            errorCode = OMRSErrorCode.NO_ENTERPRISE_REPOSITORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return metadataCollection;
    }

    private void captureUserNotAuthorizedException(OMRSAPIResponse response, UserNotAuthorizedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureFunctionNotSupportedException(OMRSAPIResponse response, FunctionNotSupportedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureRepositoryErrorException(OMRSAPIResponse response, RepositoryErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidParameterException(OMRSAPIResponse response, InvalidParameterException error) {
        String propertyName = "parameterName";
        if (error.getParameterName() == null) {
            this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        } else {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("parameterName", error.getParameterName());
            this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        }
    }

    private void captureInvalidTypeDefException(OMRSAPIResponse response, InvalidTypeDefException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefConflictException(OMRSAPIResponse response, TypeDefConflictException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefNotSupportedException(OMRSAPIResponse response, TypeDefNotSupportedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureHomeRelationshipException(OMRSAPIResponse response, HomeRelationshipException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureRelationshipNotKnownException(OMRSAPIResponse response, RelationshipNotKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidRelationshipException(OMRSAPIResponse response, InvalidRelationshipException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureRelationshipConflictException(OMRSAPIResponse response, RelationshipConflictException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefErrorException(OMRSAPIResponse response, TypeErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void capturePropertyErrorException(OMRSAPIResponse response, PropertyErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureEntityNotKnownException(OMRSAPIResponse response, EntityNotKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureHomeEntityException(OMRSAPIResponse response, HomeEntityException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefNotKnownException(TypeDefResponse response, TypeDefNotKnownException error) {
        this.captureCheckedException((OMRSAPIResponse)response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefNotKnown(OMRSAPIResponse response, TypeDefNotKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefKnownException(OMRSAPIResponse response, TypeDefKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefInUseException(OMRSAPIResponse response, TypeDefInUseException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefNotKnownException(OMRSAPIResponse response, TypeDefNotKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureEntityProxyOnlyException(OMRSAPIResponse response, EntityProxyOnlyException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureClassificationErrorException(OMRSAPIResponse response, ClassificationErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void capturePagingErrorException(OMRSAPIResponse response, PagingErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeErrorException(OMRSAPIResponse response, TypeErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureStatusNotSupportedException(OMRSAPIResponse response, StatusNotSupportedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureEntityNotDeletedException(OMRSAPIResponse response, EntityNotDeletedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureRelationshipNotDeletedException(OMRSAPIResponse response, RelationshipNotDeletedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidEntityException(OMRSAPIResponse response, InvalidEntityException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureThrowable(OMRSAPIResponse response, Throwable error, String methodName, OMRSAuditLog auditLog) {
        OMRSErrorCode errorCode = OMRSErrorCode.UNEXPECTED_EXCEPTION;
        String message = error.getMessage();
        if (message == null) {
            message = "null";
        }
        response.setRelatedHTTPCode(errorCode.getHTTPErrorCode());
        response.setExceptionClassName(error.getClass().getName());
        response.setExceptionErrorMessage(errorCode.getFormattedErrorMessage(new String[]{error.getClass().getName(), methodName, message}));
        response.setExceptionSystemAction(errorCode.getSystemAction());
        response.setExceptionUserAction(errorCode.getUserAction());
        response.setExceptionProperties(null);
        if (auditLog != null) {
            OMRSAuditCode auditCode = OMRSAuditCode.UNEXPECTED_EXCEPTION;
            auditLog.logException(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getClass().getName(), methodName, message}), null, auditCode.getSystemAction(), auditCode.getUserAction(), error);
        }
    }

    private void captureEntityConflictException(OMRSAPIResponse response, EntityConflictException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureCheckedException(OMRSAPIResponse response, OMRSCheckedExceptionBase error, String exceptionClassName) {
        this.captureCheckedException(response, error, exceptionClassName, null);
    }

    private void captureCheckedException(OMRSAPIResponse response, OMRSCheckedExceptionBase error, String exceptionClassName, Map<String, Object> exceptionProperties) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
        response.setExceptionProperties(exceptionProperties);
    }

    private String formatNextPageURL(String methodName, String serverName, String userId, String requestURLTemplate, Object requestBody, Object ... parameters) throws InvalidParameterException, UserNotAuthorizedException, RepositoryErrorException {
        OMRSRepositoryServicesInstance instance;
        if (serverName != null && (instance = instanceHandler.getInstance(userId, serverName, methodName)) != null) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                String jsonString = objectMapper.writeValueAsString(requestBody);
                String serverURLRoot = instance.getLocalServerURL();
                MessageFormat mf = new MessageFormat(serverURLRoot + requestURLTemplate);
                return mf.format(parameters) + "{" + jsonString + "}";
            }
            catch (Throwable exc) {
                log.debug("Unable to format return URL; exception is: " + exc.getMessage());
            }
        }
        return null;
    }
}

