/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.services;

import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerServiceInstanceHandler;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.rest.services.OMRSRepositoryServicesInstance;

public class OMRSRepositoryServicesInstanceHandler
extends OMAGServerServiceInstanceHandler {
    public OMRSRepositoryServicesInstanceHandler(String serviceName) {
        super(serviceName);
    }

    public OMRSRepositoryServicesInstance getInstance(String userId, String serverName, String serviceOperationName) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, UserNotAuthorizedException, RepositoryErrorException {
        try {
            return (OMRSRepositoryServicesInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        }
        catch (org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException error) {
            throw new UserNotAuthorizedException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction(), userId);
        }
        catch (InvalidParameterException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction(), error.getParameterName());
        }
        catch (PropertyServerException error) {
            throw new RepositoryErrorException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction());
        }
    }

    public OMRSAuditLog getAuditLog(String userId, String serverName, String serviceOperationName) {
        try {
            OMRSRepositoryServicesInstance instance = (OMRSRepositoryServicesInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
            if (instance != null) {
                return instance.getAuditLog();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void removeInstance(String serverName) {
        super.removeServerServiceInstance(serverName);
    }
}

