/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.archivemanager;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveStoreConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveInstanceStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveTypeStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationEntityExtension;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessorInterface;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventProcessorInterface;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;

public class OMRSArchiveManager {
    private List<OpenMetadataArchiveStoreConnector> openMetadataArchiveStores = new ArrayList<OpenMetadataArchiveStoreConnector>();
    private OMRSRepositoryContentManager repositoryContentManager = null;
    private OMRSInstanceEventProcessorInterface localInstanceEventProcessor = null;
    private AuditLog auditLog;

    public OMRSArchiveManager(List<OpenMetadataArchiveStoreConnector> startUpOpenMetadataArchives, AuditLog auditLog) {
        this.auditLog = auditLog;
        if (startUpOpenMetadataArchives != null) {
            this.openMetadataArchiveStores = new ArrayList<OpenMetadataArchiveStoreConnector>(startUpOpenMetadataArchives);
        }
    }

    public void close() {
        for (OpenMetadataArchiveStoreConnector archiveStore : this.openMetadataArchiveStores) {
            if (archiveStore == null) continue;
            try {
                archiveStore.disconnect();
            }
            catch (Throwable throwable) {}
        }
    }

    public void setLocalRepository(OMRSRepositoryContentManager repositoryContentManager, OMRSInstanceEventProcessorInterface instanceProcessor) {
        this.repositoryContentManager = repositoryContentManager;
        this.localInstanceEventProcessor = instanceProcessor;
        this.processOpenMetadataTypes();
        for (OpenMetadataArchiveStoreConnector archiveStore : this.openMetadataArchiveStores) {
            this.processOpenMetadataArchiveStore(archiveStore, "Startup archive list", (OMRSTypeDefEventProcessorInterface)repositoryContentManager, instanceProcessor);
        }
    }

    public void addOpenMetadataArchive(OpenMetadataArchiveStoreConnector archiveStore, String archiveSource) {
        this.processOpenMetadataArchiveStore(archiveStore, archiveSource, (OMRSTypeDefEventProcessorInterface)this.repositoryContentManager, this.localInstanceEventProcessor);
        this.openMetadataArchiveStores.add(archiveStore);
    }

    private void processOpenMetadataTypes() {
        OpenMetadataTypesArchive openMetadataTypesArchive = new OpenMetadataTypesArchive();
        OpenMetadataArchive openMetadataTypes = openMetadataTypesArchive.getOpenMetadataArchive();
        this.repositoryContentManager.setOpenMetadataTypesOriginGUID(openMetadataTypesArchive.getArchiveGUID());
        this.processOpenMetadataArchive(openMetadataTypes, "Open Metadata Types", (OMRSTypeDefEventProcessorInterface)this.repositoryContentManager, this.localInstanceEventProcessor);
    }

    private void processOpenMetadataArchiveStore(OpenMetadataArchiveStoreConnector archiveStore, String archiveSource, OMRSTypeDefEventProcessorInterface typeDefProcessor, OMRSInstanceEventProcessorInterface instanceProcessor) {
        if (archiveStore != null) {
            OpenMetadataArchive archiveContent = archiveStore.getArchiveContents();
            if (archiveContent == null) {
                String actionDescription = "Process Open Metadata Archive";
                this.auditLog.logMessage("Process Open Metadata Archive", OMRSAuditCode.EMPTY_ARCHIVE.getMessageDefinition(new String[]{archiveSource}));
            } else {
                this.processOpenMetadataArchive(archiveContent, archiveSource, typeDefProcessor, instanceProcessor);
            }
        }
    }

    private void processOpenMetadataArchive(OpenMetadataArchive archiveContent, String archiveSource, OMRSTypeDefEventProcessorInterface typeDefProcessor, OMRSInstanceEventProcessorInterface instanceProcessor) {
        String actionDescription = "Process Open Metadata Archive";
        OpenMetadataArchiveProperties archiveProperties = archiveContent.getArchiveProperties();
        if (archiveProperties != null) {
            this.auditLog.logMessage("Process Open Metadata Archive", OMRSAuditCode.PROCESSING_ARCHIVE.getMessageDefinition(new String[]{archiveProperties.getArchiveName()}));
            OpenMetadataArchiveTypeStore archiveTypeStore = archiveContent.getArchiveTypeStore();
            OpenMetadataArchiveInstanceStore archiveInstanceStore = archiveContent.getArchiveInstanceStore();
            int typeCount = 0;
            int instanceCount = 0;
            if (archiveTypeStore != null) {
                typeCount = this.processTypeDefStore(archiveProperties, archiveTypeStore, typeDefProcessor);
            }
            if (archiveInstanceStore != null) {
                instanceCount = this.processInstanceStore(archiveProperties, archiveInstanceStore, instanceProcessor);
            }
            this.auditLog.logMessage("Process Open Metadata Archive", OMRSAuditCode.COMPLETED_ARCHIVE.getMessageDefinition(new String[]{Integer.toString(typeCount), Integer.toString(instanceCount), archiveProperties.getArchiveName()}));
        } else {
            this.auditLog.logMessage("Process Open Metadata Archive", OMRSAuditCode.NULL_PROPERTIES_IN_ARCHIVE.getMessageDefinition(new String[]{archiveSource}));
        }
    }

    private int processTypeDefStore(OpenMetadataArchiveProperties archiveProperties, OpenMetadataArchiveTypeStore archiveTypeStore, OMRSTypeDefEventProcessorInterface typeDefProcessor) {
        List typeDefPatches = archiveTypeStore.getTypeDefPatches();
        List newAttributeTypeDefs = archiveTypeStore.getAttributeTypeDefs();
        List newTypeDefs = archiveTypeStore.getNewTypeDefs();
        int typeCount = 0;
        if (typeDefProcessor != null) {
            String sourceName = OMRSAuditingComponent.ARCHIVE_MANAGER.getComponentName();
            String originatorMetadataCollectionId = archiveProperties.getArchiveGUID();
            String originatorServerName = archiveProperties.getArchiveName();
            String originatorServerType = null;
            String originatorName = archiveProperties.getOriginatorName();
            String archiveVersion = archiveProperties.getArchiveVersion();
            String originatorOrganizationName = archiveProperties.getOriginatorOrganization();
            if (originatorName == null) {
                originatorName = sourceName;
            }
            String archiveId = originatorName + " (" + archiveVersion + ")";
            if (archiveProperties.getArchiveType() != null) {
                originatorServerType = archiveProperties.getArchiveType().getName();
            }
            if (newAttributeTypeDefs != null) {
                for (AttributeTypeDef newAttributeTypeDef : newAttributeTypeDefs) {
                    if (newAttributeTypeDef == null) continue;
                    typeDefProcessor.processNewAttributeTypeDefEvent(archiveId, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, newAttributeTypeDef);
                    ++typeCount;
                }
            }
            if (newTypeDefs != null) {
                for (TypeDef newTypeDef : newTypeDefs) {
                    if (newTypeDef == null) continue;
                    typeDefProcessor.processNewTypeDefEvent(archiveId, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, newTypeDef);
                    ++typeCount;
                }
            }
            if (typeDefPatches != null) {
                for (TypeDefPatch typeDefPatch : typeDefPatches) {
                    if (typeDefPatch == null) continue;
                    typeDefProcessor.processUpdatedTypeDefEvent(archiveId, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, typeDefPatch);
                    ++typeCount;
                }
            }
        }
        return typeCount;
    }

    private int processInstanceStore(OpenMetadataArchiveProperties archiveProperties, OpenMetadataArchiveInstanceStore archiveInstanceStore, OMRSInstanceEventProcessorInterface instanceProcessor) {
        List entities = archiveInstanceStore.getEntities();
        List relationships = archiveInstanceStore.getRelationships();
        List classifications = archiveInstanceStore.getClassifications();
        int instanceCount = 0;
        if (instanceProcessor != null) {
            String sourceName = OMRSAuditingComponent.ARCHIVE_MANAGER.getComponentName();
            String homeMetadataCollectionId = archiveProperties.getArchiveGUID();
            String archiveName = archiveProperties.getArchiveName();
            String originatorServerType = OpenMetadataArchiveType.CONTENT_PACK.getName();
            InstanceProvenanceType provenanceType = InstanceProvenanceType.CONTENT_PACK;
            Date archiveCreationTime = archiveProperties.getCreationDate();
            String originatorName = archiveProperties.getOriginatorName();
            String archiveVersion = archiveProperties.getArchiveVersion();
            String originatorOrganizationName = archiveProperties.getOriginatorOrganization();
            String originatorLicense = archiveProperties.getOriginatorLicense();
            String archiveId = originatorName + " (" + archiveVersion + ")";
            if (archiveProperties.getArchiveType() == OpenMetadataArchiveType.METADATA_EXPORT) {
                provenanceType = InstanceProvenanceType.EXPORT_ARCHIVE;
                originatorServerType = OpenMetadataArchiveType.METADATA_EXPORT.getName();
            }
            if (entities != null) {
                for (EntityDetail entity : entities) {
                    if (entity == null) continue;
                    this.setInstanceAuditHeader(homeMetadataCollectionId, archiveName, originatorName, archiveCreationTime, provenanceType, originatorLicense, (InstanceAuditHeader)entity);
                    instanceProcessor.processNewEntityEvent(archiveId, homeMetadataCollectionId, archiveName, originatorServerType, originatorOrganizationName, entity);
                    ++instanceCount;
                }
            }
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    if (relationship == null) continue;
                    this.setInstanceAuditHeader(homeMetadataCollectionId, archiveName, originatorName, archiveCreationTime, provenanceType, originatorLicense, (InstanceAuditHeader)relationship);
                    instanceProcessor.processNewRelationshipEvent(archiveId, homeMetadataCollectionId, archiveName, originatorServerType, originatorOrganizationName, relationship);
                    ++instanceCount;
                }
            }
            if (classifications != null) {
                for (ClassificationEntityExtension classificationEntityExtension : classifications) {
                    if (classificationEntityExtension == null) continue;
                    Classification classification = classificationEntityExtension.getClassification();
                    this.setInstanceAuditHeader(homeMetadataCollectionId, archiveName, originatorName, archiveCreationTime, provenanceType, originatorLicense, (InstanceAuditHeader)classification);
                    classificationEntityExtension.setClassification(classification);
                }
            }
        }
        return instanceCount;
    }

    private void setInstanceAuditHeader(String metadataCollectionId, String metadataConnectionName, String originatorName, Date creationTime, InstanceProvenanceType provenanceType, String originatorLicense, InstanceAuditHeader instance) {
        if (provenanceType == InstanceProvenanceType.EXPORT_ARCHIVE) {
            if (instance.getMetadataCollectionId() == null) {
                instance.setMetadataCollectionId(metadataCollectionId);
            }
            if (instance.getMetadataCollectionName() == null) {
                instance.setMetadataCollectionName(metadataConnectionName);
            }
            if (instance.getCreatedBy() == null) {
                instance.setCreatedBy(originatorName);
            }
            if (instance.getCreateTime() == null) {
                instance.setCreateTime(creationTime);
            }
            if (instance.getInstanceProvenanceType() == null) {
                instance.setInstanceProvenanceType(provenanceType);
            }
            if (instance.getInstanceLicense() == null) {
                instance.setInstanceLicense(originatorLicense);
            }
        } else {
            instance.setMetadataCollectionId(metadataCollectionId);
            instance.setMetadataCollectionName(metadataConnectionName);
            instance.setCreatedBy(originatorName);
            instance.setCreateTime(creationTime);
            instance.setInstanceProvenanceType(InstanceProvenanceType.CONTENT_PACK);
            instance.setInstanceLicense(originatorLicense);
        }
    }
}

