/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.utilities.OMRSRepositoryPropertiesUtilities;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryContentValidator
implements OMRSRepositoryValidator {
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryContentValidator.class);
    private OMRSRepositoryContentManager repositoryContentManager;

    public OMRSRepositoryContentValidator(OMRSRepositoryContentManager repositoryContentManager) {
        String methodName = "OMRSRepositoryContentValidator";
        this.repositoryContentManager = repositoryContentManager;
        this.validateRepositoryContentManager("OMRSRepositoryContentValidator");
    }

    public void validateEnterpriseTypeDefs(String sourceName, List<TypeDef> typeDefs, String methodName) throws RepositoryErrorException {
        this.validateRepositoryContentManager(methodName);
        this.repositoryContentManager.validateEnterpriseTypeDefs(sourceName, typeDefs, methodName);
    }

    public void validateEnterpriseAttributeTypeDefs(String sourceName, List<AttributeTypeDef> attributeTypeDefs, String methodName) throws RepositoryErrorException {
        this.validateRepositoryContentManager(methodName);
        this.repositoryContentManager.validateEnterpriseAttributeTypeDefs(sourceName, attributeTypeDefs, methodName);
    }

    public boolean isActiveType(String sourceName, String typeGUID, String typeName) {
        String methodName = "isActiveType";
        this.validateRepositoryContentManager("isActiveType");
        return this.repositoryContentManager.isActiveType(sourceName, typeGUID, typeName);
    }

    public boolean isActiveTypeId(String sourceName, String typeGUID) {
        String methodName = "isActiveTypeId";
        this.validateRepositoryContentManager("isActiveTypeId");
        return this.repositoryContentManager.isActiveTypeId(typeGUID);
    }

    public boolean isOpenType(String sourceName, String typeGUID, String typeName) {
        String methodName = "isOpenType";
        this.validateRepositoryContentManager("isOpenType");
        return this.repositoryContentManager.isOpenType(sourceName, typeGUID, typeName);
    }

    public boolean isOpenTypeId(String sourceName, String typeGUID) {
        String methodName = "isOpenTypeId";
        this.validateRepositoryContentManager("isOpenTypeId");
        return this.repositoryContentManager.isOpenTypeId(typeGUID);
    }

    public boolean isKnownType(String sourceName, String typeGUID, String typeName) {
        String methodName = "isKnownType";
        this.validateRepositoryContentManager("isKnownType");
        return this.repositoryContentManager.isKnownType(sourceName, typeGUID, typeName);
    }

    public boolean isKnownTypeId(String sourceName, String typeGUID) {
        String methodName = "isKnownTypeId";
        this.validateRepositoryContentManager("isKnownTypeId");
        return this.repositoryContentManager.isKnownTypeId(typeGUID);
    }

    public boolean validTypeId(String sourceName, String typeGUID, String typeName) {
        String methodName = "validTypeId";
        this.validateRepositoryContentManager("validTypeId");
        return this.repositoryContentManager.validTypeId(sourceName, typeGUID, typeName);
    }

    public boolean validTypeDefId(String sourceName, String typeDefGUID, String typeDefName, TypeDefCategory category) {
        String methodName = "validTypeDefId";
        this.validateRepositoryContentManager("validTypeDefId");
        return this.repositoryContentManager.validTypeDefId(sourceName, typeDefGUID, typeDefName, category);
    }

    public boolean validAttributeTypeDefId(String sourceName, String attributeTypeDefGUID, String attributeTypeDefName, AttributeTypeDefCategory category) {
        String methodName = "validAttributeTypeDefId";
        this.validateRepositoryContentManager("validAttributeTypeDefId");
        return this.repositoryContentManager.validAttributeTypeDefId(sourceName, attributeTypeDefGUID, attributeTypeDefName, category);
    }

    public boolean validTypeDefId(String sourceName, String typeDefGUID, String typeDefName, String typeDefVersion, TypeDefCategory category) {
        String methodName = "validTypeDefId";
        this.validateRepositoryContentManager("validTypeDefId");
        return this.repositoryContentManager.validTypeDefId(sourceName, typeDefGUID, typeDefName, typeDefVersion, category);
    }

    public boolean validAttributeTypeDefId(String sourceName, String attributeTypeDefGUID, String attributeTypeDefName, String attributeTypeDefVersion, AttributeTypeDefCategory category) {
        String methodName = "validAttributeTypeDefId";
        this.validateRepositoryContentManager("validAttributeTypeDefId");
        return this.repositoryContentManager.validAttributeTypeDefId(sourceName, attributeTypeDefGUID, attributeTypeDefName, attributeTypeDefVersion, category);
    }

    public void validateActiveType(String sourceName, String typeParameterName, TypeDefSummary typeDefSummary, TypeDefCategory category, String methodName) throws TypeErrorException, InvalidParameterException {
        if (!this.isActiveType(sourceName, typeDefSummary.getGUID(), typeDefSummary.getName())) {
            throw new TypeErrorException(OMRSErrorCode.TYPEDEF_NOT_KNOWN.getMessageDefinition(new String[]{typeDefSummary.getName(), typeDefSummary.getGUID(), typeParameterName, methodName, sourceName}), this.getClass().getName(), methodName);
        }
    }

    public boolean validTypeDef(String sourceName, TypeDef typeDef) {
        String methodName = "validTypeDef";
        this.validateRepositoryContentManager("validTypeDef");
        return this.repositoryContentManager.validTypeDef(sourceName, typeDef);
    }

    public boolean validAttributeTypeDef(String sourceName, AttributeTypeDef attributeTypeDef) {
        String methodName = "validAttributeTypeDef";
        this.validateRepositoryContentManager("validAttributeTypeDef");
        return this.repositoryContentManager.validAttributeTypeDef(sourceName, attributeTypeDef);
    }

    public boolean validTypeDefSummary(String sourceName, TypeDefSummary typeDefSummary) {
        String methodName = "validTypeDefSummary";
        this.validateRepositoryContentManager("validTypeDefSummary");
        return this.repositoryContentManager.validTypeDefSummary(sourceName, typeDefSummary);
    }

    public boolean validEntity(String sourceName, EntitySummary entity) {
        String methodName = "validEntity";
        return this.validInstance(sourceName, (InstanceHeader)entity, "validEntity", false);
    }

    public boolean validEntity(String sourceName, EntityProxy entity) {
        return this.validEntity(sourceName, (EntitySummary)entity);
    }

    public boolean validEntity(String sourceName, EntityDetail entity) {
        return this.validEntity(sourceName, (EntitySummary)entity);
    }

    public boolean validRelationship(String sourceName, Relationship relationship) {
        String methodName = "validRelationship";
        return this.validInstance(sourceName, (InstanceHeader)relationship, "validRelationship", false);
    }

    private boolean validInstance(String sourceName, InstanceHeader instance, String methodName, boolean fromStore) {
        String homeMetadataCollectionId;
        if (instance == null) {
            this.repositoryContentManager.logNullInstance(sourceName, methodName);
            return false;
        }
        InstanceType instanceType = instance.getType();
        if (instanceType == null) {
            this.repositoryContentManager.logNullType(sourceName, methodName);
            return false;
        }
        if (!this.validInstanceId(sourceName, instanceType.getTypeDefGUID(), instanceType.getTypeDefName(), instanceType.getTypeDefCategory(), instance.getGUID())) {
            return false;
        }
        if (!fromStore && (homeMetadataCollectionId = instance.getMetadataCollectionId()) == null) {
            this.repositoryContentManager.logNullMetadataCollectionId(sourceName, instanceType.getTypeDefGUID(), instanceType.getTypeDefName(), instanceType.getTypeDefCategory().getName(), instance.getGUID(), methodName);
            return false;
        }
        return true;
    }

    public boolean validInstanceId(String sourceName, String typeDefGUID, String typeDefName, TypeDefCategory category, String instanceGUID) {
        if (!this.validTypeDefId(sourceName, typeDefGUID, typeDefName, category)) {
            return false;
        }
        if (instanceGUID == null) {
            this.repositoryContentManager.logNullInstanceGUID(sourceName, typeDefGUID, typeDefName, category);
            return false;
        }
        return true;
    }

    public void validateUserId(String sourceName, String userId, String methodName) throws InvalidParameterException {
        String userIdParameterName = "userId";
        if ("".equals(userId)) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_USER_ID.getMessageDefinition(new String[]{"userId", methodName, sourceName}), this.getClass().getName(), methodName, "userId");
        }
    }

    public void validateTypeDefIds(String sourceName, String guidParameterName, String nameParameterName, String guid, String name, String methodName) throws InvalidParameterException {
        if (guid == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_TYPEDEF_IDENTIFIER.getMessageDefinition(new String[]{guidParameterName, methodName, sourceName}), this.getClass().getName(), methodName, guidParameterName);
        }
        if (name == null) {
            throw new InvalidParameterException(OMRSErrorCode.NO_TYPEDEF_NAME.getMessageDefinition(new String[]{nameParameterName, methodName, sourceName}), this.getClass().getName(), methodName, nameParameterName);
        }
    }

    public TypeDef getValidTypeDefFromIds(String sourceName, String guidParameterName, String nameParameterName, String guid, String name, String methodName) throws InvalidParameterException {
        this.validateTypeDefIds(sourceName, guidParameterName, nameParameterName, guid, name, methodName);
        try {
            return this.repositoryContentManager.getTypeDef(sourceName, guidParameterName, guid, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)error, guidParameterName + " or " + nameParameterName);
        }
    }

    public void validateAttributeTypeDefIds(String sourceName, String guidParameterName, String nameParameterName, String guid, String name, String methodName) throws InvalidParameterException {
        if (guid == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_ATTRIBUTE_TYPEDEF_IDENTIFIER.getMessageDefinition(new String[]{guidParameterName, methodName, sourceName}), this.getClass().getName(), methodName, guidParameterName);
        }
        if (name == null) {
            throw new InvalidParameterException(OMRSErrorCode.NO_ATTRIBUTE_TYPEDEF_NAME.getMessageDefinition(new String[]{nameParameterName, methodName, sourceName}), this.getClass().getName(), methodName, nameParameterName);
        }
    }

    public AttributeTypeDef getValidAttributeTypeDefFromIds(String sourceName, String guidParameterName, String nameParameterName, String guid, String name, String methodName) throws InvalidParameterException {
        this.validateAttributeTypeDefIds(sourceName, guidParameterName, nameParameterName, guid, name, methodName);
        try {
            return this.repositoryContentManager.getAttributeTypeDef(sourceName, guidParameterName, guid, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)error, guidParameterName + " or " + nameParameterName);
        }
    }

    public void validateTypeGUID(String sourceName, String guidParameterName, String guid, String methodName) throws InvalidParameterException, TypeErrorException {
        if (guid == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_TYPEDEF_IDENTIFIER.getMessageDefinition(new String[]{guidParameterName, methodName, sourceName}), this.getClass().getName(), methodName, guidParameterName);
        }
        this.validateOptionalTypeGUID(sourceName, guidParameterName, guid, methodName);
    }

    public void validateOptionalTypeGUID(String sourceName, String guidParameterName, String guid, String methodName) throws TypeErrorException {
        if (guid != null && !this.isKnownTypeId(sourceName, guid)) {
            throw new TypeErrorException(OMRSErrorCode.TYPEDEF_ID_NOT_KNOWN.getMessageDefinition(new String[]{guid, guidParameterName, methodName, sourceName}), this.getClass().getName(), methodName);
        }
    }

    public TypeDef validateTypeDefPatch(String sourceName, TypeDefPatch patch, String methodName) throws InvalidParameterException, TypeDefNotKnownException, PatchErrorException {
        OMRSRepositoryPropertiesUtilities utilities = new OMRSRepositoryPropertiesUtilities();
        utilities.validateTypeDefPatch(sourceName, patch, methodName);
        return this.repositoryContentManager.getTypeDefByName(patch.getTypeDefName());
    }

    public void validateInstanceTypeGUID(String sourceName, String guidParameterName, String guid, String methodName) throws TypeErrorException {
        if (guid == null) {
            throw new TypeErrorException(OMRSErrorCode.BAD_TYPEDEF_ID_FOR_INSTANCE.getMessageDefinition(new String[]{guidParameterName, methodName, sourceName}), this.getClass().getName(), methodName);
        }
    }

    public void validateTypeName(String sourceName, String nameParameterName, String name, String methodName) throws InvalidParameterException {
        if (name == null) {
            throw new InvalidParameterException(OMRSErrorCode.NO_TYPEDEF_NAME.getMessageDefinition(new String[]{nameParameterName, methodName, sourceName}), this.getClass().getName(), methodName, nameParameterName);
        }
    }

    public void validateTypeDefCategory(String sourceName, String nameParameterName, TypeDefCategory category, String methodName) throws InvalidParameterException {
        if (category == null) {
            throw new InvalidParameterException(OMRSErrorCode.NO_TYPEDEF_CATEGORY.getMessageDefinition(new String[]{nameParameterName, methodName, sourceName}), this.getClass().getName(), methodName, nameParameterName);
        }
    }

    public void validateAttributeTypeDefCategory(String sourceName, String nameParameterName, AttributeTypeDefCategory category, String methodName) throws InvalidParameterException {
        if (category == null) {
            throw new InvalidParameterException(OMRSErrorCode.NO_ATTRIBUTE_TYPEDEF_CATEGORY.getMessageDefinition(new String[]{nameParameterName, methodName, sourceName}), this.getClass().getName(), methodName, nameParameterName);
        }
    }

    public void validateTypeDef(String sourceName, String parameterName, TypeDef typeDef, String methodName) throws InvalidParameterException, InvalidTypeDefException {
        if (typeDef == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_TYPEDEF.getMessageDefinition(new String[]{parameterName, methodName, sourceName}), this.getClass().getName(), methodName, parameterName);
        }
        if (typeDef.getHeaderVersion() > 1L) {
            throw new InvalidTypeDefException(OMRSErrorCode.UNSUPPORTED_TYPE_HEADER_VERSION.getMessageDefinition(new String[]{methodName, sourceName, typeDef.getName(), Long.toString(typeDef.getHeaderVersion()), Long.toString(typeDef.getHeaderVersion())}), this.getClass().getName(), methodName);
        }
        this.validateTypeDefIds(sourceName, parameterName + ".getGUID", parameterName + ".getName", typeDef.getGUID(), typeDef.getName(), methodName);
        this.validateTypeDefCategory(sourceName, parameterName + ".getCategory", typeDef.getCategory(), methodName);
    }

    public void validateKnownTypeDef(String sourceName, String parameterName, TypeDef typeDef, String methodName) throws TypeDefNotKnownException {
        String thisMethodName = "validateKnownTypeDef";
        this.validateRepositoryContentManager("validateKnownTypeDef");
        if (!this.repositoryContentManager.isKnownType(sourceName, typeDef.getGUID(), typeDef.getName())) {
            throw new TypeDefNotKnownException(OMRSErrorCode.TYPEDEF_NOT_KNOWN.getMessageDefinition(new String[]{typeDef.getName(), typeDef.getGUID(), parameterName, methodName, sourceName}), this.getClass().getName(), methodName);
        }
    }

    public void validateUnknownTypeDef(String sourceName, String parameterName, TypeDef typeDef, String methodName) throws TypeDefKnownException, TypeDefConflictException {
        String thisMethodName = "validateUnknownTypeDef";
        this.validateRepositoryContentManager("validateUnknownTypeDef");
        if (this.repositoryContentManager.isKnownType(sourceName, typeDef.getGUID(), typeDef.getName())) {
            throw new TypeDefKnownException(OMRSErrorCode.TYPEDEF_ALREADY_DEFINED.getMessageDefinition(new String[]{typeDef.getName(), typeDef.getGUID(), sourceName}), this.getClass().getName(), methodName);
        }
    }

    public void validateUnknownAttributeTypeDef(String sourceName, String parameterName, AttributeTypeDef attributeTypeDef, String methodName) throws TypeDefKnownException, TypeDefConflictException {
        String thisMethodName = "validateUnknownTypeDef";
        this.validateRepositoryContentManager("validateUnknownTypeDef");
        if (this.repositoryContentManager.isKnownType(sourceName, attributeTypeDef.getGUID(), attributeTypeDef.getName())) {
            throw new TypeDefKnownException(OMRSErrorCode.ATTRIBUTE_TYPEDEF_ALREADY_DEFINED.getMessageDefinition(new String[]{attributeTypeDef.getName(), attributeTypeDef.getGUID(), sourceName}), this.getClass().getName(), methodName);
        }
    }

    public void validateTypeDefForInstance(String sourceName, String parameterName, TypeDef typeDef, String methodName) throws TypeErrorException, RepositoryErrorException {
        String thisMethodName = "validateTypeDefForInstance";
        if (typeDef == null) {
            throw new TypeErrorException(OMRSErrorCode.NULL_TYPEDEF.getMessageDefinition(new String[]{parameterName, methodName, sourceName}), this.getClass().getName(), methodName);
        }
        try {
            this.validateTypeDefIds(sourceName, parameterName + ".getGUID", parameterName + ".getName", typeDef.getGUID(), typeDef.getName(), methodName);
            this.validateTypeDefCategory(sourceName, parameterName + ".getCategory", typeDef.getCategory(), methodName);
        }
        catch (Throwable error) {
            throw new RepositoryErrorException(OMRSErrorCode.BAD_TYPEDEF.getMessageDefinition(new String[]{"validateTypeDefForInstance", typeDef.getName(), sourceName, methodName}), this.getClass().getName(), methodName);
        }
    }

    public void validateTypeForInstanceDelete(String sourceName, String typeDefGUID, String typeDefName, InstanceHeader instance, String methodName) throws InvalidParameterException, RepositoryErrorException {
        this.validateInstanceType(sourceName, instance);
        if (!typeDefGUID.equals(instance.getType().getTypeDefGUID()) || !typeDefName.equals(instance.getType().getTypeDefName())) {
            throw new InvalidParameterException(OMRSErrorCode.BAD_TYPEDEF_IDS_FOR_DELETE.getMessageDefinition(new String[]{typeDefName, typeDefGUID, methodName, instance.getGUID(), sourceName}), this.getClass().getName(), methodName, "type");
        }
    }

    public void validateAttributeTypeDef(String sourceName, String parameterName, AttributeTypeDef attributeTypeDef, String methodName) throws InvalidParameterException, InvalidTypeDefException {
        if (attributeTypeDef == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_ATTRIBUTE_TYPEDEF.getMessageDefinition(new String[]{parameterName, methodName, sourceName}), this.getClass().getName(), methodName, parameterName);
        }
        if (attributeTypeDef.getHeaderVersion() > 1L) {
            throw new InvalidTypeDefException(OMRSErrorCode.UNSUPPORTED_TYPE_HEADER_VERSION.getMessageDefinition(new String[]{methodName, sourceName, attributeTypeDef.getName(), Long.toString(attributeTypeDef.getHeaderVersion()), Long.toString(attributeTypeDef.getHeaderVersion())}), this.getClass().getName(), methodName);
        }
        this.validateAttributeTypeDefIds(sourceName, parameterName + ".getGUID", parameterName + ".getName", attributeTypeDef.getGUID(), attributeTypeDef.getName(), methodName);
        this.validateAttributeTypeDefCategory(sourceName, parameterName + ".getCategory", attributeTypeDef.getCategory(), methodName);
    }

    public void validateTypeDefGallery(String sourceName, String parameterName, TypeDefGallery gallery, String methodName) throws InvalidParameterException {
        if (gallery == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_TYPEDEF_GALLERY.getMessageDefinition(new String[]{parameterName, methodName, sourceName}), this.getClass().getName(), methodName, parameterName);
        }
    }

    public void validateExternalId(String sourceName, String standard, String organization, String identifier, String methodName) throws InvalidParameterException {
        if (standard == null && organization == null && identifier == null) {
            throw new InvalidParameterException(OMRSErrorCode.NO_EXTERNAL_ID.getMessageDefinition(new String[]{methodName, sourceName}), this.getClass().getName(), methodName, "externalId");
        }
    }

    public void validateGUID(String sourceName, String guidParameterName, String guid, String methodName) throws InvalidParameterException {
        if (guid == null) {
            throw new InvalidParameterException(OMRSErrorCode.NO_GUID.getMessageDefinition(new String[]{guidParameterName, methodName, sourceName}), this.getClass().getName(), methodName, guidParameterName);
        }
    }

    public void validateHomeMetadataGUID(String sourceName, String guidParameterName, String guid, String methodName) throws InvalidParameterException {
        if (guid == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_HOME_METADATA_COLLECTION_ID.getMessageDefinition(new String[]{guidParameterName, methodName, sourceName}), this.getClass().getName(), methodName, guidParameterName);
        }
    }

    public void validateHomeMetadataGUID(String sourceName, InstanceHeader instance, String methodName) throws RepositoryErrorException {
        String thisMethodName = "validateHomeMetadataGUID";
        if (instance == null) {
            this.throwValidatorLogicError(sourceName, methodName, "validateHomeMetadataGUID");
        }
        if (instance.getMetadataCollectionId() == null) {
            throw new RepositoryErrorException(OMRSErrorCode.NULL_INSTANCE_METADATA_COLLECTION_ID.getMessageDefinition(new String[]{instance.getGUID(), sourceName, methodName, instance.toString()}), this.getClass().getName(), methodName);
        }
    }

    public void validateAsOfTime(String sourceName, String parameterName, Date asOfTime, String methodName) throws InvalidParameterException {
        Date now;
        if (asOfTime != null && asOfTime.after(now = new Date())) {
            throw new InvalidParameterException(OMRSErrorCode.REPOSITORY_NOT_CRYSTAL_BALL.getMessageDefinition(new String[]{asOfTime.toString(), parameterName, methodName, sourceName}), this.getClass().getName(), methodName, parameterName);
        }
    }

    public void validateAsOfTimeNotNull(String sourceName, String parameterName, Date asOfTime, String methodName) throws InvalidParameterException {
        if (asOfTime == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_AS_OF_TIME.getMessageDefinition(new String[]{methodName, parameterName, sourceName}), this.getClass().getName(), methodName, parameterName);
        }
        this.validateAsOfTime(sourceName, parameterName, asOfTime, methodName);
    }

    public void validatePageSize(String sourceName, String parameterName, int pageSize, String methodName) throws PagingErrorException {
        if (pageSize < 0) {
            throw new PagingErrorException(OMRSErrorCode.NEGATIVE_PAGE_SIZE.getMessageDefinition(new String[]{Integer.toString(pageSize), parameterName, methodName, sourceName}), this.getClass().getName(), methodName);
        }
    }

    public TypeDef validateClassificationName(String sourceName, String parameterName, String classificationName, String methodName) throws InvalidParameterException {
        if (classificationName == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_CLASSIFICATION_NAME.getMessageDefinition(new String[]{parameterName, methodName, sourceName}), this.getClass().getName(), methodName, parameterName);
        }
        TypeDef typeDef = this.repositoryContentManager.getTypeDefByName(classificationName);
        if (typeDef == null) {
            throw new InvalidParameterException(OMRSErrorCode.UNKNOWN_CLASSIFICATION.getMessageDefinition(new String[]{classificationName, sourceName}), this.getClass().getName(), methodName, parameterName);
        }
        return typeDef;
    }

    public void validateClassificationProperties(String sourceName, String classificationName, String propertiesParameterName, InstanceProperties classificationProperties, String methodName) throws PropertyErrorException {
        this.validateRepositoryContentManager(methodName);
        TypeDef classificationTypeDef = this.repositoryContentManager.getTypeDefByName(classificationName);
        if (classificationTypeDef != null) {
            this.validatePropertiesForType(sourceName, propertiesParameterName, classificationTypeDef, classificationProperties, methodName);
        } else {
            String thisMethodName = "validateClassificationProperties";
            this.throwValidatorLogicError(sourceName, methodName, "validateClassificationProperties");
        }
    }

    public void validateClassification(String sourceName, String classificationParameterName, String classificationName, String entityTypeName, String methodName) throws InvalidParameterException, ClassificationErrorException {
        this.validateRepositoryContentManager(methodName);
        this.validateClassificationName(sourceName, classificationParameterName, classificationName, methodName);
        if (entityTypeName != null && !this.repositoryContentManager.isValidClassificationForEntity(sourceName, classificationName, entityTypeName, methodName)) {
            throw new ClassificationErrorException(OMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(new String[]{sourceName, classificationName, entityTypeName}), this.getClass().getName(), methodName);
        }
    }

    public void validateClassificationList(String sourceName, String parameterName, List<Classification> classifications, String entityTypeName, String methodName) throws InvalidParameterException, ClassificationErrorException, PropertyErrorException, TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        if (classifications != null) {
            for (Classification classification : classifications) {
                if (classification != null) {
                    this.validateClassification(sourceName, parameterName, classification.getName(), entityTypeName, methodName);
                    this.validatePropertiesForType(sourceName, parameterName, this.repositoryContentManager.getTypeDefByName(classification.getName()), classification.getProperties(), methodName);
                    continue;
                }
                throw new InvalidParameterException(OMRSErrorCode.NULL_CLASSIFICATION_NAME.getMessageDefinition(new String[]{parameterName, methodName, sourceName}), this.getClass().getName(), methodName, parameterName);
            }
        }
    }

    public void validateMatchCriteria(String sourceName, String parameterName, TypeDefProperties matchCriteria, String methodName) throws InvalidParameterException {
        if (matchCriteria == null) {
            throw new InvalidParameterException(OMRSErrorCode.NO_MATCH_CRITERIA.getMessageDefinition(new String[]{parameterName, methodName, sourceName}), this.getClass().getName(), methodName, parameterName);
        }
    }

    public void validateMatchCriteria(String sourceName, String matchCriteriaParameterName, String matchPropertiesParameterName, MatchCriteria matchCriteria, InstanceProperties matchProperties, String methodName) throws InvalidParameterException {
        if (matchCriteria == null && matchProperties == null) {
            return;
        }
        if (matchCriteria == null) {
            throw new InvalidParameterException(OMRSErrorCode.NO_MATCH_CRITERIA.getMessageDefinition(new String[]{matchCriteriaParameterName, methodName, sourceName}), this.getClass().getName(), methodName, matchCriteriaParameterName);
        }
        if (matchProperties == null) {
            throw new InvalidParameterException(OMRSErrorCode.NO_MATCH_CRITERIA.getMessageDefinition(new String[]{matchPropertiesParameterName, methodName, sourceName}), this.getClass().getName(), methodName, matchPropertiesParameterName);
        }
    }

    public void validateSearchCriteria(String sourceName, String parameterName, String searchCriteria, String methodName) throws InvalidParameterException {
        if (searchCriteria == null || "".equals(searchCriteria)) {
            throw new InvalidParameterException(OMRSErrorCode.NO_SEARCH_CRITERIA.getMessageDefinition(new String[]{parameterName, methodName, sourceName}), this.getClass().getName(), methodName, parameterName);
        }
    }

    public void validatePropertiesForType(String sourceName, String parameterName, TypeDef typeDef, InstanceProperties properties, String methodName) throws PropertyErrorException {
        List<TypeDefAttribute> typeDefAttributes;
        String thisMethodName = "validatePropertiesForType";
        if (properties == null) {
            return;
        }
        if (typeDef == null) {
            this.throwValidatorLogicError(sourceName, methodName, "validatePropertiesForType");
        }
        String typeDefCategoryName = null;
        String typeDefName = typeDef.getName();
        if (typeDef.getCategory() != null) {
            typeDefCategoryName = typeDef.getCategory().getName();
        }
        if ((typeDefAttributes = this.repositoryContentManager.getAllPropertiesForTypeDef(sourceName, typeDef, methodName)) == null) {
            throw new PropertyErrorException(OMRSErrorCode.NO_PROPERTIES_FOR_TYPE.getMessageDefinition(new String[]{typeDefCategoryName, typeDefName, sourceName}), this.getClass().getName(), methodName);
        }
        Iterator propertyList = properties.getPropertyNames();
        while (propertyList.hasNext()) {
            String propertyName = propertyList.next().toString();
            if (propertyName == null) {
                throw new PropertyErrorException(OMRSErrorCode.NULL_PROPERTY_NAME_FOR_INSTANCE.getMessageDefinition(new String[]{parameterName, methodName, sourceName}), this.getClass().getName(), methodName);
            }
            AttributeTypeDefCategory propertyDefinitionType = null;
            AttributeTypeDef attributeTypeDef = null;
            boolean recognizedProperty = false;
            for (TypeDefAttribute typeDefAttribute : typeDefAttributes) {
                if (typeDefAttribute == null || !propertyName.equals(typeDefAttribute.getAttributeName())) continue;
                recognizedProperty = true;
                attributeTypeDef = typeDefAttribute.getAttributeType();
                if (attributeTypeDef == null) {
                    propertyDefinitionType = AttributeTypeDefCategory.UNKNOWN_DEF;
                    continue;
                }
                propertyDefinitionType = attributeTypeDef.getCategory();
            }
            if (!recognizedProperty) {
                throw new PropertyErrorException(OMRSErrorCode.BAD_PROPERTY_FOR_TYPE.getMessageDefinition(new String[]{propertyName, typeDefCategoryName, typeDefName, sourceName}), this.getClass().getName(), methodName);
            }
            InstancePropertyValue propertyValue = properties.getPropertyValue(propertyName);
            if (propertyValue == null) {
                throw new PropertyErrorException(OMRSErrorCode.NULL_PROPERTY_VALUE_FOR_INSTANCE.getMessageDefinition(new String[]{parameterName, methodName, sourceName}), this.getClass().getName(), methodName);
            }
            InstancePropertyCategory propertyType = propertyValue.getInstancePropertyCategory();
            if (propertyType == null) {
                throw new PropertyErrorException(OMRSErrorCode.NULL_PROPERTY_TYPE_FOR_INSTANCE.getMessageDefinition(new String[]{parameterName, methodName, sourceName}), this.getClass().getName(), methodName);
            }
            boolean validPropertyType = false;
            String actualPropertyTypeName = propertyType.getName();
            String validPropertyTypeName = propertyDefinitionType.getName();
            switch (propertyType) {
                case PRIMITIVE: {
                    if (propertyDefinitionType == AttributeTypeDefCategory.PRIMITIVE) {
                        PrimitiveDef expectedAttributeDef;
                        PrimitiveDefCategory expectedAttributeDefCategory;
                        PrimitivePropertyValue primPropertyValue = (PrimitivePropertyValue)propertyValue;
                        PrimitiveDefCategory primPropertyCategory = primPropertyValue.getPrimitiveDefCategory();
                        if (primPropertyCategory == (expectedAttributeDefCategory = (expectedAttributeDef = (PrimitiveDef)attributeTypeDef).getPrimitiveDefCategory())) {
                            validPropertyType = true;
                            break;
                        }
                        actualPropertyTypeName = primPropertyCategory.getName();
                        validPropertyTypeName = expectedAttributeDefCategory.getName();
                        break;
                    }
                    if (propertyDefinitionType != AttributeTypeDefCategory.UNKNOWN_DEF) break;
                    validPropertyType = true;
                    break;
                }
                case ENUM: {
                    if (propertyDefinitionType != AttributeTypeDefCategory.ENUM_DEF) break;
                    validPropertyType = true;
                    break;
                }
                case MAP: 
                case STRUCT: 
                case ARRAY: {
                    if (propertyDefinitionType != AttributeTypeDefCategory.COLLECTION) break;
                    validPropertyType = true;
                }
            }
            if (validPropertyType) continue;
            throw new PropertyErrorException(OMRSErrorCode.BAD_PROPERTY_TYPE.getMessageDefinition(new String[]{propertyName, actualPropertyTypeName, typeDefCategoryName, typeDefName, validPropertyTypeName, sourceName}), this.getClass().getName(), methodName);
        }
    }

    public void validatePropertiesForType(String sourceName, String parameterName, TypeDefSummary typeDefSummary, InstanceProperties properties, String methodName) throws PropertyErrorException, TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        if (typeDefSummary == null) {
            String thisMethodName = "validatePropertiesForType";
            this.throwValidatorLogicError(sourceName, methodName, "validatePropertiesForType");
        }
        TypeDef typeDef = this.repositoryContentManager.getTypeDef(sourceName, parameterName, parameterName, typeDefSummary.getGUID(), typeDefSummary.getName(), methodName);
        this.validatePropertiesForType(sourceName, parameterName, typeDef, properties, methodName);
    }

    public void validateNewPropertiesForType(String sourceName, String parameterName, TypeDef typeDef, InstanceProperties properties, String methodName) throws PropertyErrorException {
        if (properties == null) {
            throw new PropertyErrorException(OMRSErrorCode.NO_NEW_PROPERTIES.getMessageDefinition(new String[]{parameterName, methodName, sourceName}), this.getClass().getName(), methodName);
        }
        this.validatePropertiesForType(sourceName, parameterName, typeDef, properties, methodName);
    }

    public boolean verifyInstanceType(String sourceName, String instanceTypeGUID, InstanceHeader instance) {
        if (instance != null) {
            if (instanceTypeGUID == null) {
                return true;
            }
            InstanceType entityType = instance.getType();
            if (entityType != null && this.repositoryContentManager.isTypeOfByGUID(sourceName, entityType.getTypeDefGUID(), entityType.getTypeDefName(), instanceTypeGUID)) {
                return true;
            }
        }
        return false;
    }

    public void validateEntityFromStore(String sourceName, String guid, EntitySummary entity, String methodName) throws RepositoryErrorException, EntityNotKnownException {
        if (entity == null) {
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{guid, methodName, sourceName}), this.getClass().getName(), methodName);
        }
        if (!this.validInstance(sourceName, (InstanceHeader)entity, methodName, true)) {
            throw new RepositoryErrorException(OMRSErrorCode.INVALID_ENTITY_FROM_STORE.getMessageDefinition(new String[]{guid, sourceName, methodName, entity.toString()}), this.getClass().getName(), methodName);
        }
    }

    public void validateEntityFromStore(String sourceName, String guid, EntityDetail entity, String methodName) throws RepositoryErrorException, EntityNotKnownException {
        if (entity == null) {
            throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{guid, methodName, sourceName}), this.getClass().getName(), methodName);
        }
        if (!this.validEntity(sourceName, entity)) {
            throw new RepositoryErrorException(OMRSErrorCode.INVALID_ENTITY_FROM_STORE.getMessageDefinition(new String[]{guid, sourceName, methodName, entity.toString()}), this.getClass().getName(), methodName);
        }
    }

    public void validateRelationshipFromStore(String sourceName, String guid, Relationship relationship, String methodName) throws RepositoryErrorException, RelationshipNotKnownException {
        if (relationship == null) {
            throw new RelationshipNotKnownException(OMRSErrorCode.RELATIONSHIP_NOT_FOUND.getMessageDefinition(new String[]{guid, methodName, sourceName}), this.getClass().getName(), methodName);
        }
        if (!this.validRelationship(sourceName, relationship)) {
            throw new RepositoryErrorException(OMRSErrorCode.INVALID_RELATIONSHIP_FROM_STORE.getMessageDefinition(new String[]{guid, sourceName, methodName, relationship.toString()}), this.getClass().getName(), methodName);
        }
    }

    public void validateInstanceType(String sourceName, InstanceHeader instance) throws RepositoryErrorException {
        String methodName = "validateInstanceType";
        if (instance != null) {
            InstanceType instanceType = instance.getType();
            if (instanceType != null) {
                if (this.isKnownType(sourceName, instanceType.getTypeDefGUID(), instanceType.getTypeDefName())) {
                    return;
                }
                throw new RepositoryErrorException(OMRSErrorCode.INACTIVE_INSTANCE_TYPE.getMessageDefinition(new String[]{"validateInstanceType", sourceName, instance.getGUID(), instanceType.getTypeDefName(), instanceType.getTypeDefGUID()}), this.getClass().getName(), "validateInstanceType");
            }
            throw new RepositoryErrorException(OMRSErrorCode.NULL_INSTANCE_TYPE.getMessageDefinition(new String[]{"validateInstanceType", sourceName}), this.getClass().getName(), "validateInstanceType");
        }
        String thisMethodName = "validateInstanceType";
        this.throwValidatorLogicError(sourceName, "validateInstanceType", "validateInstanceType");
    }

    public void validateInstanceType(String sourceName, InstanceHeader instance, String typeGUIDParameterName, String typeNameParameterName, String expectedTypeGUID, String expectedTypeName) throws RepositoryErrorException, TypeErrorException, InvalidParameterException {
        String methodName = "validateInstanceType";
        this.validateInstanceType(sourceName, instance);
        if (expectedTypeGUID == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_TYPEDEF_IDENTIFIER.getMessageDefinition(new String[]{typeGUIDParameterName, "validateInstanceType", sourceName}), this.getClass().getName(), "validateInstanceType", typeGUIDParameterName);
        }
        if (expectedTypeName == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_TYPEDEF_NAME.getMessageDefinition(new String[]{typeNameParameterName, "validateInstanceType", sourceName}), this.getClass().getName(), "validateInstanceType", typeNameParameterName);
        }
    }

    public boolean verifyInstanceHasRightStatus(List<InstanceStatus> validStatuses, InstanceHeader instance) {
        if (instance != null && validStatuses != null) {
            for (InstanceStatus status : validStatuses) {
                if (status != instance.getStatus()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void validateInstanceStatus(String sourceName, String instanceStatusParameterName, InstanceStatus instanceStatus, TypeDef typeDef, String methodName) throws StatusNotSupportedException {
        if (instanceStatus == InstanceStatus.DELETED) {
            throw new StatusNotSupportedException(OMRSErrorCode.BAD_DELETE_INSTANCE_STATUS.getMessageDefinition(new String[]{instanceStatus.getName(), instanceStatusParameterName, methodName, sourceName}), this.getClass().getName(), methodName);
        }
        if (instanceStatus != null) {
            if (typeDef != null) {
                List validStatuses = typeDef.getValidInstanceStatusList();
                for (InstanceStatus validStatus : validStatuses) {
                    if (instanceStatus != validStatus) continue;
                    return;
                }
                throw new StatusNotSupportedException(OMRSErrorCode.BAD_INSTANCE_STATUS.getMessageDefinition(new String[]{instanceStatus.getName(), instanceStatusParameterName, methodName, sourceName, typeDef.getName()}), this.getClass().getName(), methodName);
            }
            throw new StatusNotSupportedException(OMRSErrorCode.NULL_TYPEDEF.getMessageDefinition(new String[]{"typeDef", methodName, sourceName}), this.getClass().getName(), methodName);
        }
    }

    public void validateNewStatus(String sourceName, String instanceStatusParameterName, InstanceStatus instanceStatus, TypeDef typeDef, String methodName) throws StatusNotSupportedException, InvalidParameterException {
        if (instanceStatus == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_INSTANCE_STATUS.getMessageDefinition(new String[]{instanceStatusParameterName, methodName, sourceName}), this.getClass().getName(), methodName, instanceStatusParameterName);
        }
        this.validateInstanceStatus(sourceName, instanceStatusParameterName, instanceStatus, typeDef, methodName);
    }

    public void validateInstanceStatusForDelete(String sourceName, InstanceHeader instance, String methodName) throws InvalidParameterException {
        if (instance != null) {
            if (instance.getStatus() == InstanceStatus.DELETED) {
                throw new InvalidParameterException(OMRSErrorCode.INSTANCE_ALREADY_DELETED.getMessageDefinition(new String[]{methodName, sourceName, instance.getGUID()}), this.getClass().getName(), methodName, "instance");
            }
        } else {
            String thisMethodName = "validateInstanceStatusForDelete";
            this.throwValidatorLogicError(sourceName, methodName, "validateInstanceStatusForDelete");
        }
    }

    private String getTypeNameForMessage(InstanceHeader instanceHeader) {
        String typeName = "<nullType>";
        InstanceType type = instanceHeader.getType();
        if (type != null && type.getTypeDefName() != null) {
            typeName = type.getTypeDefName();
        }
        return typeName;
    }

    public void validateEntityIsNotDeleted(String sourceName, InstanceHeader instance, String methodName) throws EntityNotKnownException {
        if (instance != null) {
            if (instance.getStatus() == InstanceStatus.DELETED) {
                throw new EntityNotKnownException(OMRSErrorCode.ENTITY_SOFT_DELETED.getMessageDefinition(new String[]{this.getTypeNameForMessage(instance), instance.getGUID(), methodName, sourceName}), this.getClass().getName(), methodName);
            }
        } else {
            String thisMethodName = "validateEntityIsNotDeleted";
            this.throwValidatorLogicError(sourceName, methodName, "validateEntityIsNotDeleted");
        }
    }

    public void validateEntityIsDeleted(String sourceName, InstanceHeader instance, String methodName) throws EntityNotDeletedException {
        if (instance != null) {
            if (instance.getStatus() != InstanceStatus.DELETED) {
                throw new EntityNotDeletedException(OMRSErrorCode.INSTANCE_NOT_DELETED.getMessageDefinition(new String[]{methodName, sourceName, instance.getGUID()}), this.getClass().getName(), methodName);
            }
        } else {
            String thisMethodName = "validateEntityIsDeleted";
            this.throwValidatorLogicError(sourceName, methodName, "validateEntityIsDeleted");
        }
    }

    public void validateEntityCanBeUpdated(String sourceName, String metadataCollectionId, InstanceHeader instance, String methodName) throws InvalidParameterException {
        boolean updateAllowed = true;
        InstanceProvenanceType instanceProvenance = instance.getInstanceProvenanceType();
        switch (instanceProvenance) {
            case LOCAL_COHORT: {
                String entityHome = instance.getMetadataCollectionId();
                if (entityHome == null || entityHome.equals(metadataCollectionId)) break;
                updateAllowed = false;
                break;
            }
            case EXTERNAL_SOURCE: {
                String replicatedBy = instance.getReplicatedBy();
                if (replicatedBy == null || replicatedBy.equals(metadataCollectionId)) break;
                updateAllowed = false;
                break;
            }
            default: {
                updateAllowed = false;
            }
        }
        if (!updateAllowed) {
            throw new InvalidParameterException(OMRSErrorCode.INSTANCE_HOME_NOT_LOCAL.getMessageDefinition(new String[]{instance.getMetadataCollectionId(), methodName, instance.getGUID(), metadataCollectionId, sourceName}), this.getClass().getName(), methodName, "instance");
        }
    }

    public void validateEntityCanBeRehomed(String sourceName, String metadataCollectionId, InstanceHeader instance, String methodName) throws InvalidParameterException {
        boolean updateAllowed = false;
        InstanceProvenanceType instanceProvenance = instance.getInstanceProvenanceType();
        switch (instanceProvenance) {
            case LOCAL_COHORT: {
                String entityHome = instance.getMetadataCollectionId();
                if (entityHome == null || entityHome.equals(metadataCollectionId)) break;
                updateAllowed = true;
                break;
            }
            case EXTERNAL_SOURCE: {
                String replicatedBy = instance.getReplicatedBy();
                if (replicatedBy == null || replicatedBy.equals(metadataCollectionId)) break;
                updateAllowed = true;
                break;
            }
            default: {
                updateAllowed = false;
            }
        }
        if (!updateAllowed) {
            throw new InvalidParameterException(OMRSErrorCode.INSTANCE_HOME_NOT_LOCAL.getMessageDefinition(new String[]{instance.getMetadataCollectionId(), methodName, instance.getGUID(), metadataCollectionId, sourceName}), this.getClass().getName(), methodName, "instance");
        }
    }

    public void validateRelationshipIsNotDeleted(String sourceName, InstanceHeader instance, String methodName) throws RelationshipNotKnownException {
        if (instance != null) {
            if (instance.getStatus() == InstanceStatus.DELETED) {
                throw new RelationshipNotKnownException(OMRSErrorCode.RELATIONSHIP_SOFT_DELETED.getMessageDefinition(new String[]{this.getTypeNameForMessage(instance), instance.getGUID(), methodName, sourceName}), this.getClass().getName(), methodName);
            }
        } else {
            String thisMethodName = "validateRelationshipIsNotDeleted";
            this.throwValidatorLogicError(sourceName, methodName, "validateRelationshipIsNotDeleted");
        }
    }

    public void validateRelationshipIsDeleted(String sourceName, InstanceHeader instance, String methodName) throws RelationshipNotDeletedException {
        if (instance != null) {
            if (instance.getStatus() != InstanceStatus.DELETED) {
                throw new RelationshipNotDeletedException(OMRSErrorCode.INSTANCE_NOT_DELETED.getMessageDefinition(new String[]{methodName, sourceName, instance.getGUID()}), this.getClass().getName(), methodName);
            }
        } else {
            String thisMethodName = "validateRelationshipIsDeleted";
            this.throwValidatorLogicError(sourceName, methodName, "validateRelationshipIsDeleted");
        }
    }

    public void validateRelationshipCanBeUpdated(String sourceName, String metadataCollectionId, InstanceHeader instance, String methodName) throws InvalidParameterException {
        boolean updateAllowed = true;
        InstanceProvenanceType instanceProvenance = instance.getInstanceProvenanceType();
        switch (instanceProvenance) {
            case LOCAL_COHORT: {
                String relationshipHome = instance.getMetadataCollectionId();
                if (relationshipHome == null || relationshipHome.equals(metadataCollectionId)) break;
                updateAllowed = false;
                break;
            }
            case EXTERNAL_SOURCE: {
                String replicatedBy = instance.getReplicatedBy();
                if (replicatedBy == null || replicatedBy.equals(metadataCollectionId)) break;
                updateAllowed = false;
                break;
            }
            default: {
                updateAllowed = false;
            }
        }
        if (!updateAllowed) {
            throw new InvalidParameterException(OMRSErrorCode.INSTANCE_HOME_NOT_LOCAL.getMessageDefinition(new String[]{instance.getMetadataCollectionId(), methodName, instance.getGUID(), metadataCollectionId, sourceName}), this.getClass().getName(), methodName, "instance");
        }
    }

    public void validateRelationshipCanBeRehomed(String sourceName, String metadataCollectionId, InstanceHeader instance, String methodName) throws InvalidParameterException {
        boolean updateAllowed = false;
        InstanceProvenanceType instanceProvenance = instance.getInstanceProvenanceType();
        switch (instanceProvenance) {
            case LOCAL_COHORT: {
                String relationshipHome = instance.getMetadataCollectionId();
                if (relationshipHome == null || relationshipHome.equals(metadataCollectionId)) break;
                updateAllowed = true;
                break;
            }
            case EXTERNAL_SOURCE: {
                String replicatedBy = instance.getReplicatedBy();
                if (replicatedBy == null || replicatedBy.equals(metadataCollectionId)) break;
                updateAllowed = true;
                break;
            }
            default: {
                updateAllowed = false;
            }
        }
        if (!updateAllowed) {
            throw new InvalidParameterException(OMRSErrorCode.INSTANCE_HOME_NOT_LOCAL.getMessageDefinition(new String[]{instance.getMetadataCollectionId(), methodName, instance.getGUID(), metadataCollectionId, sourceName}), this.getClass().getName(), methodName, "instance");
        }
    }

    public void validateRelationshipEnds(String sourceName, EntityProxy entityOneProxy, EntityProxy entityTwoProxy, TypeDef typeDef, String methodName) throws InvalidParameterException {
        String thisMethodName = "validateRelationshipEnds";
        if (entityOneProxy != null && entityTwoProxy != null && typeDef != null) {
            try {
                RelationshipDef relationshipDef = (RelationshipDef)typeDef;
                RelationshipEndDef entityOneEndDef = null;
                RelationshipEndDef entityTwoEndDef = null;
                TypeDefLink entityOneTypeDef = null;
                TypeDefLink entityTwoTypeDef = null;
                String entityOneTypeDefName = null;
                String entityTwoTypeDefName = null;
                InstanceType entityOneType = null;
                InstanceType entityTwoType = null;
                String entityOneTypeName = null;
                String entityTwoTypeName = null;
                if (relationshipDef != null) {
                    entityOneEndDef = relationshipDef.getEndDef1();
                    entityTwoEndDef = relationshipDef.getEndDef2();
                    log.debug("Got EndDefs");
                }
                if (entityOneEndDef != null && entityTwoEndDef != null) {
                    entityOneTypeDef = entityOneEndDef.getEntityType();
                    entityTwoTypeDef = entityTwoEndDef.getEntityType();
                    log.debug("Got EndDef Types");
                }
                if (entityOneTypeDef != null && entityTwoTypeDef != null) {
                    entityOneTypeDefName = entityOneTypeDef.getName();
                    entityTwoTypeDefName = entityTwoTypeDef.getName();
                    log.debug("Got EndDef Types of One: " + entityOneTypeDefName + " and Two: " + entityTwoTypeDefName);
                }
                if (entityOneProxy != null && entityTwoProxy != null) {
                    entityOneType = entityOneProxy.getType();
                    entityTwoType = entityTwoProxy.getType();
                    log.debug("Got Proxy Types of One: " + entityOneType + " and Two: " + entityOneType);
                }
                if (entityOneType != null && entityTwoType != null) {
                    entityOneTypeName = entityOneType.getTypeDefName();
                    entityTwoTypeName = entityTwoType.getTypeDefName();
                }
                if (this.repositoryContentManager.isTypeOf(sourceName, entityOneTypeName, entityOneTypeDefName) && this.repositoryContentManager.isTypeOf(sourceName, entityTwoTypeName, entityTwoTypeDefName)) {
                    return;
                }
                throw new InvalidParameterException(OMRSErrorCode.INVALID_RELATIONSHIP_ENDS.getMessageDefinition(new String[]{methodName, sourceName, typeDef.toString(), entityOneProxy.toString(), entityTwoProxy.toString()}), this.getClass().getName(), methodName, "relationship.End");
            }
            catch (InvalidParameterException error) {
                throw error;
            }
            catch (Throwable error) {
                this.throwValidatorLogicError(sourceName, methodName, "validateRelationshipEnds");
            }
        } else {
            this.throwValidatorLogicError(sourceName, methodName, "validateRelationshipEnds");
        }
    }

    public boolean verifyEntityIsClassified(List<String> requiredClassifications, EntitySummary entity) {
        if (requiredClassifications != null) {
            List entityClassifications = entity.getClassifications();
            if (entityClassifications != null) {
                for (String requiredClassification : requiredClassifications) {
                    if (requiredClassification == null) continue;
                    for (Classification entityClassification : entityClassifications) {
                        if (entityClassification == null || !requiredClassification.equals(entityClassification.getName())) continue;
                        return true;
                    }
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public String getStringValuesFromInstancePropertiesAsArray(InstanceProperties instanceProperties) {
        String stringStart = "{ ";
        String stringDelimiter = ", ";
        String stringEnd = " }";
        String results = null;
        if (instanceProperties != null) {
            Iterator propertyNames = instanceProperties.getPropertyNames();
            while (propertyNames.hasNext()) {
                String propertyName = (String)propertyNames.next();
                if (results == null) {
                    results = this.getStringFromPropertyValue(instanceProperties.getPropertyValue(propertyName));
                    continue;
                }
                results = results + ", " + this.getStringFromPropertyValue(instanceProperties.getPropertyValue(propertyName));
            }
        }
        return "{ " + results + " }";
    }

    public String getStringValuesFromInstancePropertiesAsMap(InstanceProperties instanceProperties) {
        String stringStart = "{ ";
        String stringDelimiter = ", ";
        String mappingDelimiter = " -> ";
        String stringEnd = " }";
        String results = null;
        if (instanceProperties != null) {
            Iterator propertyNames = instanceProperties.getPropertyNames();
            while (propertyNames.hasNext()) {
                String propertyName = (String)propertyNames.next();
                if (results == null) {
                    results = propertyName + " -> " + this.getStringFromPropertyValue(instanceProperties.getPropertyValue(propertyName));
                    continue;
                }
                results = results + ", " + propertyName + " -> " + this.getStringFromPropertyValue(instanceProperties.getPropertyValue(propertyName));
            }
        }
        return "{ " + results + " }";
    }

    public String getStringValuesFromInstancePropertiesAsStruct(InstanceProperties instanceProperties) {
        String stringStart = "{ ";
        String stringDelimiter = ", ";
        String mappingDelimiter = " : ";
        String stringEnd = " }";
        String results = null;
        if (instanceProperties != null) {
            Iterator propertyNames = instanceProperties.getPropertyNames();
            while (propertyNames.hasNext()) {
                String propertyName = (String)propertyNames.next();
                if (results == null) {
                    results = propertyName + " : " + this.getStringFromPropertyValue(instanceProperties.getPropertyValue(propertyName));
                    continue;
                }
                results = results + ", " + propertyName + " : " + this.getStringFromPropertyValue(instanceProperties.getPropertyValue(propertyName));
            }
        }
        return "{ " + results + " }";
    }

    public String getStringFromPropertyValue(InstancePropertyValue instancePropertyValue) {
        if (instancePropertyValue != null) {
            if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE) {
                PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                return primitivePropertyValue.getPrimitiveValue().toString();
            }
            if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.ENUM) {
                EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
                return enumPropertyValue.getSymbolicName();
            }
            if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.ARRAY) {
                ArrayPropertyValue arrayPropertyValue = (ArrayPropertyValue)instancePropertyValue;
                if (arrayPropertyValue.getArrayCount() > 0) {
                    return this.getStringValuesFromInstancePropertiesAsArray(arrayPropertyValue.getArrayValues());
                }
            } else {
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.MAP) {
                    MapPropertyValue mapPropertyValue = (MapPropertyValue)instancePropertyValue;
                    return this.getStringValuesFromInstancePropertiesAsMap(mapPropertyValue.getMapValues());
                }
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.STRUCT) {
                    StructPropertyValue structPropertyValue = (StructPropertyValue)instancePropertyValue;
                    return this.getStringValuesFromInstancePropertiesAsStruct(structPropertyValue.getAttributes());
                }
            }
        }
        return null;
    }

    public int countMatchingPropertyValues(InstanceProperties matchProperties, InstanceProperties instanceProperties) throws InvalidParameterException {
        String methodName = "countMatchingPropertyValues";
        int matchingProperties = 0;
        if (matchProperties != null && instanceProperties != null) {
            Iterator matchPropertyNames = matchProperties.getPropertyNames();
            while (matchPropertyNames.hasNext()) {
                InstancePropertyValue matchPropertyValue;
                String matchPropertyName = (String)matchPropertyNames.next();
                if (matchPropertyName == null || (matchPropertyValue = matchProperties.getPropertyValue(matchPropertyName)) == null) continue;
                String matchPropertyValueString = this.getStringFromPropertyValue(matchPropertyValue);
                Iterator instancePropertyNames = instanceProperties.getPropertyNames();
                block8: while (instancePropertyNames.hasNext()) {
                    PrimitivePropertyValue primPropValue;
                    InstancePropertyValue instancePropertyValue;
                    String instancePropertyName = (String)instancePropertyNames.next();
                    if (instancePropertyName == null || (instancePropertyValue = instanceProperties.getPropertyValue(instancePropertyName)) == null || !instancePropertyName.equals(matchPropertyName)) continue;
                    InstancePropertyCategory ipCat = instancePropertyValue.getInstancePropertyCategory();
                    MatchOption matchOption = ipCat == InstancePropertyCategory.PRIMITIVE ? ((primPropValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING ? MatchOption.RegexFullMatch : MatchOption.ExactMatch) : (ipCat == InstancePropertyCategory.ENUM ? MatchOption.ExactMatch : MatchOption.RegexContainsMatch);
                    switch (matchOption) {
                        case ExactMatch: {
                            if (!instancePropertyValue.equals((Object)matchPropertyValue)) break;
                            ++matchingProperties;
                            break;
                        }
                        case RegexContainsMatch: {
                            matchPropertyValueString = ".*" + matchPropertyValueString + ".*";
                        }
                        case RegexFullMatch: {
                            String instancePropertyValueString = this.getStringFromPropertyValue(instancePropertyValue);
                            if (instancePropertyValueString == null) break;
                            try {
                                if (!instancePropertyValueString.matches(matchPropertyValueString)) continue block8;
                                ++matchingProperties;
                                break;
                            }
                            catch (Throwable error) {
                                throw new InvalidParameterException(OMRSErrorCode.INVALID_SEARCH_CRITERIA.getMessageDefinition(new String[]{error.getClass().getName(), matchPropertyValueString, instancePropertyValueString, error.getMessage(), "countMatchingPropertyValues"}), this.getClass().getName(), "countMatchingPropertyValues", "instanceProperties");
                            }
                        }
                    }
                }
            }
        }
        return matchingProperties;
    }

    private boolean checkStringPropertyValue(Map<String, InstancePropertyValue> propertyMap, String propertyName, String expectedValue) {
        boolean result = false;
        InstancePropertyValue instancePropertyValue = propertyMap.get(propertyName);
        if (instancePropertyValue != null && instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE) {
            try {
                PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                String matchValue = (String)primitivePropertyValue.getPrimitiveValue();
                if (matchValue != null && matchValue.matches(expectedValue)) {
                    result = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean checkDatePropertyValue(Map<String, InstancePropertyValue> propertyMap, String propertyName, Date expectedValue) {
        boolean result = false;
        InstancePropertyValue instancePropertyValue = propertyMap.get(propertyName);
        if (instancePropertyValue != null && instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE) {
            try {
                Date matchValue;
                PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                Long timestamp = (Long)primitivePropertyValue.getPrimitiveValue();
                if (timestamp != null && (matchValue = new Date(timestamp)).equals(expectedValue)) {
                    result = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public int countMatchingHeaderPropertyValues(InstanceProperties matchProperties, InstanceAuditHeader instanceHeader, InstanceProperties instanceProperties) {
        Map propertyMap;
        String metadataCollectionIdPropertyName = "metadataCollectionId";
        String metadataCollectionNamePropertyName = "metadataCollectionName";
        String typeNamePropertyName = "typeName";
        String typeGUIDPropertyName = "typeGUID";
        String createdByPropertyName = "createdBy";
        String updatedByPropertyName = "updatedBy";
        String createTimePropertyName = "createTime";
        String updateTimePropertyName = "updateTime";
        String effectiveFromPropertyName = "effectiveFrom";
        String effectiveToPropertyName = "effectiveTo";
        int matchingProperties = 0;
        if (matchProperties != null && instanceHeader != null && (propertyMap = matchProperties.getInstanceProperties()) != null) {
            if (this.checkStringPropertyValue(propertyMap, "metadataCollectionId", instanceHeader.getMetadataCollectionId())) {
                ++matchingProperties;
            }
            if (this.checkStringPropertyValue(propertyMap, "metadataCollectionName", instanceHeader.getMetadataCollectionName())) {
                ++matchingProperties;
            }
            if (this.checkStringPropertyValue(propertyMap, "typeName", instanceHeader.getType().getTypeDefName())) {
                ++matchingProperties;
            }
            if (this.checkStringPropertyValue(propertyMap, "typeGUID", instanceHeader.getType().getTypeDefGUID())) {
                ++matchingProperties;
            }
            if (this.checkStringPropertyValue(propertyMap, "createdBy", instanceHeader.getCreatedBy())) {
                ++matchingProperties;
            }
            if (this.checkStringPropertyValue(propertyMap, "updatedBy", instanceHeader.getUpdatedBy())) {
                ++matchingProperties;
            }
            if (this.checkDatePropertyValue(propertyMap, "createTime", instanceHeader.getCreateTime())) {
                ++matchingProperties;
            }
            if (this.checkDatePropertyValue(propertyMap, "updateTime", instanceHeader.getUpdateTime())) {
                ++matchingProperties;
            }
            if (instanceProperties != null) {
                if (this.checkDatePropertyValue(propertyMap, "effectiveFrom", instanceProperties.getEffectiveFromTime())) {
                    ++matchingProperties;
                }
                if (this.checkDatePropertyValue(propertyMap, "effectiveTo", instanceProperties.getEffectiveToTime())) {
                    ++matchingProperties;
                }
            }
        }
        return matchingProperties;
    }

    public boolean verifyMatchingInstancePropertyValues(InstanceProperties matchProperties, InstanceAuditHeader instanceHeader, InstanceProperties instanceProperties, MatchCriteria matchCriteria) throws InvalidParameterException {
        if (matchProperties != null && matchProperties.getInstanceProperties() != null) {
            int matchingProperties = this.countMatchingPropertyValues(matchProperties, instanceProperties) + this.countMatchingHeaderPropertyValues(matchProperties, instanceHeader, instanceProperties);
            switch (matchCriteria) {
                case ALL: {
                    if (matchingProperties != matchProperties.getPropertyCount()) break;
                    return true;
                }
                case ANY: {
                    if (matchingProperties <= 0) break;
                    return true;
                }
                case NONE: {
                    if (matchingProperties != 0) break;
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public void validateReferenceInstanceHeader(String sourceName, String localMetadataCollectionId, String instanceParameterName, InstanceHeader instance, String methodName) throws InvalidParameterException, RepositoryErrorException {
        if (instance == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_REFERENCE_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName}), this.getClass().getName(), methodName, instanceParameterName);
        }
        this.validateInstanceType(sourceName, instance);
        this.validateHomeMetadataGUID(sourceName, instanceParameterName, instance.getMetadataCollectionId(), methodName);
        if (localMetadataCollectionId.equals(instance.getMetadataCollectionId())) {
            throw new InvalidParameterException(OMRSErrorCode.LOCAL_REFERENCE_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, instanceParameterName}), this.getClass().getName(), methodName, instanceParameterName);
        }
    }

    public void validateEntityProxy(String sourceName, String localMetadataCollectionId, String proxyParameterName, EntityProxy entityProxy, String methodName) throws InvalidParameterException {
        if (entityProxy == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_ENTITY_PROXY.getMessageDefinition(new String[]{sourceName, proxyParameterName, methodName}), this.getClass().getName(), methodName, proxyParameterName);
        }
        this.validateHomeMetadataGUID(sourceName, proxyParameterName, entityProxy.getMetadataCollectionId(), methodName);
        if (localMetadataCollectionId.equals(entityProxy.getMetadataCollectionId())) {
            throw new InvalidParameterException(OMRSErrorCode.LOCAL_ENTITY_PROXY.getMessageDefinition(new String[]{sourceName, proxyParameterName, methodName}), this.getClass().getName(), methodName, proxyParameterName);
        }
        if (entityProxy.getHeaderVersion() > 1L) {
            throw new InvalidParameterException(OMRSErrorCode.UNSUPPORTED_INSTANCE_HEADER_VERSION.getMessageDefinition(new String[]{methodName, "EntityProxy", sourceName, entityProxy.getGUID(), entityProxy.getType().getTypeDefName(), Long.toString(entityProxy.getHeaderVersion()), Long.toString(1L)}), this.getClass().getName(), methodName, proxyParameterName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyInstancePropertiesMatchSearchCriteria(String sourceName, InstanceProperties properties, String searchCriteria, String methodName) throws RepositoryErrorException {
        if (properties == null) {
            return false;
        }
        Iterator propertyNames = properties.getPropertyNames();
        try {
            block9: while (propertyNames.hasNext()) {
                InstancePropertyValue propertyValue = properties.getPropertyValue((String)propertyNames.next());
                switch (propertyValue.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)propertyValue;
                        if (primitivePropertyValue.getPrimitiveDefCategory() != PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING) break;
                        String stringProperty = (String)primitivePropertyValue.getPrimitiveValue();
                        if (stringProperty == null || !stringProperty.matches(searchCriteria)) continue block9;
                        return true;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)propertyValue;
                        String enumValue = enumPropertyValue.getSymbolicName();
                        if (enumValue == null || !enumValue.matches(searchCriteria)) break;
                        return true;
                    }
                    case STRUCT: {
                        StructPropertyValue structPropertyValue = (StructPropertyValue)propertyValue;
                        if (!this.verifyInstancePropertiesMatchSearchCriteria(sourceName, structPropertyValue.getAttributes(), searchCriteria, methodName)) break;
                        return true;
                    }
                    case ARRAY: {
                        ArrayPropertyValue arrayPropertyValue = (ArrayPropertyValue)propertyValue;
                        if (!this.verifyInstancePropertiesMatchSearchCriteria(sourceName, arrayPropertyValue.getArrayValues(), searchCriteria, methodName)) break;
                        return true;
                    }
                    case MAP: {
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)propertyValue;
                        if (!this.verifyInstancePropertiesMatchSearchCriteria(sourceName, mapPropertyValue.getMapValues(), searchCriteria, methodName)) break;
                        return true;
                    }
                }
            }
            return false;
        }
        catch (Throwable error) {
            throw new RepositoryErrorException(OMRSErrorCode.BAD_PROPERTY_FOR_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName}), this.getClass().getName(), methodName, error);
        }
    }

    public boolean verifyInstancePropertiesMatchPropertyValue(String sourceName, InstanceProperties properties, String searchPropertyValue, String methodName) throws RepositoryErrorException {
        if (properties == null) {
            return false;
        }
        Iterator propertyNames = properties.getPropertyNames();
        try {
            while (propertyNames.hasNext()) {
                InstancePropertyValue instancePropertyValue = properties.getPropertyValue((String)propertyNames.next());
                switch (instancePropertyValue.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                        Object instanceProperty = primitivePropertyValue.getPrimitiveValue();
                        String stringProperty = null;
                        if (instanceProperty != null) {
                            stringProperty = instanceProperty.toString();
                        }
                        if (stringProperty == null || !stringProperty.equals(searchPropertyValue)) break;
                        return true;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
                        String enumValue = enumPropertyValue.getSymbolicName();
                        if (enumValue == null || !enumValue.equals(searchPropertyValue)) break;
                        return true;
                    }
                    case STRUCT: {
                        StructPropertyValue structPropertyValue = (StructPropertyValue)instancePropertyValue;
                        if (!this.verifyInstancePropertiesMatchPropertyValue(sourceName, structPropertyValue.getAttributes(), searchPropertyValue, methodName)) break;
                        return true;
                    }
                    case ARRAY: {
                        ArrayPropertyValue arrayPropertyValue = (ArrayPropertyValue)instancePropertyValue;
                        if (!this.verifyInstancePropertiesMatchPropertyValue(sourceName, arrayPropertyValue.getArrayValues(), searchPropertyValue, methodName)) break;
                        return true;
                    }
                    case MAP: {
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)instancePropertyValue;
                        if (!this.verifyInstancePropertiesMatchPropertyValue(sourceName, mapPropertyValue.getMapValues(), searchPropertyValue, methodName)) break;
                        return true;
                    }
                }
            }
        }
        catch (Throwable error) {
            throw new RepositoryErrorException(OMRSErrorCode.BAD_PROPERTY_FOR_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName}), this.getClass().getName(), methodName, error);
        }
        return false;
    }

    private void validateRepositoryContentManager(String methodName) {
        if (this.repositoryContentManager == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.LOCAL_REPOSITORY_CONFIGURATION_ERROR.getMessageDefinition(), this.getClass().getName(), methodName);
        }
    }

    private void throwValidatorLogicError(String sourceName, String originatingMethodName, String localMethodName) {
        throw new OMRSLogicErrorException(OMRSErrorCode.VALIDATION_LOGIC_ERROR.getMessageDefinition(new String[]{sourceName, localMethodName, originatingMethodName}), this.getClass().getName(), localMethodName);
    }

    public boolean isATypeOf(String sourceName, InstanceAuditHeader instance, String typeName, String localMethodName) {
        InstanceType instanceType;
        String methodName = "isATypeOf";
        if (typeName == null) {
            this.throwValidatorLogicError(sourceName, "isATypeOf", localMethodName);
        }
        if (instance == null) {
            this.throwValidatorLogicError(sourceName, "isATypeOf", localMethodName);
        }
        if ((instanceType = instance.getType()) != null) {
            String entityTypeName = instanceType.getTypeDefName();
            if (typeName.equals(entityTypeName)) {
                return true;
            }
            List superTypes = instanceType.getTypeDefSuperTypes();
            if (superTypes != null) {
                for (TypeDefLink typeDefLink : superTypes) {
                    if (typeDefLink == null || !typeName.equals(typeDefLink.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void validateAtMostOneEntityResult(List<EntityDetail> findResults, String typeName, String serviceName, String methodName) throws RepositoryErrorException {
        if (findResults != null && findResults.size() > 1) {
            throw new RepositoryErrorException(OMRSErrorCode.MULTIPLE_ENTITIES_FOUND.getMessageDefinition(new String[]{typeName, serviceName, methodName, findResults.toString()}), this.getClass().getName(), methodName);
        }
    }

    public void validateAtMostOneRelationshipResult(List<Relationship> findResults, String typeName, String serviceName, String methodName) throws RepositoryErrorException {
        if (findResults != null && findResults.size() > 1) {
            throw new RepositoryErrorException(OMRSErrorCode.MULTIPLE_RELATIONSHIPS_FOUND.getMessageDefinition(new String[]{typeName, serviceName, methodName, findResults.toString()}), this.getClass().getName(), methodName);
        }
    }

    private static enum MatchOption {
        RegexFullMatch,
        RegexContainsMatch,
        ExactMatch;

    }
}

