/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.server;

import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.rest.properties.AuditLogReportResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.AuditLogSeveritiesResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;
import org.odpi.openmetadata.repositoryservices.rest.server.OMRSRESTExceptionHandler;
import org.odpi.openmetadata.repositoryservices.rest.services.OMRSRepositoryServicesInstance;
import org.odpi.openmetadata.repositoryservices.rest.services.OMRSRepositoryServicesInstanceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSAuditLogRESTServices {
    private static final String serviceName = CommonServicesDescription.REPOSITORY_SERVICES.getServiceName();
    private static final OMRSRepositoryServicesInstanceHandler instanceHandler = new OMRSRepositoryServicesInstanceHandler(serviceName);
    private static final OMRSRESTExceptionHandler exceptionHandler = new OMRSRESTExceptionHandler(instanceHandler);
    private static final Logger log = LoggerFactory.getLogger(OMRSAuditLogRESTServices.class);

    public AuditLogSeveritiesResponse getSeverityList(String serverName, String userId) {
        String methodName = "getSeverityList";
        log.debug("Calling method: getSeverityList");
        AuditLogSeveritiesResponse response = new AuditLogSeveritiesResponse();
        try {
            instanceHandler.getInstance(userId, serverName, "getSeverityList");
            response.setSeverities(OMRSAuditLogRecordSeverity.getSeverityList());
        }
        catch (InvalidParameterException error) {
            exceptionHandler.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            exceptionHandler.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            exceptionHandler.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            exceptionHandler.captureThrowable((OMRSAPIResponse)response, error, userId, serverName, "getSeverityList");
        }
        log.debug("Returning from method: getSeverityList with response: " + response.toString());
        return response;
    }

    public AuditLogReportResponse getAuditLogReport(String serverName, String userId) {
        String methodName = "getAuditLogReport";
        log.debug("Calling method: getAuditLogReport");
        AuditLogReportResponse response = new AuditLogReportResponse();
        try {
            OMRSRepositoryServicesInstance instance = instanceHandler.getInstance(userId, serverName, "getAuditLogReport");
            OMRSAuditLog masterAuditLog = instance.getMasterAuditLog();
            if (masterAuditLog != null) {
                response.setReport(masterAuditLog.getFullReport());
            }
        }
        catch (InvalidParameterException error) {
            exceptionHandler.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            exceptionHandler.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            exceptionHandler.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            exceptionHandler.captureThrowable((OMRSAPIResponse)response, error, userId, serverName, "getAuditLogReport");
        }
        log.debug("Returning from method: getAuditLogReport with response: " + response.toString());
        return response;
    }
}

