/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.ExceptionAccumulatorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class QueryAccumulatorBase
extends ExceptionAccumulatorBase {
    protected String localMetadataCollectionId;
    protected AuditLog auditLog;
    protected OMRSRepositoryValidator repositoryValidator;
    private int responsesRequired = 0;
    private Map<String, Integer> resultsContributed = new HashMap<String, Integer>();
    private boolean resultsReturned = false;

    QueryAccumulatorBase(String localMetadataCollectionId, AuditLog auditLog, OMRSRepositoryValidator repositoryValidator) {
        this.localMetadataCollectionId = localMetadataCollectionId;
        this.auditLog = auditLog;
        this.repositoryValidator = repositoryValidator;
        this.registerExecutor();
    }

    public synchronized boolean areResultsComplete() {
        return this.responsesRequired == this.resultsContributed.size();
    }

    public boolean resultsReturned() {
        return this.resultsReturned;
    }

    public synchronized void registerExecutor() {
        ++this.responsesRequired;
    }

    synchronized void setResultsReturned(String metadataCollectionId, int numberOfElements) {
        this.setRequestReturned(metadataCollectionId, numberOfElements);
        this.resultsReturned = true;
    }

    private void setRequestReturned(String metadataCollectionId, int numberOfElements) {
        this.resultsContributed.put(metadataCollectionId, numberOfElements);
    }

    public synchronized void captureException(String metadataCollectionId, ClassificationErrorException exception) {
        this.setRequestReturned(metadataCollectionId, 0);
        this.classificationErrorException = exception;
    }

    public synchronized void captureException(String metadataCollectionId, EntityNotKnownException exception) {
        this.setRequestReturned(metadataCollectionId, 0);
        this.entityNotKnownException = exception;
    }

    public synchronized void captureException(String metadataCollectionId, FunctionNotSupportedException exception) {
        this.setRequestReturned(metadataCollectionId, 0);
        this.functionNotSupportedException = exception;
    }

    public synchronized void captureException(String metadataCollectionId, InvalidParameterException exception) {
        this.setRequestReturned(metadataCollectionId, 0);
        this.invalidParameterException = exception;
    }

    public synchronized void captureException(String metadataCollectionId, PagingErrorException exception) {
        this.setRequestReturned(metadataCollectionId, 0);
        this.pagingErrorException = exception;
    }

    public synchronized void captureException(String metadataCollectionId, PropertyErrorException exception) {
        this.setRequestReturned(metadataCollectionId, 0);
        this.propertyErrorException = exception;
    }

    public synchronized void captureException(String metadataCollectionId, RelationshipNotKnownException exception) {
        this.setRequestReturned(metadataCollectionId, 0);
        this.relationshipNotKnownException = exception;
    }

    public synchronized void captureException(String metadataCollectionId, RepositoryErrorException exception) {
        this.setRequestReturned(metadataCollectionId, 0);
        this.repositoryErrorException = exception;
    }

    public synchronized void captureException(String metadataCollectionId, TypeErrorException exception) {
        this.setRequestReturned(metadataCollectionId, 0);
        this.typeErrorException = exception;
    }

    public synchronized void captureException(String metadataCollectionId, UserNotAuthorizedException exception) {
        this.setRequestReturned(metadataCollectionId, 0);
        this.userNotAuthorizedException = exception;
    }

    public synchronized void captureGenericException(String metadataCollectionId, Throwable exception) {
        this.setRequestReturned(metadataCollectionId, 0);
        this.anotherException = exception;
    }
}

