/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.QueryInstanceAccumulatorBase;

public class RelationshipAccumulator
extends QueryInstanceAccumulatorBase {
    private volatile Map<String, Relationship> accumulatedRelationships = new HashMap<String, Relationship>();

    public RelationshipAccumulator(String localMetadataCollectionId, AuditLog auditLog, OMRSRepositoryValidator repositoryValidator) {
        super(localMetadataCollectionId, auditLog, repositoryValidator);
    }

    private void addRelationship(Relationship incomingRelationship, String metadataCollectionId) {
        if (incomingRelationship != null && incomingRelationship.getGUID() != null && metadataCollectionId != null) {
            String relationshipGUID = incomingRelationship.getGUID();
            Relationship currentSavedRelationship = this.accumulatedRelationships.get(relationshipGUID);
            if (super.currentInstanceIsBest((InstanceHeader)currentSavedRelationship, (InstanceHeader)incomingRelationship)) {
                return;
            }
            this.accumulatedRelationships.put(relationshipGUID, incomingRelationship);
            if (metadataCollectionId.equals(this.localMetadataCollectionId)) {
                super.captureLocalInstance(relationshipGUID);
            }
        }
    }

    public synchronized void addRelationships(List<Relationship> relationships, String metadataCollectionId) {
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                this.addRelationship(relationship, metadataCollectionId);
            }
            super.setResultsReturned(metadataCollectionId, relationships.size());
        } else {
            super.setResultsReturned(metadataCollectionId, 0);
        }
    }

    public synchronized List<Relationship> getResults(EnterpriseOMRSRepositoryConnector repositoryConnector) {
        if (this.accumulatedRelationships.isEmpty()) {
            return null;
        }
        this.makeRefreshRecommendations(repositoryConnector);
        return new ArrayList<Relationship>(this.accumulatedRelationships.values());
    }

    private void makeRefreshRecommendations(EnterpriseOMRSRepositoryConnector repositoryConnector) {
        if (this.localMetadataCollectionId == null || this.accumulatedRelationships.isEmpty()) {
            return;
        }
        for (Relationship accumulatedRelationship : this.accumulatedRelationships.values()) {
            String entityGUID;
            if (accumulatedRelationship == null || (entityGUID = accumulatedRelationship.getGUID()) == null || !super.notLocal(entityGUID)) continue;
            repositoryConnector.requestRefreshOfRelationship(accumulatedRelationship);
        }
    }
}

