/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.Date;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GetEntityExecutor
extends RepositoryExecutorBase {
    private String entityGUID;
    private boolean allExceptions = true;
    private Date asOfTime = null;
    private EntityDetail retrievedEntity = null;
    private MaintenanceAccumulator accumulator = new MaintenanceAccumulator();

    public GetEntityExecutor(String userId, String entityGUID, boolean allExceptions, String methodName) {
        super(userId, methodName);
        this.entityGUID = entityGUID;
        this.allExceptions = allExceptions;
    }

    public GetEntityExecutor(String userId, String entityGUID, Date asOfTime, String methodName) {
        super(userId, methodName);
        this.entityGUID = entityGUID;
        this.asOfTime = asOfTime;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        boolean result = false;
        try {
            this.retrievedEntity = this.asOfTime == null ? (this.allExceptions ? metadataCollection.getEntityDetail(this.userId, this.entityGUID) : metadataCollection.isEntityKnown(this.userId, this.entityGUID)) : metadataCollection.getEntityDetail(this.userId, this.entityGUID, this.asOfTime);
            if (this.retrievedEntity != null) {
                result = true;
            }
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityProxyOnlyException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Throwable error) {
            this.accumulator.captureGenericException(error);
        }
        return result;
    }

    public EntityDetail isEntityKnown() throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        if (this.retrievedEntity != null) {
            return this.retrievedEntity;
        }
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedInvalidParameterException();
        return null;
    }

    public EntityDetail getEntityDetail() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        EntityDetail entity = this.isEntityKnown();
        if (entity != null) {
            return entity;
        }
        this.accumulator.throwCapturedEntityProxyOnlyException();
        this.accumulator.throwCapturedEntityNotKnownException();
        return null;
    }

    public EntityDetail getEntityDetailHistory() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        EntityDetail entity = this.getEntityDetail();
        if (entity != null) {
            return entity;
        }
        this.accumulator.throwCapturedFunctionNotSupportedException();
        return null;
    }
}

