/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class VerifyTypeDefExecutor
extends RepositoryExecutorBase {
    private TypeDef typeDef;
    private boolean result = false;
    private boolean resultSet = false;
    private MaintenanceAccumulator accumulator = new MaintenanceAccumulator();

    public VerifyTypeDefExecutor(String userId, TypeDef typeDef, String methodName) {
        super(userId, methodName);
        this.typeDef = typeDef;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            this.result = metadataCollection.verifyTypeDef(this.userId, this.typeDef);
            this.resultSet = true;
        }
        catch (TypeDefNotSupportedException error) {
            this.accumulator.captureException(error);
        }
        catch (InvalidTypeDefException error) {
            this.accumulator.captureException(error);
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (TypeDefConflictException error) {
            this.accumulator.captureException(error);
            this.resultSet = true;
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Throwable error) {
            this.accumulator.captureGenericException(error);
        }
        return this.resultSet;
    }

    public boolean getResult() throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        this.accumulator.throwCapturedTypeDefConflictException();
        if (this.resultSet) {
            return this.result;
        }
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedThrowableException(this.methodName);
        this.accumulator.throwCapturedTypeDefNotSupportedException();
        this.accumulator.throwCapturedInvalidTypeDefException();
        this.accumulator.throwCapturedInvalidParameterException();
        return false;
    }
}

