/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortTopicStructure;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryMode;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenMetadataEventProtocolVersion;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenMetadataExchangeRule;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;

public class OMRSConfigurationFactory {
    private static final String defaultEnterpriseMetadataCollectionName = " Enterprise Metadata Collection";
    private static final String defaultCohortName = "defaultCohort";
    private ConnectorConfigurationFactory connectorConfigurationFactory = new ConnectorConfigurationFactory();

    private OpenMetadataEventProtocolVersion getDefaultEnterpriseOMRSTopicProtocolVersion() {
        return OpenMetadataEventProtocolVersion.V1;
    }

    private OpenMetadataEventProtocolVersion getDefaultCohortOMRSTopicProtocolVersion() {
        return OpenMetadataEventProtocolVersion.V1;
    }

    private OpenMetadataExchangeRule getDefaultEventsToSendRule() {
        return OpenMetadataExchangeRule.ALL;
    }

    private List<TypeDefSummary> getDefaultSelectedTypesToSend() {
        return null;
    }

    private OpenMetadataExchangeRule getDefaultEventsToSaveRule() {
        return OpenMetadataExchangeRule.ALL;
    }

    private List<TypeDefSummary> getDefaultSelectedTypesToSave() {
        return null;
    }

    private OpenMetadataExchangeRule getDefaultEventsToProcessRule() {
        return OpenMetadataExchangeRule.ALL;
    }

    private List<TypeDefSummary> getDefaultSelectedTypesToProcess() {
        return null;
    }

    private LocalRepositoryConfig getDefaultLocalRepositoryConfig(String localServerName, String localServerURL) {
        LocalRepositoryConfig localRepositoryConfig = new LocalRepositoryConfig();
        localRepositoryConfig.setMetadataCollectionId(UUID.randomUUID().toString());
        localRepositoryConfig.setLocalRepositoryMode(LocalRepositoryMode.NO_REPOSITORY);
        localRepositoryConfig.setLocalRepositoryLocalConnection(this.connectorConfigurationFactory.getDefaultLocalRepositoryLocalConnection());
        localRepositoryConfig.setLocalRepositoryRemoteConnection(this.connectorConfigurationFactory.getDefaultLocalRepositoryRemoteConnection(localServerName, localServerURL));
        localRepositoryConfig.setEventsToSaveRule(this.getDefaultEventsToSaveRule());
        localRepositoryConfig.setSelectedTypesToSave(this.getDefaultSelectedTypesToSave());
        localRepositoryConfig.setEventsToSendRule(this.getDefaultEventsToSendRule());
        localRepositoryConfig.setSelectedTypesToSend(this.getDefaultSelectedTypesToSend());
        localRepositoryConfig.setEventMapperConnection(this.connectorConfigurationFactory.getDefaultEventMapperConnection());
        return localRepositoryConfig;
    }

    public LocalRepositoryConfig getInMemoryLocalRepositoryConfig(String localServerName, String localServerURL) {
        LocalRepositoryConfig localRepositoryConfig = this.getDefaultLocalRepositoryConfig(localServerName, localServerURL);
        localRepositoryConfig.setLocalRepositoryMode(LocalRepositoryMode.OPEN_METADATA_NATIVE);
        localRepositoryConfig.setLocalRepositoryLocalConnection(this.connectorConfigurationFactory.getInMemoryLocalRepositoryLocalConnection());
        return localRepositoryConfig;
    }

    public LocalRepositoryConfig getLocalGraphLocalRepositoryConfig(String localServerName, String localServerURL, Map<String, Object> storageProperties) {
        LocalRepositoryConfig localRepositoryConfig = this.getDefaultLocalRepositoryConfig(localServerName, localServerURL);
        localRepositoryConfig.setLocalRepositoryMode(LocalRepositoryMode.OPEN_METADATA_NATIVE);
        localRepositoryConfig.setLocalRepositoryLocalConnection(this.connectorConfigurationFactory.getLocalGraphRepositoryLocalConnection(storageProperties));
        return localRepositoryConfig;
    }

    public LocalRepositoryConfig getReadOnlyLocalRepositoryConfig(String localServerName, String localServerURL) {
        LocalRepositoryConfig localRepositoryConfig = this.getDefaultLocalRepositoryConfig(localServerName, localServerURL);
        localRepositoryConfig.setLocalRepositoryMode(LocalRepositoryMode.METADATA_CACHE);
        localRepositoryConfig.setLocalRepositoryLocalConnection(this.connectorConfigurationFactory.getReadOnlyLocalRepositoryLocalConnection());
        return localRepositoryConfig;
    }

    public LocalRepositoryConfig getPluginRepositoryLocalRepositoryConfig(String localServerName, String localServerURL) {
        LocalRepositoryConfig localRepositoryConfig = this.getDefaultLocalRepositoryConfig(localServerName, localServerURL);
        localRepositoryConfig.setLocalRepositoryMode(LocalRepositoryMode.PLUGIN_REPOSITORY);
        localRepositoryConfig.setLocalRepositoryLocalConnection(null);
        return localRepositoryConfig;
    }

    public LocalRepositoryConfig getRepositoryProxyLocalRepositoryConfig(String localServerName, String localServerURL) {
        LocalRepositoryConfig localRepositoryConfig = this.getDefaultLocalRepositoryConfig(localServerName, localServerURL);
        localRepositoryConfig.setLocalRepositoryMode(LocalRepositoryMode.REPOSITORY_PROXY);
        localRepositoryConfig.setLocalRepositoryLocalConnection(null);
        return localRepositoryConfig;
    }

    public EnterpriseAccessConfig getDefaultEnterpriseAccessConfig(String localServerName, String localServerId) {
        EnterpriseAccessConfig enterpriseAccessConfig = new EnterpriseAccessConfig();
        enterpriseAccessConfig.setEnterpriseMetadataCollectionId(UUID.randomUUID().toString());
        enterpriseAccessConfig.setEnterpriseMetadataCollectionName(localServerName + defaultEnterpriseMetadataCollectionName);
        enterpriseAccessConfig.setEnterpriseOMRSTopicConnection(this.connectorConfigurationFactory.getDefaultEnterpriseOMRSTopicConnection(localServerName, localServerId));
        enterpriseAccessConfig.setEnterpriseOMRSTopicProtocolVersion(this.getDefaultEnterpriseOMRSTopicProtocolVersion());
        return enterpriseAccessConfig;
    }

    public CohortConfig getDefaultCohortConfig(String localServerName, String cohortName, CohortTopicStructure cohortTopicStructure, Map<String, Object> configurationProperties, String eventBusConnectorProvider, String topicURLRoot, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        CohortConfig cohortConfig = new CohortConfig();
        String newCohortName = defaultCohortName;
        if (cohortName != null) {
            newCohortName = cohortName;
        }
        cohortConfig.setCohortName(newCohortName);
        cohortConfig.setCohortRegistryConnection(this.connectorConfigurationFactory.getDefaultCohortRegistryConnection(localServerName, newCohortName));
        if (cohortTopicStructure == null || cohortTopicStructure == CohortTopicStructure.SINGLE_TOPIC || cohortTopicStructure == CohortTopicStructure.BOTH_SINGLE_AND_DEDICATED_TOPICS) {
            cohortConfig.setCohortOMRSTopicConnection(this.connectorConfigurationFactory.getDefaultSingleCohortOMRSTopicConnection(newCohortName, configurationProperties, eventBusConnectorProvider, topicURLRoot, serverId, eventBusConfigurationProperties));
        }
        if (cohortTopicStructure == CohortTopicStructure.DEDICATED_TOPICS || cohortTopicStructure == CohortTopicStructure.BOTH_SINGLE_AND_DEDICATED_TOPICS) {
            cohortConfig.setCohortOMRSRegistrationTopicConnection(this.connectorConfigurationFactory.getDefaultRegistrationCohortOMRSTopicConnection(newCohortName, configurationProperties, eventBusConnectorProvider, topicURLRoot, eventBusConfigurationProperties));
            cohortConfig.setCohortOMRSTypesTopicConnection(this.connectorConfigurationFactory.getDefaultTypesCohortOMRSTopicConnection(newCohortName, configurationProperties, eventBusConnectorProvider, topicURLRoot, eventBusConfigurationProperties));
            cohortConfig.setCohortOMRSInstancesTopicConnection(this.connectorConfigurationFactory.getDefaultInstancesCohortOMRSTopicConnection(newCohortName, configurationProperties, eventBusConnectorProvider, topicURLRoot, serverId, eventBusConfigurationProperties));
        }
        cohortConfig.setCohortOMRSTopicProtocolVersion(this.getDefaultCohortOMRSTopicProtocolVersion());
        cohortConfig.setEventsToProcessRule(this.getDefaultEventsToProcessRule());
        cohortConfig.setSelectedTypesToProcess(this.getDefaultSelectedTypesToProcess());
        return cohortConfig;
    }

    public RepositoryServicesConfig getDefaultRepositoryServicesConfig() {
        RepositoryServicesConfig repositoryServicesConfig = new RepositoryServicesConfig();
        ArrayList<Connection> auditLogStoreConnections = new ArrayList<Connection>();
        auditLogStoreConnections.add(this.connectorConfigurationFactory.getDefaultAuditLogConnection());
        repositoryServicesConfig.setAuditLogConnections(auditLogStoreConnections);
        return repositoryServicesConfig;
    }
}

