/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.metadatahighway;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.OMRSCohortRegistryStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.properties.MemberRegistration;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectionConsumer;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSEventListener;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRegistryEventPublisher;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventExchangeRule;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventManager;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventPublisher;
import org.odpi.openmetadata.repositoryservices.events.OpenMetadataEventsSecurity;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConnectorErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.OMRSLocalRepository;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentValidator;
import org.odpi.openmetadata.repositoryservices.metadatahighway.cohortregistry.OMRSCohortRegistry;
import org.odpi.openmetadata.repositoryservices.properties.CohortConnectionStatus;
import org.odpi.openmetadata.repositoryservices.properties.CohortDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSCohortManager {
    private String cohortName = null;
    private OMRSTopicConnector cohortSingleTopicConnector = null;
    private Connection cohortSingleTopicConnection = null;
    private OMRSTopicConnector cohortRegistrationTopicConnector = null;
    private Connection cohortRegistrationTopicConnection = null;
    private OMRSTopicConnector cohortTypesTopicConnector = null;
    private Connection cohortTypesTopicConnection = null;
    private OMRSTopicConnector cohortInstancesTopicConnector = null;
    private Connection cohortInstancesTopicConnection = null;
    private OMRSRepositoryEventManager cohortRepositoryEventManager = null;
    private OMRSCohortRegistry cohortRegistry = null;
    private CohortConnectionStatus cohortConnectionStatus = CohortConnectionStatus.NOT_INITIALIZED;
    private String localMetadataCollectionId = null;
    private OMRSRepositoryEventPublisher outboundRepositoryEventPublisher = null;
    private AuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(OMRSCohortManager.class);

    OMRSCohortManager(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public void initialize(String cohortName, String localMetadataCollectionId, String localMetadataCollectionName, String localServerName, String localServerType, String localOrganizationName, OMRSLocalRepository localRepository, OMRSRepositoryContentManager localRepositoryContentManager, OMRSConnectionConsumer connectionConsumer, OMRSTopicConnector enterpriseTopicConnector, OMRSCohortRegistryStore cohortRegistryStore, Connection cohortSingleTopicConnection, OMRSTopicConnector cohortSingleTopicConnector, Connection cohortRegistrationTopicConnection, OMRSTopicConnector cohortRegistrationTopicConnector, Connection cohortTypesTopicConnection, OMRSTopicConnector cohortTypesTopicConnector, Connection cohortInstancesTopicConnection, OMRSTopicConnector cohortInstancesTopicConnector, OMRSRepositoryEventExchangeRule inboundEventExchangeRule) {
        String actionDescription = "Initialize Cohort Manager";
        log.debug("Initialize Cohort Manager");
        try {
            this.cohortName = cohortName;
            this.auditLog.logMessage("Initialize Cohort Manager", OMRSAuditCode.COHORT_INITIALIZING.getMessageDefinition(new String[]{cohortName}));
            this.cohortConnectionStatus = CohortConnectionStatus.INITIALIZING;
            this.cohortSingleTopicConnection = cohortSingleTopicConnection;
            this.cohortSingleTopicConnector = cohortSingleTopicConnector;
            this.cohortRegistrationTopicConnection = cohortRegistrationTopicConnection;
            this.cohortRegistrationTopicConnector = cohortRegistrationTopicConnector;
            this.cohortTypesTopicConnection = cohortTypesTopicConnection;
            this.cohortTypesTopicConnector = cohortTypesTopicConnector;
            this.cohortInstancesTopicConnection = cohortInstancesTopicConnection;
            this.cohortInstancesTopicConnector = cohortInstancesTopicConnector;
            this.localMetadataCollectionId = localMetadataCollectionId;
            this.cohortRepositoryEventManager = new OMRSRepositoryEventManager(cohortName + " cohort inbound", inboundEventExchangeRule, new OMRSRepositoryContentValidator(localRepositoryContentManager), this.auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.REPOSITORY_EVENT_MANAGER));
            ArrayList<OMRSTopicConnector> registrationTopicConnectors = new ArrayList<OMRSTopicConnector>();
            if (cohortSingleTopicConnector != null) {
                registrationTopicConnectors.add(cohortSingleTopicConnector);
            }
            if (cohortRegistrationTopicConnector != null) {
                registrationTopicConnectors.add(cohortRegistrationTopicConnector);
            }
            OMRSRegistryEventPublisher outboundRegistryEventProcessor = new OMRSRegistryEventPublisher(cohortName, registrationTopicConnectors, this.auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.EVENT_PUBLISHER));
            this.cohortRegistry = new OMRSCohortRegistry(this.auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.COHORT_REGISTRY));
            if (localRepository != null) {
                this.cohortRegistry.initialize(cohortName, localMetadataCollectionId, localMetadataCollectionName, localRepository.getLocalRepositoryRemoteConnection(), localServerName, localServerType, localOrganizationName, outboundRegistryEventProcessor, cohortRegistryStore, connectionConsumer);
                OMRSRepositoryEventManager localRepositoryEventManager = localRepository.getOutboundRepositoryEventManager();
                if (localRepositoryEventManager != null) {
                    ArrayList<OMRSTopicConnector> typesTopicConnectors = new ArrayList<OMRSTopicConnector>();
                    ArrayList<OMRSTopicConnector> instancesTopicConnectors = new ArrayList<OMRSTopicConnector>();
                    if (cohortSingleTopicConnector != null) {
                        typesTopicConnectors.add(cohortSingleTopicConnector);
                        instancesTopicConnectors.add(cohortSingleTopicConnector);
                    }
                    if (cohortTypesTopicConnector != null) {
                        typesTopicConnectors.add(cohortTypesTopicConnector);
                    }
                    if (cohortInstancesTopicConnector != null) {
                        instancesTopicConnectors.add(cohortInstancesTopicConnector);
                    }
                    this.outboundRepositoryEventPublisher = new OMRSRepositoryEventPublisher(cohortName, typesTopicConnectors, instancesTopicConnectors, this.auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.EVENT_PUBLISHER));
                    localRepositoryEventManager.registerRepositoryEventProcessor(this.outboundRepositoryEventPublisher);
                }
                if (localRepository.getIncomingTypeDefEventProcessor() != null) {
                    this.cohortRepositoryEventManager.registerTypeDefProcessor(localRepository.getIncomingTypeDefEventProcessor());
                }
                if (localRepository.getIncomingInstanceEventProcessor() != null) {
                    this.cohortRepositoryEventManager.registerInstanceProcessor(localRepository.getIncomingInstanceEventProcessor());
                }
            } else {
                this.cohortRegistry.initialize(cohortName, null, null, null, localServerName, localServerType, localOrganizationName, outboundRegistryEventProcessor, cohortRegistryStore, connectionConsumer);
            }
            if (enterpriseTopicConnector != null) {
                OMRSRepositoryEventPublisher enterpriseEventPublisher = new OMRSRepositoryEventPublisher("Cohort to Enterprise", enterpriseTopicConnector, this.auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.EVENT_PUBLISHER));
                this.cohortRepositoryEventManager.registerRepositoryEventProcessor(enterpriseEventPublisher);
            }
            this.cohortConnectionStatus = CohortConnectionStatus.NEW;
        }
        catch (Exception error) {
            log.error("Unable to initialize cohort manager", (Throwable)error);
            this.cohortConnectionStatus = CohortConnectionStatus.CONFIGURATION_ERROR;
            this.auditLog.logException("Initialize Cohort Manager", OMRSAuditCode.COHORT_CONFIG_ERROR.getMessageDefinition(new String[]{cohortName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
        }
        log.debug("Initialize Cohort Manager COMPLETE");
    }

    public void setSecurityVerifier(OpenMetadataEventsSecurity securityVerifier) {
        String actionDescription = "Initialize Security and Listener";
        if (this.outboundRepositoryEventPublisher != null) {
            this.outboundRepositoryEventPublisher.setSecurityVerifier(securityVerifier);
        }
        if (this.cohortRepositoryEventManager != null) {
            this.cohortRepositoryEventManager.start();
        }
        try {
            OMRSEventListener cohortEventListener = new OMRSEventListener(this.cohortName, this.localMetadataCollectionId, this.cohortRegistry, this.cohortRepositoryEventManager, securityVerifier, this.auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.EVENT_LISTENER));
            if (this.cohortSingleTopicConnector != null) {
                this.cohortSingleTopicConnector.registerListener((OMRSTopicListener)cohortEventListener, this.cohortName + " (single)");
                this.cohortSingleTopicConnector.start();
            }
            if (this.cohortRegistrationTopicConnector != null) {
                this.cohortRegistrationTopicConnector.registerListener((OMRSTopicListener)cohortEventListener, this.cohortName + " (registration)");
                this.cohortRegistrationTopicConnector.start();
            }
            if (this.cohortTypesTopicConnector != null) {
                this.cohortTypesTopicConnector.registerListener((OMRSTopicListener)cohortEventListener, this.cohortName + " (types)");
                this.cohortTypesTopicConnector.start();
            }
            if (this.cohortInstancesTopicConnector != null) {
                this.cohortInstancesTopicConnector.registerListener((OMRSTopicListener)cohortEventListener, this.cohortName + " (instances)");
                this.cohortInstancesTopicConnector.start();
            }
        }
        catch (Exception error) {
            log.error("Unable to initialize event listener", (Throwable)error);
            this.cohortConnectionStatus = CohortConnectionStatus.CONFIGURATION_ERROR;
            this.auditLog.logException("Initialize Security and Listener", OMRSAuditCode.COHORT_CONFIG_ERROR.getMessageDefinition(new String[]{this.cohortName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
        }
        this.cohortRegistry.connectToCohort();
        this.cohortConnectionStatus = CohortConnectionStatus.CONNECTED;
    }

    public String getCohortName() {
        return this.cohortName;
    }

    MemberRegistration getLocalRegistration() {
        if (this.cohortRegistry != null) {
            return this.cohortRegistry.getLocalRegistration();
        }
        return null;
    }

    CohortDescription getCohortDescription() {
        CohortDescription description = new CohortDescription();
        description.setCohortName(this.cohortName);
        if (this.cohortRegistrationTopicConnection != null) {
            description.setTopicConnection(this.cohortRegistrationTopicConnection);
        } else {
            description.setTopicConnection(this.cohortSingleTopicConnection);
        }
        description.setSingleTopicConnection(this.cohortSingleTopicConnection);
        description.setRegistrationTopicConnection(this.cohortRegistrationTopicConnection);
        description.setTypesTopicConnection(this.cohortTypesTopicConnection);
        description.setInstancesTopicConnection(this.cohortInstancesTopicConnection);
        description.setConnectionStatus(this.cohortConnectionStatus);
        return description;
    }

    List<MemberRegistration> getRemoteMembers() {
        if (this.cohortRegistry != null) {
            return this.cohortRegistry.getRemoteMembers();
        }
        return null;
    }

    CohortConnectionStatus getCohortConnectionStatus() {
        return this.cohortConnectionStatus;
    }

    public synchronized void disconnect(boolean permanent) {
        String actionDescription = "Disconnect Cohort Manager";
        log.debug("Disconnect Cohort Manager");
        try {
            this.cohortConnectionStatus = CohortConnectionStatus.DISCONNECTING;
            if (this.cohortRegistry != null) {
                this.cohortRegistry.disconnectFromCohort(permanent);
            }
            if (this.cohortSingleTopicConnector != null) {
                this.cohortSingleTopicConnector.disconnect();
            }
            if (this.cohortRegistrationTopicConnector != null) {
                this.cohortRegistrationTopicConnector.disconnect();
            }
            if (this.cohortTypesTopicConnector != null) {
                this.cohortTypesTopicConnector.disconnect();
            }
            if (this.cohortInstancesTopicConnector != null) {
                this.cohortInstancesTopicConnector.disconnect();
            }
            this.cohortConnectionStatus = CohortConnectionStatus.DISCONNECTED;
        }
        catch (ConnectorCheckedException error) {
            log.debug("Disconnect Cohort Manager FAILED with connector checked exception");
            throw new OMRSConnectorErrorException(OMRSErrorCode.COHORT_DISCONNECT_FAILED.getMessageDefinition(new String[]{this.cohortName}), this.getClass().getName(), "Disconnect Cohort Manager", (Throwable)error);
        }
        catch (Exception error) {
            log.debug("Disconnect Cohort Manager FAILED with exception");
            throw error;
        }
        log.debug("Disconnect Cohort Manager COMPLETE");
    }

    public String toString() {
        return "OMRSCohortManager{cohortName='" + this.cohortName + '\'' + ", cohortConnectionStatus=" + this.cohortConnectionStatus + '}';
    }
}

