/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GetEntitySummaryExecutor
extends RepositoryExecutorBase {
    private String entityGUID;
    private boolean inPhaseOne = true;
    private EntitySummary latestEntity = null;
    private Map<String, Classification> homeClassifications = new HashMap<String, Classification>();
    private MaintenanceAccumulator accumulator = new MaintenanceAccumulator();

    public GetEntitySummaryExecutor(String userId, String entityGUID, String methodName) {
        super(userId, methodName);
        this.entityGUID = entityGUID;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            if (this.inPhaseOne) {
                EntitySummary retrievedEntity = metadataCollection.getEntitySummary(this.userId, this.entityGUID);
                if (retrievedEntity != null) {
                    if (retrievedEntity.getClassifications() != null) {
                        for (Classification entityClassification : retrievedEntity.getClassifications()) {
                            if (entityClassification == null || !metadataCollectionId.equals(entityClassification.getMetadataCollectionId())) continue;
                            this.homeClassifications.put(entityClassification.getName(), entityClassification);
                        }
                    }
                    if (metadataCollectionId.equals(retrievedEntity.getMetadataCollectionId())) {
                        this.latestEntity = retrievedEntity;
                        this.inPhaseOne = false;
                    } else if (this.latestEntity == null) {
                        this.latestEntity = retrievedEntity;
                    } else if (retrievedEntity.getVersion() > this.latestEntity.getVersion()) {
                        this.latestEntity = retrievedEntity;
                    }
                }
            } else {
                List homeClassifications = metadataCollection.getHomeClassifications(this.userId, this.entityGUID);
                if (homeClassifications != null) {
                    for (Classification homeClassification : homeClassifications) {
                        if (homeClassification == null) continue;
                        this.homeClassifications.put(homeClassification.getName(), homeClassification);
                    }
                }
            }
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Throwable error) {
            this.accumulator.captureGenericException(error);
        }
        return false;
    }

    public EntitySummary getEntitySummary() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        if (this.latestEntity != null) {
            if (this.homeClassifications.isEmpty()) {
                this.latestEntity.setClassifications(null);
            } else {
                this.latestEntity.setClassifications(new ArrayList<Classification>(this.homeClassifications.values()));
            }
            return this.latestEntity;
        }
        this.accumulator.throwCapturedEntityNotKnownException();
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedInvalidParameterException();
        return null;
    }
}

