/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.Date;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GetRelationshipExecutor
extends RepositoryExecutorBase {
    private String relationshipGUID;
    private boolean allExceptions = true;
    private Date asOfTime = null;
    private Relationship retrievedRelationship = null;
    private MaintenanceAccumulator accumulator = new MaintenanceAccumulator();

    public GetRelationshipExecutor(String userId, String relationshipGUID, boolean allExceptions, String methodName) {
        super(userId, methodName);
        this.relationshipGUID = relationshipGUID;
        this.allExceptions = allExceptions;
    }

    public GetRelationshipExecutor(String userId, String relationshipGUID, Date asOfTime, String methodName) {
        super(userId, methodName);
        this.relationshipGUID = relationshipGUID;
        this.asOfTime = asOfTime;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        boolean result = false;
        try {
            this.retrievedRelationship = this.asOfTime == null ? (this.allExceptions ? metadataCollection.getRelationship(this.userId, this.relationshipGUID) : metadataCollection.isRelationshipKnown(this.userId, this.relationshipGUID)) : metadataCollection.getRelationship(this.userId, this.relationshipGUID, this.asOfTime);
            if (this.retrievedRelationship != null) {
                result = true;
            }
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (RelationshipNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Throwable error) {
            this.accumulator.captureGenericException(error);
        }
        return result;
    }

    public Relationship isRelationshipKnown() throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        if (this.retrievedRelationship != null) {
            return this.retrievedRelationship;
        }
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedInvalidParameterException();
        return null;
    }

    public Relationship getRelationship() throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        Relationship relationship = this.isRelationshipKnown();
        if (relationship != null) {
            return relationship;
        }
        this.accumulator.throwCapturedRelationshipNotKnownException();
        return null;
    }

    public Relationship getRelationshipHistory() throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        Relationship relationship = this.getRelationship();
        if (relationship != null) {
            return relationship;
        }
        this.accumulator.throwCapturedFunctionNotSupportedException();
        return null;
    }
}

