/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class RestoreEntityExecutor
extends RepositoryExecutorBase {
    private String entityGUID;
    private EntityDetail restoredEntity = null;
    private MaintenanceAccumulator accumulator = new MaintenanceAccumulator();

    public RestoreEntityExecutor(String userId, String entityGUID, String methodName) {
        super(userId, methodName);
        this.entityGUID = entityGUID;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        boolean result = false;
        try {
            this.restoredEntity = metadataCollection.restoreEntity(this.userId, this.entityGUID);
            result = true;
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (FunctionNotSupportedException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityNotDeletedException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Throwable error) {
            this.accumulator.captureGenericException(error);
        }
        return result;
    }

    public EntityDetail getRestoredEntity() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (this.restoredEntity != null) {
            return this.restoredEntity;
        }
        this.accumulator.throwCapturedEntityNotDeletedException();
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedThrowableException(this.methodName);
        this.accumulator.throwCapturedEntityNotKnownException();
        this.accumulator.throwCapturedInvalidParameterException();
        this.accumulator.throwCapturedFunctionNotSupportedException();
        return null;
    }
}

