/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.admin;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveManager;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogDestination;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveStoreConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventMapperConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectionConsumer;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSEnterpriseConnectorManager;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSConnection;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSConnectorProvider;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventExchangeRule;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventManager;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventPublisher;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessorInterface;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSConnectorProvider;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentHelper;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentValidator;
import org.odpi.openmetadata.repositoryservices.metadatahighway.OMRSMetadataHighwayManager;
import org.odpi.openmetadata.repositoryservices.rest.server.OMRSRepositoryRESTServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSOperationalServices {
    private static final Logger log = LoggerFactory.getLogger(OMRSOperationalServices.class);
    private String localServerName;
    private String localServerType;
    private String localMetadataCollectionName;
    private String localOrganizationName;
    private String localServerUserId;
    private String localServerPassword;
    private String localServerURL;
    private int maxPageSize;
    private String localMetadataCollectionId = null;
    private OMRSRepositoryContentManager localRepositoryContentManager = null;
    private OMRSRepositoryEventManager localRepositoryEventManager = null;
    private OMRSMetadataHighwayManager metadataHighwayManager = null;
    private OMRSEnterpriseConnectorManager enterpriseConnectorManager = null;
    private String enterpriseMetadataCollectionId = null;
    private String enterpriseMetadataCollectionName = null;
    private OMRSTopicConnector enterpriseOMRSTopicConnector = null;
    private LocalOMRSRepositoryConnector localRepositoryConnector = null;
    private OMRSArchiveManager archiveManager = null;
    private OMRSAuditLogDestination auditLogDestination = null;
    private OMRSAuditLog auditLog = null;

    public OMRSOperationalServices(String localServerName, String localServerType, String organizationName, String localServerUserId, String localServerPassword, String localServerURL, int maxPageSize) {
        this.localServerName = localServerName;
        this.localServerType = localServerType;
        this.localOrganizationName = organizationName;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
        this.localServerURL = localServerURL;
        this.maxPageSize = maxPageSize;
    }

    public OMRSTopicConnector getEnterpriseOMRSTopicConnector() {
        return this.enterpriseOMRSTopicConnector;
    }

    public OMRSRepositoryConnector getEnterpriseOMRSRepositoryConnector(String callingServiceName) {
        String actionDescription = "getEnterpriseOMRSRepositoryConnector";
        if (this.enterpriseMetadataCollectionId != null) {
            EnterpriseOMRSConnectorProvider connectorProvider = new EnterpriseOMRSConnectorProvider(this.enterpriseConnectorManager, this.localRepositoryContentManager, this.localServerName, this.localServerType, this.localOrganizationName, this.auditLog.createNewAuditLog(OMRSAuditingComponent.ENTERPRISE_REPOSITORY_CONNECTOR), this.enterpriseMetadataCollectionId, this.enterpriseMetadataCollectionName, this.localMetadataCollectionId);
            try {
                Connector connector = connectorProvider.getConnector(new EnterpriseOMRSConnection());
                EnterpriseOMRSRepositoryConnector omrsRepositoryConnector = (EnterpriseOMRSRepositoryConnector)connector;
                omrsRepositoryConnector.setCallingServiceName(callingServiceName);
                omrsRepositoryConnector.setMaxPageSize(this.maxPageSize);
                this.auditLog.logMessage("getEnterpriseOMRSRepositoryConnector", OMRSAuditCode.NEW_ENTERPRISE_CONNECTOR.getMessageDefinition(new String[]{callingServiceName}));
                omrsRepositoryConnector.start();
                return omrsRepositoryConnector;
            }
            catch (Throwable error) {
                this.auditLog.logException("getEnterpriseOMRSRepositoryConnector", OMRSAuditCode.ENTERPRISE_CONNECTOR_FAILED.getMessageDefinition(new String[]{callingServiceName, error.getClass().getName(), error.getMessage()}), error);
            }
        }
        return null;
    }

    public OMRSEnterpriseConnectorManager getEnterpriseConnectorManager() {
        return this.enterpriseConnectorManager;
    }

    public OMRSAuditLog getAuditLog(int componentId, String componentName, String componentDescription, String componentWikiURL) {
        return this.auditLog.createNewAuditLog(componentId, componentName, componentDescription, componentWikiURL);
    }

    public void initializeAuditLog(RepositoryServicesConfig repositoryServicesConfig, String serverTypeClassification) {
        String actionDescription = "Initialize Open Metadata Repository Operational Services Audit Log";
        String methodName = "initializeAuditLog";
        if (repositoryServicesConfig == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_CONFIG.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "initializeAuditLog");
        }
        if (repositoryServicesConfig.getAuditLogConnections() == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NO_AUDIT_LOG_DESTINATIONS.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "initializeAuditLog");
        }
        this.auditLogDestination = new OMRSAuditLogDestination(this.localServerName, this.localServerType, this.localOrganizationName, this.getAuditLogStores(repositoryServicesConfig.getAuditLogConnections()));
        this.auditLog = new OMRSAuditLog(this.auditLogDestination, OMRSAuditingComponent.OPERATIONAL_SERVICES);
        this.auditLog.logMessage("Initialize Open Metadata Repository Operational Services Audit Log", OMRSAuditCode.OMRS_AUDIT_LOG_READY.getMessageDefinition(new String[]{serverTypeClassification, this.localServerName}));
    }

    public void initializeCohortMember(RepositoryServicesConfig repositoryServicesConfig) {
        String actionDescription = "Initialize Repository Services for Cohort Member";
        String methodName = "initializeCohortMember";
        if (repositoryServicesConfig == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_CONFIG.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "initializeCohortMember");
        }
        if (this.auditLog == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_AUDIT_LOG.getMessageDefinition(), this.getClass().getName(), "initializeCohortMember");
        }
        this.auditLog.logMessage("Initialize Repository Services for Cohort Member", OMRSAuditCode.OMRS_INITIALIZING.getMessageDefinition());
        EnterpriseAccessConfig enterpriseAccessConfig = repositoryServicesConfig.getEnterpriseAccessConfig();
        LocalRepositoryConfig localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
        List cohortConfigList = repositoryServicesConfig.getCohortConfigList();
        this.localRepositoryContentManager = new OMRSRepositoryContentManager(this.localServerUserId, (AuditLog)this.auditLog.createNewAuditLog(OMRSAuditingComponent.REPOSITORY_CONTENT_MANAGER));
        this.enterpriseConnectorManager = this.initializeEnterpriseConnectorManager(enterpriseAccessConfig, this.maxPageSize, this.localRepositoryContentManager);
        this.enterpriseOMRSTopicConnector = this.initializeEnterpriseOMRSTopicConnector(enterpriseAccessConfig);
        this.archiveManager = this.initializeOpenMetadataArchives(repositoryServicesConfig.getOpenMetadataArchiveConnections());
        if (localRepositoryConfig != null) {
            this.localMetadataCollectionId = localRepositoryConfig.getMetadataCollectionId();
            this.localMetadataCollectionName = localRepositoryConfig.getMetadataCollectionName();
            if (this.localMetadataCollectionName == null) {
                this.localMetadataCollectionName = this.localServerName;
            }
            this.auditLog.logMessage("Initialize Repository Services for Cohort Member", OMRSAuditCode.LOCAL_REPOSITORY_INITIALIZING.getMessageDefinition(new String[]{this.localMetadataCollectionName, this.localMetadataCollectionId}));
            this.localRepositoryEventManager = new OMRSRepositoryEventManager("local repository outbound", new OMRSRepositoryEventExchangeRule(localRepositoryConfig.getEventsToSendRule(), localRepositoryConfig.getSelectedTypesToSend()), new OMRSRepositoryContentValidator(this.localRepositoryContentManager), (AuditLog)this.auditLog.createNewAuditLog(OMRSAuditingComponent.REPOSITORY_EVENT_MANAGER));
            if (this.enterpriseOMRSTopicConnector != null) {
                OMRSRepositoryEventPublisher enterpriseEventPublisher = new OMRSRepositoryEventPublisher("Local Repository to Enterprise", this.enterpriseOMRSTopicConnector, (AuditLog)this.auditLog.createNewAuditLog(OMRSAuditingComponent.EVENT_PUBLISHER));
                this.localRepositoryEventManager.registerRepositoryEventProcessor(enterpriseEventPublisher);
            }
            this.auditLogDestination.setLocalMetadataCollectionId(this.localMetadataCollectionId);
            this.localRepositoryConnector = this.initializeLocalRepository(localRepositoryConfig);
            try {
                this.localRepositoryConnector.start();
            }
            catch (Throwable error) {
                this.auditLog.logMessage("Initialize Repository Services for Cohort Member", OMRSAuditCode.LOCAL_REPOSITORY_FAILED_TO_START.getMessageDefinition(new String[]{error.getMessage()}));
            }
        }
        if (this.localRepositoryConnector != null) {
            this.archiveManager.setLocalRepository(this.localRepositoryContentManager, (OMRSInstanceEventProcessorInterface)this.localRepositoryConnector.getIncomingInstanceEventProcessor());
        } else {
            this.archiveManager.setLocalRepository(this.localRepositoryContentManager, null);
        }
        if (this.localRepositoryConnector != null && this.enterpriseConnectorManager != null) {
            this.enterpriseConnectorManager.setLocalConnector(this.localRepositoryConnector.getMetadataCollectionId(), this.localRepositoryConnector);
        }
        if (cohortConfigList != null) {
            this.auditLog.logMessage("Initialize Repository Services for Cohort Member", OMRSAuditCode.METADATA_HIGHWAY_INITIALIZING.getMessageDefinition());
            this.metadataHighwayManager = this.initializeCohorts(this.localServerName, this.localServerType, this.localOrganizationName, this.localRepositoryConnector, this.localRepositoryContentManager, this.enterpriseConnectorManager, this.enterpriseOMRSTopicConnector, cohortConfigList);
        }
        OMRSRepositoryRESTServices.setServerRepositories(this.localServerName, this.auditLog, this.localRepositoryConnector, this.getEnterpriseOMRSRepositoryConnector(OMRSAuditingComponent.REST_SERVICES.getComponentName()), this.metadataHighwayManager, this.localServerURL, (AuditLog)this.auditLog.createNewAuditLog(OMRSAuditingComponent.REST_SERVICES), this.maxPageSize);
        if (this.localRepositoryEventManager != null) {
            this.localRepositoryEventManager.start();
        }
        this.auditLog.logMessage("Initialize Repository Services for Cohort Member", OMRSAuditCode.OMRS_INITIALIZED.getMessageDefinition());
    }

    public void initializeGovernanceServer(RepositoryServicesConfig repositoryServicesConfig) {
        String actionDescription = "Initialize Repository Services for Governance Server";
        String methodName = "initializeGovernanceServer";
        this.initializeSimpleServer(repositoryServicesConfig, "Initialize Repository Services for Governance Server", "initializeGovernanceServer");
    }

    public void initializeEngineHostServer(RepositoryServicesConfig repositoryServicesConfig) {
        String actionDescription = "Initialize Repository Services for Engine Hosting OMAG Server";
        String methodName = "initializeEngineHostServer";
        this.initializeSimpleServer(repositoryServicesConfig, "Initialize Repository Services for Engine Hosting OMAG Server", "initializeEngineHostServer");
    }

    public void initializeViewServer(RepositoryServicesConfig repositoryServicesConfig) {
        String actionDescription = "Initialize Repository Services for View Server";
        String methodName = "initializeViewServer";
        this.initializeSimpleServer(repositoryServicesConfig, "Initialize Repository Services for View Server", "initializeViewServer");
    }

    private void initializeSimpleServer(RepositoryServicesConfig repositoryServicesConfig, String actionDescription, String methodName) {
        if (repositoryServicesConfig == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_CONFIG.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), methodName);
        }
        if (this.auditLog == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_AUDIT_LOG.getMessageDefinition(), this.getClass().getName(), methodName);
        }
        this.auditLog.logMessage(actionDescription, OMRSAuditCode.OMRS_INITIALIZING.getMessageDefinition());
        OMRSRepositoryRESTServices.setServerRepositories(this.localServerName, this.auditLog, null, null, null, null, (AuditLog)this.auditLog.createNewAuditLog(OMRSAuditingComponent.REST_SERVICES), this.maxPageSize);
        this.auditLog.logMessage(actionDescription, OMRSAuditCode.OMRS_INITIALIZED.getMessageDefinition());
    }

    private OMRSTopicConnector initializeEnterpriseOMRSTopicConnector(EnterpriseAccessConfig enterpriseAccessConfig) {
        Connection enterpriseOMRSTopicConnection;
        OMRSTopicConnector enterpriseOMRSTopicConnector = null;
        if (enterpriseAccessConfig != null && (enterpriseOMRSTopicConnection = enterpriseAccessConfig.getEnterpriseOMRSTopicConnection()) != null) {
            enterpriseOMRSTopicConnector = this.getTopicConnector("Enterprise Access", enterpriseOMRSTopicConnection);
        }
        return enterpriseOMRSTopicConnector;
    }

    private OMRSEnterpriseConnectorManager initializeEnterpriseConnectorManager(EnterpriseAccessConfig enterpriseAccessConfig, int maxPageSize, OMRSRepositoryContentManager repositoryContentManager) {
        OMRSEnterpriseConnectorManager enterpriseConnectorManager;
        if (enterpriseAccessConfig == null) {
            enterpriseConnectorManager = new OMRSEnterpriseConnectorManager(false, maxPageSize, repositoryContentManager, (AuditLog)this.auditLog.createNewAuditLog(OMRSAuditingComponent.ENTERPRISE_CONNECTOR_MANAGER), this.localServerUserId, this.localServerPassword);
        } else {
            String actionDescription = "Initialize Repository Operational Services";
            this.auditLog.logMessage("Initialize Repository Operational Services", OMRSAuditCode.ENTERPRISE_ACCESS_INITIALIZING.getMessageDefinition());
            enterpriseConnectorManager = new OMRSEnterpriseConnectorManager(true, maxPageSize, repositoryContentManager, (AuditLog)this.auditLog.createNewAuditLog(OMRSAuditingComponent.ENTERPRISE_CONNECTOR_MANAGER), this.localServerUserId, this.localServerPassword);
            this.enterpriseMetadataCollectionId = enterpriseAccessConfig.getEnterpriseMetadataCollectionId();
            this.enterpriseMetadataCollectionName = enterpriseAccessConfig.getEnterpriseMetadataCollectionName();
        }
        return enterpriseConnectorManager;
    }

    private LocalOMRSRepositoryConnector initializeLocalRepository(LocalRepositoryConfig localRepositoryConfig) {
        LocalOMRSRepositoryConnector localRepositoryConnector = null;
        if (localRepositoryConfig != null) {
            LocalOMRSConnectorProvider localConnectorProvider = new LocalOMRSConnectorProvider(this.localMetadataCollectionId, localRepositoryConfig.getLocalRepositoryMode(), localRepositoryConfig.getLocalRepositoryRemoteConnection(), this.getLocalRepositoryEventMapper(localRepositoryConfig.getEventMapperConnection()), this.localRepositoryEventManager, this.localRepositoryContentManager, new OMRSRepositoryEventExchangeRule(localRepositoryConfig.getEventsToSaveRule(), localRepositoryConfig.getSelectedTypesToSave()));
            Connection localRepositoryConnection = localRepositoryConfig.getLocalRepositoryLocalConnection() != null ? localRepositoryConfig.getLocalRepositoryLocalConnection() : localRepositoryConfig.getLocalRepositoryRemoteConnection();
            localRepositoryConnector = this.getLocalOMRSConnector(localRepositoryConnection, localConnectorProvider);
        }
        return localRepositoryConnector;
    }

    private OMRSArchiveManager initializeOpenMetadataArchives(List<Connection> openMetadataArchiveConnections) {
        ArrayList<OpenMetadataArchiveStoreConnector> openMetadataArchives = null;
        if (openMetadataArchiveConnections != null) {
            openMetadataArchives = new ArrayList<OpenMetadataArchiveStoreConnector>();
            for (Connection archiveConnection : openMetadataArchiveConnections) {
                if (archiveConnection == null) continue;
                openMetadataArchives.add(this.getOpenMetadataArchiveStore(archiveConnection));
            }
        }
        return new OMRSArchiveManager(openMetadataArchives, (AuditLog)this.auditLog.createNewAuditLog(OMRSAuditingComponent.ARCHIVE_MANAGER));
    }

    private OMRSMetadataHighwayManager initializeCohorts(String localServerName, String localServerType, String localOrganizationName, LocalOMRSRepositoryConnector localRepositoryConnector, OMRSRepositoryContentManager localRepositoryContentManager, OMRSConnectionConsumer connectionConsumer, OMRSTopicConnector enterpriseTopicConnector, List<CohortConfig> cohortConfigList) {
        OMRSMetadataHighwayManager metadataHighwayManager = new OMRSMetadataHighwayManager(localServerName, localServerType, localOrganizationName, localRepositoryConnector, localRepositoryContentManager, connectionConsumer, enterpriseTopicConnector, (AuditLog)this.auditLog.createNewAuditLog(OMRSAuditingComponent.METADATA_HIGHWAY_MANAGER));
        metadataHighwayManager.initialize(cohortConfigList);
        return metadataHighwayManager;
    }

    public void setSecurityVerifier(OpenMetadataServerSecurityVerifier securityVerifier) {
        if (securityVerifier != null && this.localRepositoryConnector != null) {
            this.localRepositoryConnector.setSecurityVerifier(securityVerifier);
        }
    }

    public void addOpenMetadataArchive(Connection openMetadataArchiveConnection, String archiveSource) {
        this.archiveManager.addOpenMetadataArchive(this.getOpenMetadataArchiveStore(openMetadataArchiveConnection), archiveSource);
    }

    public boolean disconnect(boolean permanent) {
        String actionDescription = "Disconnect Repository Operational Services";
        this.auditLog.logMessage("Disconnect Repository Operational Services", OMRSAuditCode.OMRS_DISCONNECTING.getMessageDefinition());
        OMRSRepositoryRESTServices.stopInboundRESTCalls(this.localServerName);
        if (this.metadataHighwayManager != null) {
            this.metadataHighwayManager.disconnect(permanent);
        }
        if (this.enterpriseOMRSTopicConnector != null) {
            try {
                this.enterpriseOMRSTopicConnector.disconnect();
            }
            catch (Throwable error) {
                this.auditLog.logMessage("Disconnect Repository Operational Services", OMRSAuditCode.ENTERPRISE_TOPIC_DISCONNECT_ERROR.getMessageDefinition());
            }
        }
        if (this.enterpriseConnectorManager != null) {
            try {
                this.enterpriseConnectorManager.disconnect();
            }
            catch (Throwable error) {
                this.auditLog.logMessage("Disconnect Repository Operational Services", OMRSAuditCode.ENTERPRISE_CONNECTOR_DISCONNECT_ERROR.getMessageDefinition(new String[]{error.getMessage()}));
            }
        }
        if (this.archiveManager != null) {
            this.archiveManager.close();
        }
        this.auditLog.logMessage("Disconnect Repository Operational Services", OMRSAuditCode.OMRS_DISCONNECTED.getMessageDefinition());
        return true;
    }

    private List<OMRSAuditLogStore> getAuditLogStores(List<Connection> auditLogStoreConnections) {
        ArrayList<OMRSAuditLogStore> auditLogStores = new ArrayList<OMRSAuditLogStore>();
        for (Connection auditLogStoreConnection : auditLogStoreConnections) {
            auditLogStores.add(this.getAuditLogStore(auditLogStoreConnection));
        }
        if (auditLogStores.isEmpty()) {
            return null;
        }
        return auditLogStores;
    }

    private OMRSAuditLogStore getAuditLogStore(Connection auditLogStoreConnection) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(auditLogStoreConnection);
            connector.start();
            return (OMRSAuditLogStore)connector;
        }
        catch (Throwable error) {
            String methodName = "getAuditLogStore";
            log.debug("Unable to create audit log store connector: " + error.toString());
            throw new OMRSConfigErrorException(OMRSErrorCode.NULL_AUDIT_LOG_STORE.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), methodName, error);
        }
    }

    private OMRSTopicConnector getTopicConnector(String sourceName, Connection topicConnection) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(topicConnection);
            OMRSTopicConnector topicConnector = (OMRSTopicConnector)connector;
            topicConnector.setAuditLog((AuditLog)this.auditLog.createNewAuditLog(OMRSAuditingComponent.OMRS_TOPIC_CONNECTOR));
            return topicConnector;
        }
        catch (Throwable error) {
            String methodName = "getTopicConnector";
            log.debug("Unable to create topic connector: " + error.toString());
            this.auditLog.logMessage(methodName, OMRSAuditCode.BAD_TOPIC_CONNECTION.getMessageDefinition(new String[]{sourceName, error.getClass().getName(), error.getMessage()}));
            throw new OMRSConfigErrorException(OMRSErrorCode.NULL_TOPIC_CONNECTOR.getMessageDefinition(new String[]{sourceName}), this.getClass().getName(), methodName, error);
        }
    }

    private OpenMetadataArchiveStoreConnector getOpenMetadataArchiveStore(Connection openMetadataArchiveStoreConnection) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(openMetadataArchiveStoreConnection);
            OpenMetadataArchiveStoreConnector archiveStoreConnector = (OpenMetadataArchiveStoreConnector)connector;
            archiveStoreConnector.setAuditLog((AuditLog)this.auditLog.createNewAuditLog(OMRSAuditingComponent.ARCHIVE_STORE_CONNECTOR));
            return archiveStoreConnector;
        }
        catch (Throwable error) {
            String methodName = "getOpenMetadataArchiveStore";
            if (log.isDebugEnabled()) {
                log.debug("Unable to create open metadata archive connector: " + error.toString());
            }
            this.auditLog.logMessage(methodName, OMRSAuditCode.BAD_ARCHIVE_STORE.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage()}));
            throw new OMRSConfigErrorException(OMRSErrorCode.NULL_ARCHIVE_STORE.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), methodName, error);
        }
    }

    private OMRSRepositoryEventMapperConnector getLocalRepositoryEventMapper(Connection localRepositoryEventMapperConnection) {
        if (localRepositoryEventMapperConnection == null) {
            return null;
        }
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(localRepositoryEventMapperConnection);
            OMRSRepositoryEventMapperConnector eventMapperConnector = (OMRSRepositoryEventMapperConnector)connector;
            eventMapperConnector.setAuditLog((AuditLog)this.auditLog.createNewAuditLog(OMRSAuditingComponent.LOCAL_REPOSITORY_EVENT_MAPPER));
            return eventMapperConnector;
        }
        catch (Throwable error) {
            String methodName = "getLocalRepositoryEventMapper";
            log.debug("Unable to create local repository event mapper connector: " + error.toString());
            this.auditLog.logMessage(methodName, OMRSAuditCode.BAD_REAL_LOCAL_EVENT_MAPPER.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage()}));
            throw new OMRSConfigErrorException(OMRSErrorCode.NULL_EVENT_MAPPER.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), methodName, error);
        }
    }

    private LocalOMRSRepositoryConnector getLocalOMRSConnector(Connection connection, LocalOMRSConnectorProvider connectorProvider) {
        String methodName = "getLocalOMRSConnector";
        try {
            LocalOMRSRepositoryConnector localRepositoryConnector = (LocalOMRSRepositoryConnector)connectorProvider.getConnector(connection);
            localRepositoryConnector.setAuditLog(this.auditLog.createNewAuditLog(OMRSAuditingComponent.LOCAL_REPOSITORY_CONNECTOR));
            localRepositoryConnector.setMaxPageSize(this.maxPageSize);
            localRepositoryConnector.setServerName(this.localServerName);
            localRepositoryConnector.setServerType(this.localServerType);
            localRepositoryConnector.setServerUserId(this.localServerUserId);
            localRepositoryConnector.setOrganizationName(this.localOrganizationName);
            localRepositoryConnector.setRepositoryHelper(new OMRSRepositoryContentHelper(this.localRepositoryContentManager));
            localRepositoryConnector.setRepositoryValidator(new OMRSRepositoryContentValidator(this.localRepositoryContentManager));
            localRepositoryConnector.setMetadataCollectionName(this.localMetadataCollectionName);
            localRepositoryConnector.setMetadataCollectionId(this.localMetadataCollectionId);
            return localRepositoryConnector;
        }
        catch (Throwable error) {
            String connectionName = connection.getQualifiedName();
            this.auditLog.logException(methodName, OMRSAuditCode.BAD_REAL_LOCAL_REPOSITORY_CONNECTOR.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage()}), error);
            throw new OMRSConfigErrorException(OMRSErrorCode.INVALID_OMRS_CONNECTION.getMessageDefinition(new String[]{connectionName}), this.getClass().getName(), methodName, error);
        }
    }
}

