/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GetEntityExecutor
extends RepositoryExecutorBase {
    private String entityGUID;
    private boolean allExceptions = true;
    private Date asOfTime = null;
    private boolean inPhaseOne = true;
    private EntityDetail latestEntity = null;
    private Map<String, Classification> homeClassifications = new HashMap<String, Classification>();
    private MaintenanceAccumulator accumulator = new MaintenanceAccumulator();

    public GetEntityExecutor(String userId, String entityGUID, boolean allExceptions, String methodName) {
        super(userId, methodName);
        this.entityGUID = entityGUID;
        this.allExceptions = allExceptions;
    }

    public GetEntityExecutor(String userId, String entityGUID, Date asOfTime, String methodName) {
        super(userId, methodName);
        this.entityGUID = entityGUID;
        this.asOfTime = asOfTime;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            if (this.inPhaseOne) {
                EntityDetail retrievedEntity = this.asOfTime == null ? (this.allExceptions ? metadataCollection.getEntityDetail(this.userId, this.entityGUID) : metadataCollection.isEntityKnown(this.userId, this.entityGUID)) : metadataCollection.getEntityDetail(this.userId, this.entityGUID, this.asOfTime);
                if (retrievedEntity != null) {
                    if (retrievedEntity.getClassifications() != null) {
                        for (Classification entityClassification : retrievedEntity.getClassifications()) {
                            if (entityClassification == null || !metadataCollectionId.equals(entityClassification.getMetadataCollectionId())) continue;
                            this.homeClassifications.put(entityClassification.getName(), entityClassification);
                        }
                    }
                    if (metadataCollectionId.equals(retrievedEntity.getMetadataCollectionId())) {
                        this.latestEntity = retrievedEntity;
                        this.inPhaseOne = false;
                    } else if (this.latestEntity == null) {
                        this.latestEntity = retrievedEntity;
                    } else if (retrievedEntity.getVersion() > this.latestEntity.getVersion()) {
                        this.latestEntity = retrievedEntity;
                    }
                }
            } else {
                List homeClassifications = this.asOfTime == null ? metadataCollection.getHomeClassifications(this.userId, this.entityGUID) : metadataCollection.getHomeClassifications(this.userId, this.entityGUID, this.asOfTime);
                if (homeClassifications != null) {
                    for (Classification homeClassification : homeClassifications) {
                        if (homeClassification == null) continue;
                        this.homeClassifications.put(homeClassification.getName(), homeClassification);
                    }
                }
            }
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityProxyOnlyException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Throwable error) {
            this.accumulator.captureGenericException(error);
        }
        return false;
    }

    public EntityDetail isEntityKnown() throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        if (this.latestEntity != null) {
            if (this.homeClassifications.isEmpty()) {
                this.latestEntity.setClassifications(null);
            } else {
                this.latestEntity.setClassifications(new ArrayList<Classification>(this.homeClassifications.values()));
            }
            return this.latestEntity;
        }
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedInvalidParameterException();
        return null;
    }

    public EntityDetail getEntityDetail() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        EntityDetail entity = this.isEntityKnown();
        if (entity != null) {
            return entity;
        }
        this.accumulator.throwCapturedEntityProxyOnlyException();
        this.accumulator.throwCapturedEntityNotKnownException();
        return null;
    }

    public EntityDetail getEntityDetailHistory() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        EntityDetail entity = this.getEntityDetail();
        if (entity != null) {
            return entity;
        }
        this.accumulator.throwCapturedFunctionNotSupportedException();
        return null;
    }
}

