/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector;

import java.util.UUID;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.MessageDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventProcessor;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventExchangeRule;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.OMRSInstanceRetrievalEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalOMRSInstanceEventProcessor
extends OMRSInstanceEventProcessor
implements OMRSInstanceRetrievalEventProcessor {
    private static final String localOMRSInstanceEventProcessorName = "Local Repository Inbound Instance Events";
    private static final MessageFormatter messageFormatter = new MessageFormatter();
    private String localMetadataCollectionId;
    private String localServerName;
    private OMRSRepositoryConnector localRepositoryConnector;
    private OMRSRepositoryHelper repositoryHelper;
    private OMRSRepositoryValidator repositoryValidator;
    private OMRSRepositoryEventExchangeRule saveExchangeRule;
    private OMRSMetadataCollection localMetadataCollection = null;
    private OMRSRepositoryEventProcessor outboundRepositoryEventProcessor;
    private AuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(LocalOMRSInstanceEventProcessor.class);

    LocalOMRSInstanceEventProcessor(String localMetadataCollectionId, String localServerName, OMRSRepositoryConnector localConnector, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, OMRSRepositoryEventExchangeRule saveExchangeRule, OMRSRepositoryEventProcessor outboundRepositoryEventProcessor, AuditLog auditLog) {
        super(localOMRSInstanceEventProcessorName);
        String methodName = "LocalOMRSInstanceEventProcessor constructor";
        this.localMetadataCollectionId = localMetadataCollectionId;
        this.localServerName = localServerName;
        this.localRepositoryConnector = localConnector;
        this.repositoryHelper = repositoryHelper;
        this.repositoryValidator = repositoryValidator;
        this.saveExchangeRule = saveExchangeRule;
        this.outboundRepositoryEventProcessor = outboundRepositoryEventProcessor;
        this.auditLog = auditLog;
        if (localConnector != null) {
            try {
                this.localMetadataCollection = localConnector.getMetadataCollection();
            }
            catch (Throwable error) {
                this.localMetadataCollection = null;
            }
        }
        this.verifyEventProcessor("LocalOMRSInstanceEventProcessor constructor");
    }

    private void logIncomingEvent(OMRSInstanceEventType instanceEventType, InstanceHeader instanceHeader, OMRSEventOriginator instanceEventOriginator, OMRSInstanceEvent instanceEvent, String methodName) {
        String instanceGUID = "<unknown GUID>";
        if (instanceHeader != null) {
            instanceGUID = instanceHeader.getGUID();
        }
        this.logIncomingEvent(instanceEventType, instanceGUID, instanceEventOriginator, instanceEvent, methodName);
    }

    private void logIncomingEvent(OMRSInstanceEventType instanceEventType, String instanceGUID, OMRSEventOriginator instanceEventOriginator, OMRSInstanceEvent instanceEvent, String methodName) {
        this.auditLog.logMessage(methodName, OMRSAuditCode.PROCESS_INCOMING_EVENT.getMessageDefinition(new String[]{instanceEventType.getName(), instanceGUID, instanceEventOriginator.toString()}), instanceEvent.toString());
    }

    public void sendInstanceEvent(String cohortName, OMRSInstanceEvent instanceEvent) {
        String methodName = "sendInstanceEvent";
        OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
        OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
        if (instanceEventType != null && instanceEventOriginator != null) {
            block0 : switch (instanceEventType) {
                case NEW_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processNewEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case UPDATED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processUpdatedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalEntity(), instanceEvent.getEntity());
                    break;
                }
                case CLASSIFIED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processClassifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity(), instanceEvent.getClassification());
                    break;
                }
                case RECLASSIFIED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processReclassifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity(), instanceEvent.getOriginalClassification(), instanceEvent.getClassification());
                    break;
                }
                case DECLASSIFIED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processDeclassifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity(), instanceEvent.getOriginalClassification());
                    break;
                }
                case DELETED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processDeletedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case PURGED_ENTITY_EVENT: {
                    if (instanceEvent.getEntity() == null) {
                        this.logIncomingEvent(instanceEventType, instanceEvent.getInstanceGUID(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                        this.processPurgedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID());
                        break;
                    }
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processPurgedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case DELETE_PURGED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processDeletePurgedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case UNDONE_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processUndoneEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case RESTORED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processRestoredEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case REFRESH_ENTITY_REQUEST: {
                    this.logIncomingEvent(instanceEventType, instanceEvent.getInstanceGUID(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processRefreshEntityRequested(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID(), instanceEvent.getHomeMetadataCollectionId());
                    break;
                }
                case REFRESHED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processRefreshEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case RE_HOMED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processReHomedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalHomeMetadataCollectionId(), instanceEvent.getEntity());
                    break;
                }
                case RETYPED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processReTypedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalTypeDefSummary(), instanceEvent.getEntity());
                    break;
                }
                case RE_IDENTIFIED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processReIdentifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalInstanceGUID(), instanceEvent.getEntity());
                    break;
                }
                case NEW_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processNewRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case UPDATED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processUpdatedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalRelationship(), instanceEvent.getRelationship());
                    break;
                }
                case UNDONE_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processUndoneRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case DELETED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processDeletedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case PURGED_RELATIONSHIP_EVENT: {
                    if (instanceEvent.getRelationship() == null) {
                        this.logIncomingEvent(instanceEventType, instanceEvent.getInstanceGUID(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                        this.processPurgedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID());
                        break;
                    }
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processPurgedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case DELETE_PURGED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processDeletePurgedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case RESTORED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processRestoredRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case REFRESH_RELATIONSHIP_REQUEST: {
                    this.logIncomingEvent(instanceEventType, instanceEvent.getInstanceGUID(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processRefreshRelationshipRequest(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID(), instanceEvent.getHomeMetadataCollectionId());
                    break;
                }
                case REFRESHED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processRefreshRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case RE_IDENTIFIED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processReIdentifiedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalInstanceGUID(), instanceEvent.getRelationship());
                    break;
                }
                case RE_HOMED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processReHomedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalHomeMetadataCollectionId(), instanceEvent.getRelationship());
                    break;
                }
                case RETYPED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processReTypedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalTypeDefSummary(), instanceEvent.getRelationship());
                    break;
                }
                case BATCH_INSTANCES_EVENT: {
                    this.logIncomingEvent(instanceEventType, "<multiple>", instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                    this.processInstanceBatchEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getInstanceBatch());
                    break;
                }
                case INSTANCE_ERROR_EVENT: {
                    OMRSInstanceEventErrorCode errorCode = instanceEvent.getErrorCode();
                    if (errorCode != null) {
                        switch (errorCode) {
                            case CONFLICTING_INSTANCES: {
                                this.logIncomingEvent(instanceEventType, instanceEvent.getTargetInstanceGUID(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                                this.processConflictingInstancesEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTargetMetadataCollectionId(), instanceEvent.getTargetTypeDefSummary(), instanceEvent.getTargetInstanceGUID(), instanceEvent.getOtherMetadataCollectionId(), instanceEvent.getOtherOrigin(), instanceEvent.getOtherTypeDefSummary(), instanceEvent.getOtherInstanceGUID(), instanceEvent.getErrorMessage());
                                break block0;
                            }
                            case CONFLICTING_TYPE: {
                                this.logIncomingEvent(instanceEventType, instanceEvent.getTargetInstanceGUID(), instanceEventOriginator, instanceEvent, "sendInstanceEvent");
                                this.processConflictingTypeEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTargetMetadataCollectionId(), instanceEvent.getTargetTypeDefSummary(), instanceEvent.getTargetInstanceGUID(), instanceEvent.getOtherTypeDefSummary(), instanceEvent.getErrorMessage());
                                break block0;
                            }
                        }
                        log.debug("Unknown instance event error code, ignoring event");
                        break;
                    }
                    log.debug("Ignored Instance event, null error code");
                    break;
                }
                default: {
                    log.debug("Ignored Instance event, unknown type");
                    break;
                }
            }
        } else {
            log.debug("Ignored instance event, null type");
        }
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processNewEntityEvent";
        this.updateReferenceEntity(sourceName, "processNewEntityEvent", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        String methodName = "processUpdatedEntityEvent";
        this.updateReferenceEntity(sourceName, "processUpdatedEntityEvent", originatorMetadataCollectionId, originatorServerName, newEntity);
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processUndoneEntityEvent";
        this.updateReferenceEntity(sourceName, "processUndoneEntityEvent", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent";
        try {
            this.verifyEventProcessor("processClassifiedEntityEvent");
            this.localMetadataCollection.saveClassificationReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity, classification);
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, "processClassifiedEntityEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent";
        try {
            this.verifyEventProcessor("processDeclassifiedEntityEvent");
            this.localMetadataCollection.purgeClassificationReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity, originalClassification);
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, "processDeclassifiedEntityEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        try {
            this.verifyEventProcessor("processReclassifiedEntityEvent");
            this.localMetadataCollection.saveClassificationReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity, classification);
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, "processReclassifiedEntityEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletedEntityEvent";
        try {
            this.verifyEventProcessor("processDeletedEntityEvent");
            this.localMetadataCollection.deleteEntityReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity);
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, "processDeletedEntityEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processPurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processPurgedEntityEvent";
        try {
            this.verifyEventProcessor("processPurgedEntityEvent");
            this.localMetadataCollection.purgeEntityReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity);
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, "processPurgedEntityEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processPurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        String methodName = "processPurgedEntityEvent";
        try {
            this.verifyEventProcessor("processPurgedEntityEvent");
            this.localMetadataCollection.purgeEntityReferenceCopy(this.localRepositoryConnector.getServerUserId(), instanceGUID, typeDefGUID, typeDefName, originatorMetadataCollectionId);
        }
        catch (EntityNotKnownException entityNotKnownException) {
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, "processPurgedEntityEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRestoredEntityEvent";
        this.updateReferenceEntity(sourceName, "processRestoredEntityEvent", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        String methodName = "processReIdentifiedEntityEvent";
        this.updateReferenceEntity(sourceName, "processReIdentifiedEntityEvent", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        String methodName = "processReTypedEntityEvent";
        this.updateReferenceEntity(sourceName, "processReTypedEntityEvent", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        String methodName = "processReHomedEntityEvent";
        this.updateReferenceEntity(sourceName, "processReHomedEntityEvent", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processRefreshEntityRequested(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
        String methodName = "processRefreshEntityRequested";
        try {
            EntityDetail entity;
            this.verifyEventProcessor("processRefreshEntityRequested");
            if (this.localMetadataCollectionId.equals(homeMetadataCollectionId) && (entity = this.localMetadataCollection.isEntityKnown(this.localRepositoryConnector.getServerUserId(), instanceGUID)) != null) {
                this.outboundRepositoryEventProcessor.processRefreshEntityEvent(this.localRepositoryConnector.getRepositoryName(), this.localMetadataCollectionId, this.localRepositoryConnector.getServerName(), this.localRepositoryConnector.getServerType(), this.localRepositoryConnector.getOrganizationName(), entity);
            }
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, "processRefreshEntityRequested", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRefreshEntityEvent";
        this.updateReferenceEntity(sourceName, "processRefreshEntityEvent", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processNewRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processNewRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        String methodName = "processUpdatedRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processUpdatedRelationshipEvent", originatorMetadataCollectionId, originatorServerName, newRelationship);
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processUndoneRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processUndoneRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletedRelationshipEvent";
        try {
            this.verifyEventProcessor("processDeletedRelationshipEvent");
            this.localMetadataCollection.deleteRelationshipReferenceCopy(this.localRepositoryConnector.getServerUserId(), relationship);
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, "processDeletedRelationshipEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processPurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processPurgedRelationshipEvent";
        try {
            this.verifyEventProcessor("processPurgedRelationshipEvent");
            this.localMetadataCollection.purgeRelationshipReferenceCopy(this.localRepositoryConnector.getServerUserId(), relationship);
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, "processPurgedRelationshipEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processPurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        String methodName = "processPurgedRelationshipEvent";
        try {
            this.verifyEventProcessor("processPurgedRelationshipEvent");
            this.localMetadataCollection.purgeRelationshipReferenceCopy(this.localRepositoryConnector.getServerUserId(), instanceGUID, typeDefGUID, typeDefName, originatorMetadataCollectionId);
        }
        catch (RelationshipNotKnownException relationshipNotKnownException) {
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, "processPurgedRelationshipEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRestoredRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processRestoredRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        String methodName = "processReIdentifiedRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processReIdentifiedRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        String methodName = "processReTypedRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processReTypedRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        String methodName = "processReHomedRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processReHomedRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processRefreshRelationshipRequest(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
        String methodName = "processRefreshRelationshipRequest";
        try {
            Relationship relationship;
            this.verifyEventProcessor("processRefreshRelationshipRequest");
            if (this.localMetadataCollectionId.equals(homeMetadataCollectionId) && (relationship = this.localMetadataCollection.isRelationshipKnown(this.localRepositoryConnector.getServerUserId(), instanceGUID)) != null) {
                this.outboundRepositoryEventProcessor.processRefreshRelationshipEvent(this.localRepositoryConnector.getRepositoryName(), this.localMetadataCollectionId, this.localRepositoryConnector.getServerName(), this.localRepositoryConnector.getServerType(), this.localRepositoryConnector.getOrganizationName(), relationship);
            }
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, "processRefreshRelationshipRequest", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRefreshRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processRefreshRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processInstanceBatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, InstanceGraph instances) {
        String methodName = "processInstanceBatchEvent";
        try {
            this.verifyEventProcessor("processInstanceBatchEvent");
            this.localMetadataCollection.saveInstanceReferenceCopies(this.localRepositoryConnector.getServerUserId(), instances);
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, "processInstanceBatchEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processConflictingInstancesEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, String otherMetadataCollectionId, InstanceProvenanceType otherOrigin, TypeDefSummary otherTypeDefSummary, String otherInstanceGUID, String errorMessage) {
        String methodName = "processConflictingInstancesEvent";
        this.auditLog.logMessage("processConflictingInstancesEvent", OMRSAuditCode.DUPLICATE_INSTANCES_FOR_GUID.getMessageDefinition(new String[]{originatorServerName, originatorMetadataCollectionId, otherInstanceGUID, otherMetadataCollectionId, otherTypeDefSummary.toString(), otherOrigin.getName(), targetMetadataCollectionId, targetTypeDefSummary.toString(), errorMessage}), sourceName);
        if (this.localMetadataCollectionId.equals(targetMetadataCollectionId)) {
            try {
                String newGUID = UUID.randomUUID().toString();
                if (targetTypeDefSummary.getCategory() == TypeDefCategory.ENTITY_DEF) {
                    this.localMetadataCollection.reIdentifyEntity(this.localRepositoryConnector.getServerUserId(), targetTypeDefSummary.getGUID(), targetTypeDefSummary.getName(), targetInstanceGUID, newGUID);
                } else {
                    this.localMetadataCollection.reIdentifyRelationship(this.localRepositoryConnector.getServerUserId(), targetTypeDefSummary.getGUID(), targetTypeDefSummary.getName(), targetInstanceGUID, newGUID);
                }
                this.auditLog.logMessage("processConflictingInstancesEvent", OMRSAuditCode.INSTANCE_SUCCESSFULLY_REIDENTIFIED.getMessageDefinition(new String[]{this.localServerName, this.localMetadataCollectionId, otherTypeDefSummary.getName(), targetInstanceGUID, newGUID}));
            }
            catch (Throwable error) {
                this.auditLog.logMessage("processConflictingInstancesEvent", OMRSAuditCode.UNABLE_TO_RE_IDENTIFY_INSTANCE.getMessageDefinition(new String[]{this.localServerName, this.localMetadataCollectionId, otherTypeDefSummary.getName(), targetInstanceGUID, error.getClass().getName(), error.getMessage()}));
            }
        } else {
            this.removeReferenceCopyOfInstance(targetTypeDefSummary, targetInstanceGUID, targetMetadataCollectionId, "processConflictingInstancesEvent");
        }
    }

    public void processConflictingTypeEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, TypeDefSummary otherTypeDefSummary, String errorMessage) {
        String methodName = "processConflictingTypeEvent";
        if (this.localMetadataCollectionId.equals(targetMetadataCollectionId)) {
            this.auditLog.logMessage("processConflictingTypeEvent", OMRSAuditCode.LOCAL_INSTANCE_WITH_CONFLICTING_TYPES.getMessageDefinition(new String[]{originatorServerName, originatorMetadataCollectionId, targetInstanceGUID, otherTypeDefSummary.toString(), targetMetadataCollectionId, targetTypeDefSummary.toString(), errorMessage}));
        } else {
            this.auditLog.logMessage("processConflictingTypeEvent", OMRSAuditCode.INSTANCES_WITH_CONFLICTING_TYPES.getMessageDefinition(new String[]{originatorServerName, originatorMetadataCollectionId, targetInstanceGUID, otherTypeDefSummary.toString(), targetMetadataCollectionId, targetTypeDefSummary.toString(), errorMessage}));
            this.removeReferenceCopyOfInstance(targetTypeDefSummary, targetInstanceGUID, targetMetadataCollectionId, "processConflictingTypeEvent");
        }
    }

    private void refreshRetrievedEntity(String sourceName, String metadataCollectionId, String processedEntityGUID, InstanceType processedEntityType) {
        try {
            if (this.localMetadataCollection.isEntityKnown(this.localRepositoryConnector.getServerUserId(), processedEntityGUID) == null && processedEntityType != null) {
                this.localMetadataCollection.refreshEntityReferenceCopy(this.localRepositoryConnector.getServerUserId(), processedEntityGUID, processedEntityType.getTypeDefGUID(), processedEntityType.getTypeDefName(), metadataCollectionId);
            }
        }
        catch (Throwable error) {
            String methodName = "processRetrievedEntity";
            this.handleUnexpectedErrorFromEvent(error, "processRetrievedEntity", sourceName, metadataCollectionId);
        }
    }

    private void refreshRetrievedRelationship(String sourceName, String metadataCollectionId, String processedRelationshipGUID, InstanceType processedRelationshipType) {
        try {
            if (this.localMetadataCollection.isRelationshipKnown(this.localRepositoryConnector.getServerUserId(), processedRelationshipGUID) == null && processedRelationshipType != null) {
                this.localMetadataCollection.refreshRelationshipReferenceCopy(this.localRepositoryConnector.getServerUserId(), processedRelationshipGUID, processedRelationshipType.getTypeDefGUID(), processedRelationshipType.getTypeDefName(), metadataCollectionId);
            }
        }
        catch (Throwable error) {
            String methodName = "processRetrievedRelationship";
            this.handleUnexpectedErrorFromEvent(error, "processRetrievedRelationship", sourceName, metadataCollectionId);
        }
    }

    @Override
    public void processRetrievedEntitySummary(String sourceName, String metadataCollectionId, EntitySummary processedEntity) {
        if (this.verifyWhetherToRequestRefresh(sourceName, (InstanceHeader)processedEntity)) {
            this.refreshRetrievedEntity(sourceName, processedEntity.getMetadataCollectionId(), processedEntity.getGUID(), processedEntity.getType());
        }
    }

    @Override
    public void processRetrievedEntityDetail(String sourceName, String metadataCollectionId, EntityDetail processedEntity) {
        if (this.verifyWhetherToRequestRefresh(sourceName, (InstanceHeader)processedEntity)) {
            this.refreshRetrievedEntity(sourceName, processedEntity.getMetadataCollectionId(), processedEntity.getGUID(), processedEntity.getType());
        }
    }

    @Override
    public void processRetrievedRelationship(String sourceName, String metadataCollectionId, Relationship processedRelationship) {
        if (this.verifyWhetherToRequestRefresh(sourceName, (InstanceHeader)processedRelationship)) {
            this.refreshRetrievedRelationship(sourceName, processedRelationship.getMetadataCollectionId(), processedRelationship.getGUID(), processedRelationship.getType());
        }
    }

    private void removeReferenceCopyOfInstance(TypeDefSummary typeDefSummary, String instanceGUID, String homeMetadataCollectionId, String methodName) {
        try {
            if (typeDefSummary.getCategory() == TypeDefCategory.ENTITY_DEF) {
                this.localMetadataCollection.purgeEntityReferenceCopy(this.localRepositoryConnector.getServerUserId(), instanceGUID, typeDefSummary.getGUID(), typeDefSummary.getName(), homeMetadataCollectionId);
            } else {
                this.localMetadataCollection.purgeEntityReferenceCopy(this.localRepositoryConnector.getServerUserId(), instanceGUID, typeDefSummary.getGUID(), typeDefSummary.getName(), homeMetadataCollectionId);
            }
        }
        catch (Throwable error) {
            this.auditLog.logMessage(methodName, OMRSAuditCode.UNABLE_TO_REMOVE_REFERENCE_COPY.getMessageDefinition(new String[]{this.localServerName, this.localMetadataCollectionId, typeDefSummary.getName(), instanceGUID, error.getClass().getName(), error.getMessage()}), error.toString());
        }
    }

    private void updateReferenceEntity(String sourceName, String methodName, String originatorMetadataCollectionId, String originatorServerName, EntityDetail entity) {
        try {
            String entityParameterName = "entity";
            this.verifyEventProcessor(methodName);
            this.repositoryValidator.validateReferenceInstanceHeader(sourceName, this.localMetadataCollectionId, "entity", (InstanceHeader)entity, methodName);
            EntityDetail storedEntity = this.localMetadataCollection.isEntityKnown(this.localRepositoryConnector.getServerUserId(), entity.getGUID());
            if (this.compareAndValidateReferenceInstance(originatorServerName, (InstanceHeader)entity, (InstanceHeader)storedEntity, methodName) && this.verifyEventToSave(sourceName, (InstanceHeader)entity)) {
                this.localMetadataCollection.saveEntityReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity);
            }
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, methodName, originatorServerName, originatorMetadataCollectionId);
        }
    }

    private boolean compareAndValidateReferenceInstance(String originatorServerName, InstanceHeader incomingInstance, InstanceHeader storedInstance, String methodName) {
        if (storedInstance == null) {
            return true;
        }
        InstanceType storedInstanceType = storedInstance.getType();
        InstanceType incomingInstanceType = incomingInstance.getType();
        if (storedInstanceType != null && incomingInstanceType != null) {
            if (incomingInstance.getCreateTime().equals(storedInstance.getCreateTime())) {
                if (storedInstance.getVersion() < incomingInstance.getVersion()) {
                    if (storedInstanceType.getTypeDefVersion() <= incomingInstanceType.getTypeDefVersion()) {
                        if (!incomingInstance.getMetadataCollectionId().equals(storedInstance.getMetadataCollectionId())) {
                            this.auditLog.logMessage(methodName, OMRSAuditCode.NEW_HOME_INFORMATION.getMessageDefinition(new String[]{Long.toString(incomingInstance.getVersion()), incomingInstance.getGUID(), originatorServerName, incomingInstance.getMetadataCollectionId(), storedInstance.getMetadataCollectionId()}), incomingInstance.toString());
                        }
                        if (!incomingInstanceType.getTypeDefName().equals(storedInstanceType.getTypeDefName())) {
                            this.auditLog.logMessage(methodName, OMRSAuditCode.NEW_TYPE_INFORMATION.getMessageDefinition(new String[]{Long.toString(incomingInstance.getVersion()), incomingInstance.getGUID(), originatorServerName, incomingInstance.getMetadataCollectionId(), incomingInstanceType.getTypeDefName(), incomingInstanceType.getTypeDefGUID(), storedInstanceType.getTypeDefName(), storedInstanceType.getTypeDefGUID()}), incomingInstance.toString());
                        }
                        return true;
                    }
                    try {
                        AuditLogMessageDefinition messageDefinition = OMRSAuditCode.PROCESS_INSTANCE_TYPE_CONFLICT.getMessageDefinition(new String[]{storedInstance.getGUID(), originatorServerName, storedInstance.getMetadataCollectionId(), storedInstanceType.getTypeDefName(), storedInstanceType.toString(), incomingInstanceType.toString()});
                        this.outboundRepositoryEventProcessor.processConflictingTypeEvent(this.localServerName, this.localMetadataCollectionId, this.localRepositoryConnector.getServerName(), this.localRepositoryConnector.getServerType(), this.localRepositoryConnector.getOrganizationName(), incomingInstance.getMetadataCollectionId(), (TypeDefSummary)this.repositoryHelper.getTypeDef(this.localServerName, "incomingInstanceType", incomingInstanceType.getTypeDefGUID(), methodName), incomingInstance.getGUID(), (TypeDefSummary)this.repositoryHelper.getTypeDef(this.localServerName, "storedInstanceType", storedInstanceType.getTypeDefGUID(), methodName), messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition));
                    }
                    catch (Throwable error) {
                        String localMethodName = "compareAndValidateReferenceInstance";
                        this.handleUnexpectedErrorFromEvent(error, "compareAndValidateReferenceInstance", originatorServerName, incomingInstance.getMetadataCollectionId());
                    }
                }
            } else {
                try {
                    AuditLogMessageDefinition messageDefinition = OMRSAuditCode.PROCESS_INSTANCE_GUID_CONFLICT.getMessageDefinition(new String[]{incomingInstanceType.getTypeDefName(), incomingInstanceType.getTypeDefName(), originatorServerName, incomingInstance.getMetadataCollectionId(), storedInstance.getGUID(), storedInstanceType.getTypeDefName(), storedInstanceType.getTypeDefGUID()});
                    this.outboundRepositoryEventProcessor.processConflictingInstancesEvent(this.localServerName, this.localMetadataCollectionId, this.localRepositoryConnector.getServerName(), this.localRepositoryConnector.getServerType(), this.localRepositoryConnector.getOrganizationName(), incomingInstance.getMetadataCollectionId(), (TypeDefSummary)this.repositoryHelper.getTypeDef(this.localServerName, "incomingInstanceType", incomingInstanceType.getTypeDefGUID(), methodName), incomingInstance.getGUID(), this.localMetadataCollectionId, storedInstance.getInstanceProvenanceType(), (TypeDefSummary)this.repositoryHelper.getTypeDef(this.localServerName, "storedInstanceType", storedInstanceType.getTypeDefGUID(), methodName), storedInstance.getGUID(), messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition));
                }
                catch (Throwable error) {
                    String localMethodName = "compareAndValidateReferenceInstance";
                    this.handleUnexpectedErrorFromEvent(error, "compareAndValidateReferenceInstance", originatorServerName, incomingInstance.getMetadataCollectionId());
                }
            }
        }
        return false;
    }

    private void updateReferenceRelationship(String sourceName, String methodName, String originatorMetadataCollectionId, String originatorServerName, Relationship relationship) {
        try {
            String relationshipParameterName = "relationship";
            this.verifyEventProcessor(methodName);
            this.repositoryValidator.validateReferenceInstanceHeader(sourceName, this.localMetadataCollectionId, "relationship", (InstanceHeader)relationship, methodName);
            if (this.verifyEventToSave(sourceName, (InstanceHeader)relationship)) {
                this.localMetadataCollection.saveRelationshipReferenceCopy(this.localRepositoryConnector.getServerUserId(), relationship);
            }
        }
        catch (Throwable error) {
            this.handleUnexpectedErrorFromEvent(error, methodName, originatorServerName, originatorMetadataCollectionId);
        }
    }

    private void verifyEventProcessor(String methodName) {
        if (this.localMetadataCollectionId == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_LOCAL_METADATA_COLLECTION.getMessageDefinition(), this.getClass().getName(), methodName);
        }
        if (this.localRepositoryConnector == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NO_LOCAL_REPOSITORY.getMessageDefinition(new String[]{methodName}), this.getClass().getName(), methodName);
        }
        if (this.repositoryHelper == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_REPOSITORY_HELPER.getMessageDefinition(), this.getClass().getName(), methodName);
        }
        if (this.repositoryValidator == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_REPOSITORY_VALIDATOR.getMessageDefinition(), this.getClass().getName(), methodName);
        }
        if (this.saveExchangeRule == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_EXCHANGE_RULE.getMessageDefinition(new String[]{methodName}), this.getClass().getName(), methodName);
        }
        if (this.localMetadataCollection == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_METADATA_COLLECTION.getMessageDefinition(), this.getClass().getName(), methodName);
        }
    }

    private void handleUnexpectedErrorFromEvent(Throwable error, String methodName, String originatorServerName, String originatorMetadataCollectionId) {
        this.auditLog.logException(methodName, OMRSAuditCode.UNEXPECTED_EXCEPTION_FROM_EVENT.getMessageDefinition(new String[]{methodName, originatorServerName, originatorMetadataCollectionId, error.getClass().getName(), error.getMessage()}), error);
    }

    private boolean verifyEventToSave(String source, InstanceHeader instance) {
        InstanceType instanceType = instance.getType();
        return this.saveExchangeRule.processInstanceEvent(instance) && this.repositoryValidator.isActiveType(source, instanceType.getTypeDefGUID(), instanceType.getTypeDefName());
    }

    private boolean verifyEventToLearn(String source, InstanceHeader instance) {
        InstanceType instanceType = instance.getType();
        return this.saveExchangeRule.learnInstanceEvent(instance) && this.repositoryValidator.isActiveType(source, instanceType.getTypeDefGUID(), instanceType.getTypeDefName());
    }

    private boolean verifyWhetherToRequestRefresh(String source, InstanceHeader instance) {
        boolean isActiveType;
        InstanceType instanceType = instance.getType();
        this.saveExchangeRule.learnInstanceEvent(instance);
        boolean shouldProcess = this.saveExchangeRule.processInstanceEvent(instance);
        return shouldProcess && (isActiveType = this.repositoryValidator.isActiveType(source, instanceType.getTypeDefGUID(), instanceType.getTypeDefName()));
    }
}

