/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.server;

import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.metadatahighway.OMRSMetadataHighwayManager;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortMembershipListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortMembershipResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;
import org.odpi.openmetadata.repositoryservices.rest.server.OMRSRESTExceptionHandler;
import org.odpi.openmetadata.repositoryservices.rest.services.OMRSRepositoryServicesInstance;
import org.odpi.openmetadata.repositoryservices.rest.services.OMRSRepositoryServicesInstanceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSMetadataHighwayRESTServices {
    private static final String serviceName = CommonServicesDescription.REPOSITORY_SERVICES.getServiceName();
    private static final OMRSRepositoryServicesInstanceHandler instanceHandler = new OMRSRepositoryServicesInstanceHandler(serviceName);
    private static final OMRSRESTExceptionHandler exceptionHandler = new OMRSRESTExceptionHandler(instanceHandler);
    private static final Logger log = LoggerFactory.getLogger(OMRSMetadataHighwayRESTServices.class);

    public CohortListResponse getCohortList(String serverName, String userId) {
        String methodName = "getCohortList";
        log.debug("Calling method: getCohortList");
        CohortListResponse response = new CohortListResponse();
        try {
            OMRSMetadataHighwayManager metadataHighwayManager = this.getMetadataHighway(userId, serverName, "getCohortList");
            response.setCohorts(metadataHighwayManager.getCohortDescriptions());
        }
        catch (InvalidParameterException error) {
            exceptionHandler.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            exceptionHandler.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            exceptionHandler.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            exceptionHandler.captureThrowable((OMRSAPIResponse)response, error, userId, serverName, "getCohortList");
        }
        log.debug("Returning from method: getCohortList with response: " + response.toString());
        return response;
    }

    public CohortMembershipResponse getLocalRegistration(String serverName, String userId) {
        String methodName = "getLocalRegistration";
        log.debug("Calling method: getLocalRegistration");
        CohortMembershipResponse response = new CohortMembershipResponse();
        try {
            OMRSMetadataHighwayManager metadataHighwayManager = this.getMetadataHighway(userId, serverName, "getLocalRegistration");
            response.setCohortMember(metadataHighwayManager.getLocalRegistration());
        }
        catch (InvalidParameterException error) {
            exceptionHandler.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            exceptionHandler.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            exceptionHandler.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            exceptionHandler.captureThrowable((OMRSAPIResponse)response, error, userId, serverName, "getLocalRegistration");
        }
        log.debug("Returning from method: getLocalRegistration with response: " + response.toString());
        return response;
    }

    public CohortMembershipResponse getLocalRegistration(String serverName, String userId, String cohortName) {
        String methodName = "getLocalRegistration (cohort version)";
        log.debug("Calling method: getLocalRegistration (cohort version)");
        CohortMembershipResponse response = new CohortMembershipResponse();
        try {
            OMRSMetadataHighwayManager metadataHighwayManager = this.getMetadataHighway(userId, serverName, "getLocalRegistration (cohort version)");
            response.setCohortMember(metadataHighwayManager.getLocalRegistration(cohortName));
        }
        catch (InvalidParameterException error) {
            exceptionHandler.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            exceptionHandler.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            exceptionHandler.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            exceptionHandler.captureThrowable((OMRSAPIResponse)response, error, userId, serverName, "getLocalRegistration (cohort version)");
        }
        log.debug("Returning from method: getLocalRegistration (cohort version) with response: " + response.toString());
        return response;
    }

    public CohortMembershipListResponse getRemoteRegistrations(String serverName, String userId, String cohortName) {
        String methodName = "getRemoteRegistrations";
        log.debug("Calling method: getRemoteRegistrations");
        CohortMembershipListResponse response = new CohortMembershipListResponse();
        try {
            OMRSMetadataHighwayManager metadataHighwayManager = this.getMetadataHighway(userId, serverName, "getRemoteRegistrations");
            response.setCohortMembers(metadataHighwayManager.getRemoteMembers(cohortName));
        }
        catch (InvalidParameterException error) {
            exceptionHandler.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            exceptionHandler.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            exceptionHandler.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            exceptionHandler.captureThrowable((OMRSAPIResponse)response, error, userId, serverName, "getRemoteRegistrations");
        }
        log.debug("Returning from method: getRemoteRegistrations with response: " + response.toString());
        return response;
    }

    private OMRSMetadataHighwayManager getMetadataHighway(String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, RepositoryErrorException {
        OMRSRepositoryServicesInstance instance;
        OMRSMetadataHighwayManager metadataHighwayManager = null;
        if (serverName != null && (instance = instanceHandler.getInstance(userId, serverName, methodName)) != null) {
            metadataHighwayManager = instance.getMetadataHighwayManager();
        }
        if (metadataHighwayManager == null) {
            throw new RepositoryErrorException(OMRSErrorCode.NO_METADATA_HIGHWAY.getMessageDefinition(new String[]{methodName}), this.getClass().getName(), methodName);
        }
        return metadataHighwayManager;
    }
}

