/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.services;

import org.odpi.openmetadata.commonservices.multitenant.OMAGServerServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.metadatahighway.OMRSMetadataHighwayManager;

public class OMRSRepositoryServicesInstance
extends OMAGServerServiceInstance {
    private OMRSAuditLog masterAuditLog;
    private OMRSMetadataCollection localMetadataCollection;
    private OMRSMetadataCollection enterpriseMetadataCollection;
    private OMRSMetadataHighwayManager metadataHighwayManager;
    private String localServerURL;
    private AuditLog auditLog;

    public OMRSRepositoryServicesInstance(String localServerName, OMRSAuditLog masterAuditLog, OMRSRepositoryConnector localRepositoryConnector, OMRSRepositoryConnector enterpriseRepositoryConnector, OMRSMetadataHighwayManager metadataHighwayManager, String localServerURL, String serviceName, AuditLog auditLog, int maxPageSize) {
        super(localServerName, serviceName, maxPageSize);
        this.masterAuditLog = masterAuditLog;
        this.auditLog = auditLog;
        this.localServerURL = localServerURL;
        this.metadataHighwayManager = metadataHighwayManager;
        if (localRepositoryConnector == null) {
            this.localMetadataCollection = null;
        } else {
            try {
                this.localMetadataCollection = localRepositoryConnector.getMetadataCollection();
            }
            catch (Exception error) {
                this.localMetadataCollection = null;
            }
        }
        if (enterpriseRepositoryConnector == null) {
            this.enterpriseMetadataCollection = null;
        } else {
            try {
                this.enterpriseMetadataCollection = enterpriseRepositoryConnector.getMetadataCollection();
            }
            catch (Exception error) {
                this.enterpriseMetadataCollection = null;
            }
        }
    }

    public OMRSAuditLog getMasterAuditLog() {
        return this.masterAuditLog;
    }

    public OMRSMetadataCollection getLocalMetadataCollection() {
        return this.localMetadataCollection;
    }

    public OMRSMetadataCollection getEnterpriseMetadataCollection() {
        return this.enterpriseMetadataCollection;
    }

    public OMRSMetadataHighwayManager getMetadataHighwayManager() {
        return this.metadataHighwayManager;
    }

    public String getLocalServerURL() {
        return this.localServerURL;
    }

    public AuditLog getAuditLog() {
        return this.auditLog;
    }
}

