/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.eventmanagement;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventBuilder;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSMetadataDefaultEventsSecurity;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.events.OpenMetadataEventsSecurity;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryEventPublisher
extends OMRSRepositoryEventBuilder {
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryEventPublisher.class);
    private OpenMetadataEventsSecurity securityVerifier = new OMRSMetadataDefaultEventsSecurity();
    private OMRSTopicConnector omrsTopicConnector;
    private AuditLog auditLog;

    public OMRSRepositoryEventPublisher(String publisherName, OMRSTopicConnector topicConnector, AuditLog auditLog) {
        super(publisherName);
        String actionDescription = "Initialize event publisher";
        this.auditLog = auditLog;
        if (topicConnector == null) {
            log.debug("Null topic connector");
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_TOPIC_CONNECTOR.getMessageDefinition(new String[]{publisherName}), ((Object)((Object)this)).getClass().getName(), actionDescription);
        }
        this.omrsTopicConnector = topicConnector;
        log.debug("New Event Publisher: " + publisherName);
    }

    public void setSecurityVerifier(OpenMetadataEventsSecurity securityVerifier) {
        if (securityVerifier != null) {
            this.securityVerifier = securityVerifier;
        }
    }

    public void sendTypeDefEvent(String sourceName, OMRSTypeDefEvent typeDefEvent) {
        String actionDescription = "Send TypeDef Event";
        log.debug("Sending typeDefEvent for cohort: " + sourceName);
        log.debug("topicConnector: " + this.omrsTopicConnector);
        log.debug("typeDefEvent: " + typeDefEvent);
        log.debug("localEventOriginator: " + typeDefEvent.getEventOriginator());
        try {
            this.omrsTopicConnector.sendTypeDefEvent(typeDefEvent);
        }
        catch (Throwable error) {
            this.auditLog.logException(actionDescription, OMRSAuditCode.SEND_TYPEDEF_EVENT_ERROR.getMessageDefinition(new String[]{sourceName}), "typeDefEvent {" + typeDefEvent.toString() + "}", error);
            log.debug("Exception: ", error);
        }
    }

    public void sendInstanceEvent(String sourceName, OMRSInstanceEvent instanceEvent) {
        String actionDescription = "Send Instance Event";
        log.debug("Sending instanceEvent for cohort: " + sourceName);
        log.debug("topicConnector: " + this.omrsTopicConnector);
        log.debug("instanceEvent: " + instanceEvent);
        log.debug("localEventOriginator: " + instanceEvent.getEventOriginator());
        try {
            OMRSInstanceEvent validatedEvent = this.securityVerifier.validateOutboundEvent(this.eventProcessorName, instanceEvent);
            if (validatedEvent != null) {
                this.omrsTopicConnector.sendInstanceEvent(instanceEvent);
            }
        }
        catch (Throwable error) {
            this.auditLog.logException(actionDescription, OMRSAuditCode.SEND_INSTANCE_EVENT_ERROR.getMessageDefinition(new String[]{sourceName}), "instanceEvent {" + instanceEvent.toString() + "}", error);
            log.debug("Exception: ", error);
        }
    }
}

