/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.control;

import java.util.List;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.control.FederationControlBase;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutor;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class ParallelFederationControl
extends FederationControlBase {
    public ParallelFederationControl(String userId, List<OMRSRepositoryConnector> cohortConnectors, String methodName) {
        super(userId, cohortConnectors, methodName);
    }

    @Override
    public void executeCommand(RepositoryExecutor executor) throws RepositoryErrorException {
        if (this.cohortConnectors != null) {
            for (OMRSRepositoryConnector cohortConnector : this.cohortConnectors) {
                if (cohortConnector == null) continue;
                OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
                String metadataCollectionId = this.validateMetadataCollection(metadataCollection, this.methodName);
                executor.issueRequestToRepository(metadataCollectionId, metadataCollection);
            }
        }
    }
}

