/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.GetEntitySummaryExecutor;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GetEntityExecutor
extends GetEntitySummaryExecutor {
    private boolean allExceptions = true;
    private Date asOfTime = null;
    private EntityDetail latestEntity = null;

    public GetEntityExecutor(String userId, String entityGUID, boolean allExceptions, AuditLog auditLog, String methodName) {
        super(userId, entityGUID, auditLog, methodName);
        this.allExceptions = allExceptions;
    }

    public GetEntityExecutor(String userId, String entityGUID, Date asOfTime, AuditLog auditLog, String methodName) {
        super(userId, entityGUID, auditLog, methodName);
        this.asOfTime = asOfTime;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            if (this.inPhaseOne) {
                EntityDetail retrievedEntity = this.asOfTime == null ? (this.allExceptions ? metadataCollection.getEntityDetail(this.userId, this.entityGUID) : metadataCollection.isEntityKnown(this.userId, this.entityGUID)) : metadataCollection.getEntityDetail(this.userId, this.entityGUID, this.asOfTime);
                if (retrievedEntity != null) {
                    this.saveClassifications(retrievedEntity.getClassifications());
                    if (metadataCollectionId.equals(retrievedEntity.getMetadataCollectionId())) {
                        this.latestEntity = retrievedEntity;
                        this.inPhaseOne = false;
                    } else if (this.latestEntity == null) {
                        this.latestEntity = retrievedEntity;
                    } else if (retrievedEntity.getVersion() > this.latestEntity.getVersion()) {
                        this.latestEntity = retrievedEntity;
                    }
                } else {
                    this.getHomeClassifications(metadataCollection);
                }
            } else {
                this.getHomeClassifications(metadataCollection);
            }
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityProxyOnlyException error) {
            this.accumulator.captureException(error);
            this.getHomeClassifications(metadataCollection);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return false;
    }

    public EntityDetail isEntityKnown() throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        if (this.latestEntity != null) {
            if (this.allClassifications.isEmpty()) {
                this.latestEntity.setClassifications(null);
            } else {
                this.latestEntity.setClassifications(new ArrayList(this.allClassifications.values()));
            }
            return this.latestEntity;
        }
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedInvalidParameterException();
        return null;
    }

    public EntityDetail getEntityDetail() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        EntityDetail entity = this.isEntityKnown();
        if (entity != null) {
            return entity;
        }
        this.accumulator.throwCapturedEntityProxyOnlyException();
        this.accumulator.throwCapturedEntityNotKnownException();
        return null;
    }

    public EntityDetail getEntityDetailHistory() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        EntityDetail entity = this.getEntityDetail();
        if (entity != null) {
            return entity;
        }
        this.accumulator.throwCapturedFunctionNotSupportedException();
        return null;
    }
}

