/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class RestoreRelationshipExecutor
extends RepositoryExecutorBase {
    private MaintenanceAccumulator accumulator;
    private String relationshipGUID;
    private Relationship restoredRelationship = null;

    public RestoreRelationshipExecutor(String userId, String relationshipGUID, AuditLog auditLog, String methodName) {
        super(userId, methodName);
        this.relationshipGUID = relationshipGUID;
        this.accumulator = new MaintenanceAccumulator(auditLog);
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        boolean result = false;
        try {
            this.restoredRelationship = metadataCollection.restoreRelationship(this.userId, this.relationshipGUID);
            result = true;
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (FunctionNotSupportedException error) {
            this.accumulator.captureException(error);
        }
        catch (RelationshipNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (RelationshipNotDeletedException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return result;
    }

    public Relationship getRestoredRelationship() throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (this.restoredRelationship != null) {
            return this.restoredRelationship;
        }
        this.accumulator.throwCapturedRelationshipNotDeletedException();
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedGenericException(this.methodName);
        this.accumulator.throwCapturedRelationshipNotKnownException();
        this.accumulator.throwCapturedInvalidParameterException();
        this.accumulator.throwCapturedFunctionNotSupportedException();
        return null;
    }
}

