/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class ClassifyEntityExecutor
extends RepositoryExecutorBase {
    private MaintenanceAccumulator accumulator;
    private String entityGUID;
    private String classificationName;
    private String externalSourceGUID;
    private String externalSourceName;
    private ClassificationOrigin classificationOrigin;
    private String classificationOriginGUID;
    private InstanceProperties classificationProperties;
    private EntityDetail updatedEntity = null;

    public ClassifyEntityExecutor(String userId, String entityGUID, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties, AuditLog auditLog, String methodName) {
        super(userId, methodName);
        this.accumulator = new MaintenanceAccumulator(auditLog);
        this.entityGUID = entityGUID;
        this.classificationName = classificationName;
        this.externalSourceGUID = externalSourceGUID;
        this.externalSourceName = externalSourceName;
        this.classificationOrigin = classificationOrigin;
        this.classificationOriginGUID = classificationOriginGUID;
        this.classificationProperties = classificationProperties;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        boolean result = false;
        try {
            this.updatedEntity = this.externalSourceGUID == null && this.classificationOrigin == ClassificationOrigin.ASSIGNED ? metadataCollection.classifyEntity(this.userId, this.entityGUID, this.classificationName, this.classificationProperties) : metadataCollection.classifyEntity(this.userId, this.entityGUID, this.classificationName, this.externalSourceGUID, this.externalSourceName, this.classificationOrigin, this.classificationOriginGUID, this.classificationProperties);
            result = true;
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (FunctionNotSupportedException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (ClassificationErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (PropertyErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return result;
    }

    public EntityDetail getUpdatedEntity() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        if (this.updatedEntity != null) {
            return this.updatedEntity;
        }
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedGenericException(this.methodName);
        this.accumulator.throwCapturedEntityNotKnownException();
        this.accumulator.throwCapturedInvalidParameterException();
        this.accumulator.throwCapturedFunctionNotSupportedException();
        this.accumulator.throwCapturedClassificationErrorException();
        this.accumulator.throwCapturedPropertyErrorException();
        return null;
    }
}

