/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.ClassificationAccumulator;

public class EntityDetailAccumulator
extends ClassificationAccumulator {
    private volatile EntityDetail currentSavedEntity = null;

    public EntityDetailAccumulator(AuditLog auditLog) {
        super(auditLog);
    }

    public synchronized void addEntity(EntityDetail incomingEntity, String metadataCollectionId) {
        if (incomingEntity != null && incomingEntity.getGUID() != null) {
            if (metadataCollectionId.equals(incomingEntity.getMetadataCollectionId())) {
                this.currentSavedEntity = incomingEntity;
                super.setInPhaseOne(false);
            } else if (this.currentSavedEntity == null) {
                this.currentSavedEntity = incomingEntity;
            } else if (!super.currentInstanceIsBest((InstanceAuditHeader)this.currentSavedEntity, (InstanceAuditHeader)incomingEntity)) {
                this.currentSavedEntity = incomingEntity;
            }
            super.saveClassifications(incomingEntity.getClassifications());
        }
    }

    @Override
    public List<String> getResultsForAugmentation() {
        if (this.currentSavedEntity != null) {
            ArrayList<String> resultsArray = new ArrayList<String>();
            resultsArray.add(this.currentSavedEntity.getGUID());
            return resultsArray;
        }
        return null;
    }

    public EntityDetail getResult() {
        if (this.currentSavedEntity != null) {
            this.currentSavedEntity.setClassifications(super.getClassifications());
            return this.currentSavedEntity;
        }
        return null;
    }
}

