/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.TypesAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.CloneableRepositoryExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.CloneableRepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GetAllTypesExecutor
extends CloneableRepositoryExecutorBase {
    private final TypesAccumulator accumulator;

    public GetAllTypesExecutor(String userId, String methodName, String localMetadataCollectionId, AuditLog auditLog, OMRSRepositoryValidator repositoryValidator) {
        this(userId, methodName, new TypesAccumulator(localMetadataCollectionId, auditLog, repositoryValidator));
    }

    private GetAllTypesExecutor(String userId, String methodName, TypesAccumulator accumulator) {
        super(userId, methodName, accumulator);
        this.accumulator = accumulator;
    }

    @Override
    public CloneableRepositoryExecutor getClone() {
        return new GetAllTypesExecutor(this.userId, this.methodName, this.accumulator);
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            this.accumulator.addTypeDefGallery(metadataCollection.getAllTypes(this.userId), metadataCollectionId);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return false;
    }

    public TypeDefGallery getResults() throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        TypeDefGallery results = this.accumulator.getResults();
        if (results != null) {
            return results;
        }
        this.accumulator.throwCapturedInvalidParameterException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedGenericException(this.methodName);
        return null;
    }
}

