/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class VerifyTypeDefExecutor
extends RepositoryExecutorBase {
    private final TypeDef typeDef;
    private final MaintenanceAccumulator accumulator;
    private boolean result = false;
    private boolean resultSet = false;

    public VerifyTypeDefExecutor(String userId, TypeDef typeDef, AuditLog auditLog, String methodName) {
        super(userId, methodName);
        this.typeDef = typeDef;
        this.accumulator = new MaintenanceAccumulator(auditLog);
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            this.result = metadataCollection.verifyTypeDef(this.userId, this.typeDef);
            this.resultSet = true;
        }
        catch (TypeDefNotSupportedException error) {
            this.accumulator.captureException(error);
        }
        catch (InvalidTypeDefException error) {
            this.accumulator.captureException(error);
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (TypeDefConflictException error) {
            this.accumulator.captureException(error);
            this.resultSet = true;
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return this.resultSet;
    }

    public boolean getResult() throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        this.accumulator.throwCapturedTypeDefConflictException();
        if (this.resultSet) {
            return this.result;
        }
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedGenericException(this.methodName);
        this.accumulator.throwCapturedTypeDefNotSupportedException();
        this.accumulator.throwCapturedInvalidTypeDefException();
        this.accumulator.throwCapturedInvalidParameterException();
        return false;
    }
}

