/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnectorProviderBase;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectorManager;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSConnectorProperties;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentHelper;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnterpriseOMRSConnectorProvider
extends OMRSRepositoryConnectorProviderBase {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseOMRSConnectorProvider.class);
    private final OMRSConnectorManager connectorManager;
    private final OMRSRepositoryContentManager repositoryContentManager;
    private final String localServerName;
    private final String localServerType;
    private final OMRSAuditLog auditLog;
    private final String owningOrganizationName;
    private final String enterpriseMetadataCollectionId;
    private final String enterpriseMetadataCollectionName;
    private final String localMetadataCollectionId;

    public EnterpriseOMRSConnectorProvider(OMRSConnectorManager connectorManager, OMRSRepositoryContentManager repositoryContentManager, String localServerName, String localServerType, String owningOrganizationName, OMRSAuditLog auditLog, String enterpriseMetadataCollectionId, String enterpriseMetadataCollectionName, String localMetadataCollectionId) {
        super.setConnectorComponentDescription((ComponentDescription)OMRSAuditingComponent.ENTERPRISE_REPOSITORY_CONNECTOR);
        Class<EnterpriseOMRSRepositoryConnector> connectorClass = EnterpriseOMRSRepositoryConnector.class;
        super.setConnectorClassName(connectorClass.getName());
        this.connectorManager = connectorManager;
        this.repositoryContentManager = repositoryContentManager;
        this.localServerName = localServerName;
        this.localServerType = localServerType;
        this.auditLog = auditLog;
        this.owningOrganizationName = owningOrganizationName;
        this.enterpriseMetadataCollectionId = enterpriseMetadataCollectionId;
        this.enterpriseMetadataCollectionName = enterpriseMetadataCollectionName;
        this.localMetadataCollectionId = localMetadataCollectionId;
    }

    public Connector getConnector(ConnectionProperties connection) throws ConnectionCheckedException, ConnectorCheckedException {
        String methodName = "getConnector";
        log.debug(methodName + " called");
        if (this.connectorManager == null) {
            throw new ConnectorCheckedException(OMRSErrorCode.COHORT_NOT_CONNECTED.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        EnterpriseOMRSRepositoryConnector connector = new EnterpriseOMRSRepositoryConnector(this.connectorManager);
        connector.setAuditLog((AuditLog)this.auditLog.createNewAuditLog(OMRSAuditingComponent.ENTERPRISE_REPOSITORY_CONNECTOR));
        connector.initialize(this.getNewConnectorGUID(), connection);
        connector.setServerName(this.localServerName);
        connector.setServerType(this.localServerType);
        connector.setRepositoryName(this.enterpriseMetadataCollectionName);
        connector.setOrganizationName(this.owningOrganizationName);
        connector.setRepositoryHelper(new OMRSRepositoryContentHelper(this.repositoryContentManager));
        connector.setRepositoryValidator(new OMRSRepositoryContentValidator(this.repositoryContentManager));
        connector.setLocalMetadataCollectionId(this.localMetadataCollectionId);
        connector.setMetadataCollectionId(this.enterpriseMetadataCollectionId);
        connector.setMetadataCollectionName(this.enterpriseMetadataCollectionName);
        connector.initializeConnectedAssetProperties(new EnterpriseOMRSConnectorProperties(connector, this.connectorManager, this.enterpriseMetadataCollectionId, this.enterpriseMetadataCollectionName));
        log.debug(methodName + " returns: " + connector.getConnectorInstanceId() + ", " + connection.getConnectionName());
        return connector;
    }
}

