/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRelationshipExecutor
extends RepositoryExecutorBase {
    private final MaintenanceAccumulator accumulator;
    private final String relationshipTypeGUID;
    private final InstanceProperties initialProperties;
    private final EntityProxy entityOneProxy;
    private final EntityProxy entityTwoProxy;
    private final InstanceStatus initialStatus;
    private String externalSourceGUID = null;
    private String externalSourceName = null;
    private Relationship newRelationship = null;
    private static final Logger log = LoggerFactory.getLogger(AddRelationshipExecutor.class);

    public AddRelationshipExecutor(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, EntityProxy entityOneProxy, EntityProxy entityTwoProxy, InstanceStatus initialStatus, AuditLog auditLog, String methodName) {
        super(userId, methodName);
        this.accumulator = new MaintenanceAccumulator(auditLog);
        this.relationshipTypeGUID = relationshipTypeGUID;
        this.initialProperties = initialProperties;
        this.entityOneProxy = entityOneProxy;
        this.entityTwoProxy = entityTwoProxy;
        this.initialStatus = initialStatus;
    }

    public AddRelationshipExecutor(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, EntityProxy entityOneProxy, EntityProxy entityTwoProxy, InstanceStatus initialStatus, AuditLog auditLog, String methodName) {
        super(userId, methodName);
        this.accumulator = new MaintenanceAccumulator(auditLog);
        this.relationshipTypeGUID = relationshipTypeGUID;
        this.externalSourceGUID = externalSourceGUID;
        this.externalSourceName = externalSourceName;
        this.initialProperties = initialProperties;
        this.entityOneProxy = entityOneProxy;
        this.entityTwoProxy = entityTwoProxy;
        this.initialStatus = initialStatus;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        boolean result = false;
        try {
            String entityOneGUID = this.entityOneProxy.getGUID();
            String entityTwoGUID = this.entityTwoProxy.getGUID();
            if (this.ensureEntityEndKnown(this.userId, entityOneGUID, this.entityOneProxy, metadataCollection) && this.ensureEntityEndKnown(this.userId, entityTwoGUID, this.entityTwoProxy, metadataCollection)) {
                this.newRelationship = this.externalSourceGUID == null ? metadataCollection.addRelationship(this.userId, this.relationshipTypeGUID, this.initialProperties, entityOneGUID, entityTwoGUID, this.initialStatus) : metadataCollection.addExternalRelationship(this.userId, this.relationshipTypeGUID, this.externalSourceGUID, this.externalSourceName, this.initialProperties, entityOneGUID, entityTwoGUID, this.initialStatus);
            }
            if (this.newRelationship != null) {
                result = true;
            }
        }
        catch (TypeErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (StatusNotSupportedException error) {
            this.accumulator.captureException(error);
        }
        catch (PropertyErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return result;
    }

    public Relationship getNewRelationship() throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (this.newRelationship != null) {
            return this.newRelationship;
        }
        this.accumulator.throwCapturedEntityNotKnownException();
        this.accumulator.throwCapturedInvalidParameterException();
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedStatusNotSupportedException();
        this.accumulator.throwCapturedTypeErrorException();
        this.accumulator.throwCapturedPropertyErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedFunctionNotSupportedException();
        this.accumulator.throwCapturedGenericException(this.methodName);
        return null;
    }

    private boolean ensureEntityEndKnown(String userId, String entityGUID, EntityProxy entityProxy, OMRSMetadataCollection metadataCollection) {
        try {
            metadataCollection.getEntitySummary(userId, entityGUID);
            return true;
        }
        catch (EntityNotKnownException error) {
            try {
                metadataCollection.addEntityProxy(userId, entityProxy);
                return true;
            }
            catch (Exception proxyError) {
                log.debug("Error from adding proxy: " + proxyError.getMessage());
            }
        }
        catch (Exception error) {
            log.debug("Error from querying entity: " + error.getMessage());
        }
        return false;
    }
}

