/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.metadatahighway.cohortregistry;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.OMRSCohortRegistryStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.properties.MemberRegistration;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectionConsumer;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEventProcessor;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;

public class OMRSCohortRegistry
extends OMRSRegistryEventProcessor {
    private String cohortName = null;
    private String localMetadataCollectionId = null;
    private String localMetadataCollectionName = null;
    private Connection localRepositoryRemoteConnection = null;
    private String localServerName = null;
    private String localServerType = null;
    private String localOrganizationName = null;
    private OMRSCohortRegistryStore registryStore = null;
    private OMRSRegistryEventProcessor outboundRegistryEventProcessor = null;
    private OMRSConnectionConsumer connectionConsumer = null;
    private final AuditLog auditLog;

    public OMRSCohortRegistry(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    private void validateLocalMetadataCollectionId(String configuredLocalMetadataCollectionId) {
        String storedLocalMetadataCollectionId;
        String methodName = "validateLocalMetadataCollectionId()";
        if (this.registryStore == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_REGISTRY_STORE.getMessageDefinition(new String[]{this.cohortName}), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        MemberRegistration localRegistration = this.registryStore.retrieveLocalRegistration();
        if (localRegistration != null && (storedLocalMetadataCollectionId = localRegistration.getMetadataCollectionId()) != null && !storedLocalMetadataCollectionId.equals(configuredLocalMetadataCollectionId)) {
            if (configuredLocalMetadataCollectionId == null) {
                this.unRegisterLocalRepositoryWithCohort(localRegistration);
                this.registryStore.removeLocalRegistration();
            } else {
                throw new OMRSConfigErrorException(OMRSErrorCode.INVALID_LOCAL_METADATA_COLLECTION_ID.getMessageDefinition(new String[]{this.cohortName, this.localServerName, storedLocalMetadataCollectionId, configuredLocalMetadataCollectionId}), ((Object)((Object)this)).getClass().getName(), methodName);
            }
        }
    }

    public void initialize(String cohortName, String localMetadataCollectionId, String localMetadataCollectionName, Connection localRepositoryRemoteConnection, String localServerName, String localServerType, String localOrganizationName, OMRSRegistryEventProcessor registryEventProcessor, OMRSCohortRegistryStore cohortRegistryStore, OMRSConnectionConsumer connectionConsumer) {
        String actionDescription = "Initialize cohort registry";
        if (cohortRegistryStore == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_REGISTRY_STORE.getMessageDefinition(new String[]{cohortName}), ((Object)((Object)this)).getClass().getName(), actionDescription);
        }
        this.registryStore = cohortRegistryStore;
        this.localServerName = localServerName;
        this.localServerType = localServerType;
        this.localOrganizationName = localOrganizationName;
        this.cohortName = cohortName;
        this.outboundRegistryEventProcessor = registryEventProcessor;
        this.validateLocalMetadataCollectionId(localMetadataCollectionId);
        this.localMetadataCollectionId = localMetadataCollectionId;
        this.localMetadataCollectionName = localMetadataCollectionName;
        this.connectionConsumer = connectionConsumer;
        this.localRepositoryRemoteConnection = localRepositoryRemoteConnection;
    }

    public synchronized void connectToCohort() {
        List remoteRegistrations;
        if (this.registryStore == null) {
            String methodName = "connectToCohort";
            throw new OMRSRuntimeException(OMRSErrorCode.NULL_REGISTRY_STORE.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "connectToCohort");
        }
        MemberRegistration localRegistration = this.registryStore.retrieveLocalRegistration();
        if (localRegistration == null) {
            localRegistration = new MemberRegistration();
        }
        localRegistration.setMetadataCollectionId(this.localMetadataCollectionId);
        localRegistration.setMetadataCollectionName(this.localMetadataCollectionName);
        localRegistration.setServerName(this.localServerName);
        localRegistration.setServerType(this.localServerType);
        localRegistration.setOrganizationName(this.localOrganizationName);
        localRegistration.setRepositoryConnection(this.localRepositoryRemoteConnection);
        if (this.localMetadataCollectionId != null) {
            this.registryStore.saveLocalRegistration(localRegistration);
            if (localRegistration.getRegistrationTime() == null) {
                localRegistration.setRegistrationTime(new Date());
                if (this.registerLocalRepositoryWithCohort(localRegistration)) {
                    this.registryStore.saveLocalRegistration(localRegistration);
                }
            } else {
                this.reRegisterLocalRepositoryWithCohort(localRegistration);
            }
        }
        if (this.connectionConsumer != null && (remoteRegistrations = this.registryStore.retrieveRemoteRegistrations()) != null) {
            for (MemberRegistration remoteMember : remoteRegistrations) {
                if (remoteMember == null || remoteMember.getRepositoryConnection() == null) continue;
                this.registerRemoteConnectionWithConsumer(remoteMember.getMetadataCollectionId(), remoteMember.getMetadataCollectionName(), remoteMember.getServerName(), remoteMember.getServerType(), remoteMember.getOrganizationName(), remoteMember.getRepositoryConnection());
            }
        }
        this.requestRegistrationRefreshFromCohort(localRegistration);
    }

    public synchronized MemberRegistration getLocalRegistration() {
        if (this.registryStore != null) {
            return new MemberRegistration(this.registryStore.retrieveLocalRegistration());
        }
        return null;
    }

    public synchronized List<MemberRegistration> getRemoteMembers() {
        if (this.registryStore != null) {
            return this.registryStore.retrieveRemoteRegistrations();
        }
        return null;
    }

    public synchronized void disconnectFromCohort(boolean permanent) {
        String actionDescription = "Disconnect from Cohort";
        if (this.registryStore != null) {
            if (permanent) {
                MemberRegistration localRegistration = this.registryStore.retrieveLocalRegistration();
                this.auditLog.logMessage("Disconnect from Cohort", OMRSAuditCode.COHORT_PERMANENTLY_DISCONNECTING.getMessageDefinition(new String[]{this.cohortName}));
                if (localRegistration != null) {
                    this.unRegisterLocalRepositoryWithCohort(localRegistration);
                }
                this.registryStore.clearAllRegistrations();
                if (this.connectionConsumer != null) {
                    this.connectionConsumer.removeCohort(this.cohortName);
                }
            } else {
                this.auditLog.logMessage("Disconnect from Cohort", OMRSAuditCode.COHORT_DISCONNECTING.getMessageDefinition(new String[]{this.cohortName}));
            }
            this.registryStore.close();
        }
    }

    private boolean registerLocalRepositoryWithCohort(MemberRegistration localRegistration) {
        String actionDescription = "Registering with cohort";
        this.auditLog.logMessage("Registering with cohort", OMRSAuditCode.REGISTERED_WITH_COHORT.getMessageDefinition(new String[]{this.cohortName, this.localMetadataCollectionId}));
        return this.outboundRegistryEventProcessor.processRegistrationEvent(this.cohortName, localRegistration.getMetadataCollectionId(), localRegistration.getMetadataCollectionName(), localRegistration.getServerName(), localRegistration.getServerType(), localRegistration.getOrganizationName(), localRegistration.getRegistrationTime(), localRegistration.getRepositoryConnection());
    }

    private void reRegisterLocalRepositoryWithCohort(MemberRegistration localRegistration) {
        String actionDescription = "ReRegistering with cohort";
        this.auditLog.logMessage("ReRegistering with cohort", OMRSAuditCode.RE_REGISTERED_WITH_COHORT.getMessageDefinition(new String[]{this.cohortName, this.localMetadataCollectionId}));
        this.outboundRegistryEventProcessor.processReRegistrationEvent(this.cohortName, localRegistration.getMetadataCollectionId(), localRegistration.getMetadataCollectionName(), localRegistration.getServerName(), localRegistration.getServerType(), localRegistration.getOrganizationName(), localRegistration.getRegistrationTime(), localRegistration.getRepositoryConnection());
    }

    private void requestRegistrationRefreshFromCohort(MemberRegistration localRegistration) {
        String actionDescription = "Re-registering with cohort";
        this.auditLog.logMessage("Re-registering with cohort", OMRSAuditCode.REFRESH_REGISTRATION_REQUEST_WITH_COHORT.getMessageDefinition(new String[]{this.cohortName}));
        this.outboundRegistryEventProcessor.processRegistrationRefreshRequest(this.cohortName, localRegistration.getServerName(), localRegistration.getServerType(), localRegistration.getOrganizationName());
    }

    private void unRegisterLocalRepositoryWithCohort(MemberRegistration localRegistration) {
        String actionDescription = "Unregistering from cohort";
        this.auditLog.logMessage("Unregistering from cohort", OMRSAuditCode.UNREGISTERING_FROM_COHORT.getMessageDefinition(new String[]{this.cohortName, localRegistration.getMetadataCollectionId()}));
        this.outboundRegistryEventProcessor.processUnRegistrationEvent(this.cohortName, localRegistration.getMetadataCollectionId(), localRegistration.getMetadataCollectionName(), localRegistration.getServerName(), localRegistration.getServerType(), localRegistration.getOrganizationName());
    }

    private void registerRemoteConnectionWithConsumer(String remoteMetadataCollectionId, String remoteMetadataCollectionName, String remoteServerName, String remoteServerType, String owningOrganizationName, Connection remoteRepositoryConnection) {
        block5: {
            String actionDescription = "Receiving registration request";
            if (this.connectionConsumer != null) {
                try {
                    this.connectionConsumer.addRemoteConnection(this.cohortName, remoteServerName, remoteServerType, owningOrganizationName, remoteMetadataCollectionId, remoteMetadataCollectionName, remoteRepositoryConnection);
                }
                catch (OCFCheckedExceptionBase error) {
                    this.auditLog.logMessage("Receiving registration request", OMRSAuditCode.OUTGOING_BAD_CONNECTION.getMessageDefinition(new String[]{this.cohortName, remoteRepositoryConnection.getQualifiedName(), remoteServerName, remoteMetadataCollectionId, error.getReportedErrorMessage()}), error.getReportedErrorMessage());
                    if (this.outboundRegistryEventProcessor != null) {
                        this.outboundRegistryEventProcessor.processBadConnectionEvent(this.cohortName, this.localMetadataCollectionId, this.localMetadataCollectionName, this.localServerName, this.localServerType, this.localOrganizationName, remoteMetadataCollectionId, remoteRepositoryConnection, error.getReportedErrorMessage());
                    }
                }
                catch (Exception error) {
                    this.auditLog.logMessage("Receiving registration request", OMRSAuditCode.OUTGOING_BAD_CONNECTION.getMessageDefinition(new String[]{this.cohortName, remoteRepositoryConnection.getQualifiedName(), remoteServerName, remoteMetadataCollectionId, error.getMessage()}), error.getMessage());
                    if (this.outboundRegistryEventProcessor == null) break block5;
                    this.outboundRegistryEventProcessor.processBadConnectionEvent(this.cohortName, this.localMetadataCollectionId, this.localMetadataCollectionName, this.localServerName, this.localServerType, this.localOrganizationName, remoteMetadataCollectionId, remoteRepositoryConnection, error.getMessage());
                }
            }
        }
    }

    private void unRegisterRemoteConnectionWithConsumer(String remoteMetadataCollectionId) {
        if (this.connectionConsumer != null) {
            this.connectionConsumer.removeRemoteConnection(this.cohortName, remoteMetadataCollectionId);
        }
    }

    private void actionInboundRegistration(String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, Date registrationTimestamp, Connection remoteConnection) {
        MemberRegistration remoteRegistration = new MemberRegistration();
        remoteRegistration.setMetadataCollectionId(originatorMetadataCollectionId);
        remoteRegistration.setMetadataCollectionName(originatorMetadataCollectionName);
        remoteRegistration.setServerName(originatorServerName);
        remoteRegistration.setServerType(originatorServerType);
        remoteRegistration.setOrganizationName(originatorOrganizationName);
        remoteRegistration.setRegistrationTime(registrationTimestamp);
        remoteRegistration.setRepositoryConnection(remoteConnection);
        this.registryStore.saveRemoteRegistration(remoteRegistration);
        if (remoteConnection != null) {
            this.registerRemoteConnectionWithConsumer(originatorMetadataCollectionId, originatorMetadataCollectionName, originatorServerName, originatorServerType, originatorOrganizationName, remoteConnection);
        }
    }

    private boolean verifyRegistryStore(String eventName, String originatingServerName) {
        if (this.registryStore != null) {
            return true;
        }
        this.auditLog.logMessage(eventName, OMRSAuditCode.MISSING_MEMBER_REGISTRATION.getMessageDefinition(new String[]{eventName, this.cohortName, originatingServerName}));
        return false;
    }

    public synchronized boolean processRegistrationEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, Date registrationTimestamp, Connection remoteConnection) {
        String actionDescription = "Receiving Registration event";
        String eventName = "Registration";
        if (this.verifyRegistryStore("Registration", originatorServerName)) {
            this.actionInboundRegistration(originatorMetadataCollectionId, originatorMetadataCollectionName, originatorServerName, originatorServerType, originatorOrganizationName, registrationTimestamp, remoteConnection);
            this.auditLog.logMessage("Receiving Registration event", OMRSAuditCode.NEW_MEMBER_IN_COHORT.getMessageDefinition(new String[]{this.cohortName, originatorServerName, originatorMetadataCollectionId}));
            return true;
        }
        return false;
    }

    public synchronized boolean processReRegistrationEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, Date registrationTimestamp, Connection remoteConnection) {
        String actionDescription = "Receiving ReRegistration event";
        String eventName = "Re-Registration";
        if (this.verifyRegistryStore("Re-Registration", originatorServerName)) {
            this.actionInboundRegistration(originatorMetadataCollectionId, originatorMetadataCollectionName, originatorServerName, originatorServerType, originatorOrganizationName, registrationTimestamp, remoteConnection);
            this.auditLog.logMessage("Receiving ReRegistration event", OMRSAuditCode.REFRESHED_MEMBER_IN_COHORT.getMessageDefinition(new String[]{this.cohortName, originatorServerName, originatorMetadataCollectionId}));
            return true;
        }
        return false;
    }

    public synchronized boolean processRegistrationRefreshRequest(String sourceName, String originatorServerName, String originatorServerType, String originatorOrganizationName) {
        String actionDescription = "Receiving Registration Refresh event";
        String eventName = "Registration Refresh";
        if (this.verifyRegistryStore("Registration Refresh", originatorServerName)) {
            MemberRegistration localRegistration = this.registryStore.retrieveLocalRegistration();
            if (localRegistration != null) {
                this.auditLog.logMessage("Receiving Registration Refresh event", OMRSAuditCode.REFRESHING_REGISTRATION_WITH_COHORT.getMessageDefinition(new String[]{this.cohortName, this.localMetadataCollectionId, originatorServerName}));
                return this.outboundRegistryEventProcessor.processReRegistrationEvent(this.cohortName, localRegistration.getMetadataCollectionId(), localRegistration.getMetadataCollectionName(), localRegistration.getServerName(), localRegistration.getServerType(), localRegistration.getOrganizationName(), localRegistration.getRegistrationTime(), localRegistration.getRepositoryConnection());
            }
            return true;
        }
        return false;
    }

    public synchronized boolean processUnRegistrationEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName) {
        String actionDescription = "Receiving unregistration event";
        String eventName = "UnRegistration";
        if (this.verifyRegistryStore("UnRegistration", originatorServerName)) {
            this.registryStore.removeRemoteRegistration(originatorMetadataCollectionId);
            this.unRegisterRemoteConnectionWithConsumer(originatorMetadataCollectionId);
            this.auditLog.logMessage("Receiving unregistration event", OMRSAuditCode.MEMBER_LEFT_COHORT.getMessageDefinition(new String[]{originatorServerName, originatorMetadataCollectionId, this.cohortName}));
            return true;
        }
        return false;
    }

    public synchronized void processConflictingCollectionIdEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, String conflictingMetadataCollectionId, String errorMessage) {
        if (conflictingMetadataCollectionId != null) {
            String actionDescription = "Receiving Conflicting Metadata Collection Id event";
            if (conflictingMetadataCollectionId.equals(this.localMetadataCollectionId)) {
                this.auditLog.logMessage("Receiving Conflicting Metadata Collection Id event", OMRSAuditCode.INCOMING_CONFLICTING_LOCAL_METADATA_COLLECTION_ID.getMessageDefinition(new String[]{this.cohortName, originatorServerName, originatorMetadataCollectionId, conflictingMetadataCollectionId}));
            } else {
                this.auditLog.logMessage("Receiving Conflicting Metadata Collection Id event", OMRSAuditCode.INCOMING_CONFLICTING_METADATA_COLLECTION_ID.getMessageDefinition(new String[]{this.cohortName, conflictingMetadataCollectionId}));
            }
        }
    }

    public synchronized void processBadConnectionEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, Connection remoteRepositoryConnection, String errorMessage) {
        if (targetMetadataCollectionId != null && targetMetadataCollectionId.equals(this.localMetadataCollectionId)) {
            String actionDescription = "Receiving Bad Connection event";
            this.auditLog.logMessage("Receiving Bad Connection event", OMRSAuditCode.INCOMING_BAD_CONNECTION.getMessageDefinition(new String[]{this.cohortName, originatorServerName, originatorMetadataCollectionId, remoteRepositoryConnection.getQualifiedName()}), remoteRepositoryConnection.toString());
        }
    }

    public String toString() {
        return "OMRSCohortRegistry{cohortName='" + this.cohortName + "', localMetadataCollectionId='" + this.localMetadataCollectionId + "', localMetadataCollectionName='" + this.localMetadataCollectionName + "', localRepositoryRemoteConnection=" + this.localRepositoryRemoteConnection + ", localServerName='" + this.localServerName + "', localServerType='" + this.localServerType + "', localOrganizationName='" + this.localOrganizationName + "', registryStore=" + this.registryStore + ", outboundRegistryEventProcessor=" + this.outboundRegistryEventProcessor + ", connectionConsumer=" + this.connectionConsumer + "}";
    }
}

