/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;

public abstract class ClassificationAccumulator
extends MaintenanceAccumulator {
    private final List<String> contributingMetadataCollections = new ArrayList<String>();
    private final Map<String, Classification> allClassifications = new HashMap<String, Classification>();
    private volatile boolean inPhaseOne = true;

    ClassificationAccumulator(AuditLog auditLog) {
        super(auditLog);
    }

    public synchronized boolean isInPhaseOne() {
        return this.inPhaseOne;
    }

    synchronized void setInPhaseOne(boolean inPhaseOne) {
        this.inPhaseOne = inPhaseOne;
    }

    public synchronized void addContributingMetadataCollection(String metadataCollectionId) {
        this.contributingMetadataCollections.add(metadataCollectionId);
    }

    public synchronized List<String> getContributingMetadataCollections() {
        return this.contributingMetadataCollections;
    }

    public abstract List<String> getResultsForAugmentation();

    public void saveClassifications(List<Classification> retrievedClassifications) {
        if (retrievedClassifications != null) {
            for (Classification entityClassification : retrievedClassifications) {
                Classification existingClassification;
                if (entityClassification == null || (existingClassification = this.allClassifications.get(entityClassification.getName())) != null && existingClassification.getVersion() >= entityClassification.getVersion()) continue;
                this.allClassifications.put(entityClassification.getName(), entityClassification);
            }
        }
    }

    List<Classification> getClassifications() {
        if (this.allClassifications.isEmpty()) {
            return null;
        }
        return new ArrayList<Classification>(this.allClassifications.values());
    }
}

