/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.Date;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.EntityDetailAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.GetEntityExecutor;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GetEntityDetailExecutor
extends GetEntityExecutor {
    private Date asOfTime = null;
    private final EntityDetailAccumulator accumulator;

    public GetEntityDetailExecutor(String userId, String entityGUID, AuditLog auditLog, String methodName) {
        this(userId, entityGUID, new EntityDetailAccumulator(auditLog), methodName);
    }

    private GetEntityDetailExecutor(String userId, String entityGUID, EntityDetailAccumulator accumulator, String methodName) {
        super(userId, entityGUID, accumulator, methodName);
        this.accumulator = accumulator;
    }

    public GetEntityDetailExecutor(String userId, String entityGUID, Date asOfTime, AuditLog auditLog, String methodName) {
        this(userId, entityGUID, asOfTime, new EntityDetailAccumulator(auditLog), methodName);
    }

    private GetEntityDetailExecutor(String userId, String entityGUID, Date asOfTime, EntityDetailAccumulator accumulator, String methodName) {
        super(userId, entityGUID, accumulator, methodName);
        this.asOfTime = asOfTime;
        this.accumulator = accumulator;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            this.accumulator.addContributingMetadataCollection(metadataCollectionId);
            if (this.accumulator.isInPhaseOne()) {
                EntityDetail retrievedEntity = this.asOfTime == null ? metadataCollection.isEntityKnown(this.userId, this.entityGUID) : metadataCollection.getEntityDetail(this.userId, this.entityGUID, this.asOfTime);
                if (retrievedEntity != null) {
                    this.accumulator.addEntity(retrievedEntity, metadataCollectionId);
                } else {
                    this.getHomeClassifications(metadataCollection);
                }
            } else {
                this.getHomeClassifications(metadataCollection);
            }
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityProxyOnlyException error) {
            this.accumulator.captureException(error);
            this.getHomeClassifications(metadataCollection);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return false;
    }

    public EntityDetail isEntityKnown(boolean returnDeletedClassifications) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        EntityDetail result = this.accumulator.getResult(returnDeletedClassifications);
        if (result != null) {
            return result;
        }
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedInvalidParameterException();
        return null;
    }

    public EntityDetail getEntityDetail() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        EntityDetail entity = this.isEntityKnown(false);
        if (entity != null) {
            if (entity.getStatus() == InstanceStatus.DELETED) {
                throw new EntityNotKnownException(OMRSErrorCode.ENTITY_SOFT_DELETED.getMessageDefinition(new String[]{entity.getType().getTypeDefName(), entity.getGUID(), this.methodName, "Enterprise"}), this.getClass().getName(), this.methodName);
            }
            return entity;
        }
        this.accumulator.throwCapturedEntityProxyOnlyException();
        this.accumulator.throwCapturedEntityNotKnownException();
        throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{this.entityGUID, this.methodName, "Enterprise"}), this.getClass().getName(), this.methodName);
    }

    public EntityDetail getEntityDetailHistory() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        EntityDetail entity = this.getEntityDetail();
        if (entity != null) {
            return entity;
        }
        this.accumulator.throwCapturedFunctionNotSupportedException();
        return null;
    }
}

