/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.eventmanagement;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenMetadataExchangeRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OMRSRepositoryEventExchangeRule {
    private final OpenMetadataExchangeRule exchangeRule;
    private final List<String> selectedTypesToProcess = new ArrayList<String>();

    public OMRSRepositoryEventExchangeRule(OpenMetadataExchangeRule exchangeRule, List<TypeDefSummary> selectedTypesToProcess) {
        String methodName = "OMRSRepositoryEventExchangeRule constructor";
        if (exchangeRule == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_EXCHANGE_RULE.getMessageDefinition(new String[]{"OMRSRepositoryEventExchangeRule constructor"}), this.getClass().getName(), "OMRSRepositoryEventExchangeRule constructor");
        }
        this.exchangeRule = exchangeRule;
        if (selectedTypesToProcess != null) {
            for (TypeDefSummary typeDefSummary : selectedTypesToProcess) {
                String typeDefSummaryGUID;
                if (typeDefSummary == null || (typeDefSummaryGUID = typeDefSummary.getGUID()) == null) continue;
                this.selectedTypesToProcess.add(typeDefSummaryGUID);
            }
        }
    }

    public boolean processTypeDefEvents() {
        return this.exchangeRule != OpenMetadataExchangeRule.REGISTRATION_ONLY;
    }

    public boolean processInstanceEvent(String typeDefGUID, String typeDefName) {
        if (this.exchangeRule == OpenMetadataExchangeRule.REGISTRATION_ONLY || this.exchangeRule == OpenMetadataExchangeRule.JUST_TYPEDEFS) {
            return false;
        }
        if (typeDefGUID == null || typeDefName == null) {
            return false;
        }
        if (this.exchangeRule == OpenMetadataExchangeRule.ALL) {
            return true;
        }
        if (this.exchangeRule == OpenMetadataExchangeRule.DESELECTED_TYPES) {
            return !this.selectedTypesToProcess.contains(typeDefGUID);
        }
        return this.selectedTypesToProcess.contains(typeDefGUID);
    }

    public boolean processInstanceEvent(TypeDefSummary typeDefSummary) {
        if (typeDefSummary == null) {
            return false;
        }
        return this.processInstanceEvent(typeDefSummary.getGUID(), typeDefSummary.getName());
    }

    public boolean processInstanceEvent(InstanceHeader instance) {
        if (instance == null) {
            return false;
        }
        InstanceType type = instance.getType();
        if (type == null) {
            return false;
        }
        return this.processInstanceEvent(type.getTypeDefGUID(), type.getTypeDefName());
    }

    public boolean learnInstanceEvent(InstanceHeader instance) {
        String typeDefGUID;
        InstanceType type;
        if (this.exchangeRule == OpenMetadataExchangeRule.LEARNED_TYPES && (type = instance.getType()) != null && (typeDefGUID = type.getTypeDefGUID()) != null) {
            if (!this.selectedTypesToProcess.contains(type.getTypeDefGUID())) {
                this.selectedTypesToProcess.add(typeDefGUID);
            }
            return true;
        }
        return false;
    }
}

