/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.utilities.OMRSRepositoryPropertiesUtilities;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventManager;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventType;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSTypeDefManager;
import org.odpi.openmetadata.repositoryservices.rest.server.OMRSRepositoryRESTServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryContentManager
extends OMRSTypeDefEventProcessor
implements OMRSTypeDefManager {
    private final String localServerUserId;
    private LocalOMRSRepositoryConnector localRepositoryConnector = null;
    private String localServerName = null;
    private OMRSRepositoryEventManager outboundRepositoryEventManager = null;
    private String openTypesOriginGUID = null;
    private final Map<String, TypeDef> knownTypeDefGUIDs = new HashMap<String, TypeDef>();
    private final Map<String, TypeDef> knownTypeDefNames = new HashMap<String, TypeDef>();
    private final Map<String, AttributeTypeDef> knownAttributeTypeDefGUIDs = new HashMap<String, AttributeTypeDef>();
    private final Map<String, AttributeTypeDef> knownAttributeTypeDefNames = new HashMap<String, AttributeTypeDef>();
    private final Map<String, TypeDef> activeTypeDefGUIDs = new HashMap<String, TypeDef>();
    private final Map<String, TypeDef> activeTypeDefNames = new HashMap<String, TypeDef>();
    private final Map<String, AttributeTypeDef> activeAttributeTypeDefGUIDs = new HashMap<String, AttributeTypeDef>();
    private final Map<String, AttributeTypeDef> activeAttributeTypeDefNames = new HashMap<String, AttributeTypeDef>();
    private final Map<String, List<TypeDefLink>> typeDefSuperTypes = new HashMap<String, List<TypeDefLink>>();
    private final Map<String, InstanceType> knownInstanceTypes = new HashMap<String, InstanceType>();
    private final Map<String, String> metadataCollectionNames = new HashMap<String, String>();
    private final Map<String, Set<String>> knownPropertyToTypeDefNames = new HashMap<String, Set<String>>();
    private final AuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryContentManager.class);

    public OMRSRepositoryContentManager(String localServerUserId, AuditLog auditLog) {
        super("Local Repository Content (TypeDef) Manager");
        this.localServerUserId = localServerUserId;
        this.auditLog = auditLog;
    }

    public void setupEventProcessor(LocalOMRSRepositoryConnector localRepositoryConnector, OMRSRepositoryEventManager outboundRepositoryEventManager) {
        if (localRepositoryConnector != null) {
            this.localRepositoryConnector = localRepositoryConnector;
            this.localServerName = localRepositoryConnector.getLocalServerName();
        }
        this.outboundRepositoryEventManager = outboundRepositoryEventManager;
    }

    public void setOpenMetadataTypesOriginGUID(String openMetadataTypesGUID) {
        this.openTypesOriginGUID = openMetadataTypesGUID;
    }

    @Override
    public void addTypeDef(String sourceName, TypeDef newTypeDef) {
        this.cacheTypeDef(sourceName, newTypeDef, true);
    }

    private void cacheTypeDef(String sourceName, TypeDef newTypeDef, boolean isLocallySupported) {
        this.knownTypeDefGUIDs.put(newTypeDef.getGUID(), newTypeDef);
        this.knownTypeDefNames.put(newTypeDef.getName(), newTypeDef);
        if (isLocallySupported) {
            this.activeTypeDefGUIDs.put(newTypeDef.getGUID(), newTypeDef);
            this.activeTypeDefNames.put(newTypeDef.getName(), newTypeDef);
            log.debug("New Active Type {} from {}. Full TypeDef: {}", new Object[]{newTypeDef.getName(), sourceName, newTypeDef});
        } else {
            log.debug("New Known Type {} from {}. Full TypeDef: {}", new Object[]{newTypeDef.getName(), sourceName, newTypeDef});
        }
        this.cacheTypeDefPropertyLookup(sourceName, newTypeDef);
    }

    private void cacheUnsupportedTypeDef(String sourceName, TypeDefPatch typeDefPatch, String methodName) throws InvalidParameterException, PatchErrorException {
        TypeDef originalTypeDef = this.getTypeDefByName(typeDefPatch.getTypeDefName());
        OMRSRepositoryPropertiesUtilities utilities = new OMRSRepositoryPropertiesUtilities();
        TypeDef updatedTypeDef = utilities.applyPatch(sourceName, originalTypeDef, typeDefPatch, methodName);
        this.cacheTypeDef(sourceName, updatedTypeDef, false);
    }

    private void cacheTypeDefPropertyLookup(String sourceName, TypeDef typeDef) {
        String typeDefName = typeDef.getName();
        List propertiesDefinition = typeDef.getPropertiesDefinition();
        if (propertiesDefinition != null) {
            for (TypeDefAttribute property : propertiesDefinition) {
                String propertyName = property.getAttributeName();
                this.knownPropertyToTypeDefNames.computeIfAbsent(propertyName, k -> new HashSet());
                this.knownPropertyToTypeDefNames.get(propertyName).add(typeDefName);
                log.debug("Cached property '{}' from {}, for lookup under TypeDef: {}", new Object[]{propertyName, sourceName, typeDefName});
            }
        }
    }

    private void uncacheTypeDef(String sourceName, String obsoleteTypeDefGUID, String obsoleteTypeDefName, boolean isLocallySupported) {
        this.knownTypeDefGUIDs.remove(obsoleteTypeDefGUID);
        this.knownTypeDefNames.remove(obsoleteTypeDefName);
        if (isLocallySupported) {
            this.activeTypeDefGUIDs.remove(obsoleteTypeDefGUID);
            this.activeTypeDefNames.remove(obsoleteTypeDefName);
        }
        log.debug("Removed Type {} from {}", (Object)obsoleteTypeDefName, (Object)sourceName);
        this.uncacheTypeDefPropertyLookup(sourceName, obsoleteTypeDefName);
    }

    private void uncacheTypeDefPropertyLookup(String sourceName, String typeDefName) {
        for (String propertyName : this.knownPropertyToTypeDefNames.keySet()) {
            boolean removed = this.knownPropertyToTypeDefNames.get(propertyName).remove(typeDefName);
            if (!removed) continue;
            log.debug("Removed Type {} from {}, from reverse-lookup of property: {}", new Object[]{typeDefName, sourceName, propertyName});
        }
    }

    @Override
    public void addAttributeTypeDef(String sourceName, AttributeTypeDef newAttributeTypeDef) {
        this.cacheAttributeTypeDef(sourceName, newAttributeTypeDef, true);
    }

    private void cacheAttributeTypeDef(String sourceName, AttributeTypeDef newAttributeTypeDef, boolean isLocallySupported) {
        this.knownAttributeTypeDefGUIDs.put(newAttributeTypeDef.getGUID(), newAttributeTypeDef);
        this.knownAttributeTypeDefNames.put(newAttributeTypeDef.getName(), newAttributeTypeDef);
        if (isLocallySupported) {
            this.activeAttributeTypeDefGUIDs.put(newAttributeTypeDef.getGUID(), newAttributeTypeDef);
            this.activeAttributeTypeDefNames.put(newAttributeTypeDef.getName(), newAttributeTypeDef);
            if (log.isDebugEnabled()) {
                log.debug("New Active Attribute Type " + newAttributeTypeDef.getName() + " from " + sourceName + ". Full AttributeTypeDef: " + newAttributeTypeDef);
            } else {
                log.debug("New Known Attribute Type " + newAttributeTypeDef.getName() + " from " + sourceName + ". Full AttributeTypeDef: " + newAttributeTypeDef);
            }
        }
    }

    @Override
    public void updateTypeDef(String sourceName, TypeDef typeDef) {
        this.cacheTypeDef(sourceName, typeDef, true);
    }

    @Override
    public void deleteTypeDef(String sourceName, String obsoleteTypeDefGUID, String obsoleteTypeDefName) {
        if (this.validTypeId(sourceName, obsoleteTypeDefGUID, obsoleteTypeDefName)) {
            this.knownTypeDefGUIDs.remove(obsoleteTypeDefGUID);
            this.knownTypeDefNames.remove(obsoleteTypeDefName);
            if (this.localRepositoryConnector != null) {
                this.activeTypeDefGUIDs.remove(obsoleteTypeDefGUID);
                this.activeTypeDefNames.remove(obsoleteTypeDefName);
                log.debug("Deleted Active TypeDef " + obsoleteTypeDefName + " from " + sourceName);
            }
        }
    }

    @Override
    public void deleteAttributeTypeDef(String sourceName, String obsoleteAttributeTypeDefGUID, String obsoleteAttributeTypeDefName) {
        if (this.validTypeId(sourceName, obsoleteAttributeTypeDefGUID, obsoleteAttributeTypeDefName)) {
            this.knownAttributeTypeDefGUIDs.remove(obsoleteAttributeTypeDefGUID);
            this.knownAttributeTypeDefNames.remove(obsoleteAttributeTypeDefName);
            if (this.localRepositoryConnector != null) {
                this.activeAttributeTypeDefGUIDs.remove(obsoleteAttributeTypeDefGUID);
                this.activeAttributeTypeDefNames.remove(obsoleteAttributeTypeDefName);
                if (log.isDebugEnabled()) {
                    log.debug("Deleted Active AttributeTypeDef " + obsoleteAttributeTypeDefName + " from " + sourceName);
                }
            }
        }
    }

    @Override
    public void reIdentifyTypeDef(String sourceName, String originalTypeDefGUID, String originalTypeDefName, TypeDef newTypeDef) {
        this.deleteTypeDef(sourceName, originalTypeDefGUID, originalTypeDefName);
        this.addTypeDef(sourceName, newTypeDef);
    }

    @Override
    public void reIdentifyAttributeTypeDef(String sourceName, String originalAttributeTypeDefGUID, String originalAttributeTypeDefName, AttributeTypeDef newAttributeTypeDef) {
        this.deleteAttributeTypeDef(sourceName, originalAttributeTypeDefGUID, originalAttributeTypeDefName);
        this.addAttributeTypeDef(sourceName, newAttributeTypeDef);
    }

    private List<String> getPropertyNames(String sourceName, TypeDef typeDef, String methodName) throws TypeErrorException {
        String thisMethodName = "getPropertyNames";
        ArrayList<String> propertyNames = null;
        if (this.validTypeDef(sourceName, typeDef)) {
            List propertiesDefinition = typeDef.getPropertiesDefinition();
            if (propertiesDefinition != null && propertiesDefinition.size() > 0) {
                propertyNames = new ArrayList<String>();
                for (TypeDefAttribute propertyDefinition : propertiesDefinition) {
                    if (propertyDefinition != null) {
                        String propertyName = propertyDefinition.getAttributeName();
                        if (propertyName != null) {
                            log.debug(typeDef.getName() + " from " + sourceName + " has property " + propertyName);
                            propertyNames.add(propertyName);
                            continue;
                        }
                        throw new TypeErrorException(OMRSErrorCode.BAD_TYPEDEF_ATTRIBUTE_NAME.getMessageDefinition(new String[]{sourceName}), this.getClass().getName(), methodName);
                    }
                    throw new TypeErrorException(OMRSErrorCode.NULL_TYPEDEF_ATTRIBUTE.getMessageDefinition(new String[]{sourceName}), this.getClass().getName(), methodName);
                }
                if (propertyNames.size() == 0) {
                    propertyNames = null;
                }
            }
        } else {
            throw new TypeErrorException(OMRSErrorCode.BAD_TYPEDEF.getMessageDefinition(new String[]{"getPropertyNames", typeDef.getName(), sourceName, methodName}), this.getClass().getName(), methodName);
        }
        return propertyNames;
    }

    private List<TypeDefLink> getSuperTypes(String sourceName, String typeName, String methodName) {
        String thisMethodName = "getSuperTypes";
        List<TypeDefLink> typeHierarchy = this.typeDefSuperTypes.get(typeName);
        if (typeHierarchy == null) {
            typeHierarchy = new ArrayList<TypeDefLink>();
            TypeDef typeDef = this.knownTypeDefNames.get(typeName);
            if (typeDef != null) {
                TypeDefLink superTypeLink = typeDef.getSuperType();
                while (superTypeLink != null) {
                    String superTypeName = superTypeLink.getName();
                    if (superTypeName != null) {
                        log.debug(typeName + " has super type " + superTypeName);
                        typeHierarchy.add(superTypeLink);
                        TypeDef superTypeDef = this.knownTypeDefNames.get(superTypeName);
                        if (superTypeDef != null) {
                            superTypeLink = superTypeDef.getSuperType();
                            continue;
                        }
                        log.error(superTypeName + " supertype is not known in TypeDef cache");
                        this.throwContentManagerLogicError(sourceName, methodName, "getSuperTypes");
                        continue;
                    }
                    log.error("Corrupted TypeDef cache, no name for " + superTypeLink);
                    this.throwContentManagerLogicError(sourceName, methodName, "getSuperTypes");
                }
                this.typeDefSuperTypes.put(typeName, typeHierarchy);
            } else {
                log.error(typeName + " type is not known in TypeDef cache");
                this.throwContentManagerLogicError(sourceName, methodName, "getSuperTypes(" + typeName + ")");
            }
        }
        if (typeHierarchy.isEmpty()) {
            return null;
        }
        return typeHierarchy;
    }

    boolean isTypeOf(String sourceName, String actualTypeName, String expectedTypeName) {
        String methodName = "isTypeOf";
        log.debug("isTypeOf: sourceName = " + sourceName + "; actualTypeName = " + actualTypeName + "; expectedTypeName = " + expectedTypeName);
        if (expectedTypeName == null) {
            return true;
        }
        if (actualTypeName == null) {
            return false;
        }
        if (actualTypeName.equals(expectedTypeName)) {
            log.debug("Simple match success");
            return true;
        }
        List<TypeDefLink> typeHierarchy = this.getSuperTypes(sourceName, actualTypeName, "isTypeOf");
        if (typeHierarchy != null) {
            for (TypeDefLink superType : typeHierarchy) {
                if (superType == null) continue;
                if (expectedTypeName.equals(superType.getName())) {
                    log.debug("SuperType match success");
                    return true;
                }
                log.debug("No match with " + superType.getName());
            }
        }
        return false;
    }

    boolean isTypeOfByGUID(String sourceName, String actualTypeGUID, String actualTypeName, String expectedTypeGUID) {
        String methodName = "isTypeOfByGUID";
        log.debug("IsTypeOfByGUID: sourceName = " + sourceName + "; actualTypeName = " + actualTypeName + "; expectedTypeGUID = " + expectedTypeGUID);
        if (expectedTypeGUID == null) {
            log.debug("Any type will do");
            return true;
        }
        if (actualTypeGUID == null) {
            log.debug("No type to test against");
            return false;
        }
        if (actualTypeGUID.equals(expectedTypeGUID)) {
            log.debug("Simple match success");
            return true;
        }
        List<TypeDefLink> typeHierarchy = this.getSuperTypes(sourceName, actualTypeName, "isTypeOfByGUID");
        if (typeHierarchy != null) {
            for (TypeDefLink superType : typeHierarchy) {
                if (superType == null) continue;
                if (expectedTypeGUID.equals(superType.getGUID())) {
                    log.debug("SuperType match success");
                    return true;
                }
                log.debug("No match with " + superType.getGUID());
            }
        }
        return false;
    }

    @Override
    public InstanceType getInstanceType(String sourceName, TypeDefCategory category, String typeName, String methodName) throws TypeErrorException {
        String thisMethodName = "getInstanceType";
        if (this.isValidTypeCategory(sourceName, category, typeName, methodName)) {
            InstanceType instanceType = this.knownInstanceTypes.get(typeName);
            if (instanceType != null) {
                return instanceType;
            }
            TypeDef typeDef = this.knownTypeDefNames.get(typeName);
            if (typeDef != null) {
                List<String> propertyNames;
                instanceType = new InstanceType();
                instanceType.setHeaderVersion(1L);
                instanceType.setTypeDefCategory(category);
                instanceType.setTypeDefGUID(typeDef.getGUID());
                instanceType.setTypeDefName(typeDef.getName());
                instanceType.setTypeDefVersion(typeDef.getVersion());
                instanceType.setTypeDefDescription(typeDef.getDescription());
                instanceType.setTypeDefDescriptionGUID(typeDef.getDescriptionGUID());
                instanceType.setTypeDefSuperTypes(this.getSuperTypes(sourceName, typeName, methodName));
                if (typeDef.getValidInstanceStatusList() != null) {
                    instanceType.setValidStatusList(typeDef.getValidInstanceStatusList());
                }
                if ((propertyNames = this.getPropertyNames(sourceName, typeDef, methodName)) == null) {
                    propertyNames = new ArrayList<String>();
                }
                TypeDefLink superTypeLink = typeDef.getSuperType();
                while (superTypeLink != null) {
                    String superTypeName = superTypeLink.getName();
                    if (superTypeName != null) {
                        log.debug(typeName + " from " + sourceName + " has super type " + superTypeName);
                        TypeDef superTypeDef = this.knownTypeDefNames.get(superTypeName);
                        if (superTypeDef != null) {
                            List<String> superTypePropertyNames = this.getPropertyNames(sourceName, superTypeDef, methodName);
                            if (superTypePropertyNames != null) {
                                propertyNames.addAll(0, superTypePropertyNames);
                            }
                            superTypeLink = superTypeDef.getSuperType();
                            continue;
                        }
                        log.error(superTypeName + " is not known");
                        this.throwContentManagerLogicError(sourceName, methodName, "getInstanceType");
                        continue;
                    }
                    log.error("Corrupted TypeDef cache");
                    this.throwContentManagerLogicError(sourceName, methodName, "getInstanceType");
                }
                if (propertyNames.size() > 0) {
                    instanceType.setValidInstanceProperties(propertyNames);
                }
                this.knownInstanceTypes.put(typeName, instanceType);
                return instanceType;
            }
        } else {
            throw new TypeErrorException(OMRSErrorCode.BAD_CATEGORY_FOR_TYPEDEF_ATTRIBUTE.getMessageDefinition(new String[]{sourceName, typeName, category.getName()}), this.getClass().getName(), methodName);
        }
        log.error("TypeDef " + typeName + " should already have been validated");
        this.throwContentManagerLogicError(sourceName, methodName, "getInstanceType");
        return null;
    }

    @Override
    public boolean isValidTypeCategory(String sourceName, TypeDefCategory category, String typeName, String methodName) throws TypeErrorException {
        String thisMethodName = "isValidTypeCategory";
        if (category == null) {
            this.throwContentManagerLogicError(sourceName, methodName, "isValidTypeCategory");
            return false;
        }
        if (typeName == null) {
            this.throwContentManagerLogicError(sourceName, methodName, "isValidTypeCategory");
            return false;
        }
        TypeDef typeDef = this.knownTypeDefNames.get(typeName);
        if (typeDef != null) {
            TypeDefCategory retrievedTypeDefCategory = typeDef.getCategory();
            if (retrievedTypeDefCategory != null) {
                return category.getOrdinal() == retrievedTypeDefCategory.getOrdinal();
            }
        } else {
            throw new TypeErrorException(OMRSErrorCode.TYPEDEF_NOT_KNOWN_FOR_INSTANCE.getMessageDefinition(new String[]{typeName, category.getName(), methodName, sourceName}), this.getClass().getName(), methodName);
        }
        this.throwContentManagerLogicError(sourceName, methodName, "isValidTypeCategory");
        return false;
    }

    @Override
    public boolean isValidClassificationForEntity(String sourceName, String classificationTypeName, String entityTypeName, String methodName) {
        String thisMethodName = "isValidClassificationForEntity";
        try {
            if (this.isValidTypeCategory(sourceName, TypeDefCategory.CLASSIFICATION_DEF, classificationTypeName, methodName) && this.isValidTypeCategory(sourceName, TypeDefCategory.ENTITY_DEF, entityTypeName, methodName)) {
                ClassificationDef classificationTypeDef = (ClassificationDef)this.knownTypeDefNames.get(classificationTypeName);
                if (classificationTypeDef != null) {
                    List entityDefs = classificationTypeDef.getValidEntityDefs();
                    if (entityDefs == null || entityDefs.isEmpty()) {
                        return true;
                    }
                    HashSet<String> entityTypes = new HashSet<String>();
                    TypeDef typeDef = this.getTypeDefByName(entityTypeName);
                    entityTypes.add(entityTypeName);
                    while (typeDef.getSuperType() != null) {
                        TypeDefLink superTypeLink = typeDef.getSuperType();
                        String parentName = superTypeLink.getName();
                        entityTypes.add(parentName);
                        typeDef = this.knownTypeDefGUIDs.get(superTypeLink.getGUID());
                    }
                    for (TypeDefLink allowedEntityDefLink : entityDefs) {
                        String allowedTypeName;
                        if (allowedEntityDefLink == null || !entityTypes.contains(allowedTypeName = allowedEntityDefLink.getName())) continue;
                        return true;
                    }
                    return false;
                }
                this.throwContentManagerLogicError(sourceName, methodName, "isValidClassificationForEntity");
                return false;
            }
            return false;
        }
        catch (ClassCastException | TypeErrorException typeError) {
            this.throwContentManagerLogicError(sourceName, methodName, "isValidClassificationForEntity");
            return false;
        }
    }

    private TypeDef getTypeDefFromCache(String sourceName, String typeName, String thisMethodName, String originalMethodName) throws TypeErrorException {
        TypeDef typeDef;
        if (typeName == null) {
            this.throwContentManagerLogicError(sourceName, thisMethodName, originalMethodName);
        }
        if ((typeDef = this.knownTypeDefNames.get(typeName)) == null) {
            throw new TypeErrorException(OMRSErrorCode.TYPEDEF_NAME_NOT_KNOWN.getMessageDefinition(new String[]{typeName, originalMethodName, sourceName}), this.getClass().getName(), originalMethodName);
        }
        return typeDef;
    }

    @Override
    public InstanceStatus getInitialStatus(String sourceName, String typeName, String methodName) throws TypeErrorException {
        String thisMethodName = "getInitialStatus";
        TypeDef typeDef = this.getTypeDefFromCache(sourceName, typeName, "getInitialStatus", methodName);
        return typeDef.getInitialStatus();
    }

    @Override
    public String getEntityURL(String sourceName, String guid) {
        return OMRSRepositoryRESTServices.getEntityURL(this.localServerName, guid);
    }

    @Override
    public String getRelationshipURL(String sourceName, String guid) {
        return OMRSRepositoryRESTServices.getRelationshipURL(this.localServerName, guid);
    }

    TypeDefGallery getActiveTypeDefGallery() {
        TypeDefGallery typeDefGallery = new TypeDefGallery();
        if (!this.activeAttributeTypeDefNames.isEmpty()) {
            typeDefGallery.setAttributeTypeDefs(new ArrayList<AttributeTypeDef>(this.activeAttributeTypeDefNames.values()));
        }
        if (!this.activeTypeDefNames.isEmpty()) {
            typeDefGallery.setTypeDefs(new ArrayList<TypeDef>(this.activeTypeDefNames.values()));
        }
        return typeDefGallery;
    }

    List<TypeDef> getActiveTypeDefs() {
        ArrayList<TypeDef> results = null;
        if (!this.activeTypeDefGUIDs.isEmpty()) {
            results = new ArrayList<TypeDef>(this.activeTypeDefGUIDs.values());
        }
        return results;
    }

    List<AttributeTypeDef> getActiveAttributeTypeDefs() {
        ArrayList<AttributeTypeDef> results = null;
        if (!this.activeAttributeTypeDefGUIDs.isEmpty()) {
            results = new ArrayList<AttributeTypeDef>(this.activeAttributeTypeDefGUIDs.values());
        }
        return results;
    }

    TypeDefGallery getKnownTypeDefGallery() {
        TypeDefGallery typeDefGallery = new TypeDefGallery();
        if (!this.knownAttributeTypeDefNames.isEmpty()) {
            typeDefGallery.setAttributeTypeDefs(new ArrayList<AttributeTypeDef>(this.knownAttributeTypeDefNames.values()));
        }
        if (!this.knownTypeDefNames.isEmpty()) {
            typeDefGallery.setTypeDefs(new ArrayList<TypeDef>(this.knownTypeDefNames.values()));
        }
        return typeDefGallery;
    }

    List<TypeDef> getKnownTypeDefs() {
        ArrayList<TypeDef> results = null;
        if (!this.knownTypeDefGUIDs.isEmpty()) {
            results = new ArrayList<TypeDef>(this.knownTypeDefGUIDs.values());
        }
        return results;
    }

    List<AttributeTypeDef> getKnownAttributeTypeDefs() {
        ArrayList<AttributeTypeDef> results = null;
        if (!this.knownAttributeTypeDefGUIDs.isEmpty()) {
            results = new ArrayList<AttributeTypeDef>(this.knownAttributeTypeDefGUIDs.values());
        }
        return results;
    }

    TypeDef getTypeDefByName(String typeDefName) {
        return this.knownTypeDefNames.get(typeDefName);
    }

    AttributeTypeDef getAttributeTypeDefByName(String attributeTypeDefName) {
        return this.knownAttributeTypeDefNames.get(attributeTypeDefName);
    }

    TypeDef getTypeDef(String sourceName, String guidParameterName, String typeDefGUID, String methodName) throws TypeErrorException {
        String thisMethodName = "getTypeDef";
        if (typeDefGUID != null) {
            TypeDef typeDef = this.knownTypeDefGUIDs.get(typeDefGUID);
            if (typeDef == null) {
                throw new TypeErrorException(OMRSErrorCode.TYPEDEF_ID_NOT_KNOWN.getMessageDefinition(new String[]{typeDefGUID, guidParameterName, methodName, sourceName}), this.getClass().getName(), methodName);
            }
            return typeDef;
        }
        this.throwContentManagerLogicError(sourceName, methodName, "getTypeDef");
        return null;
    }

    AttributeTypeDef getAttributeTypeDef(String sourceName, String attributeTypeDefGUID, String methodName) throws TypeErrorException {
        String thisMethodName = "getAttributeTypeDef";
        if (attributeTypeDefGUID != null) {
            AttributeTypeDef attributeTypeDef = this.knownAttributeTypeDefGUIDs.get(attributeTypeDefGUID);
            if (attributeTypeDef == null) {
                throw new TypeErrorException(OMRSErrorCode.BAD_TYPEDEF.getMessageDefinition(new String[]{"getAttributeTypeDef", attributeTypeDefGUID, sourceName, methodName}), this.getClass().getName(), methodName);
            }
            return attributeTypeDef;
        }
        this.throwContentManagerLogicError(sourceName, methodName, "getAttributeTypeDef");
        return null;
    }

    TypeDef getTypeDef(String sourceName, String guidParameterName, String nameParameterName, String typeDefGUID, String typeDefName, String methodName) throws TypeErrorException {
        if (this.validTypeId(sourceName, typeDefGUID, typeDefName)) {
            return this.knownTypeDefNames.get(typeDefName);
        }
        throw new TypeErrorException(OMRSErrorCode.UNKNOWN_TYPEDEF.getMessageDefinition(new String[]{typeDefName, typeDefGUID, sourceName, methodName, nameParameterName, guidParameterName}), this.getClass().getName(), methodName);
    }

    AttributeTypeDef getAttributeTypeDef(String sourceName, String attributeTypeDefGUID, String attributeTypeDefName, String methodName) throws TypeErrorException {
        String thisMethodName = "getAttributeTypeDef";
        if (this.validTypeId(sourceName, attributeTypeDefGUID, attributeTypeDefName)) {
            return this.knownAttributeTypeDefNames.get(attributeTypeDefName);
        }
        throw new TypeErrorException(OMRSErrorCode.BAD_TYPEDEF.getMessageDefinition(new String[]{"getAttributeTypeDef", attributeTypeDefName, sourceName, methodName}), this.getClass().getName(), methodName);
    }

    InstanceProperties addEnumPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, String enumTypeGUID, String enumTypeName, int ordinal, String methodName) throws TypeErrorException {
        EnumDef enumDef;
        List enumDefValues;
        InstanceProperties resultingProperties;
        String thisMethodName = "addEnumPropertyToInstance";
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        AttributeTypeDef attributeTypeDef = this.getAttributeTypeDef(sourceName, enumTypeGUID, enumTypeName, methodName);
        if (attributeTypeDef instanceof EnumDef && (enumDefValues = (enumDef = (EnumDef)attributeTypeDef).getElementDefs()) != null) {
            for (EnumElementDef enumElementDef : enumDefValues) {
                if (enumElementDef == null || enumElementDef.getOrdinal() != ordinal) continue;
                EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
                enumPropertyValue.setOrdinal(ordinal);
                enumPropertyValue.setSymbolicName(enumElementDef.getValue());
                enumPropertyValue.setDescription(enumElementDef.getDescription());
                resultingProperties.setProperty(propertyName, (InstancePropertyValue)enumPropertyValue);
                return resultingProperties;
            }
        }
        throw new TypeErrorException(OMRSErrorCode.BAD_TYPEDEF.getMessageDefinition(new String[]{"addEnumPropertyToInstance", enumTypeName, sourceName, methodName}), this.getClass().getName(), methodName);
    }

    List<TypeDefAttribute> getAllPropertiesForTypeDef(String sourceName, TypeDef typeDef, String methodName) {
        String thisMethodName = "getAllPropertiesForTypeDef";
        if (typeDef == null) {
            this.throwContentManagerLogicError(sourceName, methodName, "getAllPropertiesForTypeDef");
            return null;
        }
        ArrayList<TypeDefAttribute> propertiesDefinition = typeDef.getPropertiesDefinition();
        if (propertiesDefinition == null) {
            propertiesDefinition = new ArrayList<TypeDefAttribute>();
        }
        TypeDefLink superTypeLink = typeDef.getSuperType();
        while (superTypeLink != null) {
            TypeDef superTypeDef = this.knownTypeDefGUIDs.get(superTypeLink.getGUID());
            List superTypePropertiesDefinition = superTypeDef.getPropertiesDefinition();
            if (superTypePropertiesDefinition != null) {
                propertiesDefinition.addAll(superTypePropertiesDefinition);
            }
            superTypeLink = superTypeDef.getSuperType();
        }
        return propertiesDefinition;
    }

    Set<String> getAllTypeDefsForProperty(String sourceName, String propertyName, String methodName) {
        String thisMethodName = "getAllTypeDefsForProperty";
        if (propertyName == null) {
            this.throwContentManagerLogicError(sourceName, methodName, "getAllTypeDefsForProperty");
            return null;
        }
        return this.knownPropertyToTypeDefNames.getOrDefault(propertyName, null);
    }

    void validateEnterpriseTypeDefs(String sourceName, List<TypeDef> typeDefs, String methodName) throws RepositoryErrorException {
        for (TypeDef typeDef : typeDefs) {
            if (this.validTypeId(sourceName, typeDef.getGUID(), typeDef.getName())) {
                if (this.isKnownType(sourceName, typeDef.getGUID(), typeDef.getName())) continue;
                this.knownTypeDefNames.put(typeDef.getName(), typeDef);
                continue;
            }
            throw new RepositoryErrorException(OMRSErrorCode.CONFLICTING_ENTERPRISE_TYPEDEFS.getMessageDefinition(), this.getClass().getName(), methodName);
        }
    }

    void validateEnterpriseAttributeTypeDefs(String sourceName, List<AttributeTypeDef> attributeTypeDefs, String methodName) throws RepositoryErrorException {
        for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
            if (this.validTypeId(sourceName, attributeTypeDef.getGUID(), attributeTypeDef.getName())) {
                if (this.isKnownType(sourceName, attributeTypeDef.getGUID(), attributeTypeDef.getName())) continue;
                this.knownAttributeTypeDefNames.put(attributeTypeDef.getName(), attributeTypeDef);
                continue;
            }
            throw new RepositoryErrorException(OMRSErrorCode.CONFLICTING_ENTERPRISE_TYPEDEFS.getMessageDefinition(), this.getClass().getName(), methodName);
        }
    }

    boolean isOpenType(String sourceName, String typeGUID, String typeName) {
        if (this.validTypeId(sourceName, typeGUID, typeName)) {
            TypeDef typeDef = this.knownTypeDefNames.get(typeName);
            if (typeDef == null) {
                return false;
            }
            if (this.openTypesOriginGUID != null) {
                if (this.openTypesOriginGUID.equals(typeDef.getOrigin())) {
                    log.debug("TypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName + " is an open type");
                    return true;
                }
                log.debug("TypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName + " is NOT an open type");
            }
        }
        return false;
    }

    boolean isOpenTypeId(String typeGUID) {
        TypeDef typeDef;
        if (typeGUID != null && (typeDef = this.knownTypeDefGUIDs.get(typeGUID)) != null) {
            String originGUID = typeDef.getOrigin();
            return this.openTypesOriginGUID.equals(originGUID);
        }
        return false;
    }

    boolean isKnownType(String sourceName, String typeGUID, String typeName) {
        if (this.validTypeId(sourceName, typeGUID, typeName)) {
            TypeDef typeDef = this.knownTypeDefNames.get(typeName);
            if (typeDef == null) {
                AttributeTypeDef attributeTypeDef = this.knownAttributeTypeDefNames.get(typeName);
                if (attributeTypeDef == null) {
                    log.debug("Unknown (Attribute)TypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName);
                    return false;
                }
                log.debug("Known AttributeTypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName);
                return true;
            }
            log.debug("Known TypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName);
            return true;
        }
        log.debug("Invalid TypeDef  from " + sourceName + " so can not validate known type");
        return false;
    }

    boolean isKnownTypeId(String typeGUID) {
        if (typeGUID != null) {
            if (this.knownTypeDefGUIDs.get(typeGUID) != null) {
                return true;
            }
            return this.knownAttributeTypeDefGUIDs.get(typeGUID) != null;
        }
        return false;
    }

    boolean isActiveType(String sourceName, String typeGUID, String typeName) {
        if (this.validTypeId(sourceName, typeGUID, typeName)) {
            TypeDef typeDef = this.activeTypeDefNames.get(typeName);
            if (typeDef == null) {
                AttributeTypeDef attributeTypeDef = this.activeAttributeTypeDefNames.get(typeName);
                if (attributeTypeDef == null) {
                    log.debug("Inactive (Attribute)TypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName);
                    return false;
                }
                log.debug("Active AttributeTypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName);
                return true;
            }
            log.debug("Active TypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName);
            return true;
        }
        log.debug("Invalid TypeDef  from " + sourceName + " so can not validate active type");
        return false;
    }

    boolean isActiveTypeId(String typeGUID) {
        if (typeGUID != null) {
            if (this.activeTypeDefGUIDs.get(typeGUID) != null) {
                return true;
            }
            return this.activeAttributeTypeDefGUIDs.get(typeGUID) != null;
        }
        return false;
    }

    boolean validTypeId(String sourceName, String typeGUID, String typeName) {
        if (typeName == null) {
            this.logNullTypeName(sourceName, typeGUID);
            return false;
        }
        if (typeGUID == null) {
            this.logNullTypeGUID(sourceName, typeName);
            return false;
        }
        TypeDef typeDef = this.knownTypeDefNames.get(typeName);
        if (typeDef != null) {
            if (!typeGUID.equals(typeDef.getGUID())) {
                this.logTypeGUIDMismatch(sourceName, typeGUID, typeName, typeDef.getGUID(), typeDef.getName());
                return false;
            }
            log.debug("Valid TypeDef of " + typeName + " from " + sourceName);
            return true;
        }
        AttributeTypeDef attributeTypeDef = this.knownAttributeTypeDefNames.get(typeName);
        if (attributeTypeDef == null) {
            return false;
        }
        if (!typeGUID.equals(attributeTypeDef.getGUID())) {
            this.logTypeGUIDMismatch(sourceName, typeGUID, typeName, attributeTypeDef.getGUID(), attributeTypeDef.getName());
            return false;
        }
        log.debug("Valid AttributeTypeDef " + typeName + " from " + sourceName);
        return true;
    }

    private void logUnknownType(String sourceName, String requestedTypeGUID, String requestedTypeName) {
        String actionDescription = "validate type identifier";
        this.auditLog.logMessage("validate type identifier", OMRSAuditCode.UNKNOWN_TYPE.getMessageDefinition(new String[]{sourceName, requestedTypeName, requestedTypeGUID}));
    }

    private void logNullTypeName(String sourceName, String requestedTypeGUID) {
        String actionDescription = "validate type identifier";
        this.auditLog.logMessage("validate type identifier", OMRSAuditCode.NULL_TYPE_NAME.getMessageDefinition(new String[]{sourceName, requestedTypeGUID}));
    }

    private void logNullTypeGUID(String sourceName, String requestedTypeName) {
        String actionDescription = "validate type identifier";
        this.auditLog.logMessage("validate type identifier", OMRSAuditCode.NULL_TYPE_IDENTIFIER.getMessageDefinition(new String[]{requestedTypeName, sourceName}));
    }

    private void logTypeGUIDMismatch(String sourceName, String requestedTypeGUID, String requestedTypeName, String localTypeGUID, String localTypeName) {
        String actionDescription = "validate type identifier";
        this.auditLog.logMessage("validate type identifier", OMRSAuditCode.TYPE_IDENTIFIER_MISMATCH.getMessageDefinition(new String[]{localTypeName, localTypeGUID, requestedTypeName, requestedTypeGUID, sourceName}));
    }

    void logNullInstanceGUID(String sourceName, String typeDefGUID, String typeDefName, TypeDefCategory category) {
        String actionDescription = "validate type identifiers and category";
        this.auditLog.logMessage("validate type identifiers and category", OMRSAuditCode.NULL_INSTANCE_ID.getMessageDefinition(new String[]{sourceName, typeDefName, typeDefGUID, category.getName()}));
    }

    void logNullInstance(String sourceName, String methodName) {
        String actionDescription = "validate request parameters";
        this.auditLog.logMessage("validate request parameters", OMRSAuditCode.NULL_INSTANCE.getMessageDefinition(new String[]{methodName, sourceName}));
    }

    boolean validTypeDefId(String sourceName, String typeDefGUID, String typeDefName, TypeDefCategory category) {
        if (!this.validTypeId(sourceName, typeDefGUID, typeDefName)) {
            return false;
        }
        if (category == null) {
            this.logNullTypeCategory(sourceName, typeDefGUID, typeDefName);
            return false;
        }
        TypeDef typeDef = this.knownTypeDefNames.get(typeDefName);
        if (typeDef != null) {
            TypeDefCategory knownTypeDefCategory = typeDef.getCategory();
            if (category.getOrdinal() != knownTypeDefCategory.getOrdinal()) {
                this.logUnknownTypeCategory(sourceName, typeDefGUID, typeDefName, category.getName(), knownTypeDefCategory.getName());
                return false;
            }
        }
        return true;
    }

    private void logNullTypeCategory(String sourceName, String typeDefGUID, String typeDefName) {
        String actionDescription = "validate type identifiers and category";
        this.auditLog.logMessage("validate type identifiers and category", OMRSAuditCode.NULL_TYPE_CATEGORY.getMessageDefinition(new String[]{sourceName, typeDefName, typeDefGUID}));
    }

    private void logUnknownTypeCategory(String sourceName, String typeDefGUID, String typeDefName, String category, String localTypeCategory) {
        String actionDescription = "validate type identifiers and category";
        this.auditLog.logMessage("validate type identifiers and category", OMRSAuditCode.UNKNOWN_TYPE_CATEGORY.getMessageDefinition(new String[]{sourceName, typeDefName, typeDefGUID, category, localTypeCategory}));
    }

    private void logVersionMismatch(String sourceName, String typeDefGUID, String typeDefName, String category, String versionName, String localVersionName) {
        String actionDescription = "validate type identifiers and category";
        this.auditLog.logMessage("validate type identifiers and category", OMRSAuditCode.TYPE_VERSION_MISMATCH.getMessageDefinition(new String[]{sourceName, typeDefName, typeDefGUID, category, versionName, localVersionName}));
    }

    void logNullMetadataCollectionId(String sourceName, String typeDefGUID, String typeDefName, String category, String instanceGUID, String methodName) {
        String actionDescription = "validate type identifiers and category";
        this.auditLog.logMessage("validate type identifiers and category", OMRSAuditCode.NULL_METADATA_COLLECTION_ID.getMessageDefinition(new String[]{methodName, sourceName, instanceGUID, typeDefName, typeDefGUID, category}));
    }

    void logNullType(String sourceName, String methodName) {
        String actionDescription = "validate type object";
        this.auditLog.logMessage("validate type object", OMRSAuditCode.NULL_TYPE.getMessageDefinition(new String[]{methodName, sourceName}));
    }

    boolean validAttributeTypeDefId(String sourceName, String attributeTypeDefGUID, String attributeTypeDefName, AttributeTypeDefCategory category) {
        if (!this.validTypeId(sourceName, attributeTypeDefGUID, attributeTypeDefName)) {
            return false;
        }
        if (category == null) {
            this.logNullTypeCategory(sourceName, attributeTypeDefGUID, attributeTypeDefName);
            return false;
        }
        AttributeTypeDef attributeTypeDef = this.knownAttributeTypeDefNames.get(attributeTypeDefName);
        if (attributeTypeDef != null) {
            AttributeTypeDefCategory knownAttributeTypeDefCategory = attributeTypeDef.getCategory();
            if (category.getOrdinal() != knownAttributeTypeDefCategory.getOrdinal()) {
                this.logUnknownTypeCategory(sourceName, attributeTypeDefGUID, attributeTypeDefName, category.getName(), knownAttributeTypeDefCategory.getName());
                return false;
            }
        }
        return true;
    }

    boolean validTypeDefId(String sourceName, String typeDefGUID, String typeDefName, String typeDefVersion, TypeDefCategory typeDefCategory) {
        if (!this.validTypeDefId(sourceName, typeDefGUID, typeDefName, typeDefCategory)) {
            return false;
        }
        TypeDef typeDef = this.knownTypeDefNames.get(typeDefName);
        if (typeDef == null) {
            log.debug("Unknown TypeDef " + typeDefName + " (GUID = " + typeDefGUID + ") from " + sourceName);
            return true;
        }
        if (!typeDef.getVersionName().equals(typeDefVersion)) {
            this.logVersionMismatch(sourceName, typeDefGUID, typeDefName, typeDefCategory.getName(), typeDefVersion, typeDef.getVersionName());
            return false;
        }
        return true;
    }

    boolean validAttributeTypeDefId(String sourceName, String attributeTypeDefGUID, String attributeTypeDefName, String attributeTypeDefVersion, AttributeTypeDefCategory category) {
        if (!this.validAttributeTypeDefId(sourceName, attributeTypeDefGUID, attributeTypeDefName, category)) {
            return false;
        }
        AttributeTypeDef attributeTypeDef = this.knownAttributeTypeDefNames.get(attributeTypeDefName);
        if (attributeTypeDef == null) {
            log.debug("Unknown TypeDef " + attributeTypeDefName + " (GUID = " + attributeTypeDefGUID + ") from " + sourceName);
            return true;
        }
        if (!attributeTypeDef.getVersionName().equals(attributeTypeDefVersion)) {
            this.logVersionMismatch(sourceName, attributeTypeDefGUID, attributeTypeDefName, category.getName(), attributeTypeDefVersion, attributeTypeDef.getVersionName());
            return false;
        }
        return true;
    }

    boolean validTypeDef(String sourceName, TypeDef typeDef) {
        String methodName = "validTypeDef";
        if (typeDef == null) {
            this.logNullType(sourceName, "validTypeDef");
            return false;
        }
        return this.validTypeDefId(sourceName, typeDef.getGUID(), typeDef.getName(), typeDef.getVersionName(), typeDef.getCategory());
    }

    boolean validAttributeTypeDef(String sourceName, AttributeTypeDef attributeTypeDef) {
        String methodName = "validAttributeTypeDef";
        if (attributeTypeDef == null) {
            this.logNullType(sourceName, "validAttributeTypeDef");
            return false;
        }
        return this.validAttributeTypeDefId(sourceName, attributeTypeDef.getGUID(), attributeTypeDef.getName(), attributeTypeDef.getCategory());
    }

    boolean validTypeDefSummary(String sourceName, TypeDefSummary typeDefSummary) {
        String methodName = "validTypeDefSummary";
        if (typeDefSummary == null) {
            this.logNullType(sourceName, "validTypeDefSummary");
            return false;
        }
        return this.validTypeDefId(sourceName, typeDefSummary.getGUID(), typeDefSummary.getName(), typeDefSummary.getVersionName(), typeDefSummary.getCategory());
    }

    public void sendTypeDefEvent(String cohortName, OMRSTypeDefEvent typeDefEvent) {
        OMRSTypeDefEventType typeDefEventType = typeDefEvent.getTypeDefEventType();
        OMRSEventOriginator typeDefEventOriginator = typeDefEvent.getEventOriginator();
        if (typeDefEventType != null && typeDefEventOriginator != null) {
            block0 : switch (typeDefEventType) {
                case NEW_TYPEDEF_EVENT: {
                    this.processNewTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTypeDef());
                    break;
                }
                case NEW_ATTRIBUTE_TYPEDEF_EVENT: {
                    this.processNewAttributeTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getAttributeTypeDef());
                    break;
                }
                case UPDATED_TYPEDEF_EVENT: {
                    this.processUpdatedTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTypeDefPatch());
                    break;
                }
                case DELETED_TYPEDEF_EVENT: {
                    this.processDeletedTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTypeDefGUID(), typeDefEvent.getTypeDefName());
                    break;
                }
                case DELETED_ATTRIBUTE_TYPEDEF_EVENT: {
                    this.processDeletedAttributeTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTypeDefGUID(), typeDefEvent.getTypeDefName());
                    break;
                }
                case RE_IDENTIFIED_TYPEDEF_EVENT: {
                    this.processReIdentifiedTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getOriginalTypeDefSummary(), typeDefEvent.getTypeDef());
                    break;
                }
                case RE_IDENTIFIED_ATTRIBUTE_TYPEDEF_EVENT: {
                    this.processReIdentifiedAttributeTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getOriginalAttributeTypeDef(), typeDefEvent.getAttributeTypeDef());
                    break;
                }
                case TYPEDEF_ERROR_EVENT: {
                    OMRSTypeDefEventErrorCode errorCode = typeDefEvent.getErrorCode();
                    if (errorCode != null) {
                        switch (errorCode) {
                            case CONFLICTING_TYPEDEFS: {
                                this.processTypeDefConflictEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getOriginalTypeDefSummary(), typeDefEvent.getOtherMetadataCollectionId(), typeDefEvent.getOtherTypeDefSummary(), typeDefEvent.getErrorMessage());
                                break block0;
                            }
                            case CONFLICTING_ATTRIBUTE_TYPEDEFS: {
                                this.processAttributeTypeDefConflictEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getOriginalAttributeTypeDef(), typeDefEvent.getOtherMetadataCollectionId(), typeDefEvent.getOtherAttributeTypeDef(), typeDefEvent.getErrorMessage());
                                break block0;
                            }
                            case TYPEDEF_PATCH_MISMATCH: {
                                this.processTypeDefPatchMismatchEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTargetMetadataCollectionId(), typeDefEvent.getTargetTypeDefSummary(), typeDefEvent.getOtherTypeDef(), typeDefEvent.getErrorMessage());
                                break block0;
                            }
                        }
                        log.debug("Unknown TypeDef event error code; ignoring event");
                        break;
                    }
                    log.debug("Ignored TypeDef event; null error code");
                    break;
                }
                default: {
                    log.debug("Ignored TypeDef event; unknown type");
                }
            }
        }
    }

    private void logTypeProcessingException(OMRSCheckedExceptionBase error, String typeName, String actionDescription, String sourceName, String originatorMetadataCollectionId, String originatorServerName, String additionalInformation) {
        this.auditLog.logMessage(actionDescription, OMRSAuditCode.UNEXPECTED_EXCEPTION_FROM_TYPE_PROCESSING.getMessageDefinition(new String[]{error.getClass().getName(), typeName, sourceName, originatorServerName, originatorMetadataCollectionId, error.getReportedErrorMessage()}), additionalInformation);
    }

    private void logUnexpectedException(Exception error, String actionDescription, String sourceName, String additionalInformation) {
        this.auditLog.logException(actionDescription, OMRSAuditCode.UNHANDLED_EXCEPTION_FROM_TYPE_PROCESSING.getMessageDefinition(new String[]{sourceName, error.getClass().getName(), error.getMessage()}), additionalInformation, (Throwable)error);
    }

    public void processNewTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDef typeDef) {
        String actionDescription = "Process New TypeDef Event";
        OMRSMetadataCollection metadataCollection = null;
        try {
            if (this.localRepositoryConnector != null) {
                metadataCollection = this.localRepositoryConnector.getMetadataCollection();
            }
            if (metadataCollection != null) {
                TypeDef currentTypeDef = this.activeTypeDefNames.get(typeDef.getName());
                if (currentTypeDef == null) {
                    if (!metadataCollection.verifyTypeDef(this.localServerUserId, typeDef)) {
                        metadataCollection.addTypeDef(this.localServerUserId, typeDef);
                        this.auditLog.logMessage("Process New TypeDef Event", OMRSAuditCode.NEW_TYPE_ADDED.getMessageDefinition(new String[]{typeDef.getName(), typeDef.getGUID(), Long.toString(typeDef.getVersion()), sourceName}));
                    } else {
                        this.auditLog.logMessage("Process New TypeDef Event", OMRSAuditCode.TYPE_ALREADY_KNOWN.getMessageDefinition(new String[]{typeDef.getName(), typeDef.getGUID(), Long.toString(typeDef.getVersion()), sourceName}));
                    }
                    this.cacheTypeDef(sourceName, typeDef, true);
                }
            } else {
                this.auditLog.logMessage("Process New TypeDef Event", OMRSAuditCode.NEW_TYPE_CACHED_FOR_ENTERPRISE.getMessageDefinition(new String[]{typeDef.getName(), typeDef.getGUID(), Long.toString(typeDef.getVersion()), sourceName}));
                this.cacheTypeDef(sourceName, typeDef, false);
            }
        }
        catch (TypeDefNotSupportedException fixedTypeSystemResponse) {
            this.cacheTypeDef(sourceName, typeDef, false);
            this.auditLog.logMessage("Process New TypeDef Event", OMRSAuditCode.NEW_TYPE_NOT_SUPPORTED.getMessageDefinition(new String[]{typeDef.getName(), typeDef.getGUID(), Long.toString(typeDef.getVersion())}));
            log.debug("TypeDef not added because repository does not support dynamic type definitions: " + typeDef);
            log.debug("TypeDefNotSupportedException:", (Throwable)fixedTypeSystemResponse);
        }
        catch (RepositoryErrorException error) {
            this.cacheTypeDef(sourceName, typeDef, false);
            this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDef.getName(), "Process New TypeDef Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDef.toString());
            log.debug("TypeDef " + typeDef.getName() + " not added because repository is not available: " + typeDef);
            log.debug("RepositoryErrorException:", (Throwable)error);
        }
        catch (UserNotAuthorizedException error) {
            this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDef.getName(), "Process New TypeDef Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDef.toString());
            log.debug("TypeDef " + typeDef.getName() + " not added because repository is not authorized: " + typeDef);
            log.debug("RepositoryErrorException:", (Throwable)error);
        }
        catch (TypeDefConflictException error) {
            log.debug("TypeDef not added because it conflicts with another TypeDef already in the repository: " + typeDef);
            log.debug("TypeDefConflictException:", (Throwable)error);
            this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDef.getName(), "Process New TypeDef Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDef.toString());
            this.outboundRepositoryEventManager.processTypeDefConflictEvent(sourceName, this.localRepositoryConnector.getMetadataCollectionId(), this.localRepositoryConnector.getLocalServerName(), this.localRepositoryConnector.getLocalServerType(), this.localRepositoryConnector.getOrganizationName(), (TypeDefSummary)typeDef, originatorMetadataCollectionId, (TypeDefSummary)this.knownTypeDefNames.get(typeDef.getName()), error.getReportedErrorMessage());
        }
        catch (InvalidTypeDefException error) {
            this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDef.getName(), "Process New TypeDef Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDef.toString());
            log.debug("TypeDef not added because repository thinks it is invalid: " + typeDef);
            log.debug("InvalidTypeDefException: ", (Throwable)error);
        }
        catch (TypeDefKnownException error) {
            this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDef.getName(), "Process New TypeDef Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDef.toString());
            log.debug("TypeDef not added because repository has a logic error: " + typeDef);
            log.debug("TypeDefKnownException: ", (Throwable)error);
        }
        catch (Exception error) {
            this.logUnexpectedException(error, "Process New TypeDef Event", sourceName, typeDef.toString());
            log.debug("TypeDef not added because repository has an unexpected error: " + typeDef);
            log.debug("Exception: ", (Throwable)error);
        }
    }

    public void processNewAttributeTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, AttributeTypeDef attributeTypeDef) {
        String actionDescription = "Process New AttributeTypeDef Event";
        OMRSMetadataCollection metadataCollection = null;
        try {
            if (this.localRepositoryConnector != null) {
                metadataCollection = this.localRepositoryConnector.getMetadataCollection();
            }
            if (metadataCollection != null) {
                if (!metadataCollection.verifyAttributeTypeDef(this.localServerUserId, attributeTypeDef)) {
                    metadataCollection.addAttributeTypeDef(this.localServerUserId, attributeTypeDef);
                    this.cacheAttributeTypeDef(sourceName, attributeTypeDef, true);
                    this.activeAttributeTypeDefNames.put(attributeTypeDef.getName(), attributeTypeDef);
                    this.auditLog.logMessage("Process New AttributeTypeDef Event", OMRSAuditCode.NEW_TYPE_ADDED.getMessageDefinition(new String[]{attributeTypeDef.getName(), attributeTypeDef.getGUID(), Long.toString(attributeTypeDef.getVersion()), sourceName}));
                }
                this.cacheAttributeTypeDef(sourceName, attributeTypeDef, true);
            } else {
                this.cacheAttributeTypeDef(sourceName, attributeTypeDef, false);
            }
        }
        catch (TypeDefNotSupportedException fixedTypeSystemResponse) {
            this.cacheAttributeTypeDef(sourceName, attributeTypeDef, false);
            this.auditLog.logMessage("Process New AttributeTypeDef Event", OMRSAuditCode.NEW_TYPE_NOT_SUPPORTED.getMessageDefinition(new String[]{attributeTypeDef.getName(), attributeTypeDef.getGUID(), Long.toString(attributeTypeDef.getVersion())}), attributeTypeDef.toString());
            log.debug("TypeDef not added because repository does not support dynamic type definitions: " + attributeTypeDef);
            log.debug("TypeDefNotSupportedException:", (Throwable)fixedTypeSystemResponse);
        }
        catch (RepositoryErrorException error) {
            this.cacheAttributeTypeDef(sourceName, attributeTypeDef, false);
            this.logTypeProcessingException((OMRSCheckedExceptionBase)error, attributeTypeDef.getName(), "Process New AttributeTypeDef Event", sourceName, originatorMetadataCollectionId, originatorServerName, attributeTypeDef.toString());
            log.debug("TypeDef " + attributeTypeDef.getName() + " not added because repository is not available: " + attributeTypeDef);
            log.debug("RepositoryErrorException:", (Throwable)error);
        }
        catch (UserNotAuthorizedException error) {
            this.logTypeProcessingException((OMRSCheckedExceptionBase)error, attributeTypeDef.getName(), "Process New AttributeTypeDef Event", sourceName, originatorMetadataCollectionId, originatorServerName, attributeTypeDef.toString());
            log.debug("TypeDef " + attributeTypeDef.getName() + " not added because repository is not authorized: " + attributeTypeDef);
            log.debug("RepositoryErrorException:", (Throwable)error);
        }
        catch (TypeDefConflictException error) {
            this.logTypeProcessingException((OMRSCheckedExceptionBase)error, attributeTypeDef.getName(), "Process New AttributeTypeDef Event", sourceName, originatorMetadataCollectionId, originatorServerName, attributeTypeDef.toString());
            log.debug("TypeDef not added because it conflicts with another TypeDef already in the repository: " + attributeTypeDef);
            log.debug("TypeDefConflictException:", (Throwable)error);
            this.outboundRepositoryEventManager.processAttributeTypeDefConflictEvent(sourceName, this.localRepositoryConnector.getMetadataCollectionId(), this.localRepositoryConnector.getLocalServerName(), this.localRepositoryConnector.getLocalServerType(), this.localRepositoryConnector.getOrganizationName(), attributeTypeDef, originatorMetadataCollectionId, this.knownAttributeTypeDefNames.get(attributeTypeDef.getName()), null);
        }
        catch (InvalidTypeDefException error) {
            this.logTypeProcessingException((OMRSCheckedExceptionBase)error, attributeTypeDef.getName(), "Process New AttributeTypeDef Event", sourceName, originatorMetadataCollectionId, originatorServerName, attributeTypeDef.toString());
            log.debug("TypeDef not added because repository thinks it is invalid: " + attributeTypeDef);
            log.debug("InvalidTypeDefException: ", (Throwable)error);
        }
        catch (TypeDefKnownException error) {
            this.logTypeProcessingException((OMRSCheckedExceptionBase)error, attributeTypeDef.getName(), "Process New AttributeTypeDef Event", sourceName, originatorMetadataCollectionId, originatorServerName, attributeTypeDef.toString());
            log.debug("TypeDef not added because repository has a logic error: " + attributeTypeDef);
            log.debug("TypeDefKnownException: ", (Throwable)error);
        }
        catch (Exception error) {
            this.logUnexpectedException(error, "Process New AttributeTypeDef Event", sourceName, attributeTypeDef.toString());
            log.debug("TypeDef not added because repository has an unexpected error: " + attributeTypeDef);
            log.debug("Exception: ", (Throwable)error);
        }
    }

    public void processUpdatedTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefPatch typeDefPatch) {
        block26: {
            String methodName = "processUpdatedTypeDefEvent";
            String actionDescription = "Process TypeDef Patch Event";
            OMRSMetadataCollection metadataCollection = null;
            try {
                if (this.localRepositoryConnector != null) {
                    metadataCollection = this.localRepositoryConnector.getMetadataCollection();
                }
                if (metadataCollection != null) {
                    TypeDef currentTypeDef = this.activeTypeDefNames.get(typeDefPatch.getTypeDefName());
                    if (currentTypeDef != null) {
                        if (currentTypeDef.getVersion() == typeDefPatch.getApplyToVersion()) {
                            TypeDef updatedTypeDef = metadataCollection.updateTypeDef(this.localServerUserId, typeDefPatch);
                            if (log.isDebugEnabled()) {
                                log.debug("Patch successfully applied:" + updatedTypeDef);
                            }
                            this.auditLog.logMessage("Process TypeDef Patch Event", OMRSAuditCode.TYPE_UPDATED.getMessageDefinition(new String[]{updatedTypeDef.getName(), updatedTypeDef.getGUID(), Long.toString(updatedTypeDef.getVersion()), sourceName}));
                            this.cacheTypeDef(sourceName, updatedTypeDef, true);
                        } else if (currentTypeDef.getVersion() < typeDefPatch.getApplyToVersion()) {
                            if (log.isDebugEnabled()) {
                                log.debug("Future patch skipped:" + typeDefPatch);
                            }
                            this.auditLog.logMessage("Process TypeDef Patch Event", OMRSAuditCode.TYPE_UPDATE_SKIPPED.getMessageDefinition(new String[]{currentTypeDef.getName(), currentTypeDef.getGUID(), Long.toString(currentTypeDef.getVersion()), Long.toString(typeDefPatch.getApplyToVersion())}));
                            this.cacheUnsupportedTypeDef(sourceName, typeDefPatch, "processUpdatedTypeDefEvent");
                        } else if (log.isDebugEnabled()) {
                            log.debug("Back-level patch ignored:" + typeDefPatch);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Unsupported patch ignored:" + typeDefPatch);
                        }
                        this.auditLog.logMessage("Process TypeDef Patch Event", OMRSAuditCode.UNKNOWN_TYPE_UPDATE_SKIPPED.getMessageDefinition(new String[]{typeDefPatch.getTypeDefName(), typeDefPatch.getTypeDefGUID(), sourceName}));
                        this.cacheUnsupportedTypeDef(sourceName, typeDefPatch, "processUpdatedTypeDefEvent");
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("No local repository - patch cached in known types:" + typeDefPatch);
                    }
                    this.auditLog.logMessage("Process TypeDef Patch Event", OMRSAuditCode.UPDATED_TYPE_CACHED_FOR_ENTERPRISE.getMessageDefinition(new String[]{typeDefPatch.getTypeDefName(), typeDefPatch.getTypeDefGUID(), Long.toString(typeDefPatch.getApplyToVersion()), sourceName}));
                    this.cacheUnsupportedTypeDef(sourceName, typeDefPatch, "processUpdatedTypeDefEvent");
                }
            }
            catch (FunctionNotSupportedException error) {
                this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDefPatch.getTypeDefName(), "Process TypeDef Patch Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDefPatch.toString());
                if (log.isDebugEnabled()) {
                    log.debug("Patch not applied because repository does not support patching: " + typeDefPatch);
                }
            }
            catch (RepositoryErrorException error) {
                this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDefPatch.getTypeDefName(), "Process TypeDef Patch Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDefPatch.toString());
                if (log.isDebugEnabled()) {
                    log.debug("Patch not applied because repository is not available: " + typeDefPatch);
                }
            }
            catch (UserNotAuthorizedException error) {
                this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDefPatch.getTypeDefName(), "Process TypeDef Patch Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDefPatch.toString());
                if (log.isDebugEnabled()) {
                    log.debug("Patch not applied because repository is not authorized to make this change: " + typeDefPatch);
                }
            }
            catch (TypeDefNotKnownException error) {
                this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDefPatch.getTypeDefName(), "Process TypeDef Patch Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDefPatch.toString());
                if (log.isDebugEnabled()) {
                    log.debug("Patch not applied because TypeDef does not exist: " + typeDefPatch);
                    log.debug("TypeDefNotKnownException: ", (Throwable)error);
                }
            }
            catch (PatchErrorException error) {
                this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDefPatch.getTypeDefName(), "Process TypeDef Patch Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDefPatch.toString());
                if (log.isDebugEnabled()) {
                    log.debug("Patch not applied because it is invalid: " + typeDefPatch);
                    log.debug("PatchErrorException: ", (Throwable)error);
                }
            }
            catch (Exception error) {
                this.logUnexpectedException(error, "Process TypeDef Patch Event", sourceName, typeDefPatch.toString());
                if (!log.isDebugEnabled()) break block26;
                log.debug("Patch not applied because of an error " + typeDefPatch);
                log.debug("Exception: ", (Throwable)error);
            }
        }
    }

    public void processDeletedTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName) {
        block13: {
            String actionDescription = "Process TypeDef Delete Event";
            OMRSMetadataCollection metadataCollection = null;
            try {
                if (this.localRepositoryConnector != null) {
                    metadataCollection = this.localRepositoryConnector.getMetadataCollection();
                }
                if (metadataCollection != null) {
                    metadataCollection.deleteTypeDef(this.localServerUserId, typeDefGUID, typeDefName);
                    log.debug("type def successfully deleted: " + typeDefGUID);
                    this.uncacheTypeDef(sourceName, typeDefGUID, typeDefName, true);
                } else {
                    this.uncacheTypeDef(sourceName, typeDefGUID, typeDefName, false);
                }
            }
            catch (UserNotAuthorizedException error) {
                this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDefName, "Process TypeDef Delete Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDefName + " (" + typeDefGUID + ")");
                if (log.isDebugEnabled()) {
                    log.debug("TypeDef not deleted because repository is not authorized to make these changes: " + typeDefName);
                }
            }
            catch (FunctionNotSupportedException error) {
                this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDefName, "Process TypeDef Delete Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDefName + " (" + typeDefGUID + ")");
                if (log.isDebugEnabled()) {
                    log.debug("TypeDef not deleted because repository does not support it: " + typeDefName);
                }
            }
            catch (RepositoryErrorException error) {
                this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDefName, "Process TypeDef Delete Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDefName + " (" + typeDefGUID + ")");
                if (log.isDebugEnabled()) {
                    log.debug("TypeDef not deleted because repository is not available: " + typeDefName);
                }
            }
            catch (TypeDefNotKnownException error) {
                this.logTypeProcessingException((OMRSCheckedExceptionBase)error, typeDefName, "Process TypeDef Delete Event", sourceName, originatorMetadataCollectionId, originatorServerName, typeDefName + " (" + typeDefGUID + ")");
                if (log.isDebugEnabled()) {
                    log.debug("Delete not applied because TypeDef does not exist: " + typeDefName);
                    log.debug("TypeDefNotKnownException: ", (Throwable)error);
                }
            }
            catch (Exception error) {
                this.logUnexpectedException(error, "Process TypeDef Delete Event", sourceName, typeDefName + " (" + typeDefGUID + ")");
                if (!log.isDebugEnabled()) break block13;
                log.debug("Type not deleted because of an error " + typeDefName);
                log.debug("Exception: ", (Throwable)error);
            }
        }
    }

    public void processDeletedAttributeTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String attributeTypeDefGUID, String attributeTypeDefName) {
        block13: {
            String actionDescription = "Process AttributeTypeDef Delete Event";
            OMRSMetadataCollection metadataCollection = null;
            try {
                if (this.localRepositoryConnector != null) {
                    metadataCollection = this.localRepositoryConnector.getMetadataCollection();
                }
                if (metadataCollection != null) {
                    metadataCollection.deleteTypeDef(this.localServerUserId, attributeTypeDefGUID, attributeTypeDefName);
                    log.debug("type def successfully deleted: " + attributeTypeDefGUID);
                    this.uncacheTypeDef(sourceName, attributeTypeDefGUID, attributeTypeDefName, true);
                } else {
                    this.uncacheTypeDef(sourceName, attributeTypeDefGUID, attributeTypeDefName, false);
                }
            }
            catch (UserNotAuthorizedException error) {
                this.logTypeProcessingException((OMRSCheckedExceptionBase)error, attributeTypeDefName, "Process AttributeTypeDef Delete Event", sourceName, originatorMetadataCollectionId, originatorServerName, attributeTypeDefName + " (" + attributeTypeDefGUID + ")");
                if (log.isDebugEnabled()) {
                    log.debug("AttributeTypeDef not deleted because repository is not authorized to make these changes: " + attributeTypeDefName);
                }
            }
            catch (FunctionNotSupportedException error) {
                this.logTypeProcessingException((OMRSCheckedExceptionBase)error, attributeTypeDefName, "Process AttributeTypeDef Delete Event", sourceName, originatorMetadataCollectionId, originatorServerName, attributeTypeDefName + " (" + attributeTypeDefGUID + ")");
                if (log.isDebugEnabled()) {
                    log.debug("AttributeTypeDef not deleted because repository does not support delete: " + attributeTypeDefName);
                }
            }
            catch (RepositoryErrorException error) {
                this.logTypeProcessingException((OMRSCheckedExceptionBase)error, attributeTypeDefName, "Process AttributeTypeDef Delete Event", sourceName, originatorMetadataCollectionId, originatorServerName, attributeTypeDefName + " (" + attributeTypeDefGUID + ")");
                if (log.isDebugEnabled()) {
                    log.debug("AttributeTypeDef not deleted because repository is not available: " + attributeTypeDefName);
                }
            }
            catch (TypeDefNotKnownException error) {
                this.logTypeProcessingException((OMRSCheckedExceptionBase)error, attributeTypeDefName, "Process AttributeTypeDef Delete Event", sourceName, originatorMetadataCollectionId, originatorServerName, attributeTypeDefName + " (" + attributeTypeDefGUID + ")");
                if (log.isDebugEnabled()) {
                    log.debug("Delete not applied because TypeDef does not exist: " + attributeTypeDefName);
                    log.debug("TypeDefNotKnownException: ", (Throwable)error);
                }
            }
            catch (Exception error) {
                this.logUnexpectedException(error, "Process AttributeTypeDef Delete Event", sourceName, attributeTypeDefName + " (" + attributeTypeDefGUID + ")");
                if (!log.isDebugEnabled()) break block13;
                log.debug("Type not deleted because of an error " + attributeTypeDefName);
                log.debug("Exception: ", (Throwable)error);
            }
        }
    }

    public void processReIdentifiedTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, TypeDef typeDef) {
    }

    public void processReIdentifiedAttributeTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, AttributeTypeDef originalAttributeTypeDef, AttributeTypeDef attributeTypeDef) {
    }

    public void processTypeDefConflictEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originatorTypeDefSummary, String otherMetadataCollectionId, TypeDefSummary conflictingTypeDefSummary, String errorMessage) {
        String actionDescription = "Received TypeDef Conflict Event";
        Object additionalInformation = "Originator's type: ";
        String typeName = "<null>";
        String typeGUID = "<null>";
        if (originatorTypeDefSummary != null) {
            additionalInformation = (String)additionalInformation + originatorTypeDefSummary.toString();
            typeName = originatorTypeDefSummary.getName();
            typeGUID = originatorTypeDefSummary.getGUID();
        } else {
            additionalInformation = (String)additionalInformation + "<null>";
        }
        additionalInformation = (String)additionalInformation + "; conflicting type: ";
        additionalInformation = conflictingTypeDefSummary != null ? (String)additionalInformation + conflictingTypeDefSummary.toString() : (String)additionalInformation + "<null>";
        this.auditLog.logMessage("Received TypeDef Conflict Event", OMRSAuditCode.REMOTE_TYPE_CONFLICT.getMessageDefinition(new String[]{typeName, typeGUID, originatorServerName, originatorMetadataCollectionId, otherMetadataCollectionId, errorMessage}), (String)additionalInformation);
    }

    public void processAttributeTypeDefConflictEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, AttributeTypeDef originatorAttributeTypeDef, String otherMetadataCollectionId, AttributeTypeDef conflictingAttributeTypeDef, String errorMessage) {
        String actionDescription = "Received TypeDef Conflict Event";
        Object additionalInformation = "Originator's type: ";
        String typeName = "<null>";
        String typeGUID = "<null>";
        if (originatorAttributeTypeDef != null) {
            additionalInformation = (String)additionalInformation + originatorAttributeTypeDef.toString();
            typeName = originatorAttributeTypeDef.getName();
            typeGUID = originatorAttributeTypeDef.getGUID();
        } else {
            additionalInformation = (String)additionalInformation + "<null>";
        }
        additionalInformation = (String)additionalInformation + "; conflicting type: ";
        additionalInformation = conflictingAttributeTypeDef != null ? (String)additionalInformation + conflictingAttributeTypeDef.toString() : (String)additionalInformation + "<null>";
        this.auditLog.logMessage("Received TypeDef Conflict Event", OMRSAuditCode.REMOTE_TYPE_CONFLICT.getMessageDefinition(new String[]{typeName, typeGUID, originatorServerName, originatorMetadataCollectionId, otherMetadataCollectionId, errorMessage}), (String)additionalInformation);
    }

    public void processTypeDefPatchMismatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, TypeDef otherTypeDef, String errorMessage) {
    }

    synchronized void registerMetadataCollection(String metadataCollectionId, String metadataCollectionName) {
        if (metadataCollectionId != null) {
            this.metadataCollectionNames.put(metadataCollectionId, metadataCollectionName);
        }
    }

    public synchronized String getMetadataCollectionName(String metadataCollectionId) {
        if (metadataCollectionId != null) {
            return this.metadataCollectionNames.get(metadataCollectionId);
        }
        return null;
    }

    private void throwContentManagerLogicError(String sourceName, String originatingMethodName, String localMethodName) {
        throw new OMRSLogicErrorException(OMRSErrorCode.CONTENT_MANAGER_LOGIC_ERROR.getMessageDefinition(new String[]{sourceName, localMethodName, originatingMethodName}), this.getClass().getName(), localMethodName);
    }
}

