/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.eventmanagement;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventBuilder;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSMetadataDefaultEventsSecurity;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.events.OpenMetadataEventsSecurity;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryEventPublisher
extends OMRSRepositoryEventBuilder {
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryEventPublisher.class);
    private OpenMetadataEventsSecurity securityVerifier = new OMRSMetadataDefaultEventsSecurity();
    private List<OMRSTopicConnector> typesTopicConnectors;
    private List<OMRSTopicConnector> instancesTopicConnectors;
    private AuditLog auditLog;

    public OMRSRepositoryEventPublisher(String publisherName, OMRSTopicConnector topicConnector, AuditLog auditLog) {
        super(publisherName);
        String actionDescription = "Initialize event publisher";
        this.auditLog = auditLog;
        if (topicConnector == null) {
            log.debug("Null topic connector");
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_TOPIC_CONNECTOR.getMessageDefinition(new String[]{publisherName}), ((Object)((Object)this)).getClass().getName(), actionDescription);
        }
        this.typesTopicConnectors = new ArrayList<OMRSTopicConnector>();
        this.typesTopicConnectors.add(topicConnector);
        this.instancesTopicConnectors = new ArrayList<OMRSTopicConnector>();
        this.instancesTopicConnectors.add(topicConnector);
        log.debug("New Event Publisher: " + publisherName);
    }

    public OMRSRepositoryEventPublisher(String publisherName, List<OMRSTopicConnector> typesTopicConnectors, List<OMRSTopicConnector> instancesTopicConnectors, AuditLog auditLog) {
        super(publisherName);
        String actionDescription = "Initialize event publisher";
        this.auditLog = auditLog;
        if (typesTopicConnectors == null || typesTopicConnectors.isEmpty()) {
            log.debug("Null topic connector");
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_TOPIC_CONNECTOR.getMessageDefinition(new String[]{publisherName + " (types)"}), ((Object)((Object)this)).getClass().getName(), actionDescription);
        }
        if (instancesTopicConnectors == null || instancesTopicConnectors.isEmpty()) {
            log.debug("Null topic connector");
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_TOPIC_CONNECTOR.getMessageDefinition(new String[]{publisherName + " (instances)"}), ((Object)((Object)this)).getClass().getName(), actionDescription);
        }
        this.typesTopicConnectors = typesTopicConnectors;
        this.instancesTopicConnectors = instancesTopicConnectors;
        log.debug("New Event Publisher: " + publisherName);
    }

    public void setSecurityVerifier(OpenMetadataEventsSecurity securityVerifier) {
        if (securityVerifier != null) {
            this.securityVerifier = securityVerifier;
        }
    }

    public void sendTypeDefEvent(String sourceName, OMRSTypeDefEvent typeDefEvent) {
        String actionDescription = "Send TypeDef Event";
        log.debug("Sending typeDefEvent for cohort: " + sourceName);
        log.debug("typeDefEvent: " + typeDefEvent);
        log.debug("localEventOriginator: " + typeDefEvent.getEventOriginator());
        try {
            for (OMRSTopicConnector omrsTopicConnector : this.typesTopicConnectors) {
                log.debug("topicConnector: " + omrsTopicConnector);
                omrsTopicConnector.sendTypeDefEvent(typeDefEvent);
            }
        }
        catch (Exception error) {
            this.auditLog.logException(actionDescription, OMRSAuditCode.SEND_TYPEDEF_EVENT_ERROR.getMessageDefinition(new String[]{sourceName}), "typeDefEvent {" + typeDefEvent.toString() + "}", (Throwable)error);
            log.debug("Exception: ", (Throwable)error);
        }
    }

    public void sendInstanceEvent(String sourceName, OMRSInstanceEvent instanceEvent) {
        String actionDescription = "Send Instance Event";
        log.debug("Sending instanceEvent for cohort: " + sourceName);
        log.debug("instanceEvent: " + instanceEvent);
        log.debug("localEventOriginator: " + instanceEvent.getEventOriginator());
        try {
            OMRSInstanceEvent validatedEvent = this.securityVerifier.validateOutboundEvent(this.eventProcessorName, instanceEvent);
            if (validatedEvent != null) {
                for (OMRSTopicConnector omrsTopicConnector : this.instancesTopicConnectors) {
                    log.debug("topicConnector: " + omrsTopicConnector);
                    omrsTopicConnector.sendInstanceEvent(instanceEvent);
                }
            }
        }
        catch (Exception error) {
            this.auditLog.logException(actionDescription, OMRSAuditCode.SEND_INSTANCE_EVENT_ERROR.getMessageDefinition(new String[]{sourceName}), "instanceEvent {" + instanceEvent.toString() + "}", (Throwable)error);
            log.debug("Exception: ", (Throwable)error);
        }
    }
}

