/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.server;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.MessageDefinition;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;
import org.odpi.openmetadata.repositoryservices.rest.services.OMRSRepositoryServicesInstanceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OMRSRESTExceptionHandler {
    private static final MessageFormatter messageFormatter = new MessageFormatter();
    private OMRSRepositoryServicesInstanceHandler instanceHandler;
    private static final Logger log = LoggerFactory.getLogger(OMRSRESTExceptionHandler.class);

    OMRSRESTExceptionHandler(OMRSRepositoryServicesInstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    void captureUserNotAuthorizedException(OMRSAPIResponse response, UserNotAuthorizedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    void captureRepositoryErrorException(OMRSAPIResponse response, RepositoryErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    void captureInvalidParameterException(OMRSAPIResponse response, InvalidParameterException error) {
        String propertyName = "parameterName";
        if (error.getParameterName() == null) {
            this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        } else {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("parameterName", error.getParameterName());
            this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        }
    }

    void captureGenericException(OMRSAPIResponse response, Exception error, String userId, String serverName, String methodName) {
        String message = error.getMessage();
        if (message == null) {
            message = "null";
        }
        ExceptionMessageDefinition messageDefinition = OMRSErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), methodName, message});
        response.setRelatedHTTPCode(messageDefinition.getHttpErrorCode());
        response.setExceptionClassName(error.getClass().getName());
        response.setActionDescription(message);
        response.setExceptionErrorMessage(messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition));
        response.setExceptionErrorMessageId(messageDefinition.getMessageId());
        response.setExceptionErrorMessageParameters(messageDefinition.getMessageParams());
        response.setExceptionSystemAction(messageDefinition.getSystemAction());
        response.setExceptionUserAction(messageDefinition.getUserAction());
        if (error.getCause() != null) {
            response.setExceptionCausedBy(error.getCause().getClass().getName());
        }
        response.setExceptionProperties(null);
        try {
            AuditLog auditLog = this.instanceHandler.getAuditLog(userId, serverName, methodName);
            if (auditLog != null) {
                auditLog.logException(methodName, OMRSAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), methodName, message}), (Throwable)error);
            }
        }
        catch (Exception secondError) {
            log.error("Unexpected exception processing error {}", (Object)error.toString(), (Object)secondError);
        }
    }

    private void captureCheckedException(OMRSAPIResponse response, OMRSCheckedExceptionBase error, String exceptionClassName) {
        this.captureCheckedException(response, error, exceptionClassName, null);
    }

    private void captureCheckedException(OMRSAPIResponse response, OMRSCheckedExceptionBase error, String exceptionClassName, Map<String, Object> exceptionProperties) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setActionDescription(error.getReportingActionDescription());
        response.setExceptionErrorMessage(error.getReportedErrorMessage());
        response.setExceptionErrorMessageId(error.getReportedErrorMessageId());
        response.setExceptionErrorMessageParameters(error.getReportedErrorMessageParameters());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
        response.setExceptionProperties(exceptionProperties);
        response.setExceptionCausedBy(error.getReportedCaughtExceptionClassName());
    }
}

