/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.QueryInstanceAccumulatorBase;

public class EntityAccumulator
extends QueryInstanceAccumulatorBase {
    private volatile Map<String, EntityDetail> accumulatedEntities = new HashMap<String, EntityDetail>();
    private volatile Map<String, List<Classification>> accumulatedClassifications = new HashMap<String, List<Classification>>();

    public EntityAccumulator(String localMetadataCollectionId, AuditLog auditLog, OMRSRepositoryValidator repositoryValidator) {
        super(localMetadataCollectionId, auditLog, repositoryValidator);
    }

    private void addEntity(EntityDetail incomingEntity, String metadataCollectionId) {
        if (incomingEntity != null && incomingEntity.getGUID() != null && metadataCollectionId != null) {
            List<Classification> currentSavedClassifications;
            String entityGUID = incomingEntity.getGUID();
            EntityDetail currentSavedEntity = this.accumulatedEntities.get(entityGUID);
            if (!super.currentInstanceIsBest((InstanceAuditHeader)currentSavedEntity, (InstanceAuditHeader)incomingEntity)) {
                this.accumulatedEntities.put(entityGUID, incomingEntity);
                if (metadataCollectionId.equals(this.localMetadataCollectionId)) {
                    super.captureLocalInstance(entityGUID);
                }
            }
            if ((currentSavedClassifications = this.accumulatedClassifications.get(entityGUID)) == null) {
                if (incomingEntity.getClassifications() != null) {
                    this.accumulatedClassifications.put(entityGUID, incomingEntity.getClassifications());
                }
            } else if (incomingEntity.getClassifications() != null) {
                HashMap<String, Classification> entityClassificationsMap = new HashMap<String, Classification>();
                for (Classification existingClassification : currentSavedClassifications) {
                    if (existingClassification == null) continue;
                    entityClassificationsMap.put(existingClassification.getName(), existingClassification);
                }
                for (Classification newClassification : incomingEntity.getClassifications()) {
                    Classification existingClassification;
                    if (newClassification == null || (existingClassification = (Classification)entityClassificationsMap.get(newClassification.getName())) != null && existingClassification.getVersion() >= newClassification.getVersion()) continue;
                    entityClassificationsMap.put(newClassification.getName(), newClassification);
                }
                if (!entityClassificationsMap.isEmpty()) {
                    this.accumulatedClassifications.put(entityGUID, new ArrayList(entityClassificationsMap.values()));
                }
            }
        }
    }

    public synchronized void addEntities(List<EntityDetail> entities, String metadataCollectionId) {
        if (entities != null) {
            for (EntityDetail entity : entities) {
                this.addEntity(entity, metadataCollectionId);
            }
            super.setResultsReturned(metadataCollectionId, entities.size());
        } else {
            super.setResultsReturned(metadataCollectionId, 0);
        }
    }

    public synchronized List<EntityDetail> getResults(EnterpriseOMRSRepositoryConnector repositoryConnector, OMRSMetadataCollection metadataCollection) {
        if (this.accumulatedEntities.isEmpty()) {
            return null;
        }
        this.makeRefreshRecommendations(repositoryConnector);
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        if (metadataCollection != null) {
            for (EntityDetail accumulatedEntity : this.accumulatedEntities.values()) {
                if (accumulatedEntity == null) continue;
                EntityDetail resultEntity = new EntityDetail(accumulatedEntity);
                resultEntity.setClassifications(this.accumulatedClassifications.get(accumulatedEntity.getGUID()));
                results.add(resultEntity);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private void makeRefreshRecommendations(EnterpriseOMRSRepositoryConnector repositoryConnector) {
        if (this.localMetadataCollectionId == null || this.accumulatedEntities.isEmpty()) {
            return;
        }
        for (EntityDetail accumulatedEntity : this.accumulatedEntities.values()) {
            String entityGUID;
            if (accumulatedEntity == null || (entityGUID = accumulatedEntity.getGUID()) == null || !super.notLocal(entityGUID)) continue;
            repositoryConnector.requestRefreshOfEntity(accumulatedEntity);
        }
    }
}

