/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class PurgeEntityExecutor
extends RepositoryExecutorBase {
    private MaintenanceAccumulator accumulator;
    private String entityGUID;
    private String typeDefGUID;
    private String typeDefName;
    private boolean entityDeleted = false;

    public PurgeEntityExecutor(String userId, String typeDefGUID, String typeDefName, String entityGUID, AuditLog auditLog, String methodName) {
        super(userId, methodName);
        this.accumulator = new MaintenanceAccumulator(auditLog);
        this.entityGUID = entityGUID;
        this.typeDefGUID = typeDefGUID;
        this.typeDefName = typeDefName;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            metadataCollection.purgeEntity(this.userId, this.typeDefGUID, this.typeDefName, this.entityGUID);
            this.entityDeleted = true;
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityNotDeletedException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (FunctionNotSupportedException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return this.entityDeleted;
    }

    public void getResult() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (this.entityDeleted) {
            return;
        }
        this.accumulator.throwCapturedEntityNotDeletedException();
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedGenericException(this.methodName);
        this.accumulator.throwCapturedEntityNotKnownException();
        this.accumulator.throwCapturedFunctionNotSupportedException();
        this.accumulator.throwCapturedInvalidParameterException();
    }
}

