/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.eventmanagement;

import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventType;

public abstract class OMRSRepositoryEventBuilder
extends OMRSRepositoryEventProcessor {
    OMRSRepositoryEventBuilder(String eventProcessorName) {
        super(eventProcessorName);
    }

    public void processNewTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDef typeDef) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSTypeDefEvent typeDefEvent = new OMRSTypeDefEvent(OMRSTypeDefEventType.NEW_TYPEDEF_EVENT, typeDef);
        typeDefEvent.setEventOriginator(eventOriginator);
        this.sendTypeDefEvent(sourceName, typeDefEvent);
    }

    public void processNewAttributeTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, AttributeTypeDef attributeTypeDef) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSTypeDefEvent typeDefEvent = new OMRSTypeDefEvent(OMRSTypeDefEventType.NEW_ATTRIBUTE_TYPEDEF_EVENT, attributeTypeDef);
        typeDefEvent.setEventOriginator(eventOriginator);
        this.sendTypeDefEvent(sourceName, typeDefEvent);
    }

    public void processUpdatedTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefPatch typeDefPatch) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSTypeDefEvent typeDefEvent = new OMRSTypeDefEvent(OMRSTypeDefEventType.UPDATED_TYPEDEF_EVENT, typeDefPatch);
        typeDefEvent.setEventOriginator(eventOriginator);
        this.sendTypeDefEvent(sourceName, typeDefEvent);
    }

    public void processDeletedTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSTypeDefEvent typeDefEvent = new OMRSTypeDefEvent(OMRSTypeDefEventType.DELETED_TYPEDEF_EVENT, typeDefGUID, typeDefName);
        typeDefEvent.setEventOriginator(eventOriginator);
        this.sendTypeDefEvent(sourceName, typeDefEvent);
    }

    public void processDeletedAttributeTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String attributeTypeDefGUID, String attributeTypeDefName) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSTypeDefEvent typeDefEvent = new OMRSTypeDefEvent(OMRSTypeDefEventType.DELETED_ATTRIBUTE_TYPEDEF_EVENT, attributeTypeDefGUID, attributeTypeDefName);
        typeDefEvent.setEventOriginator(eventOriginator);
        this.sendTypeDefEvent(sourceName, typeDefEvent);
    }

    public void processReIdentifiedTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, TypeDef typeDef) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSTypeDefEvent typeDefEvent = new OMRSTypeDefEvent(OMRSTypeDefEventType.RE_IDENTIFIED_TYPEDEF_EVENT, originalTypeDefSummary, typeDef);
        typeDefEvent.setEventOriginator(eventOriginator);
        this.sendTypeDefEvent(sourceName, typeDefEvent);
    }

    public void processReIdentifiedAttributeTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, AttributeTypeDef originalAttributeTypeDef, AttributeTypeDef attributeTypeDef) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSTypeDefEvent typeDefEvent = new OMRSTypeDefEvent(OMRSTypeDefEventType.RE_IDENTIFIED_ATTRIBUTE_TYPEDEF_EVENT, originalAttributeTypeDef, attributeTypeDef);
        typeDefEvent.setEventOriginator(eventOriginator);
        this.sendTypeDefEvent(sourceName, typeDefEvent);
    }

    public void processTypeDefConflictEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originatorTypeDefSummary, String otherMetadataCollectionId, TypeDefSummary conflictingTypeDefSummary, String errorMessage) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSTypeDefEvent typeDefEvent = new OMRSTypeDefEvent(OMRSTypeDefEventErrorCode.CONFLICTING_TYPEDEFS, errorMessage, originatorTypeDefSummary, otherMetadataCollectionId, conflictingTypeDefSummary);
        typeDefEvent.setEventOriginator(eventOriginator);
        this.sendTypeDefEvent(sourceName, typeDefEvent);
    }

    public void processAttributeTypeDefConflictEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, AttributeTypeDef originatorAttributeTypeDef, String otherMetadataCollectionId, AttributeTypeDef conflictingAttributeTypeDef, String errorMessage) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSTypeDefEvent typeDefEvent = new OMRSTypeDefEvent(OMRSTypeDefEventErrorCode.CONFLICTING_ATTRIBUTE_TYPEDEFS, errorMessage, originatorAttributeTypeDef, otherMetadataCollectionId, conflictingAttributeTypeDef);
        typeDefEvent.setEventOriginator(eventOriginator);
        this.sendTypeDefEvent(sourceName, typeDefEvent);
    }

    public void processTypeDefPatchMismatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, TypeDef otherTypeDef, String errorMessage) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSTypeDefEvent typeDefEvent = new OMRSTypeDefEvent(OMRSTypeDefEventErrorCode.TYPEDEF_PATCH_MISMATCH, errorMessage, targetMetadataCollectionId, targetTypeDefSummary, otherTypeDef);
        typeDefEvent.setEventOriginator(eventOriginator);
        this.sendTypeDefEvent(sourceName, typeDefEvent);
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.NEW_ENTITY_EVENT, entity);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.UPDATED_ENTITY_EVENT, oldEntity, newEntity);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.UNDONE_ENTITY_EVENT, entity);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.CLASSIFIED_ENTITY_EVENT, entity, null, classification);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification classification) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.CLASSIFIED_ENTITY_EVENT, entity, null, classification);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.DECLASSIFIED_ENTITY_EVENT, entity, originalClassification, null);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.DECLASSIFIED_ENTITY_EVENT, entity, originalClassification, null);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.RECLASSIFIED_ENTITY_EVENT, entity, originalClassification, classification);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification, Classification classification) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.RECLASSIFIED_ENTITY_EVENT, entity, originalClassification, classification);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.DELETED_ENTITY_EVENT, entity);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.RESTORED_ENTITY_EVENT, entity);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processPurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.PURGED_ENTITY_EVENT, entity);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processPurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.PURGED_ENTITY_EVENT, typeDefGUID, typeDefName, instanceGUID);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.DELETE_PURGED_ENTITY_EVENT, entity);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.RE_IDENTIFIED_ENTITY_EVENT, entity);
        instanceEvent.setEventOriginator(eventOriginator);
        instanceEvent.setOriginalInstanceGUID(originalEntityGUID);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.RETYPED_ENTITY_EVENT, entity);
        instanceEvent.setEventOriginator(eventOriginator);
        instanceEvent.setOriginalTypeDefSummary(originalTypeDefSummary);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.RE_HOMED_ENTITY_EVENT, entity);
        instanceEvent.setEventOriginator(eventOriginator);
        instanceEvent.setOriginalHomeMetadataCollectionId(originalHomeMetadataCollectionId);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processRefreshEntityRequested(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.REFRESH_ENTITY_REQUEST, typeDefGUID, typeDefName, instanceGUID);
        instanceEvent.setEventOriginator(eventOriginator);
        instanceEvent.setHomeMetadataCollectionId(homeMetadataCollectionId);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.REFRESHED_ENTITY_EVENT, entity);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.NEW_RELATIONSHIP_EVENT, relationship);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.UPDATED_RELATIONSHIP_EVENT, oldRelationship, newRelationship);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.UNDONE_RELATIONSHIP_EVENT, relationship);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.DELETED_RELATIONSHIP_EVENT, relationship);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.RESTORED_RELATIONSHIP_EVENT, relationship);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processPurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.PURGED_RELATIONSHIP_EVENT, relationship);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processPurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.PURGED_RELATIONSHIP_EVENT, typeDefGUID, typeDefName, instanceGUID);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.DELETE_PURGED_RELATIONSHIP_EVENT, relationship);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.RE_IDENTIFIED_RELATIONSHIP_EVENT, relationship);
        instanceEvent.setEventOriginator(eventOriginator);
        instanceEvent.setOriginalInstanceGUID(originalRelationshipGUID);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.RETYPED_RELATIONSHIP_EVENT, relationship);
        instanceEvent.setEventOriginator(eventOriginator);
        instanceEvent.setOriginalTypeDefSummary(originalTypeDefSummary);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.RE_HOMED_RELATIONSHIP_EVENT, relationship);
        instanceEvent.setEventOriginator(eventOriginator);
        instanceEvent.setOriginalHomeMetadataCollectionId(originalHomeMetadataCollection);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processRefreshRelationshipRequest(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.REFRESH_RELATIONSHIP_REQUEST, typeDefGUID, typeDefName, instanceGUID);
        instanceEvent.setEventOriginator(eventOriginator);
        instanceEvent.setHomeMetadataCollectionId(homeMetadataCollectionId);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.REFRESHED_RELATIONSHIP_EVENT, relationship);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processInstanceBatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, InstanceGraph instances) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.BATCH_INSTANCES_EVENT, instances);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processConflictingInstancesEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, String otherMetadataCollectionId, InstanceProvenanceType otherOrigin, TypeDefSummary otherTypeDefSummary, String otherInstanceGUID, String errorMessage) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventErrorCode.CONFLICTING_INSTANCES, errorMessage, targetMetadataCollectionId, targetTypeDefSummary, targetInstanceGUID, otherMetadataCollectionId, otherOrigin, otherTypeDefSummary, otherInstanceGUID);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }

    public void processConflictingTypeEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, TypeDefSummary otherTypeDefSummary, String errorMessage) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSInstanceEvent instanceEvent = new OMRSInstanceEvent(OMRSInstanceEventErrorCode.CONFLICTING_TYPE, errorMessage, targetMetadataCollectionId, targetTypeDefSummary, targetInstanceGUID, otherTypeDefSummary);
        instanceEvent.setEventOriginator(eventOriginator);
        this.sendInstanceEvent(sourceName, instanceEvent);
    }
}

