/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GetEntitySummaryExecutor
extends RepositoryExecutorBase {
    protected MaintenanceAccumulator accumulator;
    protected String entityGUID;
    protected Map<String, Classification> allClassifications = new HashMap<String, Classification>();
    protected boolean inPhaseOne = true;
    private EntitySummary latestEntity = null;

    public GetEntitySummaryExecutor(String userId, String entityGUID, AuditLog auditLog, String methodName) {
        super(userId, methodName);
        this.accumulator = new MaintenanceAccumulator(auditLog);
        this.entityGUID = entityGUID;
    }

    protected void saveClassifications(List<Classification> retrievedClassifications) {
        if (retrievedClassifications != null) {
            for (Classification entityClassification : retrievedClassifications) {
                Classification existingClassification;
                if (entityClassification == null || (existingClassification = this.allClassifications.get(entityClassification.getName())) != null && existingClassification.getVersion() >= entityClassification.getVersion()) continue;
                this.allClassifications.put(entityClassification.getName(), entityClassification);
            }
        }
    }

    protected void getHomeClassifications(OMRSMetadataCollection metadataCollection) {
        try {
            List homeClassifications = metadataCollection.getHomeClassifications(this.userId, this.entityGUID);
            this.saveClassifications(homeClassifications);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            if (this.inPhaseOne) {
                EntitySummary retrievedEntity = metadataCollection.getEntitySummary(this.userId, this.entityGUID);
                if (retrievedEntity != null) {
                    this.saveClassifications(retrievedEntity.getClassifications());
                    if (metadataCollectionId.equals(retrievedEntity.getMetadataCollectionId())) {
                        this.latestEntity = retrievedEntity;
                        this.inPhaseOne = false;
                    } else if (this.latestEntity == null) {
                        this.latestEntity = retrievedEntity;
                    } else if (retrievedEntity.getVersion() > this.latestEntity.getVersion()) {
                        this.latestEntity = retrievedEntity;
                    }
                } else {
                    this.getHomeClassifications(metadataCollection);
                }
            } else {
                this.getHomeClassifications(metadataCollection);
            }
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return false;
    }

    public EntitySummary getEntitySummary() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        if (this.latestEntity != null) {
            if (this.allClassifications.isEmpty()) {
                this.latestEntity.setClassifications(null);
            } else {
                this.latestEntity.setClassifications(new ArrayList<Classification>(this.allClassifications.values()));
            }
            return this.latestEntity;
        }
        this.accumulator.throwCapturedEntityNotKnownException();
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedInvalidParameterException();
        return null;
    }
}

