/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class AddEntityExecutor
extends RepositoryExecutorBase {
    private String entityTypeGUID;
    private InstanceProperties initialProperties;
    private List<Classification> initialClassifications;
    private InstanceStatus initialStatus;
    private MaintenanceAccumulator accumulator;
    private String externalSourceGUID = null;
    private String externalSourceName = null;
    private EntityDetail newEntity = null;

    public AddEntityExecutor(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus, AuditLog auditLog, String methodName) {
        super(userId, methodName);
        this.entityTypeGUID = entityTypeGUID;
        this.initialProperties = initialProperties;
        this.initialClassifications = initialClassifications;
        this.initialStatus = initialStatus;
        this.accumulator = new MaintenanceAccumulator(auditLog);
    }

    public AddEntityExecutor(String userId, String entityTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus, AuditLog auditLog, String methodName) {
        super(userId, methodName);
        this.entityTypeGUID = entityTypeGUID;
        this.externalSourceGUID = externalSourceGUID;
        this.externalSourceName = externalSourceName;
        this.initialProperties = initialProperties;
        this.initialClassifications = initialClassifications;
        this.initialStatus = initialStatus;
        this.accumulator = new MaintenanceAccumulator(auditLog);
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        boolean result = false;
        try {
            this.newEntity = this.externalSourceGUID == null ? metadataCollection.addEntity(this.userId, this.entityTypeGUID, this.initialProperties, this.initialClassifications, this.initialStatus) : metadataCollection.addExternalEntity(this.userId, this.entityTypeGUID, this.externalSourceGUID, this.externalSourceName, this.initialProperties, this.initialClassifications, this.initialStatus);
            if (this.newEntity != null) {
                result = true;
            }
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (ClassificationErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (TypeErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (StatusNotSupportedException error) {
            this.accumulator.captureException(error);
        }
        catch (PropertyErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return result;
    }

    public EntityDetail getNewEntity() throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (this.newEntity != null) {
            return this.newEntity;
        }
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedGenericException(this.methodName);
        this.accumulator.throwCapturedTypeErrorException();
        this.accumulator.throwCapturedClassificationErrorException();
        this.accumulator.throwCapturedPropertyErrorException();
        this.accumulator.throwCapturedStatusNotSupportedException();
        this.accumulator.throwCapturedInvalidParameterException();
        this.accumulator.throwCapturedFunctionNotSupportedException();
        return null;
    }
}

