/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.eventmanagement;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.InternalOMRSEventProcessingContext;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventProcessor;
import org.odpi.openmetadata.repositoryservices.eventmanagement.BufferedInstanceEvent;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventBuilder;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventExchangeRule;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessorInterface;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventProcessorInterface;
import org.odpi.openmetadata.repositoryservices.events.future.OMRSFuture;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryEventManager
extends OMRSRepositoryEventBuilder {
    private boolean isActive = false;
    private List<OMRSTypeDefEvent> typeDefEventBuffer = new ArrayList<OMRSTypeDefEvent>();
    private List<BufferedInstanceEvent> instanceEventBuffer = new ArrayList<BufferedInstanceEvent>();
    private List<OMRSTypeDefEventProcessorInterface> typeDefEventConsumers = new ArrayList<OMRSTypeDefEventProcessorInterface>();
    private List<OMRSInstanceEventProcessorInterface> instanceEventConsumers = new ArrayList<OMRSInstanceEventProcessorInterface>();
    private OMRSRepositoryContentValidator repositoryValidator;
    private OMRSRepositoryEventExchangeRule exchangeRule;
    private AuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryEventManager.class);

    public OMRSRepositoryEventManager(String eventManagerName, OMRSRepositoryEventExchangeRule exchangeRule, OMRSRepositoryContentValidator repositoryValidator, AuditLog auditLog) {
        super(eventManagerName);
        this.auditLog = auditLog;
        String actionDescription = "Initialize OMRS Event Manager";
        String methodName = "OMRSRepositoryEventManager";
        auditLog.logMessage("Initialize OMRS Event Manager", OMRSAuditCode.INITIALIZING_EVENT_MANAGER.getMessageDefinition(new String[]{eventManagerName}));
        if (exchangeRule == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_EXCHANGE_RULE.getMessageDefinition(new String[]{"OMRSRepositoryEventManager"}), ((Object)((Object)this)).getClass().getName(), "OMRSRepositoryEventManager");
        }
        this.exchangeRule = exchangeRule;
        if (repositoryValidator == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_REPOSITORY_VALIDATOR.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "OMRSRepositoryEventManager");
        }
        this.repositoryValidator = repositoryValidator;
        log.debug("New Event Manager");
    }

    public void registerTypeDefProcessor(OMRSTypeDefEventProcessor typeDefEventConsumer) {
        String actionDescription = "Register TypeDef Event Processor";
        this.auditLog.logMessage("Register TypeDef Event Processor", OMRSAuditCode.REGISTERING_EVENT_PROCESSOR.getMessageDefinition(new String[]{typeDefEventConsumer.getEventProcessorName(), super.getEventProcessorName()}));
        this.typeDefEventConsumers.add((OMRSTypeDefEventProcessorInterface)typeDefEventConsumer);
    }

    public void registerInstanceProcessor(OMRSInstanceEventProcessor instanceEventConsumer) {
        String actionDescription = "Register Instance Event Processor";
        this.auditLog.logMessage("Register Instance Event Processor", OMRSAuditCode.REGISTERING_EVENT_PROCESSOR.getMessageDefinition(new String[]{instanceEventConsumer.getEventProcessorName(), super.getEventProcessorName()}));
        this.instanceEventConsumers.add((OMRSInstanceEventProcessorInterface)instanceEventConsumer);
    }

    public void registerRepositoryEventProcessor(OMRSRepositoryEventProcessor repositoryEventProcessor) {
        String actionDescription = "Register Instance Event Processor";
        this.auditLog.logMessage("Register Instance Event Processor", OMRSAuditCode.REGISTERING_EVENT_PROCESSOR.getMessageDefinition(new String[]{repositoryEventProcessor.getEventProcessorName(), super.getEventProcessorName()}));
        this.instanceEventConsumers.add((OMRSInstanceEventProcessorInterface)repositoryEventProcessor);
        this.typeDefEventConsumers.add((OMRSTypeDefEventProcessorInterface)repositoryEventProcessor);
    }

    public void start() {
        String actionDescription = "Start OMRS Event Manager";
        this.auditLog.logMessage("Start OMRS Event Manager", OMRSAuditCode.STARTING_EVENT_MANAGER.getMessageDefinition(new String[]{this.eventProcessorName, Integer.toString(this.typeDefEventConsumers.size()), Integer.toString(this.instanceEventConsumers.size())}));
        this.isActive = true;
        this.drainEventBuffers();
    }

    private void drainEventBuffers() {
        String actionDescription = "Drain Event Buffers";
        if (!this.typeDefEventBuffer.isEmpty()) {
            this.auditLog.logMessage("Drain Event Buffers", OMRSAuditCode.DRAINING_TYPEDEF_EVENT_BUFFER.getMessageDefinition(new String[]{this.eventProcessorName, Integer.toString(this.typeDefEventBuffer.size())}));
            for (OMRSTypeDefEvent oMRSTypeDefEvent : this.typeDefEventBuffer) {
                if (oMRSTypeDefEvent == null) continue;
                this.distributeTypeDefEvent(oMRSTypeDefEvent);
            }
            this.typeDefEventBuffer.clear();
        }
        if (!this.instanceEventBuffer.isEmpty()) {
            this.auditLog.logMessage("Drain Event Buffers", OMRSAuditCode.DRAINING_INSTANCE_EVENT_BUFFER.getMessageDefinition(new String[]{this.eventProcessorName, Integer.toString(this.instanceEventBuffer.size())}));
            for (BufferedInstanceEvent bufferedInstanceEvent : this.instanceEventBuffer) {
                if (bufferedInstanceEvent == null) continue;
                InternalOMRSEventProcessingContext.clear();
                InternalOMRSEventProcessingContext.getInstance().setCurrentMessageId(bufferedInstanceEvent.getMessageId());
                this.distributeInstanceEvent(bufferedInstanceEvent.getEvent());
                OMRSFuture future = InternalOMRSEventProcessingContext.getInstance().getOverallAsyncProcessingResult();
                bufferedInstanceEvent.getFuture().setDelegate(future);
            }
            this.instanceEventBuffer.clear();
        }
    }

    private void distributeTypeDefEvent(OMRSTypeDefEvent event) {
        if (this.exchangeRule.processTypeDefEvents()) {
            for (OMRSTypeDefEventProcessorInterface consumer : this.typeDefEventConsumers) {
                consumer.sendTypeDefEvent(this.eventProcessorName, event);
            }
        }
    }

    private void distributeInstanceEvent(OMRSInstanceEvent event) {
        boolean validEvent = false;
        if (event.getInstanceEventType() == OMRSInstanceEventType.BATCH_INSTANCES_EVENT) {
            InstanceGraph eventGraph = event.getInstanceBatch();
            List eventEntities = eventGraph.getEntities();
            List eventRelationships = eventGraph.getRelationships();
            ArrayList<EntityDetail> validEntities = new ArrayList<EntityDetail>();
            ArrayList<Relationship> validRelationships = new ArrayList<Relationship>();
            for (EntityDetail entity : eventEntities) {
                if (!this.exchangeRule.processInstanceEvent((InstanceHeader)entity)) continue;
                validEntities.add(entity);
            }
            for (Relationship relationship : eventRelationships) {
                if (!this.exchangeRule.processInstanceEvent((InstanceHeader)relationship)) continue;
                validRelationships.add(relationship);
            }
            if (validEntities.size() > 0 || validRelationships.size() > 0) {
                InstanceGraph validInstanceGraph = new InstanceGraph(validEntities, validRelationships);
                OMRSInstanceEvent validInstanceEvent = new OMRSInstanceEvent(OMRSInstanceEventType.BATCH_INSTANCES_EVENT, validInstanceGraph);
                validInstanceEvent.setEventOriginator(event.getEventOriginator());
                event = validInstanceEvent;
                validEvent = true;
            }
        } else {
            validEvent = this.exchangeRule.processInstanceEvent(event.getTypeDefGUID(), event.getTypeDefName());
        }
        if (validEvent) {
            for (OMRSInstanceEventProcessorInterface consumer : this.instanceEventConsumers) {
                consumer.sendInstanceEvent(this.eventProcessorName, event);
            }
        }
    }

    public void sendTypeDefEvent(String sourceName, OMRSTypeDefEvent typeDefEvent) {
        if (this.isActive) {
            this.distributeTypeDefEvent(typeDefEvent);
        } else {
            this.typeDefEventBuffer.add(typeDefEvent);
        }
    }

    public void sendInstanceEvent(String sourceName, OMRSInstanceEvent instanceEvent) {
        if (this.isActive) {
            this.distributeInstanceEvent(instanceEvent);
        } else {
            BufferedInstanceEvent event = new BufferedInstanceEvent(instanceEvent, InternalOMRSEventProcessingContext.getInstance().getCurrentMessageId());
            this.instanceEventBuffer.add(event);
            InternalOMRSEventProcessingContext context = InternalOMRSEventProcessingContext.getInstance();
            context.addAsyncProcessingResult((OMRSFuture)event.getFuture());
        }
    }

    @Override
    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processNewEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
        }
    }

    @Override
    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        if (this.repositoryValidator.validEntity(sourceName, newEntity)) {
            super.processUpdatedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, oldEntity, newEntity);
        }
    }

    @Override
    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processUndoneEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
        }
    }

    @Override
    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processClassifiedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, classification);
        }
    }

    @Override
    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification classification) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processClassifiedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, classification);
        }
    }

    @Override
    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processDeclassifiedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, originalClassification);
        }
    }

    @Override
    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processDeclassifiedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, originalClassification);
        }
    }

    @Override
    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processReclassifiedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, originalClassification, classification);
        }
    }

    @Override
    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification, Classification classification) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processReclassifiedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity, originalClassification, classification);
        }
    }

    @Override
    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processDeletedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
        }
    }

    @Override
    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processRestoredEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
        }
    }

    @Override
    public void processPurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processPurgedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
        }
    }

    @Override
    public void processPurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        if (this.repositoryValidator.validInstanceId(sourceName, typeDefGUID, typeDefName, TypeDefCategory.ENTITY_DEF, instanceGUID)) {
            super.processPurgedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, typeDefGUID, typeDefName, instanceGUID);
        }
    }

    @Override
    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processDeletePurgedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
        }
    }

    @Override
    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processReIdentifiedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, originalEntityGUID, entity);
        }
    }

    @Override
    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processReTypedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, originalTypeDefSummary, entity);
        }
    }

    @Override
    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processReHomedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, originalHomeMetadataCollectionId, entity);
        }
    }

    @Override
    public void processRefreshEntityRequested(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
        if (this.repositoryValidator.validInstanceId(sourceName, typeDefGUID, typeDefName, TypeDefCategory.ENTITY_DEF, instanceGUID)) {
            super.processRefreshEntityRequested(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, typeDefGUID, typeDefName, instanceGUID, homeMetadataCollectionId);
        }
    }

    @Override
    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        if (this.repositoryValidator.validEntity(sourceName, entity)) {
            super.processRefreshEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
        }
    }

    @Override
    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        if (this.repositoryValidator.validRelationship(sourceName, relationship)) {
            super.processNewRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship);
        }
    }

    @Override
    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        if (this.repositoryValidator.validRelationship(sourceName, newRelationship)) {
            super.processUpdatedRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, oldRelationship, newRelationship);
        }
    }

    @Override
    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        if (this.repositoryValidator.validRelationship(sourceName, relationship)) {
            super.processUndoneRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship);
        }
    }

    @Override
    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        if (this.repositoryValidator.validRelationship(sourceName, relationship)) {
            super.processDeletedRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship);
        }
    }

    @Override
    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        if (this.repositoryValidator.validRelationship(sourceName, relationship)) {
            super.processRestoredRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship);
        }
    }

    @Override
    public void processPurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        if (this.repositoryValidator.validRelationship(sourceName, relationship)) {
            super.processPurgedRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship);
        }
    }

    @Override
    public void processPurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        if (this.repositoryValidator.validInstanceId(sourceName, typeDefGUID, typeDefName, TypeDefCategory.RELATIONSHIP_DEF, instanceGUID)) {
            super.processPurgedRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, typeDefGUID, typeDefName, instanceGUID);
        }
    }

    @Override
    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        if (this.repositoryValidator.validRelationship(sourceName, relationship)) {
            super.processDeletePurgedRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship);
        }
    }

    @Override
    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        if (this.repositoryValidator.validRelationship(sourceName, relationship)) {
            super.processReIdentifiedRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, originalRelationshipGUID, relationship);
        }
    }

    @Override
    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        if (this.repositoryValidator.validRelationship(sourceName, relationship)) {
            super.processReTypedRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, originalTypeDefSummary, relationship);
        }
    }

    @Override
    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        if (this.repositoryValidator.validRelationship(sourceName, relationship)) {
            super.processReHomedRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, originalHomeMetadataCollection, relationship);
        }
    }

    @Override
    public void processRefreshRelationshipRequest(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
        if (this.repositoryValidator.validInstanceId(sourceName, typeDefGUID, typeDefName, TypeDefCategory.RELATIONSHIP_DEF, instanceGUID)) {
            super.processRefreshRelationshipRequest(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, typeDefGUID, typeDefName, instanceGUID, homeMetadataCollectionId);
        }
    }

    @Override
    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        if (this.repositoryValidator.validRelationship(sourceName, relationship)) {
            super.processRefreshRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship);
        }
    }

    @Override
    public void processInstanceBatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, InstanceGraph instances) {
        if (instances != null) {
            ArrayList<EntityDetail> validatedEntities = new ArrayList<EntityDetail>();
            ArrayList<Relationship> validatedRelationships = new ArrayList<Relationship>();
            if (instances.getEntities() != null) {
                for (EntityDetail entity : instances.getEntities()) {
                    if (!this.repositoryValidator.validEntity(sourceName, entity)) continue;
                    validatedEntities.add(entity);
                }
            }
            if (instances.getRelationships() != null) {
                for (Relationship relationship : instances.getRelationships()) {
                    if (!this.repositoryValidator.validRelationship(sourceName, relationship)) continue;
                    validatedRelationships.add(relationship);
                }
            }
            if (!validatedEntities.isEmpty() || !validatedRelationships.isEmpty()) {
                InstanceGraph validatedInstances = new InstanceGraph();
                validatedInstances.setEntities(validatedEntities);
                validatedInstances.setRelationships(validatedRelationships);
                super.processInstanceBatchEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, validatedInstances);
            }
        }
    }

    @Override
    public void processConflictingInstancesEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, String otherMetadataCollectionId, InstanceProvenanceType otherOrigin, TypeDefSummary otherTypeDefSummary, String otherInstanceGUID, String errorMessage) {
        if (this.repositoryValidator.validTypeDefSummary(sourceName, targetTypeDefSummary) && this.repositoryValidator.validTypeDefSummary(sourceName, otherTypeDefSummary) && (this.exchangeRule.processInstanceEvent(targetTypeDefSummary) || this.exchangeRule.processInstanceEvent(otherTypeDefSummary))) {
            super.processConflictingInstancesEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, targetMetadataCollectionId, targetTypeDefSummary, targetInstanceGUID, otherMetadataCollectionId, otherOrigin, otherTypeDefSummary, otherInstanceGUID, errorMessage);
        }
    }

    @Override
    public void processConflictingTypeEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, TypeDefSummary otherTypeDefSummary, String errorMessage) {
        if (this.exchangeRule.processInstanceEvent(targetTypeDefSummary)) {
            super.processConflictingTypeEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, targetMetadataCollectionId, targetTypeDefSummary, targetInstanceGUID, otherTypeDefSummary, errorMessage);
        }
    }
}

