/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataDefaultRepositorySecurity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OpenMetadataRepositorySecurity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventManager;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefInUseException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSTypeDefManager;

public class LocalOMRSMetadataCollection
extends OMRSMetadataCollectionBase {
    private OMRSMetadataCollection realMetadataCollection;
    private String localServerName;
    private String localServerType;
    private String localOrganizationName;
    private boolean produceEventsForRealConnector;
    private OMRSRepositoryEventManager outboundRepositoryEventProcessor;
    private OMRSTypeDefManager localTypeDefManager;
    private OpenMetadataRepositorySecurity securityVerifier = new OMRSMetadataDefaultRepositorySecurity();

    LocalOMRSMetadataCollection(LocalOMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId, String localServerName, String localServerType, String localOrganizationName, OMRSMetadataCollection realMetadataCollection, OMRSRepositoryEventManager outboundRepositoryEventProcessor, boolean produceEventsForRealConnector, OMRSTypeDefManager typeDefManager) {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
        if (realMetadataCollection == null) {
            String actionDescription = "Local OMRS Metadata Collection Constructor";
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_LOCAL_METADATA_COLLECTION.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "Local OMRS Metadata Collection Constructor");
        }
        this.realMetadataCollection = realMetadataCollection;
        this.localServerName = localServerName;
        this.localServerType = localServerType;
        this.localOrganizationName = localOrganizationName;
        this.produceEventsForRealConnector = produceEventsForRealConnector;
        this.outboundRepositoryEventProcessor = outboundRepositoryEventProcessor;
        this.localTypeDefManager = typeDefManager;
    }

    void setSecurityVerifier(OpenMetadataRepositorySecurity securityVerifier) {
        if (securityVerifier != null) {
            this.securityVerifier = securityVerifier;
        }
    }

    private List<TypeDef> securityVerifyTypeDefList(String userId, List<TypeDef> typeDefs) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        if (typeDefs != null) {
            ArrayList<TypeDef> validatedTypeDefs = new ArrayList<TypeDef>();
            org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException savedException = null;
            for (TypeDef typeDef : typeDefs) {
                try {
                    this.securityVerifier.validateUserForTypeRead(userId, this.metadataCollectionName, typeDef);
                    validatedTypeDefs.add(typeDef);
                }
                catch (UserNotAuthorizedException error) {
                    savedException = new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
                }
            }
            if (validatedTypeDefs.isEmpty()) {
                if (savedException != null) {
                    throw savedException;
                }
            } else {
                return validatedTypeDefs;
            }
        }
        return null;
    }

    private List<AttributeTypeDef> securityVerifyAttributeTypeDefList(String userId, List<AttributeTypeDef> attributeTypeDefs) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        if (attributeTypeDefs != null) {
            ArrayList<AttributeTypeDef> validatedAttributeTypeDefs = new ArrayList<AttributeTypeDef>();
            org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException savedException = null;
            for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
                try {
                    this.securityVerifier.validateUserForTypeRead(userId, this.metadataCollectionName, attributeTypeDef);
                    validatedAttributeTypeDefs.add(attributeTypeDef);
                }
                catch (UserNotAuthorizedException error) {
                    savedException = new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
                }
            }
            if (validatedAttributeTypeDefs.isEmpty()) {
                if (savedException != null) {
                    throw savedException;
                }
            } else {
                return validatedAttributeTypeDefs;
            }
        }
        return null;
    }

    public TypeDefGallery getAllTypes(String userId) throws InvalidParameterException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getAllTypes";
        super.basicRequestValidation(userId, "getAllTypes");
        TypeDefGallery results = this.realMetadataCollection.getAllTypes(userId);
        if (results != null) {
            results.setTypeDefs(this.securityVerifyTypeDefList(userId, results.getTypeDefs()));
            results.setAttributeTypeDefs(this.securityVerifyAttributeTypeDefList(userId, results.getAttributeTypeDefs()));
        }
        return results;
    }

    public TypeDefGallery findTypesByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "findTypesByName";
        String nameParameterName = "name";
        super.typeNameParameterValidation(userId, name, "name", "findTypesByName");
        TypeDefGallery results = this.realMetadataCollection.findTypesByName(userId, name);
        if (results != null) {
            results.setTypeDefs(this.securityVerifyTypeDefList(userId, results.getTypeDefs()));
            results.setAttributeTypeDefs(this.securityVerifyAttributeTypeDefList(userId, results.getAttributeTypeDefs()));
        }
        return results;
    }

    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "findTypeDefsByCategory";
        String categoryParameterName = "category";
        super.typeDefCategoryParameterValidation(userId, category, "category", "findTypeDefsByCategory");
        return this.securityVerifyTypeDefList(userId, this.realMetadataCollection.findTypeDefsByCategory(userId, category));
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "findAttributeTypeDefsByCategory";
        String categoryParameterName = "category";
        super.attributeTypeDefCategoryParameterValidation(userId, category, "category", "findAttributeTypeDefsByCategory");
        return this.securityVerifyAttributeTypeDefList(userId, this.realMetadataCollection.findAttributeTypeDefsByCategory(userId, category));
    }

    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "findTypeDefsByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        super.typeDefPropertyParameterValidation(userId, matchCriteria, "matchCriteria", "findTypeDefsByProperty");
        return this.securityVerifyTypeDefList(userId, this.realMetadataCollection.findTypeDefsByProperty(userId, matchCriteria));
    }

    public List<TypeDef> findTypesByExternalID(String userId, String standard, String organization, String identifier) throws InvalidParameterException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "findTypesByExternalID";
        super.typeDefExternalIDParameterValidation(userId, standard, organization, identifier, "findTypesByExternalID");
        return this.securityVerifyTypeDefList(userId, this.realMetadataCollection.findTypesByExternalID(userId, standard, organization, identifier));
    }

    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "searchForTypeDefs";
        String searchCriteriaParameterName = "searchCriteria";
        super.typeDefSearchParameterValidation(userId, searchCriteria, "searchCriteria", "searchForTypeDefs");
        return this.securityVerifyTypeDefList(userId, this.realMetadataCollection.searchForTypeDefs(userId, searchCriteria));
    }

    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        super.typeGUIDParameterValidation(userId, guid, "guid", "getTypeDefByGUID");
        TypeDef typeDef = this.realMetadataCollection.getTypeDefByGUID(userId, guid);
        if (typeDef != null) {
            try {
                this.securityVerifier.validateUserForTypeRead(userId, this.metadataCollectionName, typeDef);
            }
            catch (UserNotAuthorizedException error) {
                throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
            }
        }
        return typeDef;
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByGUID";
        String guidParameterName = "guid";
        super.typeGUIDParameterValidation(userId, guid, "guid", "getAttributeTypeDefByGUID");
        AttributeTypeDef attributeTypeDef = this.realMetadataCollection.getAttributeTypeDefByGUID(userId, guid);
        if (attributeTypeDef != null) {
            try {
                this.securityVerifier.validateUserForTypeRead(userId, this.metadataCollectionName, attributeTypeDef);
            }
            catch (UserNotAuthorizedException error) {
                throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
            }
        }
        return attributeTypeDef;
    }

    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getTypeDefByName";
        String nameParameterName = "name";
        super.typeNameParameterValidation(userId, name, "name", "getTypeDefByName");
        TypeDef typeDef = this.realMetadataCollection.getTypeDefByName(userId, name);
        if (typeDef != null) {
            try {
                this.securityVerifier.validateUserForTypeRead(userId, this.metadataCollectionName, typeDef);
            }
            catch (UserNotAuthorizedException error) {
                throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
            }
        }
        return typeDef;
    }

    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByName";
        String nameParameterName = "name";
        super.typeNameParameterValidation(userId, name, "name", "getAttributeTypeDefByName");
        AttributeTypeDef attributeTypeDef = this.realMetadataCollection.getAttributeTypeDefByName(userId, name);
        if (attributeTypeDef != null) {
            try {
                this.securityVerifier.validateUserForTypeRead(userId, this.metadataCollectionName, attributeTypeDef);
            }
            catch (UserNotAuthorizedException error) {
                throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
            }
        }
        return attributeTypeDef;
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "addTypeDef";
        String typeDefParameterName = "newTypeDef";
        super.newTypeDefParameterValidation(userId, newTypeDef, "newTypeDef", "addTypeDef");
        try {
            this.securityVerifier.validateUserForTypeCreate(userId, this.metadataCollectionName, newTypeDef);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        this.realMetadataCollection.addTypeDef(userId, newTypeDef);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.addTypeDef(this.repositoryName, newTypeDef);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processNewTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, newTypeDef);
        }
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "addAttributeTypeDef";
        String typeDefParameterName = "newAttributeTypeDef";
        super.newAttributeTypeDefParameterValidation(userId, newAttributeTypeDef, "newAttributeTypeDef", "addAttributeTypeDef");
        try {
            this.securityVerifier.validateUserForTypeCreate(userId, this.metadataCollectionName, newAttributeTypeDef);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        this.realMetadataCollection.addAttributeTypeDef(userId, newAttributeTypeDef);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.addAttributeTypeDef(this.repositoryName, newAttributeTypeDef);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processNewAttributeTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, newAttributeTypeDef);
        }
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "verifyTypeDef";
        String typeDefParameterName = "typeDef";
        super.typeDefParameterValidation(userId, typeDef, "typeDef", "verifyTypeDef");
        return this.realMetadataCollection.verifyTypeDef(userId, typeDef);
    }

    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "verifyAttributeTypeDef";
        String typeDefParameterName = "attributeTypeDef";
        super.attributeTypeDefParameterValidation(userId, attributeTypeDef, "attributeTypeDef", "verifyAttributeTypeDef");
        return this.realMetadataCollection.verifyAttributeTypeDef(userId, attributeTypeDef);
    }

    public TypeDef updateTypeDef(String userId, TypeDefPatch typeDefPatch) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, PatchErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "updateTypeDef";
        TypeDef typeDef = super.updateTypeDefParameterValidation(userId, typeDefPatch, "updateTypeDef");
        try {
            this.securityVerifier.validateUserForTypeUpdate(userId, this.metadataCollectionName, typeDef, typeDefPatch);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        TypeDef updatedTypeDef = this.realMetadataCollection.updateTypeDef(userId, typeDefPatch);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.updateTypeDef(this.repositoryName, updatedTypeDef);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processUpdatedTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefPatch);
        }
        return updatedTypeDef;
    }

    public void deleteTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "deleteTypeDef";
        String guidParameterName = "obsoleteTypeDefGUID";
        String nameParameterName = "obsoleteTypeDefName";
        TypeDef typeDef = super.manageTypeDefParameterValidation(userId, "obsoleteTypeDefGUID", "obsoleteTypeDefName", obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteTypeDef");
        try {
            this.securityVerifier.validateUserForTypeDelete(userId, this.metadataCollectionName, typeDef);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        this.realMetadataCollection.deleteTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.deleteTypeDef(this.repositoryName, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processDeletedTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
    }

    public void deleteAttributeTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "deleteAttributeTypeDef";
        String guidParameterName = "obsoleteTypeDefGUID";
        String nameParameterName = "obsoleteTypeDefName";
        AttributeTypeDef attributeTypeDef = super.manageAttributeTypeDefParameterValidation(userId, "obsoleteTypeDefGUID", "obsoleteTypeDefName", obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteAttributeTypeDef");
        try {
            this.securityVerifier.validateUserForTypeDelete(userId, this.metadataCollectionName, attributeTypeDef);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        this.realMetadataCollection.deleteAttributeTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.deleteAttributeTypeDef(this.repositoryName, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processDeletedAttributeTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
    }

    public TypeDef reIdentifyTypeDef(String userId, String originalTypeDefGUID, String originalTypeDefName, String newTypeDefGUID, String newTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "reIdentifyTypeDef";
        String originalGUIDParameterName = "originalTypeDefGUID";
        String originalNameParameterName = "originalTypeDefName";
        String newGUIDParameterName = "newTypeDefGUID";
        String newNameParameterName = "newTypeDefName";
        TypeDef originalTypeDef = super.manageTypeDefParameterValidation(userId, "originalTypeDefGUID", "originalTypeDefName", originalTypeDefGUID, originalTypeDefName, "reIdentifyTypeDef");
        super.manageTypeDefParameterValidation(userId, "newTypeDefGUID", "newTypeDefName", newTypeDefGUID, newTypeDefName, "reIdentifyTypeDef");
        try {
            this.securityVerifier.validateUserForTypeReIdentify(userId, this.metadataCollectionName, originalTypeDef, newTypeDefGUID, newTypeDefName);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        TypeDef newTypeDef = this.realMetadataCollection.reIdentifyTypeDef(userId, originalTypeDefGUID, originalTypeDefName, newTypeDefGUID, newTypeDefName);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.reIdentifyTypeDef(this.repositoryName, originalTypeDefGUID, originalTypeDefName, newTypeDef);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processReIdentifiedTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, (TypeDefSummary)originalTypeDef, newTypeDef);
        }
        return newTypeDef;
    }

    public AttributeTypeDef reIdentifyAttributeTypeDef(String userId, String originalAttributeTypeDefGUID, String originalAttributeTypeDefName, String newAttributeTypeDefGUID, String newAttributeTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "reIdentifyAttributeTypeDef";
        String originalGUIDParameterName = "originalAttributeTypeDefGUID";
        String originalNameParameterName = "originalAttributeTypeDefName";
        String newGUIDParameterName = "newAttributeTypeDefGUID";
        String newNameParameterName = "newAttributeTypeDefName";
        AttributeTypeDef originalAttributeTypeDef = super.manageAttributeTypeDefParameterValidation(userId, "originalAttributeTypeDefGUID", "originalAttributeTypeDefName", originalAttributeTypeDefGUID, originalAttributeTypeDefName, "reIdentifyAttributeTypeDef");
        super.manageAttributeTypeDefParameterValidation(userId, "newAttributeTypeDefGUID", "newAttributeTypeDefName", newAttributeTypeDefGUID, newAttributeTypeDefName, "reIdentifyAttributeTypeDef");
        try {
            this.securityVerifier.validateUserForTypeReIdentify(userId, this.metadataCollectionName, originalAttributeTypeDef, newAttributeTypeDefGUID, newAttributeTypeDefName);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        AttributeTypeDef newAttributeTypeDef = this.realMetadataCollection.reIdentifyAttributeTypeDef(userId, originalAttributeTypeDefGUID, originalAttributeTypeDefName, newAttributeTypeDefGUID, newAttributeTypeDefName);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.reIdentifyAttributeTypeDef(this.repositoryName, originalAttributeTypeDefGUID, originalAttributeTypeDefName, newAttributeTypeDef);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processReIdentifiedAttributeTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, originalAttributeTypeDef, newAttributeTypeDef);
        }
        return newAttributeTypeDef;
    }

    private void setLocalProvenance(InstanceAuditHeader instance) {
        if (instance != null) {
            if (instance.getMetadataCollectionId() == null) {
                instance.setMetadataCollectionId(this.metadataCollectionId);
                instance.setMetadataCollectionName(this.metadataCollectionName);
                instance.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
            }
            if (instance.getInstanceProvenanceType() == InstanceProvenanceType.EXTERNAL_SOURCE && instance.getReplicatedBy() == null) {
                instance.setReplicatedBy(this.metadataCollectionId);
            }
            if (instance.getMetadataCollectionName() == null && this.metadataCollectionId.equals(instance.getMetadataCollectionId())) {
                instance.setMetadataCollectionName(this.metadataCollectionName);
            }
        }
    }

    private void setLocalProvenanceInEntityClassifications(List<Classification> entityClassifications) {
        if (entityClassifications != null) {
            for (Classification homeClassification : entityClassifications) {
                if (homeClassification == null) continue;
                this.setLocalProvenance((InstanceAuditHeader)homeClassification);
            }
        }
    }

    private void setLocalProvenanceThroughoutEntity(EntityDetail entity) {
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            this.setLocalProvenanceInEntityClassifications(entity.getClassifications());
        }
    }

    private void setLocalProvenanceThroughoutRelationship(Relationship relationship) {
        if (relationship != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            EntityProxy endOneProxy = relationship.getEntityOneProxy();
            this.setLocalProvenance((InstanceAuditHeader)endOneProxy);
            relationship.setEntityOneProxy(endOneProxy);
            EntityProxy endTwoProxy = relationship.getEntityTwoProxy();
            this.setLocalProvenance((InstanceAuditHeader)endTwoProxy);
            relationship.setEntityTwoProxy(endTwoProxy);
        }
    }

    private List<EntityDetail> setLocalProvenanceInEntityList(List<EntityDetail> instanceList) {
        if (instanceList == null || instanceList.isEmpty()) {
            return null;
        }
        ArrayList<EntityDetail> resultList = new ArrayList<EntityDetail>();
        for (EntityDetail entity : instanceList) {
            if (entity == null) continue;
            this.setLocalProvenanceThroughoutEntity(entity);
            resultList.add(entity);
        }
        return resultList;
    }

    private List<Relationship> setLocalProvenanceInRelationshipList(List<Relationship> instanceList) {
        if (instanceList == null || instanceList.isEmpty()) {
            return null;
        }
        ArrayList<Relationship> resultList = new ArrayList<Relationship>();
        for (Relationship relationship : instanceList) {
            if (relationship == null) continue;
            this.setLocalProvenanceThroughoutRelationship(relationship);
            resultList.add(relationship);
        }
        return resultList;
    }

    private List<EntityDetail> securityVerifyReadEntityList(String userId, List<EntityDetail> instanceList) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        if (instanceList == null || instanceList.isEmpty()) {
            return null;
        }
        ArrayList<EntityDetail> resultList = new ArrayList<EntityDetail>();
        for (EntityDetail entity : instanceList) {
            EntityDetail validatedEntity = this.getValidatedEntity(userId, entity);
            if (validatedEntity == null) continue;
            resultList.add(validatedEntity);
        }
        return resultList;
    }

    private List<Relationship> securityVerifyReadRelationshipList(String userId, List<Relationship> instanceList) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        if (instanceList == null || instanceList.isEmpty()) {
            return null;
        }
        ArrayList<Relationship> resultList = new ArrayList<Relationship>();
        for (Relationship relationship : instanceList) {
            Relationship validatedRelationship = this.getValidatedRelationship(userId, relationship);
            if (validatedRelationship == null) continue;
            resultList.add(validatedRelationship);
        }
        return resultList;
    }

    private EntityDetail getValidatedEntity(String userId, EntityDetail retrievedEntity) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        if (retrievedEntity != null) {
            this.setLocalProvenanceThroughoutEntity(retrievedEntity);
            this.setLocalProvenanceInEntityClassifications(retrievedEntity.getClassifications());
            try {
                return this.securityVerifier.validateUserForEntityRead(userId, this.metadataCollectionName, retrievedEntity);
            }
            catch (UserNotAuthorizedException error) {
                throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
            }
        }
        return null;
    }

    private Relationship getValidatedRelationship(String userId, Relationship retrievedRelationship) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        if (retrievedRelationship != null) {
            this.setLocalProvenanceThroughoutRelationship(retrievedRelationship);
            try {
                return this.securityVerifier.validateUserForRelationshipRead(userId, this.metadataCollectionName, retrievedRelationship);
            }
            catch (UserNotAuthorizedException error) {
                throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
            }
        }
        return null;
    }

    private InstanceGraph setLocalProvenanceInGraph(InstanceGraph instanceGraph) {
        InstanceGraph resultGraph = new InstanceGraph();
        if (instanceGraph != null) {
            resultGraph.setEntities(this.setLocalProvenanceInEntityList(instanceGraph.getEntities()));
            resultGraph.setRelationships(this.setLocalProvenanceInRelationshipList(instanceGraph.getRelationships()));
        }
        return resultGraph;
    }

    private InstanceGraph securityVerifyReadGraph(String userId, InstanceGraph instanceGraph) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        InstanceGraph resultGraph = new InstanceGraph();
        if (instanceGraph != null) {
            org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException savedException = null;
            try {
                resultGraph.setEntities(this.securityVerifyReadEntityList(userId, instanceGraph.getEntities()));
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
                savedException = error;
            }
            try {
                resultGraph.setRelationships(this.securityVerifyReadRelationshipList(userId, instanceGraph.getRelationships()));
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
                savedException = error;
            }
            if (resultGraph.getEntities() == null && resultGraph.getRelationships() == null && savedException != null) {
                throw savedException;
            }
        }
        return resultGraph;
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "isEntityKnown";
        super.getInstanceParameterValidation(userId, guid, "isEntityKnown");
        EntityDetail entity = this.realMetadataCollection.isEntityKnown(userId, guid);
        return this.getValidatedEntity(userId, entity);
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getEntitySummary";
        super.getInstanceParameterValidation(userId, guid, "getEntitySummary");
        EntitySummary entity = this.realMetadataCollection.getEntitySummary(userId, guid);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "getEntitySummary");
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            this.setLocalProvenanceInEntityClassifications(entity.getClassifications());
            try {
                this.securityVerifier.validateUserForEntitySummaryRead(userId, this.metadataCollectionName, entity);
            }
            catch (UserNotAuthorizedException error) {
                throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
            }
        }
        return entity;
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, "getEntityDetail");
        EntityDetail entity = this.realMetadataCollection.getEntityDetail(userId, guid);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "getEntityDetail");
        return this.getValidatedEntity(userId, entity);
    }

    public EntityDetail getEntityDetail(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, asOfTime, "getEntityDetail");
        EntityDetail entity = this.realMetadataCollection.getEntityDetail(userId, guid, asOfTime);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "getEntityDetail");
        return this.getValidatedEntity(userId, entity);
    }

    public List<EntityDetail> getEntityDetailHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getEntityDetailHistory";
        this.getInstanceHistoryParameterValidation(userId, guid, fromTime, toTime, "getEntityDetailHistory");
        List history = this.realMetadataCollection.getEntityDetailHistory(userId, guid, fromTime, toTime, startFromElement, pageSize, sequencingOrder);
        return this.securityVerifyReadEntityList(userId, this.setLocalProvenanceInEntityList(history));
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        super.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.securityVerifyReadRelationshipList(userId, this.setLocalProvenanceInRelationshipList(resultList));
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        super.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.securityVerifyReadEntityList(userId, this.setLocalProvenanceInEntityList(resultList));
    }

    public List<EntityDetail> findEntities(String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties matchProperties, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        super.findEntitiesParameterValidation(userId, entityTypeGUID, entitySubtypeGUIDs, matchProperties, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findEntities(userId, entityTypeGUID, entitySubtypeGUIDs, matchProperties, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.securityVerifyReadEntityList(userId, this.setLocalProvenanceInEntityList(resultList));
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        super.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findEntitiesByClassification(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.securityVerifyReadEntityList(userId, this.setLocalProvenanceInEntityList(resultList));
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        super.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.securityVerifyReadEntityList(userId, this.setLocalProvenanceInEntityList(resultList));
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "isRelationshipKnown";
        super.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
        Relationship relationship = this.realMetadataCollection.isRelationshipKnown(userId, guid);
        return this.getValidatedRelationship(userId, relationship);
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, "getRelationship");
        Relationship relationship = this.realMetadataCollection.getRelationship(userId, guid);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, guid, relationship, "getRelationship");
        return this.getValidatedRelationship(userId, relationship);
    }

    public Relationship getRelationship(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, asOfTime, "getRelationship");
        Relationship relationship = this.realMetadataCollection.getRelationship(userId, guid, asOfTime);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, guid, relationship, "getRelationship");
        return this.getValidatedRelationship(userId, relationship);
    }

    public List<Relationship> getRelationshipHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getRelationshipHistory";
        this.getInstanceHistoryParameterValidation(userId, guid, fromTime, toTime, "getRelationshipHistory");
        List history = this.realMetadataCollection.getRelationshipHistory(userId, guid, fromTime, toTime, startFromElement, pageSize, sequencingOrder);
        return this.securityVerifyReadRelationshipList(userId, this.setLocalProvenanceInRelationshipList(history));
    }

    public List<Relationship> findRelationships(String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        super.findRelationshipsParameterValidation(userId, relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findRelationships(userId, relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.securityVerifyReadRelationshipList(userId, this.setLocalProvenanceInRelationshipList(resultList));
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        super.findRelationshipsByPropertyParameterValidation(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.securityVerifyReadRelationshipList(userId, this.setLocalProvenanceInRelationshipList(resultList));
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        super.findRelationshipsByPropertyValueParameterValidation(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.securityVerifyReadRelationshipList(userId, this.setLocalProvenanceInRelationshipList(resultList));
    }

    public InstanceGraph getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        super.getLinkingEntitiesParameterValidation(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
        InstanceGraph resultGraph = this.realMetadataCollection.getLinkingEntities(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
        return this.securityVerifyReadGraph(userId, this.setLocalProvenanceInGraph(resultGraph));
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getEntityNeighborhood";
        super.getEntityNeighborhoodParameterValidation(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
        this.validateRepositoryConnector("getEntityNeighborhood");
        InstanceGraph resultGraph = this.realMetadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
        return this.securityVerifyReadGraph(userId, this.setLocalProvenanceInGraph(resultGraph));
    }

    public List<EntityDetail> getRelatedEntities(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "getRelatedEntities";
        super.getRelatedEntitiesParameterValidation(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        this.validateRepositoryConnector("getRelatedEntities");
        List resultList = this.realMetadataCollection.getRelatedEntities(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.securityVerifyReadEntityList(userId, this.setLocalProvenanceInEntityList(resultList));
    }

    public EntityDetail addEntity(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "addEntity";
        super.addEntityParameterValidation(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus, "addEntity");
        try {
            this.securityVerifier.validateUserForEntityCreate(userId, this.metadataCollectionName, entityTypeGUID, initialProperties, initialClassifications, initialStatus);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        EntityDetail entity = this.realMetadataCollection.addEntity(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus);
        if (entity != null) {
            this.setLocalProvenanceThroughoutEntity(entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processNewEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public EntityDetail addExternalEntity(String userId, String entityTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "addExternalEntity";
        super.addExternalEntityParameterValidation(userId, entityTypeGUID, externalSourceGUID, initialProperties, initialClassifications, initialStatus, "addExternalEntity");
        try {
            this.securityVerifier.validateUserForEntityCreate(userId, externalSourceName, entityTypeGUID, initialProperties, initialClassifications, initialStatus);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        EntityDetail entity = this.realMetadataCollection.addExternalEntity(userId, entityTypeGUID, externalSourceGUID, externalSourceName, initialProperties, initialClassifications, initialStatus);
        if (entity != null) {
            this.setLocalProvenanceThroughoutEntity(entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processNewEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public void addEntityProxy(String userId, EntityProxy entityProxy) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        super.addEntityProxyParameterValidation(userId, entityProxy);
        this.realMetadataCollection.addEntityProxy(userId, entityProxy);
    }

    private EntityDetail validateEntityCanBeUpdated(String userId, String entityGUID, String methodName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        EntityDetail entityDetail = this.validateEntityIsNotProxy(userId, entityGUID, methodName);
        this.validateEntityCanBeUpdatedByRepository(entityGUID, entityDetail, methodName);
        return entityDetail;
    }

    private EntityDetail validateEntityIsNotProxy(String userId, String entityGUID, String methodName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        EntityDetail entityDetail;
        try {
            entityDetail = this.realMetadataCollection.getEntityDetail(userId, entityGUID);
        }
        catch (EntityProxyOnlyException error) {
            throw new InvalidParameterException(OMRSErrorCode.ENTITY_PROXY_IN_HOME.getMessageDefinition(new String[]{this.repositoryName, entityGUID, methodName}), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)error, "entityGUID");
        }
        return entityDetail;
    }

    private void validateEntityCanBeUpdatedByRepository(String entityGUID, EntityDetail entityDetail, String methodName) throws InvalidParameterException, EntityNotKnownException {
        if (entityDetail != null) {
            if (entityDetail.getInstanceProvenanceType() == InstanceProvenanceType.LOCAL_COHORT ? this.metadataCollectionId.equals(entityDetail.getMetadataCollectionId()) : entityDetail.getInstanceProvenanceType() == InstanceProvenanceType.EXTERNAL_SOURCE && this.metadataCollectionId.equals(entityDetail.getReplicatedBy())) {
                return;
            }
            String parameterName = "entityGUID";
            throw new InvalidParameterException(OMRSErrorCode.ENTITY_CAN_NOT_BE_UPDATED.getMessageDefinition(new String[]{this.repositoryName, entityGUID, methodName}), ((Object)((Object)this)).getClass().getName(), methodName, parameterName);
        }
        throw new EntityNotKnownException(OMRSErrorCode.NULL_INSTANCE.getMessageDefinition(new String[]{this.repositoryName, entityGUID, methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    private EntityDetail validateEntityCanBeRehomed(String userId, String entityGUID, String methodName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        EntityDetail entityDetail = this.validateEntityIsNotProxy(userId, entityGUID, methodName);
        this.validateEntityCanBeRehomedByRepository(entityGUID, entityDetail, methodName);
        return entityDetail;
    }

    private EntityDetail validateEntityCanBeRehomedByRepository(String entityGUID, EntityDetail entityDetail, String methodName) throws InvalidParameterException, EntityNotKnownException {
        if (entityDetail != null) {
            boolean updateAllowed = false;
            InstanceProvenanceType instanceProvenance = entityDetail.getInstanceProvenanceType();
            switch (instanceProvenance) {
                case LOCAL_COHORT: {
                    String entityHome = entityDetail.getMetadataCollectionId();
                    if (entityHome == null || entityHome.equals(this.metadataCollectionId)) break;
                    updateAllowed = true;
                    break;
                }
                case EXTERNAL_SOURCE: {
                    String replicatedBy = entityDetail.getReplicatedBy();
                    if (replicatedBy == null || replicatedBy.equals(this.metadataCollectionId)) break;
                    updateAllowed = true;
                    break;
                }
                default: {
                    updateAllowed = false;
                }
            }
            if (updateAllowed) {
                return entityDetail;
            }
            String parameterName = "entityGUID";
            throw new InvalidParameterException(OMRSErrorCode.INSTANCE_HOME_NOT_LOCAL.getMessageDefinition(new String[]{entityDetail.getMetadataCollectionId(), methodName, entityDetail.getGUID(), this.metadataCollectionId, this.repositoryName}), ((Object)((Object)this)).getClass().getName(), methodName, parameterName);
        }
        throw new EntityNotKnownException(OMRSErrorCode.NULL_INSTANCE.getMessageDefinition(new String[]{this.repositoryName, entityGUID, methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    private Relationship validateRelationshipCanBeUpdated(String userId, String relationshipGUID, String methodName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        Relationship relationship = this.validateRelationshipCanBeUpdatedByRepository(relationshipGUID, this.realMetadataCollection.getRelationship(userId, relationshipGUID), methodName);
        return relationship;
    }

    private Relationship validateRelationshipCanBeUpdated(String userId, Relationship relationship, String methodName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        if (relationship != null) {
            relationship = this.validateRelationshipCanBeUpdatedByRepository(relationship.getGUID(), relationship, methodName);
            return relationship;
        }
        throw new RelationshipNotKnownException(OMRSErrorCode.NULL_INSTANCE.getMessageDefinition(new String[]{this.repositoryName, null, methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    private Relationship validateRelationshipCanBeUpdatedByRepository(String relationshipGUID, Relationship relationship, String methodName) throws InvalidParameterException, RelationshipNotKnownException, RepositoryErrorException {
        if (relationship != null) {
            this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, relationshipGUID, relationship, methodName);
            if (relationship.getInstanceProvenanceType() == InstanceProvenanceType.LOCAL_COHORT ? this.metadataCollectionId.equals(relationship.getMetadataCollectionId()) : relationship.getInstanceProvenanceType() == InstanceProvenanceType.EXTERNAL_SOURCE && this.metadataCollectionId.equals(relationship.getReplicatedBy())) {
                return relationship;
            }
            String parameterName = "relationshipGUID";
            throw new InvalidParameterException(OMRSErrorCode.RELATIONSHIP_CAN_NOT_BE_UPDATED.getMessageDefinition(new String[]{this.repositoryName, relationshipGUID, methodName}), ((Object)((Object)this)).getClass().getName(), methodName, parameterName);
        }
        throw new RelationshipNotKnownException(OMRSErrorCode.NULL_INSTANCE.getMessageDefinition(new String[]{this.repositoryName, relationshipGUID, methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    private Relationship validateRelationshipCanBeRehomed(String userId, String relationshipGUID, String methodName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        return this.validateRelationshipCanBeRehomedByRepository(relationshipGUID, this.realMetadataCollection.getRelationship(userId, relationshipGUID), methodName);
    }

    private Relationship validateRelationshipCanBeRehomedByRepository(String relationshipGUID, Relationship relationship, String methodName) throws InvalidParameterException, RelationshipNotKnownException {
        if (relationship != null) {
            boolean updateAllowed = false;
            InstanceProvenanceType instanceProvenance = relationship.getInstanceProvenanceType();
            switch (instanceProvenance) {
                case LOCAL_COHORT: {
                    String entityHome = relationship.getMetadataCollectionId();
                    if (entityHome == null || entityHome.equals(this.metadataCollectionId)) break;
                    updateAllowed = true;
                    break;
                }
                case EXTERNAL_SOURCE: {
                    String replicatedBy = relationship.getReplicatedBy();
                    if (replicatedBy == null || replicatedBy.equals(this.metadataCollectionId)) break;
                    updateAllowed = true;
                    break;
                }
                default: {
                    updateAllowed = false;
                }
            }
            if (updateAllowed) {
                return relationship;
            }
            String parameterName = "relationshipGUID";
            throw new InvalidParameterException(OMRSErrorCode.INSTANCE_HOME_NOT_LOCAL.getMessageDefinition(new String[]{relationship.getMetadataCollectionId(), methodName, relationship.getGUID(), this.metadataCollectionId, this.repositoryName}), ((Object)((Object)this)).getClass().getName(), methodName, parameterName);
        }
        throw new RelationshipNotKnownException(OMRSErrorCode.NULL_INSTANCE.getMessageDefinition(new String[]{this.repositoryName, relationshipGUID, methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    private void notifyOfUpdatedEntity(EntityDetail oldEntity, EntityDetail newEntity) {
        if (newEntity != null && this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processUpdatedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, oldEntity, newEntity);
        }
    }

    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "updateEntityStatus";
        super.updateInstanceStatusParameterValidation(userId, entityGUID, newStatus, "updateEntityStatus");
        EntityDetail currentEntity = this.validateEntityCanBeUpdated(userId, entityGUID, "updateEntityStatus");
        try {
            this.securityVerifier.validateUserForEntityUpdate(userId, this.metadataCollectionName, currentEntity);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        EntityDetail newEntity = this.realMetadataCollection.updateEntityStatus(userId, entityGUID, newStatus);
        if (newEntity != null) {
            this.setLocalProvenanceThroughoutEntity(newEntity);
            this.notifyOfUpdatedEntity(currentEntity, newEntity);
        }
        return newEntity;
    }

    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "updateEntityProperties";
        super.updateInstancePropertiesPropertyValidation(userId, entityGUID, properties, "updateEntityProperties");
        EntityDetail currentEntity = this.validateEntityCanBeUpdated(userId, entityGUID, "updateEntityProperties");
        try {
            this.securityVerifier.validateUserForEntityUpdate(userId, this.metadataCollectionName, currentEntity);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        EntityDetail newEntity = this.realMetadataCollection.updateEntityProperties(userId, entityGUID, properties);
        if (newEntity != null) {
            this.setLocalProvenanceThroughoutEntity(newEntity);
            this.notifyOfUpdatedEntity(currentEntity, newEntity);
        }
        return newEntity;
    }

    public EntityDetail undoEntityUpdate(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "undoEntityUpdate";
        String parameterName = "entityGUID";
        this.manageInstanceParameterValidation(userId, entityGUID, "entityGUID", "undoEntityUpdate");
        EntityDetail currentEntity = this.validateEntityCanBeUpdated(userId, entityGUID, "undoEntityUpdate");
        try {
            this.securityVerifier.validateUserForEntityUpdate(userId, this.metadataCollectionName, currentEntity);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        EntityDetail entity = this.realMetadataCollection.undoEntityUpdate(userId, entityGUID);
        if (entity != null) {
            this.setLocalProvenanceThroughoutEntity(entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processUndoneEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public EntityDetail deleteEntity(String userId, String typeDefGUID, String typeDefName, String obsoleteEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "deleteEntity";
        String parameterName = "obsoleteEntityGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteEntityGUID, "obsoleteEntityGUID", "deleteEntity");
        EntityDetail currentEntity = this.validateEntityCanBeUpdated(userId, obsoleteEntityGUID, "deleteEntity");
        try {
            this.securityVerifier.validateUserForEntityDelete(userId, this.metadataCollectionName, currentEntity);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        EntityDetail entity = this.realMetadataCollection.deleteEntity(userId, typeDefGUID, typeDefName, obsoleteEntityGUID);
        if (entity != null && this.produceEventsForRealConnector) {
            this.setLocalProvenanceThroughoutEntity(entity);
            this.outboundRepositoryEventProcessor.processDeletedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
        }
        return entity;
    }

    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "purgeEntity";
        String parameterName = "deletedEntityGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedEntityGUID, "deletedEntityGUID", "purgeEntity");
        EntityDetail entity = this.realMetadataCollection.isEntityKnown(userId, deletedEntityGUID);
        if (entity != null) {
            this.validateEntityCanBeUpdatedByRepository(deletedEntityGUID, entity, "purgeEntity");
            try {
                this.securityVerifier.validateUserForEntityDelete(userId, this.metadataCollectionName, entity);
            }
            catch (UserNotAuthorizedException error) {
                throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
            }
        }
        this.realMetadataCollection.purgeEntity(userId, typeDefGUID, typeDefName, deletedEntityGUID);
        if (this.produceEventsForRealConnector) {
            if (entity == null) {
                this.outboundRepositoryEventProcessor.processPurgedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefGUID, typeDefName, deletedEntityGUID);
            } else {
                this.outboundRepositoryEventProcessor.processPurgedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
    }

    public EntityDetail restoreEntity(String userId, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "restoreEntity";
        String parameterName = "deletedEntityGUID";
        super.manageInstanceParameterValidation(userId, deletedEntityGUID, "deletedEntityGUID", "restoreEntity");
        try {
            this.securityVerifier.validateUserForEntityRestore(userId, this.metadataCollectionName, deletedEntityGUID);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        EntityDetail entity = this.realMetadataCollection.restoreEntity(userId, deletedEntityGUID);
        if (entity != null) {
            this.setLocalProvenanceThroughoutEntity(entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processRestoredEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "classifyEntity";
        TypeDef typeDef = this.classifyEntityParameterValidation(userId, entityGUID, classificationName, classificationProperties, "classifyEntity");
        if (!this.repositoryValidator.isActiveType(this.repositoryName, typeDef.getGUID(), typeDef.getName())) {
            throw new ClassificationErrorException(OMRSErrorCode.UNSUPPORTED_CLASSIFICATION.getMessageDefinition(new String[]{this.repositoryName, classificationName}), ((Object)((Object)this)).getClass().getName(), "classifyEntity");
        }
        EntitySummary currentEntity = this.getEntitySummary(userId, entityGUID);
        try {
            this.securityVerifier.validateUserForEntityClassificationAdd(userId, this.metadataCollectionName, currentEntity, classificationName, classificationProperties);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        EntityDetail entity = this.realMetadataCollection.classifyEntity(userId, entityGUID, classificationName, classificationProperties);
        if (entity != null) {
            this.setLocalProvenanceThroughoutEntity(entity);
            if (this.produceEventsForRealConnector) {
                Classification newClassification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, (EntitySummary)entity, classificationName, "classifyEntity");
                this.outboundRepositoryEventProcessor.processClassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity, newClassification);
            }
        }
        return entity;
    }

    public Classification classifyEntity(String userId, EntityProxy entityProxy, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "classifyEntity";
        TypeDef typeDef = this.classifyEntityParameterValidation(userId, entityProxy, classificationName, classificationProperties, "classifyEntity");
        if (!this.repositoryValidator.isActiveType(this.repositoryName, typeDef.getGUID(), typeDef.getName())) {
            throw new ClassificationErrorException(OMRSErrorCode.UNSUPPORTED_CLASSIFICATION.getMessageDefinition(new String[]{this.repositoryName, classificationName}), ((Object)((Object)this)).getClass().getName(), "classifyEntity");
        }
        try {
            this.securityVerifier.validateUserForEntityClassificationAdd(userId, this.metadataCollectionName, (EntitySummary)entityProxy, classificationName, classificationProperties);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        Classification classification = this.realMetadataCollection.classifyEntity(userId, entityProxy, classificationName, classificationProperties);
        if (classification != null) {
            this.setLocalProvenance((InstanceAuditHeader)classification);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processClassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entityProxy, classification);
            }
        }
        return classification;
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntity (detailed)";
        TypeDef typeDef = this.classifyEntityParameterValidation(userId, entityGUID, classificationName, classificationProperties, "classifyEntity (detailed)");
        if (!this.repositoryValidator.isActiveType(this.repositoryName, typeDef.getGUID(), typeDef.getName())) {
            throw new ClassificationErrorException(OMRSErrorCode.UNSUPPORTED_CLASSIFICATION.getMessageDefinition(new String[]{this.repositoryName, classificationName}), ((Object)((Object)this)).getClass().getName(), "classifyEntity (detailed)");
        }
        EntitySummary currentEntity = this.getEntitySummary(userId, entityGUID);
        try {
            this.securityVerifier.validateUserForEntityClassificationAdd(userId, this.metadataCollectionName, currentEntity, classificationName, classificationProperties);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        EntityDetail entity = this.realMetadataCollection.classifyEntity(userId, entityGUID, classificationName, externalSourceGUID, externalSourceName, classificationOrigin, classificationOriginGUID, classificationProperties);
        if (entity != null) {
            this.setLocalProvenanceThroughoutEntity(entity);
            if (this.produceEventsForRealConnector) {
                Classification newClassification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, (EntitySummary)entity, classificationName, "classifyEntity (detailed)");
                this.outboundRepositoryEventProcessor.processClassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity, newClassification);
            }
        }
        return entity;
    }

    public Classification classifyEntity(String userId, EntityProxy entityProxy, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntity (detailed)";
        TypeDef typeDef = this.classifyEntityParameterValidation(userId, entityProxy.getGUID(), classificationName, classificationProperties, "classifyEntity (detailed)");
        if (!this.repositoryValidator.isActiveType(this.repositoryName, typeDef.getGUID(), typeDef.getName())) {
            throw new ClassificationErrorException(OMRSErrorCode.UNSUPPORTED_CLASSIFICATION.getMessageDefinition(new String[]{this.repositoryName, classificationName}), ((Object)((Object)this)).getClass().getName(), "classifyEntity (detailed)");
        }
        try {
            this.securityVerifier.validateUserForEntityClassificationAdd(userId, this.metadataCollectionName, (EntitySummary)entityProxy, classificationName, classificationProperties);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        Classification classification = this.realMetadataCollection.classifyEntity(userId, entityProxy, classificationName, externalSourceGUID, externalSourceName, classificationOrigin, classificationOriginGUID, classificationProperties);
        if (classification != null) {
            this.setLocalProvenance((InstanceAuditHeader)classification);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processClassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entityProxy, classification);
            }
        }
        return classification;
    }

    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "declassifyEntity";
        this.declassifyEntityParameterValidation(userId, entityGUID, classificationName, "declassifyEntity");
        EntitySummary currentEntity = this.getEntitySummary(userId, entityGUID);
        Classification currentClassification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, currentEntity, classificationName, "declassifyEntity");
        try {
            this.securityVerifier.validateUserForEntityClassificationDelete(userId, this.metadataCollectionName, currentEntity, classificationName);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        EntityDetail entity = this.realMetadataCollection.declassifyEntity(userId, entityGUID, classificationName);
        if (entity != null) {
            this.setLocalProvenanceThroughoutEntity(entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processDeclassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity, currentClassification);
            }
        }
        return entity;
    }

    public Classification declassifyEntity(String userId, EntityProxy entityProxy, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "declassifyEntity (EntityProxy)";
        String entityGUID = entityProxy.getGUID();
        this.declassifyEntityParameterValidation(userId, entityGUID, classificationName, "declassifyEntity (EntityProxy)");
        try {
            this.securityVerifier.validateUserForEntityClassificationDelete(userId, this.metadataCollectionName, (EntitySummary)entityProxy, classificationName);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        Classification removedClassification = this.realMetadataCollection.declassifyEntity(userId, entityProxy, classificationName);
        this.setLocalProvenance((InstanceAuditHeader)removedClassification);
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processDeclassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entityProxy, removedClassification);
        }
        return removedClassification;
    }

    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "updateEntityClassification";
        this.classifyEntityParameterValidation(userId, entityGUID, classificationName, properties, "updateEntityClassification");
        EntitySummary currentEntity = this.getEntitySummary(userId, entityGUID);
        Classification currentClassification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, currentEntity, classificationName, "updateEntityClassification");
        try {
            this.securityVerifier.validateUserForEntityClassificationUpdate(userId, this.metadataCollectionName, currentEntity, classificationName, properties);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        EntityDetail entity = this.realMetadataCollection.updateEntityClassification(userId, entityGUID, classificationName, properties);
        if (entity != null) {
            this.setLocalProvenanceThroughoutEntity(entity);
            if (this.produceEventsForRealConnector) {
                Classification newClassification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, (EntitySummary)entity, classificationName, "updateEntityClassification");
                this.outboundRepositoryEventProcessor.processReclassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity, currentClassification, newClassification);
            }
        }
        return entity;
    }

    public Classification updateEntityClassification(String userId, EntityProxy entityProxy, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "updateEntityClassification (EntityProxy)";
        this.classifyEntityParameterValidation(userId, entityProxy.getGUID(), classificationName, properties, "updateEntityClassification (EntityProxy)");
        try {
            this.securityVerifier.validateUserForEntityClassificationUpdate(userId, this.metadataCollectionName, (EntitySummary)entityProxy, classificationName, properties);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        Classification newClassification = this.realMetadataCollection.updateEntityClassification(userId, entityProxy, classificationName, properties);
        this.setLocalProvenance((InstanceAuditHeader)newClassification);
        if (this.produceEventsForRealConnector) {
            Classification currentClassification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, (EntitySummary)entityProxy, classificationName, "updateEntityClassification (EntityProxy)");
            this.outboundRepositoryEventProcessor.processReclassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entityProxy, currentClassification, newClassification);
        }
        return newClassification;
    }

    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "addRelationship";
        super.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addRelationship");
        EntitySummary end1 = this.realMetadataCollection.getEntitySummary(userId, entityOneGUID);
        EntitySummary end2 = this.realMetadataCollection.getEntitySummary(userId, entityTwoGUID);
        try {
            this.securityVerifier.validateUserForRelationshipCreate(userId, this.metadataCollectionName, relationshipTypeGUID, initialProperties, end1, end2, initialStatus);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        Relationship relationship = this.realMetadataCollection.addRelationship(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus);
        if (relationship != null) {
            this.setLocalProvenanceThroughoutRelationship(relationship);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processNewRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
            }
        }
        return relationship;
    }

    public Relationship addExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "addExternalRelationship";
        super.addExternalRelationshipParameterValidation(userId, relationshipTypeGUID, externalSourceGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addExternalRelationship");
        EntitySummary end1 = this.realMetadataCollection.getEntitySummary(userId, entityOneGUID);
        EntitySummary end2 = this.realMetadataCollection.getEntitySummary(userId, entityTwoGUID);
        try {
            this.securityVerifier.validateUserForRelationshipCreate(userId, this.metadataCollectionName, relationshipTypeGUID, initialProperties, end1, end2, initialStatus);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        Relationship relationship = this.realMetadataCollection.addExternalRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, initialProperties, entityOneGUID, entityTwoGUID, initialStatus);
        if (relationship != null) {
            this.setLocalProvenanceThroughoutRelationship(relationship);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processNewRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
            }
        }
        return relationship;
    }

    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "updateRelationshipStatus";
        this.updateInstanceStatusParameterValidation(userId, relationshipGUID, newStatus, "updateRelationshipStatus");
        Relationship currentRelationship = this.validateRelationshipCanBeUpdated(userId, relationshipGUID, "updateRelationshipStatus");
        try {
            this.securityVerifier.validateUserForRelationshipUpdate(userId, this.metadataCollectionName, currentRelationship);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        Relationship newRelationship = this.realMetadataCollection.updateRelationshipStatus(userId, relationshipGUID, newStatus);
        if (newRelationship != null) {
            this.setLocalProvenanceThroughoutRelationship(newRelationship);
            this.notifyOfUpdatedRelationship(currentRelationship, newRelationship);
        }
        return newRelationship;
    }

    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "updateRelationshipProperties";
        this.updateInstancePropertiesPropertyValidation(userId, relationshipGUID, properties, "updateRelationshipProperties");
        Relationship currentRelationship = this.validateRelationshipCanBeUpdated(userId, relationshipGUID, "updateRelationshipProperties");
        try {
            this.securityVerifier.validateUserForRelationshipUpdate(userId, this.metadataCollectionName, currentRelationship);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        Relationship newRelationship = this.realMetadataCollection.updateRelationshipProperties(userId, relationshipGUID, properties);
        if (newRelationship != null) {
            this.setLocalProvenanceThroughoutRelationship(newRelationship);
            this.notifyOfUpdatedRelationship(currentRelationship, newRelationship);
        }
        return newRelationship;
    }

    private void notifyOfUpdatedRelationship(Relationship oldRelationship, Relationship newRelationship) {
        if (newRelationship != null && this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processUpdatedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, oldRelationship, newRelationship);
        }
    }

    public Relationship undoRelationshipUpdate(String userId, String relationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "undoRelationshipUpdate";
        String parameterName = "relationshipGUID";
        this.manageInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", "undoRelationshipUpdate");
        Relationship currentRelationship = this.validateRelationshipCanBeUpdated(userId, relationshipGUID, "undoRelationshipUpdate");
        try {
            this.securityVerifier.validateUserForRelationshipUpdate(userId, this.metadataCollectionName, currentRelationship);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        Relationship newRelationship = this.realMetadataCollection.undoRelationshipUpdate(userId, relationshipGUID);
        if (newRelationship != null) {
            this.setLocalProvenanceThroughoutRelationship(newRelationship);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processUndoneRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, newRelationship);
            }
        }
        return newRelationship;
    }

    public Relationship deleteRelationship(String userId, String typeDefGUID, String typeDefName, String obsoleteRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "deleteRelationship";
        String parameterName = "obsoleteRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID, "obsoleteRelationshipGUID", "deleteRelationship");
        Relationship currentRelationship = this.validateRelationshipCanBeUpdated(userId, obsoleteRelationshipGUID, "deleteRelationship");
        try {
            this.securityVerifier.validateUserForRelationshipDelete(userId, this.metadataCollectionName, currentRelationship);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        Relationship newRelationship = this.realMetadataCollection.deleteRelationship(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID);
        if (newRelationship != null && this.produceEventsForRealConnector) {
            this.setLocalProvenanceThroughoutRelationship(newRelationship);
            this.outboundRepositoryEventProcessor.processDeletedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, newRelationship);
        }
        return newRelationship;
    }

    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "purgeRelationship";
        String parameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedRelationshipGUID, "deletedRelationshipGUID", "purgeRelationship");
        Relationship relationship = this.realMetadataCollection.isRelationshipKnown(userId, deletedRelationshipGUID);
        if (relationship != null) {
            this.validateRelationshipCanBeUpdated(deletedRelationshipGUID, relationship, "purgeRelationship");
            try {
                this.securityVerifier.validateUserForRelationshipDelete(userId, this.metadataCollectionName, relationship);
            }
            catch (UserNotAuthorizedException error) {
                throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
            }
        }
        this.realMetadataCollection.purgeRelationship(userId, typeDefGUID, typeDefName, deletedRelationshipGUID);
        if (this.produceEventsForRealConnector) {
            if (relationship == null) {
                this.outboundRepositoryEventProcessor.processPurgedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefGUID, typeDefName, deletedRelationshipGUID);
            } else {
                this.setLocalProvenanceThroughoutRelationship(relationship);
                this.outboundRepositoryEventProcessor.processPurgedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
            }
        }
    }

    public Relationship restoreRelationship(String userId, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "restoreRelationship";
        String parameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, deletedRelationshipGUID, "deletedRelationshipGUID", "restoreRelationship");
        try {
            this.securityVerifier.validateUserForRelationshipRestore(userId, this.metadataCollectionName, deletedRelationshipGUID);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        Relationship newRelationship = this.realMetadataCollection.restoreRelationship(userId, deletedRelationshipGUID);
        if (newRelationship != null) {
            this.setLocalProvenanceThroughoutRelationship(newRelationship);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processRestoredRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, newRelationship);
            }
        }
        return newRelationship;
    }

    public EntityDetail reIdentifyEntity(String userId, String typeDefGUID, String typeDefName, String entityGUID, String newEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "reIdentifyEntity";
        String instanceParameterName = "entityGUID";
        String newInstanceParameterName = "newEntityGUID";
        super.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, entityGUID, "entityGUID", newEntityGUID, "newEntityGUID", "reIdentifyEntity");
        EntityDetail currentEntity = this.validateEntityCanBeUpdated(userId, entityGUID, "reIdentifyEntity");
        try {
            this.securityVerifier.validateUserForEntityReIdentification(userId, this.metadataCollectionName, currentEntity, newEntityGUID);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        EntityDetail entity = this.realMetadataCollection.reIdentifyEntity(userId, typeDefGUID, typeDefName, entityGUID, newEntityGUID);
        if (entity != null) {
            this.setLocalProvenanceThroughoutEntity(entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processReIdentifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entityGUID, entity);
            }
        }
        return entity;
    }

    public EntityDetail reTypeEntity(String userId, String entityGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, EntityNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "reTypeEntity";
        String entityParameterName = "entityGUID";
        super.reTypeInstanceParameterValidation(userId, entityGUID, "entityGUID", TypeDefCategory.ENTITY_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeEntity");
        EntityDetail currentEntity = this.validateEntityCanBeUpdated(userId, entityGUID, "reTypeEntity");
        try {
            this.securityVerifier.validateUserForEntityReTyping(userId, this.metadataCollectionName, currentEntity, newTypeDefSummary);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        EntityDetail entity = this.realMetadataCollection.reTypeEntity(userId, entityGUID, currentTypeDefSummary, newTypeDefSummary);
        if (entity != null) {
            this.setLocalProvenanceThroughoutEntity(entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processReTypedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, currentTypeDefSummary, entity);
            }
        }
        return entity;
    }

    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "reHomeEntity";
        String entityParameterName = "entityGUID";
        String newHomeParameterName = "newHomeMetadataCollectionId";
        super.reHomeInstanceParameterValidation(userId, entityGUID, "entityGUID", typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, "reHomeEntity");
        if (this.metadataCollectionId.equals(newHomeMetadataCollectionId)) {
            EntityDetail currentEntity = this.validateEntityCanBeRehomed(userId, entityGUID, "reHomeEntity");
            try {
                this.securityVerifier.validateUserForEntityReHoming(userId, this.metadataCollectionName, currentEntity, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
            }
            catch (UserNotAuthorizedException error) {
                throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
            }
            EntityDetail entity = this.realMetadataCollection.reHomeEntity(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
            if (entity != null) {
                if (entity.getMetadataCollectionId() == null) {
                    entity.setMetadataCollectionId(newHomeMetadataCollectionId);
                    entity.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
                }
                if (entity.getMetadataCollectionName() == null) {
                    entity.setMetadataCollectionName(newHomeMetadataCollectionName);
                }
                if (this.produceEventsForRealConnector) {
                    this.outboundRepositoryEventProcessor.processReHomedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, this.metadataCollectionId, entity);
                }
            }
            return entity;
        }
        throw new InvalidParameterException(OMRSErrorCode.NOT_FOR_LOCAL_COLLECTION.getMessageDefinition(new String[]{entityGUID, typeDefName, typeDefGUID, newHomeMetadataCollectionId, this.metadataCollectionId}), ((Object)((Object)this)).getClass().getName(), "reHomeEntity", "newHomeMetadataCollectionId");
    }

    public Relationship reIdentifyRelationship(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String newRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "reIdentifyRelationship";
        String instanceParameterName = "relationshipGUID";
        String newInstanceParameterName = "newRelationshipGUID";
        super.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, relationshipGUID, "relationshipGUID", newRelationshipGUID, "newRelationshipGUID", "reIdentifyRelationship");
        Relationship currentRelationship = this.validateRelationshipCanBeUpdated(userId, relationshipGUID, "reIdentifyRelationship");
        try {
            this.securityVerifier.validateUserForRelationshipReIdentification(userId, this.metadataCollectionName, currentRelationship, newRelationshipGUID);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        Relationship relationship = this.realMetadataCollection.reIdentifyRelationship(userId, typeDefGUID, typeDefName, relationshipGUID, newRelationshipGUID);
        if (relationship != null) {
            this.setLocalProvenanceThroughoutRelationship(relationship);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processReIdentifiedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationshipGUID, relationship);
            }
        }
        return relationship;
    }

    public Relationship reTypeRelationship(String userId, String relationshipGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, RelationshipNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "reTypeRelationship";
        String relationshipParameterName = "relationshipGUID";
        super.reTypeInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", TypeDefCategory.RELATIONSHIP_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeRelationship");
        Relationship currentRelationship = this.validateRelationshipCanBeUpdated(userId, relationshipGUID, "reTypeRelationship");
        try {
            this.securityVerifier.validateUserForRelationshipReTyping(userId, this.metadataCollectionName, currentRelationship, newTypeDefSummary);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
        }
        Relationship relationship = this.realMetadataCollection.reTypeRelationship(userId, relationshipGUID, currentTypeDefSummary, newTypeDefSummary);
        if (relationship != null) {
            this.setLocalProvenanceThroughoutRelationship(relationship);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processReTypedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, currentTypeDefSummary, relationship);
            }
        }
        return relationship;
    }

    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "reHomeRelationship";
        String relationshipParameterName = "relationshipGUID";
        String newHomeParameterName = "newHomeMetadataCollectionId";
        super.reHomeInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, "reHomeRelationship");
        if (this.metadataCollectionId.equals(newHomeMetadataCollectionId)) {
            Relationship currentRelationship = this.validateRelationshipCanBeRehomed(userId, relationshipGUID, "reHomeRelationship");
            try {
                this.securityVerifier.validateUserForRelationshipReHoming(userId, this.metadataCollectionName, currentRelationship, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
            }
            catch (UserNotAuthorizedException error) {
                throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException(error);
            }
            Relationship relationship = this.realMetadataCollection.reHomeRelationship(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
            if (relationship != null) {
                this.setLocalProvenanceThroughoutRelationship(relationship);
                if (this.produceEventsForRealConnector) {
                    this.outboundRepositoryEventProcessor.processReHomedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, homeMetadataCollectionId, relationship);
                }
            }
            return relationship;
        }
        throw new InvalidParameterException(OMRSErrorCode.NOT_FOR_LOCAL_COLLECTION.getMessageDefinition(new String[]{relationshipGUID, typeDefName, typeDefGUID, newHomeMetadataCollectionId, this.metadataCollectionId}), ((Object)((Object)this)).getClass().getName(), "reHomeRelationship", "newHomeMetadataCollectionId");
    }

    public void saveEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "saveEntityReferenceCopy";
        String instanceParameterName = "entity";
        super.referenceInstanceParameterValidation(userId, (InstanceHeader)entity, "entity", "saveEntityReferenceCopy");
        if (entity.getHeaderVersion() <= 1L && this.securityVerifier.validateEntityReferenceCopySave(entity)) {
            this.realMetadataCollection.saveEntityReferenceCopy(userId, entity);
        }
    }

    public List<Classification> getHomeClassifications(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "getHomeClassifications";
        super.getInstanceParameterValidation(userId, entityGUID, "getHomeClassifications");
        List homeClassifications = this.realMetadataCollection.getHomeClassifications(userId, entityGUID);
        if (homeClassifications != null) {
            this.setLocalProvenanceInEntityClassifications(homeClassifications);
        }
        return homeClassifications;
    }

    public List<Classification> getHomeClassifications(String userId, String entityGUID, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "getHomeClassifications (with history)";
        super.getInstanceParameterValidation(userId, entityGUID, "getHomeClassifications (with history)");
        List homeClassifications = this.realMetadataCollection.getHomeClassifications(userId, entityGUID, asOfTime);
        if (homeClassifications != null) {
            this.setLocalProvenanceInEntityClassifications(homeClassifications);
        }
        return homeClassifications;
    }

    public void deleteEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "deleteEntityReferenceCopy";
        String instanceParameterName = "entity";
        super.referenceInstanceParameterValidation(userId, (InstanceHeader)entity, "entity", "deleteEntityReferenceCopy");
        this.realMetadataCollection.deleteEntityReferenceCopy(userId, entity);
    }

    public void purgeEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        String instanceParameterName = "entity";
        this.referenceInstanceParameterValidation(userId, (InstanceHeader)entity, "entity", "purgeEntityReferenceCopy");
        this.realMetadataCollection.purgeEntityReferenceCopy(userId, entity);
    }

    public void purgeEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, entityGUID, typeDefGUID, typeDefName, "entityGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeEntityReferenceCopy");
        this.realMetadataCollection.purgeEntityReferenceCopy(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
    }

    public void refreshEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, HomeEntityException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "refreshEntityReferenceCopy";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, entityGUID, typeDefGUID, typeDefName, "entityGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "refreshEntityReferenceCopy");
        EntityDetail entity = this.isEntityKnown(userId, entityGUID);
        if (entity != null && this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
            throw new HomeEntityException(OMRSErrorCode.HOME_REFRESH.getMessageDefinition(new String[]{"refreshEntityReferenceCopy", entityGUID, this.metadataCollectionId, this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "refreshEntityReferenceCopy");
        }
        this.outboundRepositoryEventProcessor.processRefreshEntityRequested(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefGUID, typeDefName, entityGUID, homeMetadataCollectionId);
    }

    public void saveClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityConflictException, InvalidEntityException, PropertyErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "saveClassificationReferenceCopy";
        String instanceParameterName = "entity";
        this.basicRequestValidation(userId, "saveClassificationReferenceCopy");
        if (entity == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_REFERENCE_INSTANCE.getMessageDefinition(new String[]{this.repositoryName, "saveClassificationReferenceCopy"}), ((Object)((Object)this)).getClass().getName(), "saveClassificationReferenceCopy", "entity");
        }
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "entity", entity.getMetadataCollectionId(), "saveClassificationReferenceCopy");
        if (entity.getHeaderVersion() <= 1L) {
            this.realMetadataCollection.saveClassificationReferenceCopy(userId, entity, classification);
        }
    }

    public void saveClassificationReferenceCopy(String userId, EntityProxy entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityConflictException, InvalidEntityException, PropertyErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "saveClassificationReferenceCopy";
        String instanceParameterName = "entity";
        this.basicRequestValidation(userId, "saveClassificationReferenceCopy");
        if (entity == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_REFERENCE_INSTANCE.getMessageDefinition(new String[]{this.repositoryName, "saveClassificationReferenceCopy"}), ((Object)((Object)this)).getClass().getName(), "saveClassificationReferenceCopy", "entity");
        }
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "entity", entity.getMetadataCollectionId(), "saveClassificationReferenceCopy");
        if (entity.getHeaderVersion() <= 1L) {
            this.realMetadataCollection.saveClassificationReferenceCopy(userId, entity, classification);
        }
    }

    public void purgeClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, TypeErrorException, PropertyErrorException, EntityConflictException, InvalidEntityException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "purgeClassificationReferenceCopy";
        String instanceParameterName = "entity";
        this.basicRequestValidation(userId, "purgeClassificationReferenceCopy");
        if (entity == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_REFERENCE_INSTANCE.getMessageDefinition(new String[]{this.repositoryName, "purgeClassificationReferenceCopy"}), ((Object)((Object)this)).getClass().getName(), "purgeClassificationReferenceCopy", "entity");
        }
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "entity", entity.getMetadataCollectionId(), "purgeClassificationReferenceCopy");
        if (entity.getHeaderVersion() <= 1L) {
            this.realMetadataCollection.purgeClassificationReferenceCopy(userId, entity, classification);
        }
    }

    public void saveRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "saveRelationshipReferenceCopy";
        String instanceParameterName = "relationship";
        super.referenceInstanceParameterValidation(userId, (InstanceHeader)relationship, "relationship", "saveRelationshipReferenceCopy");
        if (relationship.getHeaderVersion() <= 1L && this.securityVerifier.validateRelationshipReferenceCopySave(relationship)) {
            this.realMetadataCollection.saveRelationshipReferenceCopy(userId, relationship);
        }
    }

    public void deleteRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "deleteRelationshipReferenceCopy";
        String instanceParameterName = "relationship";
        super.referenceInstanceParameterValidation(userId, (InstanceHeader)relationship, "relationship", "deleteRelationshipReferenceCopy");
        this.realMetadataCollection.deleteRelationshipReferenceCopy(userId, relationship);
    }

    public void purgeRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        String instanceParameterName = "relationship";
        this.referenceInstanceParameterValidation(userId, (InstanceHeader)relationship, "relationship", "purgeRelationshipReferenceCopy");
        this.realMetadataCollection.purgeRelationshipReferenceCopy(userId, relationship);
    }

    public void purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, relationshipGUID, typeDefGUID, typeDefName, "relationshipGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeRelationshipReferenceCopy");
        this.realMetadataCollection.purgeRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
    }

    public void refreshRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, HomeRelationshipException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        String methodName = "refreshRelationshipReferenceCopy";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, relationshipGUID, typeDefGUID, typeDefName, "relationshipGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "refreshRelationshipReferenceCopy");
        Relationship relationship = this.isRelationshipKnown(userId, relationshipGUID);
        if (relationship != null && this.metadataCollectionId.equals(relationship.getMetadataCollectionId())) {
            throw new HomeRelationshipException(OMRSErrorCode.HOME_REFRESH.getMessageDefinition(new String[]{"refreshRelationshipReferenceCopy", relationshipGUID, this.metadataCollectionId, this.repositoryName}), ((Object)((Object)this)).getClass().getName(), "refreshRelationshipReferenceCopy");
        }
        this.outboundRepositoryEventProcessor.processRefreshRelationshipRequest(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefGUID, typeDefName, relationshipGUID, homeMetadataCollectionId);
    }

    public void saveInstanceReferenceCopies(String userId, InstanceGraph instances) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, EntityConflictException, RelationshipConflictException, InvalidEntityException, InvalidRelationshipException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, FunctionNotSupportedException {
        if (instances != null) {
            List relationships;
            InstanceGraph validatedInstances = null;
            List entities = instances.getEntities();
            if (entities != null && !entities.isEmpty()) {
                ArrayList<EntityDetail> validatedEntities = new ArrayList<EntityDetail>();
                for (EntityDetail entity : entities) {
                    if (entity == null || !this.securityVerifier.validateEntityReferenceCopySave(entity)) continue;
                    validatedEntities.add(entity);
                }
                if (!validatedEntities.isEmpty()) {
                    validatedInstances = new InstanceGraph();
                    validatedInstances.setEntities(validatedEntities);
                }
            }
            if ((relationships = instances.getRelationships()) != null && !relationships.isEmpty()) {
                ArrayList<Relationship> validatedRelationships = new ArrayList<Relationship>();
                for (Relationship relationship : relationships) {
                    if (relationship == null || !this.securityVerifier.validateRelationshipReferenceCopySave(relationship)) continue;
                    validatedRelationships.add(relationship);
                }
                if (!validatedRelationships.isEmpty()) {
                    if (validatedInstances == null) {
                        validatedInstances = new InstanceGraph();
                    }
                    validatedInstances.setRelationships(validatedRelationships);
                }
            }
            if (validatedInstances != null) {
                this.realMetadataCollection.saveInstanceReferenceCopies(userId, validatedInstances);
            }
        }
    }
}

