/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.metadatahighway;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenMetadataEventProtocolVersion;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.OMRSCohortRegistryStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.properties.MemberRegistration;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectionConsumer;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventExchangeRule;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventProtocolVersion;
import org.odpi.openmetadata.repositoryservices.events.OpenMetadataEventsSecurity;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.OMRSLocalRepository;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.odpi.openmetadata.repositoryservices.metadatahighway.OMRSCohortManager;
import org.odpi.openmetadata.repositoryservices.properties.CohortConnectionStatus;
import org.odpi.openmetadata.repositoryservices.properties.CohortDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSMetadataHighwayManager {
    private List<OMRSCohortManager> cohortManagers = new ArrayList<OMRSCohortManager>();
    private String localServerName;
    private String localServerType;
    private String localOrganizationName;
    private OMRSLocalRepository localRepository;
    private OMRSRepositoryContentManager localRepositoryContentManager;
    private OMRSConnectionConsumer enterpriseAccessConnectionConsumer;
    private OMRSTopicConnector enterpriseAccessTopicConnector;
    private AuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(OMRSMetadataHighwayManager.class);

    public OMRSMetadataHighwayManager(String localServerName, String localServerType, String localOrganizationName, OMRSLocalRepository localRepository, OMRSRepositoryContentManager localRepositoryContentManager, OMRSConnectionConsumer enterpriseAccessConnectionConsumer, OMRSTopicConnector enterpriseAccessTopicConnector, AuditLog auditLog) {
        this.localServerName = localServerName;
        this.localServerType = localServerType;
        this.localOrganizationName = localOrganizationName;
        this.localRepository = localRepository;
        this.localRepositoryContentManager = localRepositoryContentManager;
        this.enterpriseAccessConnectionConsumer = enterpriseAccessConnectionConsumer;
        this.enterpriseAccessTopicConnector = enterpriseAccessTopicConnector;
        this.auditLog = auditLog;
    }

    public void initialize(List<CohortConfig> cohortConfigList) {
        if (cohortConfigList != null) {
            for (CohortConfig cohortConfig : cohortConfigList) {
                this.connectToCohort(cohortConfig);
            }
        }
    }

    public void setSecurityVerifier(OpenMetadataEventsSecurity securityVerifier) {
        if (securityVerifier != null) {
            for (OMRSCohortManager existingCohortManager : this.cohortManagers) {
                if (existingCohortManager == null) continue;
                existingCohortManager.setSecurityVerifier(securityVerifier);
            }
        }
    }

    public CohortConnectionStatus connectToCohort(CohortConfig cohortConfig) {
        OMRSCohortManager cohortManager = new OMRSCohortManager(this.auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.COHORT_MANAGER));
        String localMetadataCollectionId = null;
        String localMetadataCollectionName = null;
        String actionDescription = "Connect to Cohort";
        if (cohortConfig.getCohortName() == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_COHORT_NAME.getMessageDefinition(), this.getClass().getName(), actionDescription);
        }
        for (OMRSCohortManager existingCohortManager : this.cohortManagers) {
            if (existingCohortManager == null || !cohortConfig.getCohortName().equals(existingCohortManager.getCohortName())) continue;
            throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_COHORT_NAME.getMessageDefinition(new String[]{cohortConfig.getCohortName()}), this.getClass().getName(), actionDescription);
        }
        if (this.localRepository != null) {
            localMetadataCollectionId = this.localRepository.getMetadataCollectionId();
            localMetadataCollectionName = this.localRepository.getMetadataCollectionName();
        }
        try {
            OMRSCohortRegistryStore cohortRegistryStore = this.getCohortRegistryStore(cohortConfig.getCohortName(), cohortConfig.getCohortRegistryConnection());
            OMRSTopicConnector cohortSingleTopicConnector = null;
            OMRSTopicConnector cohortRegistrationTopicConnector = null;
            OMRSTopicConnector cohortTypesTopicConnector = null;
            OMRSTopicConnector cohortInstancesTopicConnector = null;
            if (cohortConfig.getCohortOMRSTopicConnection() != null) {
                cohortSingleTopicConnector = this.getTopicConnector(cohortConfig.getCohortName() + " (single)", cohortConfig.getCohortOMRSTopicConnection(), cohortConfig.getCohortOMRSTopicProtocolVersion());
            }
            if (cohortConfig.getCohortOMRSRegistrationTopicConnection() != null) {
                cohortRegistrationTopicConnector = this.getTopicConnector(cohortConfig.getCohortName() + " (registration)", cohortConfig.getCohortOMRSRegistrationTopicConnection(), cohortConfig.getCohortOMRSTopicProtocolVersion());
            }
            if (cohortConfig.getCohortOMRSTypesTopicConnection() != null) {
                cohortTypesTopicConnector = this.getTopicConnector(cohortConfig.getCohortName() + " (types)", cohortConfig.getCohortOMRSTypesTopicConnection(), cohortConfig.getCohortOMRSTopicProtocolVersion());
            }
            if (cohortConfig.getCohortOMRSInstancesTopicConnection() != null) {
                cohortInstancesTopicConnector = this.getTopicConnector(cohortConfig.getCohortName() + " (instances)", cohortConfig.getCohortOMRSInstancesTopicConnection(), cohortConfig.getCohortOMRSTopicProtocolVersion());
            }
            OMRSRepositoryEventExchangeRule inboundEventExchangeRule = new OMRSRepositoryEventExchangeRule(cohortConfig.getEventsToProcessRule(), cohortConfig.getSelectedTypesToProcess());
            cohortManager.initialize(cohortConfig.getCohortName(), localMetadataCollectionId, localMetadataCollectionName, this.localServerName, this.localServerType, this.localOrganizationName, this.localRepository, this.localRepositoryContentManager, this.enterpriseAccessConnectionConsumer, this.enterpriseAccessTopicConnector, cohortRegistryStore, cohortConfig.getCohortOMRSTopicConnection(), cohortSingleTopicConnector, cohortConfig.getCohortOMRSRegistrationTopicConnection(), cohortRegistrationTopicConnector, cohortConfig.getCohortOMRSTypesTopicConnection(), cohortTypesTopicConnector, cohortConfig.getCohortOMRSInstancesTopicConnection(), cohortInstancesTopicConnector, inboundEventExchangeRule);
            this.cohortManagers.add(cohortManager);
        }
        catch (OMRSConfigErrorException error) {
            this.auditLog.logMessage(actionDescription, OMRSAuditCode.COHORT_CONFIG_ERROR.getMessageDefinition(new String[]{cohortConfig.getCohortName(), error.getReportedErrorMessage()}));
            throw error;
        }
        catch (Exception error) {
            throw error;
        }
        return cohortManager.getCohortConnectionStatus();
    }

    public MemberRegistration getLocalRegistration() {
        for (OMRSCohortManager existingCohortManager : this.cohortManagers) {
            MemberRegistration localRegistration;
            if (existingCohortManager == null || (localRegistration = existingCohortManager.getLocalRegistration()) == null) continue;
            localRegistration.setRegistrationTime(null);
            return localRegistration;
        }
        return null;
    }

    public MemberRegistration getLocalRegistration(String cohortName) {
        if (cohortName != null) {
            for (OMRSCohortManager existingCohortManager : this.cohortManagers) {
                if (existingCohortManager == null || !cohortName.equals(existingCohortManager.getCohortName())) continue;
                return existingCohortManager.getLocalRegistration();
            }
        }
        return null;
    }

    public List<MemberRegistration> getRemoteMembers(String cohortName) {
        if (cohortName == null) {
            String actionDescription = "get remote members";
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_COHORT_NAME.getMessageDefinition(), this.getClass().getName(), "get remote members");
        }
        for (OMRSCohortManager existingCohortManager : this.cohortManagers) {
            if (existingCohortManager == null || !cohortName.equals(existingCohortManager.getCohortName())) continue;
            return existingCohortManager.getRemoteMembers();
        }
        return null;
    }

    public List<CohortDescription> getCohortDescriptions() {
        ArrayList<CohortDescription> cohortDescriptions = new ArrayList<CohortDescription>();
        for (OMRSCohortManager existingCohortManager : this.cohortManagers) {
            if (existingCohortManager == null) continue;
            cohortDescriptions.add(existingCohortManager.getCohortDescription());
        }
        if (cohortDescriptions.isEmpty()) {
            return null;
        }
        return cohortDescriptions;
    }

    public CohortConnectionStatus getCohortConnectionStatus(String cohortName) {
        String actionDescription = "Get cohort status";
        if (cohortName == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_COHORT_NAME.getMessageDefinition(), this.getClass().getName(), actionDescription);
        }
        for (OMRSCohortManager existingCohortManager : this.cohortManagers) {
            if (existingCohortManager == null || !cohortName.equals(existingCohortManager.getCohortName())) continue;
            return existingCohortManager.getCohortConnectionStatus();
        }
        return CohortConnectionStatus.NOT_INITIALIZED;
    }

    public boolean disconnectFromCohort(String cohortName, boolean permanent) {
        String actionDescription = "Disconnect cohort";
        if (cohortName == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_COHORT_NAME.getMessageDefinition(), this.getClass().getName(), actionDescription);
        }
        for (OMRSCohortManager existingCohortManager : this.cohortManagers) {
            if (existingCohortManager == null || !cohortName.equals(existingCohortManager.getCohortName())) continue;
            existingCohortManager.disconnect(permanent);
            return true;
        }
        return false;
    }

    public void disconnect(boolean permanent) {
        String actionDescription = "Disconnecting from metadata highway";
        if (log.isDebugEnabled()) {
            log.debug("Disconnecting from metadata highway");
        }
        for (OMRSCohortManager cohortManager : this.cohortManagers) {
            if (cohortManager == null) continue;
            cohortManager.disconnect(permanent);
        }
        if (log.isDebugEnabled()) {
            log.debug("Disconnecting from metadata highway COMPLETE");
        }
    }

    private OMRSCohortRegistryStore getCohortRegistryStore(String cohortName, Connection cohortRegistryConnection) {
        String methodName = "getCohortRegistryStore()";
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
            Connector connector = connectorBroker.getConnector(cohortRegistryConnection);
            return (OMRSCohortRegistryStore)connector;
        }
        catch (Exception error) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to create cohort registry store connector: " + error.toString());
            }
            throw new OMRSConfigErrorException(OMRSErrorCode.NULL_REGISTRY_STORE.getMessageDefinition(new String[]{cohortName}), this.getClass().getName(), "getCohortRegistryStore()", (Throwable)error);
        }
    }

    private OMRSTopicConnector getTopicConnector(String cohortName, Connection topicConnection, OpenMetadataEventProtocolVersion protocolVersion) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
            Connector connector = connectorBroker.getConnector(topicConnection);
            OMRSTopicConnector topicConnector = (OMRSTopicConnector)connector;
            if (protocolVersion == OpenMetadataEventProtocolVersion.V1) {
                topicConnector.setEventProtocolLevel(OMRSEventProtocolVersion.V1);
            }
            return topicConnector;
        }
        catch (Exception error) {
            String methodName = "getTopicConnector()";
            if (log.isDebugEnabled()) {
                log.debug("Unable to create topic connector: " + error.toString());
            }
            this.auditLog.logMessage(methodName, OMRSAuditCode.BAD_TOPIC_CONNECTION.getMessageDefinition(new String[]{cohortName, error.getClass().getName(), error.getMessage()}));
            throw new OMRSConfigErrorException(OMRSErrorCode.NULL_TOPIC_CONNECTOR.getMessageDefinition(new String[]{cohortName}), this.getClass().getName(), methodName, (Throwable)error);
        }
    }

    public String toString() {
        return "OMRSMetadataHighwayManager{cohortManagers=" + this.cohortManagers + ", localServerName='" + this.localServerName + "', localServerType='" + this.localServerType + "', localOrganizationName='" + this.localOrganizationName + "', localRepository=" + this.localRepository + ", localRepositoryContentManager=" + this.localRepositoryContentManager + ", enterpriseAccessConnectionConsumer=" + this.enterpriseAccessConnectionConsumer + ", enterpriseAccessTopicConnector=" + this.enterpriseAccessTopicConnector + "}";
    }
}

