/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.List;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.ClassificationAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;

public abstract class GetEntityExecutor
extends RepositoryExecutorBase {
    private ClassificationAccumulator accumulator;
    protected String entityGUID;

    public GetEntityExecutor(String userId, String entityGUID, ClassificationAccumulator accumulator, String methodName) {
        super(userId, methodName);
        this.accumulator = accumulator;
        this.entityGUID = entityGUID;
    }

    @Override
    public List<String> getResultsForAugmentation() {
        return this.accumulator.getResultsForAugmentation();
    }

    @Override
    public void augmentResultFromRepository(String resultGUID, String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        List<String> contributingMetadataCollections = this.accumulator.getContributingMetadataCollections();
        if (contributingMetadataCollections == null || !contributingMetadataCollections.contains(metadataCollectionId)) {
            this.getHomeClassifications(metadataCollection);
        }
    }

    protected void getHomeClassifications(OMRSMetadataCollection metadataCollection) {
        try {
            List homeClassifications = metadataCollection.getHomeClassifications(this.userId, this.entityGUID);
            this.accumulator.saveClassifications(homeClassifications);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

